/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.stax;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.common.sax.IObjectFactory;
import com.cognos.cps.bseries.xts.request.nav.NavUtils;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.IsolatedXMLStreamReader;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class CMResponse {
    public static final String RESPONSE_TYPE_QUERY = "queryResult";
    public static final String RESPONSE_TYPE_UPDATE = "updateResult";
    private ArrayList m_CMQueries;
    private ArrayList m_CMObjects;
    private String m_cacheValidator;
    private IObjectFactory m_factory;
    private int m_itemCount;
    private boolean m_bMergeQueries;
    private String m_resultElementTag;
    private String _localName;
    private String _name;
    private String _value;
    private String _objectClass;
    private String _searchPath;
    private String _storeID;
    private String _title;
    private String _attribute;
    private String _type;
    private String _mapName;

    public CMResponse() {
        this(false, null);
    }

    public CMResponse(boolean mergeQueries) {
        this(mergeQueries, null);
    }

    public CMResponse(boolean mergeQueries, String type) {
        this.m_resultElementTag = type == null ? RESPONSE_TYPE_QUERY : type;
        this.m_bMergeQueries = mergeQueries;
        this.m_CMQueries = new ArrayList();
    }

    public void initialize(IObjectFactory factory) {
        this.m_factory = factory;
    }

    public void parse(XMLStreamReader reader) throws XMLStreamException {
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                if (this.m_resultElementTag.equals(this._localName)) {
                    this._attribute = reader.getAttributeValue("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
                    if (this._attribute != null && this._attribute.indexOf("baseClass") != -1) {
                        if (this.m_bMergeQueries) {
                            if (this.m_CMObjects == null) {
                                this.m_CMObjects = new ArrayList();
                            }
                        } else {
                            this.m_CMObjects = new ArrayList();
                        }
                        while (NavUtils.moveToElementWithinParent("item", this.m_resultElementTag, reader)) {
                            this._type = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                            GenericCMObject obj = this.m_factory.createObject(this._type);
                            ++this.m_itemCount;
                            this.m_CMObjects.add(obj);
                            this.processCMObject(reader, obj);
                        }
                        this.m_CMQueries.add(this.m_CMObjects);
                    }
                } else if ("cacheValidator".equals(this._localName)) {
                    this.m_cacheValidator = reader.getElementText().trim();
                }
            }
            reader.next();
        }
    }

    private void processCMObject(XMLStreamReader reader, GenericCMObject obj) throws XMLStreamException {
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                if (this.m_factory.getObjectDescriptor().supportsParameter(this._localName) || this.m_factory.getObjectDescriptor().supportsDate(this._localName) || this.m_factory.getObjectDescriptor().supportsNumeric(this._localName)) {
                    this.processParam(reader, obj);
                } else if (this.m_factory.getObjectDescriptor().supportsArray(this._localName)) {
                    this.processArray(reader, obj);
                } else if (this.m_factory.getObjectDescriptor().supportsMap(this._localName)) {
                    this.processMap(reader, obj);
                } else if (this._localName.equals("ancestors")) {
                    this.processAncestor(reader, obj);
                } else if (this.m_factory.getObjectDescriptor().supportsObject(this._localName)) {
                    if (NavUtils.moveToElementWithinParent("item", this._localName, reader)) {
                        this._type = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                        GenericCMObject nestedObject = this.m_factory.createObject(this._type);
                        obj.setObject(this._localName, nestedObject);
                        this.processCMObject(reader, nestedObject);
                    }
                } else if (this.m_factory.getObjectDescriptor().hasHandler(this._localName)) {
                    IXMLSerializable handler = this.m_factory.getObjectDescriptor().getHandler(this._localName);
                    obj.setAny(this._localName, handler);
                    IsolatedXMLStreamReader xsr = new IsolatedXMLStreamReader(reader);
                    handler.read((XMLStreamReader)xsr);
                } else {
                    StaxUtils.moveToNextSibling((XMLStreamReader)reader);
                }
            } else if (reader.isEndElement() && "item".equals(reader.getLocalName())) break;
            reader.next();
        }
    }

    private void processParam(XMLStreamReader reader, GenericCMObject obj) throws XMLStreamException {
        if (NavUtils.moveToElementWithinParent("value", this._localName, reader)) {
            obj.setParameter(this._localName, reader.getElementText().trim());
        } else {
            obj.setParameter(this._localName, "");
        }
    }

    private void processArray(XMLStreamReader reader, GenericCMObject obj) throws XMLStreamException {
        String arraytype = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        String arraylocalname = this._localName;
        obj.createArrayParameter(arraylocalname);
        while (NavUtils.moveToElementWithinParent("item", arraylocalname, reader)) {
            if ("cm:baseClassArrayProp".equals(arraytype)) {
                this._type = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                GenericCMObject nestedObject = this.m_factory.createObject(this._type);
                obj.setArrayParameter(arraylocalname, nestedObject);
                this.processCMObject(reader, nestedObject);
                continue;
            }
            obj.setArrayParameter(arraylocalname, reader.getElementText().trim());
        }
    }

    private void processMap(XMLStreamReader reader, GenericCMObject obj) throws XMLStreamException {
        this._mapName = this._localName;
        obj.createMapParameter(this._mapName);
        while (NavUtils.moveToElementWithinParent("item", this._mapName, reader)) {
            StaxUtils.moveToNextElement((XMLStreamReader)reader);
            this._name = reader.getElementText().trim();
            StaxUtils.moveToNextElement((XMLStreamReader)reader);
            obj.setMapParameter(this._mapName, this._name, this.getMapValue(reader));
        }
    }

    private Object getMapValue(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<String> list = null;
        int level = 0;
        StringBuffer textBuffer = new StringBuffer();
        while (reader.hasNext()) {
            reader.next();
            if (reader.isStartElement()) {
                textBuffer.setLength(0);
                ++level;
                if (list != null) continue;
                list = new ArrayList<String>();
                continue;
            }
            if (reader.isEndElement()) {
                if (level-- == 0) break;
                if (list == null) continue;
                list.add(textBuffer.toString());
                continue;
            }
            if (!reader.isCharacters()) continue;
            textBuffer.append(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
        }
        if (list != null) {
            return list;
        }
        return textBuffer.toString();
    }

    private void processAncestor(XMLStreamReader reader, GenericCMObject obj) throws XMLStreamException {
        while (NavUtils.moveToElementWithinParent("item", "ancestors", reader)) {
            reader.next();
            while (reader.hasNext()) {
                if (reader.isStartElement()) {
                    this._localName = reader.getLocalName();
                    if ("objectClass".equals(this._localName)) {
                        this._objectClass = reader.getElementText().trim();
                    } else if ("searchPath".equals(this._localName)) {
                        this._searchPath = reader.getElementText().trim();
                    } else if ("storeID".equals(this._localName)) {
                        this._storeID = reader.getElementText().trim();
                    } else if ("title".equals(this._localName)) {
                        this._title = reader.getElementText().trim();
                    }
                } else if (reader.isEndElement() && "item".equals(reader.getLocalName())) break;
                reader.next();
            }
            obj.addAncestor(this._objectClass, this._searchPath, this._storeID, this._title);
        }
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public List getObjectsFromQuery(int query) {
        if (query < this.m_CMQueries.size()) {
            return (List)this.m_CMQueries.get(query);
        }
        return Collections.EMPTY_LIST;
    }

    public List getAllObjects() {
        if (this.m_bMergeQueries) {
            if (this.m_CMObjects != null) {
                return this.m_CMObjects;
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList all = new ArrayList();
        for (List l : this.m_CMQueries) {
            all.addAll(l);
        }
        return all;
    }

    public String getCacheValidator() {
        return this.m_cacheValidator;
    }
}

