/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.request.nav.stax;

import com.cognos.cps.bseries.xts.common.sax.GenericCMObject;
import com.cognos.cps.bseries.xts.request.nav.RequestContext;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.CustomNavProperty;
import com.cognos.cps.bseries.xts.request.nav.element.navProperty.NavPropertyManager;
import com.cognos.cps.bseries.xts.request.nav.helpers.SearchContext;
import com.cognos.cps.bseries.xts.request.nav.op.CCPSOperation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class NavRequest {
    public static final String ITEMTYPE_SEPARATOR = "~";
    public static final String CHILD_OBJECTS_ALL = "all";
    public static final String CHILD_OBJECTS_CONTAINERS = "containers";
    public static final String CHILD_OBJECTS_ITEMS = "item";
    public static final String CHILD_OBJECTS_URLS = "urls";
    public static final String CHILD_OBJECTS_RSS = "rss";
    public static final String ELEM_VALIDATETAG = "validateTag";
    public static final String ELEM_CONTEXT = "context";
    public static final String ELEM_SOURCE_CONTEXT = "sourceContext";
    public static final String ELEM_STRING = "string";
    public static final String ELEM_SEARCHTYPE = "searchType";
    public static final String ELEM_SKIPOBJECTS = "skipObjects";
    public static final String ELEM_MAXOBJECTS = "maxObjects";
    public static final String ELEM_MATCH = "match";
    public static final String ELEM_ID = "id";
    public static final String ELEM_DEPLOYMENTID = "deploymentId";
    public static final String ELEM_CHILDOBJECTS = "childObjects";
    public static final String ELEM_CHILDOBJECTFILTER = "childObjectFilter";
    public static final String ELEM_CHILDOBJECTFILTER_ITEMTYPE = "itemType";
    public static final String ELEM_SORT = "sort";
    public static final String ELEM_SORT_USAGE = "sort@usage";
    public static final String ELEM_SCOPE = "scope";
    public static final String ELEM_OBJECTS = "objects";
    public static final String ELEM_ITEMMODDIFIED = "itemModified";
    public static final String ELEM_FIELDS = "fields";
    public static final String ELEM_RECURSIVE = "recursive";
    private static final String NAV_NAMESPACE = "http://developer.cognos.com/schemas/cps/navigation/1/";
    private static ArrayList ELEMENTS = new ArrayList();
    private GenericCMObject containerObj;
    private GenericCMObject userFolderObj;
    private Map prop;
    private CCPSOperation operation;
    private String opName;
    private HashMap properties = new HashMap();
    private HashMap params = new HashMap();
    private HashMap elements = new HashMap();
    private ArrayList actionsVisibilityRanges = null;
    private ArrayList linksVisibilityRanges = null;
    public static final int OPMODE_CONTENT = 1;
    public static final int OPMODE_ADMIN = 2;
    private int opMode = -1;
    private ArrayList customProperties;
    private ArrayList navRequests;
    private int cmRequestCount = -1;
    private String _localName;
    private String _namespaceURI;
    private String _propertyName;
    private String _value;
    private StringBuffer itemTypes = new StringBuffer();

    public NavRequest() {
        this.customProperties = new ArrayList();
        this.navRequests = new ArrayList();
        this.prop = new HashMap();
    }

    public void addParams(Map parms) {
        for (Map.Entry pair : parms.entrySet()) {
            String key = (String)pair.getKey();
            String val = (String)pair.getValue();
            this.params.put(key, val);
        }
    }

    public void parse(XMLStreamReader reader) throws XMLStreamException {
        reader.getEventType();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this.opName = reader.getLocalName();
                break;
            }
            reader.next();
        }
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                this._localName = reader.getLocalName();
                this._namespaceURI = reader.getNamespaceURI();
                if (NAV_NAMESPACE.equals(this._namespaceURI) && ELEMENTS.contains(this._localName)) {
                    this.handleElement(this._localName, reader);
                } else if (NAV_NAMESPACE.equals(this._namespaceURI) && "property".equals(this._localName)) {
                    this._propertyName = reader.getAttributeValue("", "name");
                    if (NavPropertyManager.isNavProperty(this._propertyName)) {
                        this.properties.put(this._propertyName, reader.getElementText().trim());
                    } else {
                        CustomNavProperty property = NavPropertyManager.getInstance().getCustomNavProperty(this._propertyName);
                        if (property != null) {
                            this.customProperties.add(property);
                        }
                    }
                } else if (NAV_NAMESPACE.equals(this._namespaceURI) && "param".equals(this._localName)) {
                    this.params.put(reader.getAttributeValue("", "name"), reader.getElementText().trim());
                } else if (NAV_NAMESPACE.equals(this._namespaceURI) && ELEM_CHILDOBJECTFILTER_ITEMTYPE.equals(this._localName)) {
                    this.itemTypes.append(reader.getElementText().trim()).append(ITEMTYPE_SEPARATOR);
                }
            } else if (reader.isEndElement() && this.opName.equals(reader.getLocalName())) break;
            reader.next();
        }
    }

    public void setOperation(CCPSOperation operation) {
        this.operation = operation;
    }

    public CCPSOperation getOperation() {
        return this.operation;
    }

    public String getOpName() {
        return this.opName;
    }

    public String getId() {
        return (String)this.elements.get(ELEM_ID);
    }

    public String getDeploymentId() {
        return (String)this.elements.get(ELEM_DEPLOYMENTID);
    }

    public String getChildObjects() {
        return (String)this.elements.get(ELEM_CHILDOBJECTS);
    }

    public int getSkipObjects() {
        Integer skipObjects = (Integer)this.elements.get(ELEM_SKIPOBJECTS);
        return skipObjects != null ? skipObjects : 0;
    }

    public boolean isSkipObjects() {
        return this.elements.containsKey(ELEM_SKIPOBJECTS);
    }

    public int getMaxObjects() {
        Integer maxObjects = (Integer)this.elements.get(ELEM_MAXOBJECTS);
        return maxObjects != null ? maxObjects : 0;
    }

    public LinkedHashMap getSortSpecs() {
        return (LinkedHashMap)this.elements.get(ELEM_SORT);
    }

    public String getSearchType() {
        return (String)this.elements.get(ELEM_SEARCHTYPE);
    }

    public String getItemTypes() {
        if (this.itemTypes.length() > 1) {
            return this.itemTypes.substring(0, this.itemTypes.length() - 1);
        }
        return null;
    }

    public SearchContext getSearchContext() {
        return (SearchContext)this.elements.get(ELEM_CONTEXT);
    }

    public String getSourceContext() {
        return (String)this.elements.get(ELEM_SOURCE_CONTEXT);
    }

    public String getSearchString() {
        return (String)this.elements.get(ELEM_STRING);
    }

    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public ArrayList getCustomProperties() {
        return this.customProperties;
    }

    public boolean isParam(String name) {
        return this.params.containsKey(name);
    }

    public String getParam(String name) {
        return (String)this.params.get(name);
    }

    public Enumeration getParamNames() {
        final Iterator it = this.params.keySet().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    private ArrayList initializeVisibilityRanges(String visibilityLevelParam) {
        ArrayList<Range> visibilityRanges = new ArrayList<Range>();
        String visibility = (String)this.params.get(visibilityLevelParam);
        if (visibility != null && visibility.length() > 0) {
            try {
                Matcher matcher = Pattern.compile("\\[(\\d+):(\\d+)\\]").matcher(visibility);
                while (matcher.find()) {
                    int low = Integer.parseInt(matcher.group(1));
                    int high = Integer.parseInt(matcher.group(2));
                    visibilityRanges.add(new Range(low, high));
                }
            }
            catch (Exception e) {
                visibilityRanges.add(new Range(0, 10));
            }
        } else {
            visibilityRanges.add(new Range(0, 10));
        }
        return visibilityRanges;
    }

    public boolean inActionsVisibilityRange(int visLevel) {
        boolean inRange = false;
        if (this.actionsVisibilityRanges == null) {
            this.actionsVisibilityRanges = this.initializeVisibilityRanges("actionsVisibilityLevel");
        }
        for (Range curRange : this.actionsVisibilityRanges) {
            if (!curRange.inRange(visLevel)) continue;
            inRange = true;
            break;
        }
        return inRange;
    }

    public boolean inLinksVisibilityRange(int visLevel) {
        boolean inRange = false;
        if (this.linksVisibilityRanges == null) {
            this.linksVisibilityRanges = this.initializeVisibilityRanges("linksVisibilityLevel");
        }
        for (Range curRange : this.linksVisibilityRanges) {
            if (!curRange.inRange(visLevel)) continue;
            inRange = true;
            break;
        }
        return inRange;
    }

    public Object getElement(String name) {
        return this.elements.get(name);
    }

    private void parseChildObjectFilter(XMLStreamReader reader) throws XMLStreamException {
        StringBuffer childrenFilter = new StringBuffer();
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                if (NAV_NAMESPACE.equals(reader.getNamespaceURI()) && ELEM_CHILDOBJECTFILTER_ITEMTYPE.equals(reader.getLocalName())) {
                    childrenFilter.append(reader.getElementText().trim()).append(ITEMTYPE_SEPARATOR);
                }
            } else if (reader.isEndElement() && ELEM_CHILDOBJECTFILTER.equals(reader.getLocalName())) break;
            reader.next();
        }
        this.elements.put(ELEM_CHILDOBJECTFILTER, childrenFilter);
    }

    private void handleElement(String name, XMLStreamReader reader) throws XMLStreamException {
        if (ELEM_CHILDOBJECTFILTER.equals(name)) {
            this.parseChildObjectFilter(reader);
        } else {
            if (ELEM_SORT.equals(name)) {
                this.elements.put(ELEM_SORT_USAGE, reader.getAttributeValue("", "usage"));
                LinkedHashMap<String, String> sortEntries = (LinkedHashMap<String, String>)this.elements.get(ELEM_SORT);
                if (sortEntries == null) {
                    sortEntries = new LinkedHashMap<String, String>();
                    this.elements.put(ELEM_SORT, sortEntries);
                }
                String order = reader.getAttributeValue("", "order");
                this._value = reader.getElementText().trim();
                sortEntries.put(this._value, order);
                return;
            }
            this._value = reader.getElementText().trim();
            if (ELEM_SKIPOBJECTS.equals(name)) {
                try {
                    this.elements.put(ELEM_SKIPOBJECTS, new Integer(this._value));
                }
                catch (Exception exception) {}
            } else if (ELEM_MAXOBJECTS.equals(name)) {
                try {
                    this.elements.put(ELEM_MAXOBJECTS, new Integer(this._value));
                }
                catch (Exception exception) {}
            } else if (ELEM_CONTEXT.equals(name)) {
                this.elements.put(ELEM_CONTEXT, new SearchContext(this._value));
            } else {
                this.elements.put(name, this._value);
            }
        }
    }

    public ArrayList getNavRequests() {
        return this.navRequests;
    }

    public void setCMRequestCount(int cmRequestCount) {
        this.cmRequestCount = cmRequestCount;
    }

    public int getCMRequestCount() {
        return this.cmRequestCount;
    }

    public boolean isCMOperation(RequestContext context) {
        return this.operation.isCMOperation(context);
    }

    public GenericCMObject getContainer() {
        return this.containerObj;
    }

    public GenericCMObject getUserFolder() {
        return this.userFolderObj;
    }

    public void setContainer(GenericCMObject obj) {
        this.containerObj = obj;
    }

    public void setUserFolder(GenericCMObject obj) {
        this.userFolderObj = obj;
    }

    public void setProp(String key, Object obj) {
        this.prop.put(key, obj);
    }

    public Object getProp(String key) {
        return this.prop.get(key);
    }

    public int getOpMode() {
        if (this.opMode == -1) {
            this.opMode = "admin".equals(this.getParam("mode")) ? 2 : 1;
        }
        return this.opMode;
    }

    static {
        ELEMENTS.add(ELEM_CONTEXT);
        ELEMENTS.add(ELEM_SOURCE_CONTEXT);
        ELEMENTS.add(ELEM_SEARCHTYPE);
        ELEMENTS.add(ELEM_STRING);
        ELEMENTS.add(ELEM_SKIPOBJECTS);
        ELEMENTS.add(ELEM_MAXOBJECTS);
        ELEMENTS.add(ELEM_MATCH);
        ELEMENTS.add(ELEM_ID);
        ELEMENTS.add(ELEM_DEPLOYMENTID);
        ELEMENTS.add(ELEM_CHILDOBJECTS);
        ELEMENTS.add(ELEM_CHILDOBJECTFILTER);
        ELEMENTS.add(ELEM_SORT);
        ELEMENTS.add(ELEM_VALIDATETAG);
        ELEMENTS.add(ELEM_ITEMMODDIFIED);
        ELEMENTS.add(ELEM_FIELDS);
        ELEMENTS.add(ELEM_RECURSIVE);
        ELEMENTS.add(ELEM_OBJECTS);
        ELEMENTS.add(ELEM_SCOPE);
    }

    private class Range {
        int lowValue;
        int highValue;

        public Range(int low, int high) {
            this.lowValue = low;
            this.highValue = high;
        }

        public boolean inRange(int visLevel) {
            return visLevel >= this.lowValue && visLevel <= this.highValue;
        }
    }
}

