/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.session;

import com.cognos.cps.bseries.xts.session.SessionMapHandler;
import com.cognos.cps.bseries.xts.session.SessionResult;
import com.cognos.cps.common.session.ISession;
import com.cognos.cps.common.session.SessionException;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.XTSException;
import com.cognos.xts.common.pool.AXTSPoolObject;
import com.cognos.xts.common.pool.sax.XTSSAXParserPool;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.XTSBusRequest;
import com.cognos.xts.interpreter.instructions.request.XTSBusResult;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SessionImpl
implements ISession {
    private static final String CM_TARGET = "bus://cm";
    private static final String ENVELOPE_S1 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader xsi:type=\"bus:biBusHeader\"><CAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"bus:CAM\"><CAMPassport xsi:type=\"bus:CAMPassport\"><id xsi:type=\"xsd:string\" xml:space=\"preserve\">";
    private static final String ENVELOPE_S2 = "</id></CAMPassport></CAM></bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body>";
    private static final String ENVELOPE_S3 = "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String CMD_GETIDS = "<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\"><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~~/runTimeState</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">state</item></properties></item></requests></cm:query>";
    private static final String CMD_GETREGIONS = "<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\"><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~/session</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">searchPath</item></properties></item></requests></cm:query>";
    private static final String CMD_REMOVE1 = "<cm:delete xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><search xsi:type=\"xsd:string\">~~/runTimeState[@name='";
    private static final String CMD_REMOVE2 = "']</search><options xsi:type=\"cm:deleteOptions\"><recursive xsi:type=\"xsd:boolean\">true</recursive><force xsi:type=\"xsd:boolean\">true</force></options></cm:delete>";
    private static final String CMD_PUT1 = "<cm:add xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><search xsi:type=\"xsd:string\">~~</search><objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[]\"><item xsi:type=\"cm:runTimeState\"><defaultName xsi:type=\"cm:stringProp\"><value xsi:type=\"xsd:string\">";
    private static final String CMD_PUT2 = "</value></defaultName><state xsi:type=\"cm:anyTypeProp\"><value xsi:type=\"xsd:string\">";
    private static final String CMD_PUT3 = "</value></state></item></objects><options xsi:type=\"cm:addOptions\"><updateAction xsi:type=\"cm:updateActionEnum\">update</updateAction></options></cm:add>";
    private static final String CMD_GET1 = "<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:queryRequest[]\"><item xsi:type=\"cm:queryRequest\"><search xsi:type=\"xsd:string\">~~/runTimeState[@name='";
    private static final String CMD_GET2 = "']</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">defaultName</item><item xsi:type=\"cm:propEnum\">state</item></properties></item></requests></cm:query>";
    private XTSBusRequest busRequest = null;
    private String m_identifier;

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_identifier = identifier;
        this.busRequest = new XTSBusRequest();
        this.busRequest.initialize(env, identifier, instAtts, instParams);
    }

    public void terminate() throws XTSInstructionException {
        this.busRequest.terminate();
    }

    private Reader sendCMRequest(XTSEnvironment env, Reader request) throws XTSInstructionException {
        HashMap<String, String> cmAtts = new HashMap<String, String>();
        cmAtts.put("target", CM_TARGET);
        HashMap<String, String[]> cmParams = new HashMap<String, String[]>();
        cmParams.put("soapAction", new String[]{"http://www.ibm.com/xmlns/prod/cognos/contentManagerService/201904/"});
        cmParams.put("responseEnvelope", new String[]{"false"});
        XTSBusResult response = (XTSBusResult)this.busRequest.execute(env, cmAtts, cmParams, request);
        Reader reader = response.getResult().getReader();
        return reader;
    }

    private Reader buildSoapEnvelope(String request, String passport) {
        StringBuffer envelope = new StringBuffer();
        envelope.append(ENVELOPE_S1);
        envelope.append(passport);
        envelope.append(ENVELOPE_S2);
        envelope.append(request);
        envelope.append(ENVELOPE_S3);
        return new StringReader(envelope.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionMapHandler parseResponse(Reader result, String itemType, String keyElement, String valueElement) throws SessionException {
        SessionMapHandler sessionMapHandler;
        AXTSPoolObject parser = XTSSAXParserPool.getInstance().acquire();
        try {
            XMLReader xmlreader = ((SAXParser)parser.get()).getXMLReader();
            SessionMapHandler handler = new SessionMapHandler(xmlreader, itemType, keyElement, valueElement);
            xmlreader.setContentHandler(handler);
            xmlreader.parse(new InputSource(result));
            sessionMapHandler = handler;
        }
        catch (Throwable throwable) {
            try {
                XTSSAXParserPool.getInstance().put(parser);
                throw throwable;
            }
            catch (IOException e) {
                Object[] args = new String[]{this.m_identifier};
                throw new SessionException("cps.common.parse.io.error", args);
            }
            catch (SAXException e) {
                Object[] args = new String[]{this.m_identifier};
                throw new SessionException("cps.common.parse.sax.error", args);
            }
            catch (XTSException e) {
                Object[] args = new String[]{this.m_identifier};
                throw new SessionException("cps.common.parse.error", args, (Throwable)e);
            }
        }
        XTSSAXParserPool.getInstance().put(parser);
        return sessionMapHandler;
    }

    public void put(Object environment, String id, String region, Object value) throws SessionException {
        XTSEnvironment env = (XTSEnvironment)environment;
        char[] buf = new char[1024];
        StringBuffer sb = new StringBuffer();
        Reader body = (Reader)value;
        if (body != null) {
            try {
                int charsRead;
                while ((charsRead = body.read(buf)) != -1) {
                    sb.append(buf, 0, charsRead);
                }
            }
            catch (IOException e) {
                Object[] args = new String[]{this.m_identifier};
                throw new SessionException("cps.common.bodyread.error", args);
            }
        }
        StringBuffer request = new StringBuffer();
        request.append(CMD_PUT1);
        EncodingUtils.xmlEncode((String)id, (StringBuffer)request);
        request.append(CMD_PUT2);
        EncodingUtils.xmlEncode((String)sb.toString(), (StringBuffer)request);
        request.append(CMD_PUT3);
        Reader soapEnvelope = this.buildSoapEnvelope(request.toString(), region);
        try {
            this.sendCMRequest(env, soapEnvelope);
        }
        catch (XTSInstructionException e) {
            Object[] args = new String[]{this.m_identifier};
            throw new SessionException("cps.session.request.error", args, (Throwable)e);
        }
    }

    public Object get(Object environment, String id, String region) throws SessionException {
        Reader result;
        XTSEnvironment env = (XTSEnvironment)environment;
        StringBuffer request = new StringBuffer();
        request.append(CMD_GET1);
        EncodingUtils.xmlEncode((String)id, (StringBuffer)request);
        request.append(CMD_GET2);
        Reader soapEnvelope = this.buildSoapEnvelope(request.toString(), region);
        try {
            result = this.sendCMRequest(env, soapEnvelope);
        }
        catch (XTSInstructionException e) {
            Object[] args = new String[]{this.m_identifier};
            throw new SessionException("cps.session.request.error", args, (Throwable)e);
        }
        SessionMapHandler handler = this.parseResponse(result, "cm:runTimeState", "defaultName", "state");
        String value = handler.getValue(id);
        return new SessionResult(value);
    }

    public void remove(Object environment, String id, String region) throws SessionException {
        XTSEnvironment env = (XTSEnvironment)environment;
        StringBuffer request = new StringBuffer();
        request.append(CMD_REMOVE1);
        EncodingUtils.xmlEncode((String)id, (StringBuffer)request);
        request.append(CMD_REMOVE2);
        Reader soapEnvelope = this.buildSoapEnvelope(request.toString(), region);
        try {
            this.sendCMRequest(env, soapEnvelope);
        }
        catch (XTSInstructionException e) {
            Object[] args = new String[]{this.m_identifier};
            throw new SessionException("cps.session.request.error", args, (Throwable)e);
        }
    }

    public String[] getIds(Object environment, String region) throws SessionException {
        Reader result;
        XTSEnvironment env = (XTSEnvironment)environment;
        Reader soapEnvelope = this.buildSoapEnvelope(CMD_GETIDS, region);
        SessionMapHandler handler = null;
        try {
            result = this.sendCMRequest(env, soapEnvelope);
        }
        catch (XTSInstructionException e) {
            Object[] args = new String[]{this.m_identifier};
            throw new SessionException("cps.session.request.error", args, (Throwable)e);
        }
        handler = this.parseResponse(result, "cm:runTimeState", "defaultName", "state");
        String[] ids = handler.getKeys();
        return ids;
    }

    public String[] getRegions(Object environment, String region) throws SessionException {
        Reader result;
        XTSEnvironment env = (XTSEnvironment)environment;
        Reader soapEnvelope = this.buildSoapEnvelope(CMD_GETREGIONS, region);
        try {
            result = this.sendCMRequest(env, soapEnvelope);
        }
        catch (XTSInstructionException e) {
            Object[] args = new String[]{this.m_identifier};
            throw new SessionException("cps.session.request.error", args, (Throwable)e);
        }
        SessionMapHandler handler = this.parseResponse(result, "cm:session", "defaultName", "searchPath");
        String[] regions = handler.getKeys();
        return regions;
    }

    public void invalidate(Object envioronment, String region) throws SessionException {
    }
}

