/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.session;

import java.util.HashMap;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SessionMapHandler
extends DefaultHandler {
    private static final String ITEM_ELEMENT = "item";
    private static final String TYPE_ATTRIBUTE = "xsi:type";
    private HashMap m_sessionValues;
    private boolean m_item;
    private String m_currentKey;
    private String m_currentValue;
    private String m_keyElement;
    private String m_valueElement;
    private String m_itemType;
    private ValueHandler m_propertyHandler;
    private XMLReader m_reader;

    public SessionMapHandler(XMLReader reader, String itemType, String keyElement, String valueElement) {
        this.m_reader = reader;
        this.m_sessionValues = new HashMap();
        this.m_keyElement = keyElement;
        this.m_valueElement = valueElement;
        this.m_itemType = itemType;
        this.m_propertyHandler = new ValueHandler(reader, this);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_item) {
            if (localName.equals(this.m_keyElement)) {
                this.m_currentKey = this.m_propertyHandler.getChars();
            } else if (localName.equals(this.m_valueElement)) {
                this.m_currentValue = this.m_propertyHandler.getChars();
            } else if (localName.equals(ITEM_ELEMENT)) {
                if (this.m_currentKey != null) {
                    this.m_sessionValues.put(this.m_currentKey, this.m_currentValue);
                }
                this.m_item = false;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_item) {
            if (localName.equals(this.m_keyElement)) {
                this.m_reader.setContentHandler(this.m_propertyHandler);
            } else if (localName.equals(this.m_valueElement)) {
                this.m_reader.setContentHandler(this.m_propertyHandler);
            }
        } else if (localName.equals(ITEM_ELEMENT) && this.m_itemType.equals(attributes.getValue(TYPE_ATTRIBUTE))) {
            this.m_item = true;
        }
    }

    public String getValue(String key) {
        return (String)this.m_sessionValues.get(key);
    }

    public String[] getKeys() {
        Set keys = this.m_sessionValues.keySet();
        String[] result = new String[keys.size()];
        keys.toArray(result);
        return result;
    }

    static class ValueHandler
    extends DefaultHandler {
        private static final String VALUE_ELEMENT = "value";
        private boolean collectChars;
        private StringBuffer currentChars;
        private DefaultHandler parent;
        private XMLReader reader;
        private int index;

        public ValueHandler(XMLReader reader, DefaultHandler parent) {
            this.reader = reader;
            this.parent = parent;
            this.currentChars = new StringBuffer();
            this.index = 0;
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            if (this.collectChars) {
                this.currentChars.append(new String(arg0, arg1, arg2));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            --this.index;
            if (localName.equals(VALUE_ELEMENT)) {
                this.collectChars = false;
            }
            if (this.index == 0) {
                this.reader.setContentHandler(this.parent);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            ++this.index;
            if (localName.equals(VALUE_ELEMENT)) {
                this.collectChars = true;
                this.currentChars.setLength(0);
            }
        }

        public String getChars() {
            return this.currentChars.toString();
        }
    }
}

