/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.bseries.xts.session;

import com.cognos.cps.bseries.xts.session.SessionImpl;
import com.cognos.cps.bseries.xts.session.SessionResult;
import com.cognos.cps.common.session.SessionException;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.UXTSInstructionUtils;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.request.IXTSRequestInstruction;
import java.io.Reader;
import java.util.Map;

public class SessionRequest
extends AXTSInstruction
implements IXTSRequestInstruction {
    private static final String LIST_DELIMITER = ", ";
    private static final String METHOD_GET = "get";
    private static final String METHOD_GETIDS = "getIds";
    private static final String METHOD_GETREGIONS = "getRegions";
    private static final String METHOD_INVALIDATE = "invalidate";
    private static final String METHOD_PUT = "put";
    private static final String METHOD_REMOVE = "remove";
    protected String m_identifier = null;
    protected SessionImpl m_session = new SessionImpl();

    private String arrayToString(String[] array) {
        StringBuffer buf = new StringBuffer();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                EncodingUtils.xmlEncode((String)array[i], (StringBuffer)buf);
                if (i >= array.length - 1) continue;
                buf.append(LIST_DELIMITER);
            }
        }
        return buf.toString();
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        String method = UXTSInstructionUtils.getParameter((String)"method", (Map)instParams);
        if (method == null) {
            Object[] args = new String[]{this.m_identifier, "method"};
            throw new XTSInstructionException("cps.common.missingparameter.error", args);
        }
        try {
            if (method.equals(METHOD_GET)) {
                String region = this.getParam("region", instParams, true);
                String id = this.getParam("id", instParams, true);
                this.validateParam(id);
                Object result = this.m_session.get(env, id, region);
                return (SessionResult)result;
            }
            if (method.equals(METHOD_PUT)) {
                String region = this.getParam("region", instParams, true);
                String id = this.getParam("id", instParams, true);
                this.validateParam(id);
                this.m_session.put(env, id, region, body);
                return new SessionResult("");
            }
            if (method.equals(METHOD_REMOVE)) {
                String region = this.getParam("region", instParams, true);
                String id = this.getParam("id", instParams, true);
                this.validateParam(id);
                this.m_session.remove(env, id, region);
                return new SessionResult("");
            }
            if (method.equals(METHOD_INVALIDATE)) {
                String region = this.getParam("region", instParams, true);
                this.m_session.invalidate(env, region);
                return new SessionResult("");
            }
            if (method.equals(METHOD_GETREGIONS)) {
                String region = this.getParam("region", instParams, true);
                String[] regions = this.m_session.getRegions(env, region);
                return new SessionResult(this.arrayToString(regions));
            }
            if (method.equals(METHOD_GETIDS)) {
                String region = this.getParam("region", instParams, true);
                String[] ids = this.m_session.getIds(env, region);
                return new SessionResult(this.arrayToString(ids));
            }
            Object[] args = new String[]{this.m_identifier, method};
            throw new XTSInstructionException("cps.common.undefinedmethod.error", args);
        }
        catch (SessionException e) {
            throw new XTSInstructionException(e.getKey(), e.copyArgs(), e.getRootCause());
        }
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    private String getParam(String param, Map instParams, boolean required) throws XTSInstructionException {
        String s = UXTSInstructionUtils.getParameter((String)param, (Map)instParams);
        if (required && (s == null || s.length() == 0)) {
            Object[] args = new String[]{this.m_identifier, param};
            throw new XTSInstructionException("cps.session.noparam.error", args);
        }
        return s;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_identifier = identifier;
        this.m_session.initialize(env, identifier, instAtts, instParams);
    }

    public boolean isInitialized() {
        return this.m_identifier != null;
    }

    public void terminate() throws XTSInstructionException {
        this.m_identifier = null;
        this.m_session.terminate();
    }

    private void validateParam(String s) throws XTSInstructionException {
        if (s.indexOf(39) != -1) {
            Object[] args = new String[]{this.m_identifier, s};
            throw new XTSInstructionException("cps.session.invalidparam.error", args);
        }
    }
}

