/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.cache;

import com.cognos.cps.cache.Cache;
import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.block.BlockCache;
import com.cognos.cps.cache.block.BlockCacheLimited;
import com.cognos.cps.cache.block.BlockManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CacheManager {
    private BlockManager blockManager;
    private ExpiryThread expiryThread;
    int timeToLiveSeconds;
    int timeToIdleSeconds;
    int checkExpiryIntervalSeconds;
    Map caches;
    private int maxCacheSize;
    private CacheEncryptor cacheEncryptor;

    public CacheManager(String name, File cacheDirectory, int timeToIdleSeconds, int timeToLiveSeconds, int checkExpiryIntervalSeconds, CacheEncryptor cacheEncryptor, int maxCacheSize) {
        this.blockManager = new BlockManager(cacheDirectory, name);
        this.caches = new HashMap();
        this.cacheEncryptor = cacheEncryptor;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.checkExpiryIntervalSeconds = checkExpiryIntervalSeconds;
        this.maxCacheSize = maxCacheSize;
        this.expiryThread = new ExpiryThread();
        this.expiryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getCache(Object region) {
        Map map = this.caches;
        synchronized (map) {
            Cache cache = (Cache)this.caches.get(region);
            if (cache != null) {
                cache.touch();
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCache(Object region) {
        Cache cache;
        Map map = this.caches;
        synchronized (map) {
            cache = (Cache)this.caches.remove(region);
        }
        if (cache != null) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache createCache(Object region) {
        Map map = this.caches;
        synchronized (map) {
            Cache cache = (Cache)this.caches.get(region);
            if (cache == null) {
                cache = this.maxCacheSize > 0 ? new BlockCacheLimited(this.blockManager, this.cacheEncryptor, this.maxCacheSize) : new BlockCache(this.blockManager, this.cacheEncryptor);
                this.caches.put(region, cache);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCacheIds() {
        Map map = this.caches;
        synchronized (map) {
            return new HashSet(this.caches.keySet());
        }
    }

    public void terminate() {
        this.expiryThread.stopRunning();
    }

    private class ExpiryThread
    extends Thread {
        private final int checkExpiryInterval;
        private final int timeToIdle;
        private final int timeToLive;
        private boolean keepRunning;

        public ExpiryThread() {
            super("CPS Cache Expiry Thread");
            this.checkExpiryInterval = CacheManager.this.checkExpiryIntervalSeconds * 1000;
            this.timeToIdle = CacheManager.this.timeToIdleSeconds * 1000;
            this.timeToLive = CacheManager.this.timeToLiveSeconds * 1000;
            this.keepRunning = true;
            this.setDaemon(true);
        }

        public synchronized boolean keepRunning() {
            return this.keepRunning;
        }

        public synchronized void stopRunning() {
            this.keepRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.keepRunning()) {
                    Thread.sleep(this.checkExpiryInterval);
                    Collection ids = CacheManager.this.getCacheIds();
                    for (Object key : ids) {
                        Cache cache = (Cache)CacheManager.this.caches.get(key);
                        if (cache == null) continue;
                        if (cache.isEmpty()) {
                            Map map = CacheManager.this.caches;
                            synchronized (map) {
                                if (System.currentTimeMillis() >= cache.lastAccessTime() + (long)this.timeToIdle) {
                                    CacheManager.this.caches.remove(key);
                                }
                            }
                            cache.clear();
                            continue;
                        }
                        cache.handleExpiredContent(this.timeToLive, this.timeToIdle);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

