/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.cache.block;

import com.cognos.cps.cache.Cache;
import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.CacheException;
import com.cognos.cps.cache.block.BlockHandle;
import com.cognos.cps.cache.block.BlockManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BlockCache
extends Cache {
    Map cacheMap = Collections.synchronizedMap(new HashMap());
    BlockManager blockManager;
    private CacheEncryptor cacheEncryptor;

    public BlockCache(BlockManager bm, CacheEncryptor cacheEncryptor) {
        this.blockManager = bm;
        this.cacheEncryptor = cacheEncryptor;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<BlockCacheElement> freeList = new ArrayList<BlockCacheElement>();
        Map map = this.cacheMap;
        synchronized (map) {
            for (Object key : this.keySet()) {
                BlockCacheElement element = (BlockCacheElement)this.cacheMap.remove(key);
                freeList.add(element);
            }
        }
        for (BlockCacheElement element : freeList) {
            try {
                this.blockManager.free(element.blockHandle);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public Collection values() {
        return super.values();
    }

    @Override
    public void putAll(Map t) {
        if (t instanceof BlockCache) {
            this.cacheMap.putAll(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        HashSet<BlockCacheEntry> entrySet = new HashSet<BlockCacheEntry>();
        Map map = this.cacheMap;
        synchronized (map) {
            for (Object key : this.cacheMap.keySet()) {
                if (key == null) continue;
                entrySet.add(new BlockCacheEntry(key));
            }
        }
        return entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set keySet() {
        HashSet copy;
        Map map = this.cacheMap;
        synchronized (map) {
            copy = new HashSet(this.cacheMap.keySet());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        BlockCacheElement element;
        Map map = this.cacheMap;
        synchronized (map) {
            element = (BlockCacheElement)this.cacheMap.get(key);
            if (element != null) {
                element.touch();
            }
        }
        if (element != null) {
            byte[] bytes = new byte[element.size];
            try {
                this.blockManager.read(element.blockHandle, bytes);
                byte[] clearBytes = this.cacheEncryptor.decrypt(bytes);
                ByteArrayInputStream instr = new ByteArrayInputStream(clearBytes);
                ObjectInputStream objstr = new ObjectInputStream(instr);
                return objstr.readObject();
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new CacheException("cps.cache.block.getfailed", args, e);
            }
            catch (ClassNotFoundException e) {
                String[] args = new String[]{e.getMessage()};
                throw new CacheException("cps.cache.block.getfailed", args, e);
            }
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        BlockCacheElement element = (BlockCacheElement)this.cacheMap.remove(key);
        if (element != null) {
            byte[] bytes = new byte[element.size];
            try {
                this.blockManager.read(element.blockHandle, bytes);
                this.blockManager.free(element.blockHandle);
                byte[] clearBytes = this.cacheEncryptor.decrypt(bytes);
                ByteArrayInputStream instr = new ByteArrayInputStream(clearBytes);
                ObjectInputStream objstr = new ObjectInputStream(instr);
                return objstr.readObject();
            }
            catch (IOException e) {
                throw new CacheException("BlockCache.removefailed" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new CacheException("BlockCache.removefailed" + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Object put(Object key, Object value) {
        BlockCacheElement element = new BlockCacheElement();
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objstr = new ObjectOutputStream(outstr);
            objstr.writeObject(value);
            objstr.close();
            byte[] bytes = outstr.toByteArray();
            byte[] cipherBytes = this.cacheEncryptor.encrypt(bytes);
            element.size = cipherBytes.length;
            element.blockHandle = this.blockManager.write(cipherBytes);
            BlockCacheElement oldElement = this.cacheMap.put(key, element);
            if (oldElement != null) {
                this.blockManager.free(oldElement.blockHandle);
            }
        }
        catch (IOException e) {
            throw new CacheException("BlockCache.putfailed" + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireOldContent(int expiresAfter, int maxIdle) {
        long now = System.currentTimeMillis();
        ArrayList<BlockCacheElement> freeList = new ArrayList<BlockCacheElement>();
        Map map = this.cacheMap;
        synchronized (map) {
            for (Object key : this.keySet()) {
                BlockCacheElement element = (BlockCacheElement)this.cacheMap.get(key);
                if (now < element.creationTime() + (long)expiresAfter && now < element.lastAccessTime() + (long)maxIdle) continue;
                this.cacheMap.remove(key);
                freeList.add(element);
            }
        }
        for (BlockCacheElement element : freeList) {
            try {
                this.blockManager.free(element.blockHandle);
            }
            catch (IOException iOException) {}
        }
    }

    protected class BlockCacheEntry
    implements Map.Entry {
        private Object key;

        BlockCacheEntry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return BlockCache.this.get(this.key);
        }

        public Object setValue(Object value) {
            return BlockCache.this.put(this.key, value);
        }
    }

    protected class BlockCacheElement
    extends Cache.CacheElement {
        int size;
        BlockHandle blockHandle;

        protected BlockCacheElement() {
        }
    }
}

