/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.cache.block;

import com.cognos.cps.cache.CacheEncryptor;
import com.cognos.cps.cache.block.BlockCache;
import com.cognos.cps.cache.block.BlockManager;
import java.util.ArrayList;

public class BlockCacheLimited
extends BlockCache {
    private int maxSize;

    public BlockCacheLimited(BlockManager bm, CacheEncryptor cacheEncryptor, int maxSize) {
        super(bm, cacheEncryptor);
        this.maxSize = maxSize;
    }

    @Override
    public Object put(Object key, Object value) {
        String strkey = key instanceof String ? (String)key : key.toString();
        String subkey = strkey.substring(0, strkey.indexOf("#"));
        String checksum = strkey.substring(strkey.indexOf("#") + 1);
        Object obj = super.get(subkey);
        ArrayList<String> checksumList = null;
        if (obj instanceof ArrayList) {
            checksumList = (ArrayList<String>)obj;
            checksumList.remove(checksum);
            int removeCount = checksumList.size() - this.maxSize + 1;
            for (int i = 0; i < removeCount; ++i) {
                String removedChecksum = (String)checksumList.remove(0);
                super.remove(subkey + "#" + removedChecksum);
            }
        } else {
            checksumList = new ArrayList<String>(this.maxSize);
        }
        checksumList.add(checksum);
        super.put(subkey, checksumList);
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        String strkey = key instanceof String ? (String)key : key.toString();
        String subkey = strkey.substring(0, strkey.indexOf("#"));
        String checksum = strkey.substring(strkey.indexOf("#") + 1);
        Object obj = super.get(subkey);
        if (obj instanceof ArrayList) {
            ArrayList checksumList = (ArrayList)obj;
            checksumList.remove(checksum);
            if (checksumList.isEmpty()) {
                super.remove(subkey);
            } else {
                super.put(subkey, checksumList);
            }
        }
        return super.remove(key);
    }

    @Override
    public boolean isMaxSizeReached(Object key) {
        ArrayList checksumList;
        String strkey = key instanceof String ? (String)key : key.toString();
        String subkey = strkey.substring(0, strkey.indexOf("#"));
        Object obj = super.get(subkey);
        return obj instanceof ArrayList && (checksumList = (ArrayList)obj).size() >= this.maxSize;
    }
}

