/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.cache.block;

import com.cognos.cps.cache.block.BlockHandle;
import com.cognos.cps.cache.block.BlockStore;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BlockManager {
    private Map blockStoreMap = Collections.synchronizedMap(new HashMap());
    private String filePrefix;
    private File cacheDir;

    public BlockManager(File file, String prefix) {
        if (file.isDirectory()) {
            this.cacheDir = new File(file, prefix);
            this.cacheDir.mkdir();
        } else {
            this.cacheDir = new File(file.getParentFile(), prefix);
        }
        this.cacheDir.mkdir();
        this.filePrefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockHandle write(byte[] bytes) throws IOException {
        BlockStore bs;
        Long blockSize = new Long(Math.round(Math.pow(2.0, Math.ceil(Math.log(bytes.length) / Math.log(2.0)))));
        Map map = this.blockStoreMap;
        synchronized (map) {
            bs = (BlockStore)this.blockStoreMap.get(blockSize);
            if (bs == null) {
                bs = new BlockStore(new File(this.cacheDir, this.filePrefix + "." + blockSize), blockSize.intValue());
                this.blockStoreMap.put(blockSize, bs);
            }
        }
        BlockHandle bh = new BlockHandle();
        bh.blockSize = blockSize.intValue();
        bh.blockOffSet = bs.write(bytes);
        return bh;
    }

    public void read(BlockHandle bh, byte[] bytes) throws IOException {
        BlockStore bs = (BlockStore)this.blockStoreMap.get(new Long(bh.blockSize));
        if (bs == null) {
            return;
        }
        bs.read(bh.blockOffSet, bytes);
    }

    public void free(BlockHandle bh) throws IOException {
        BlockStore bs = (BlockStore)this.blockStoreMap.get(new Long(bh.blockSize));
        if (bs == null) {
            return;
        }
        bs.free(bh.blockOffSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Map map = this.blockStoreMap;
        synchronized (map) {
            for (BlockStore blockStore : this.blockStoreMap.entrySet()) {
                blockStore.clear();
            }
            this.blockStoreMap.clear();
        }
    }
}

