/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.cache.block;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.SortedSet;
import java.util.TreeSet;

public class BlockStore {
    private RandomAccessFile blockFile;
    private int blockSize;
    private SortedSet freeBlocks;

    public BlockStore(File file, int blockSize) throws IOException {
        this.blockSize = blockSize;
        this.freeBlocks = new TreeSet();
        file.deleteOnExit();
        this.blockFile = new RandomAccessFile(file, "rw");
        this.blockFile.setLength(0L);
    }

    public synchronized void read(int block, byte[] bytes) throws IOException {
        this.blockFile.seek(block * this.blockSize);
        this.blockFile.readFully(bytes, 0, Math.min(this.blockSize, bytes.length));
    }

    public synchronized int write(byte[] bytes) throws IOException {
        int block;
        if (!this.freeBlocks.isEmpty()) {
            block = (Integer)this.freeBlocks.first();
            this.blockFile.seek(block * this.blockSize);
            this.blockFile.write(bytes, 0, Math.min(this.blockSize, bytes.length));
            this.freeBlocks.remove(this.freeBlocks.first());
        } else {
            block = new Long(this.blockFile.length() / (long)this.blockSize).intValue();
            this.blockFile.seek(this.blockFile.length());
            this.blockFile.setLength(this.blockFile.length() + (long)this.blockSize);
            this.blockFile.write(bytes, 0, Math.min(this.blockSize, bytes.length));
        }
        return block;
    }

    public synchronized void free(int block) throws IOException {
        if ((long)(block * this.blockSize) < this.blockFile.length()) {
            this.freeBlocks.add(new Integer(block));
            if ((long)(this.freeBlocks.size() * this.blockSize) >= this.blockFile.length()) {
                this.blockFile.setLength(0L);
                this.freeBlocks.clear();
            }
        }
    }

    public synchronized long size() throws IOException {
        return this.blockFile.length();
    }

    public synchronized void clear() throws IOException {
        this.blockFile.setLength(0L);
        this.freeBlocks.clear();
    }
}

