/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.fragment;

import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.common.utils.XMLUtils;
import com.cognos.cps.fragment.WSRPBridge;
import com.cognos.cps.pagelet.common.utils.AssemblerStateEncoder;
import com.cognos.cps.pagelet.common.utils.PageletFactory;
import com.cognos.cps.pagelet.common.utils.PortletRefs;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.consumer.v1.intf.IConsumer;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkupResponse;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Interaction;
import com.cognos.cps.services.pagelet.objects.v1.types.Metadata;
import com.cognos.cps.services.pagelet.objects.v1.types.NewPortletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageState;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletState;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletMarkup;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPageletResponse;
import com.cognos.cps.services.soap.envelope.Detail;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.LocalizedString;
import com.cognos.cps.services.wsrp.v1.types.MarkupType;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import com.cognos.cps.services.wsrp.v1.types.Resource;
import com.cognos.cps.services.wsrp.v1.types.ResourceList;
import com.cognos.cps.services.wsrp.v1.types.ResourceValue;
import com.cognos.cps.services.wsrp.v1.types.ServiceDescription;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.schemas.AnyType;
import com.cognos.portal.schemas.QName;
import com.cognos.portal.schemas.fragments.Default;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Info;
import com.cognos.portal.schemas.fragments.Meta;
import com.cognos.portal.schemas.fragments.Params;
import com.cognos.portal.schemas.fragments.Properties;
import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.PipelineException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exolab.castor.types.AnyNode;

public class PortletToFragment
extends WSRPBridge {
    private static final String VALIDATE_NAMESPACE_PREFIX = "val";
    private static final String VALIDATE_NAMESPACE_URI = "http://developer.cognos.com/schemas/validator/1/";
    private static final String CUSTOM_PORTLET_CONTEXT = "wsrp_portlet_context";
    private static final String CUSTOM_PORTLET_HANDLE = "wsrp_portlet_handle";
    private static final String CUSTOM_PORTLET_STATE_EXTENSION = "wsrp_portlet_state_extension";
    private static final String TRANSIENT_P2P = "wsrp_p2pc";
    private static final String TRANSIENT_PACKAGE_STATE = "pkgState";
    public static final String WSRP_TO_FRAGMENT_BRIDGE_PARAMS = "wtfbparams";
    private ServiceLogger logger;
    private IConsumer m_consumer;
    private Map storages;
    private List sharedParameters;

    public PortletToFragment(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(PortletToFragment.class) : null;
    }

    private IStorage getStorage(String path, IContext context) {
        IStorage storage;
        String key = null;
        if (path != null && path.length() > 0) {
            int index = path.indexOf(47, 1);
            key = path.substring(0, index);
        }
        if (key == null) {
            key = path;
        }
        if ((storage = (IStorage)this.storages.get(key)) == null && (storage = PageletFactory.createStorageObject(key, context, null)) != null) {
            this.storages.put(key, storage);
        }
        return storage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(Map inputs) throws PipelineException {
        IContext cpsContext = this.getCpsContext(Locale.ENGLISH);
        this.m_consumer = PageletFactory.createConsumerObject(null, cpsContext, null);
        this.storages = new HashMap();
        boolean isSharedParam = false;
        String localName = null;
        XMLStreamReader xsr = (XMLStreamReader)inputs.get("bridge.config");
        if (xsr == null) return;
        this.sharedParameters = new ArrayList();
        try {
            block6: while (xsr.hasNext()) {
                int event = xsr.next();
                switch (event) {
                    case 1: {
                        localName = xsr.getLocalName();
                        if ("shared".equals(localName)) {
                            isSharedParam = true;
                            break;
                        }
                        if (!isSharedParam || !"param".equals(localName)) break;
                        String name = xsr.getAttributeValue("", "name");
                        if (name == null || name.length() <= 0) continue block6;
                        this.sharedParameters.add(name);
                        break;
                    }
                    case 2: {
                        if (!"shared".equals(localName)) break;
                        isSharedParam = false;
                        continue block6;
                    }
                }
            }
            return;
        }
        catch (XMLStreamException e) {
            throw new PipelineException("Error while configuring WSRP bridge", (Throwable)e);
        }
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        this.portletToFragment(context);
    }

    private void portletToFragment(StageContext context) throws PipelineException {
        Fragment fragment = context.getFragment();
        try {
            Parameters controllerParams;
            XMLParameters customs = context.getCustomsParams();
            XMLParameters state = context.getStateParams();
            XMLParameters transients = context.getTransientParams();
            XMLParameters interactions = context.getInteractionParams();
            String tunnelParams = interactions.getValue(WSRP_TO_FRAGMENT_BRIDGE_PARAMS);
            if (tunnelParams != null && tunnelParams.length() > 0) {
                tunnelParams = new String(EncodingUtils.web64decode((String)tunnelParams, (boolean)true), "UTF-8");
                XMLParameters tmpParams = XMLParameters.parse((String)tunnelParams);
                interactions.remove(WSRP_TO_FRAGMENT_BRIDGE_PARAMS);
                interactions.addAll((Collection)tmpParams);
            }
            IContext cpsContext = this.getCpsContext(context);
            QueryPageletResponse queryPageletResponse = this.queryPagelet(cpsContext, context);
            queryPageletResponse.getPagelet().getPortletInstance()[0].removeAccessRights(AccessRightsType.READONLY);
            queryPageletResponse.getPagelet().getPortletInstance()[0].removeAccessRights(AccessRightsType.DISABLED);
            queryPageletResponse.getPagelet().getPortletInstance()[0].removeAccessRights(AccessRightsType.LOCKED);
            Metadata meta = queryPageletResponse.getPagelet().getMetadata();
            if (meta == null) {
                throw new PipelineException("The pagelet response does not contain any metadata");
            }
            if (meta.getPortletProducerCount() < 1) {
                throw new PipelineException("The pagelet response does not contain any portlet producer");
            }
            PortletProducer portletProducer = meta.getPortletProducer(0);
            String transientPropertiesSuffix = portletProducer.getId();
            this.fixTransients(TRANSIENT_P2P + transientPropertiesSuffix, transients, interactions);
            this.fixTransients(TRANSIENT_PACKAGE_STATE + transientPropertiesSuffix, transients, interactions);
            ArrayList<String> modeList = new ArrayList<String>();
            ArrayList<String> windowStateList = new ArrayList<String>();
            String handle = null;
            LocalizedString portletTitle = null;
            if (portletProducer.getPortletCount() > 0) {
                Portlet portlet = portletProducer.getPortlet(0);
                ServiceDescription serviceDescription = portletProducer.getServiceDescription();
                if (serviceDescription != null) {
                    int wsrpIndex = "wsrp:".length();
                    handle = portlet.getHandle();
                    PortletDescription[] offeredPortlets = serviceDescription.getOfferedPortlets();
                    if (offeredPortlets != null) {
                        block3: for (int i = 0; i < offeredPortlets.length; ++i) {
                            if (!handle.equals(offeredPortlets[i].getPortletHandle())) continue;
                            portletTitle = offeredPortlets[i].getTitle();
                            MarkupType[] markups = offeredPortlets[i].getMarkupTypes();
                            if (markups == null) break;
                            for (int j = 0; j < markups.length; ++j) {
                                String[] windowStates;
                                MarkupType markup = markups[j];
                                String mimeType = markup.getMimeType();
                                if (!"text/html".equalsIgnoreCase(mimeType)) continue;
                                String[] modes = markup.getModes();
                                if (modes != null) {
                                    for (int k = 0; k < modes.length; ++k) {
                                        String mode = modes[k];
                                        if (mode.startsWith("wsrp:")) {
                                            mode = mode.substring(wsrpIndex);
                                        }
                                        modeList.add(mode);
                                    }
                                }
                                if ((windowStates = markup.getWindowStates()) == null) break block3;
                                for (int k = 0; k < windowStates.length; ++k) {
                                    String windowState = windowStates[k];
                                    if (windowState.startsWith("wsrp:")) {
                                        windowState = windowState.substring(wsrpIndex);
                                    }
                                    windowStateList.add(windowState);
                                }
                                break block3;
                            }
                            break;
                        }
                    }
                }
            }
            if (customs.size() == 0) {
                StringBuffer newCustoms = new StringBuffer();
                StringBuffer externalRefsExtension = null;
                Iterator it = interactions.iterator();
                while (it.hasNext()) {
                    XMLParameter nvp = (XMLParameter)it.next();
                    String name = nvp.getName();
                    if (!name.startsWith("cpscp_")) continue;
                    String customName = name.substring(6);
                    String customValue = nvp.getValue();
                    newCustoms.append("<param name=\"");
                    newCustoms.append(customName);
                    newCustoms.append("\">");
                    EncodingUtils.xmlEncode((String)customValue, (StringBuffer)newCustoms);
                    newCustoms.append("</param>");
                    it.remove();
                    if (!this.isExternalRef(customName)) continue;
                    if (externalRefsExtension == null) {
                        externalRefsExtension = new StringBuffer();
                    }
                    externalRefsExtension.append("<cpsext:externalRef type=\"nav\" name=\"");
                    EncodingUtils.xmlEncode((String)customName, (StringBuffer)externalRefsExtension);
                    externalRefsExtension.append("\">");
                    EncodingUtils.xmlEncode((String)customValue, (StringBuffer)externalRefsExtension);
                    externalRefsExtension.append("</cpsext:externalRef>");
                }
                if (newCustoms.length() > 0) {
                    String encoded = EncodingUtils.base64encode((byte[])newCustoms.toString().getBytes("UTF-8"), (boolean)true);
                    customs.addParameter(CUSTOM_PORTLET_CONTEXT, encoded);
                    customs.addParameter(CUSTOM_PORTLET_HANDLE, handle + ":custom");
                    if (externalRefsExtension != null) {
                        StringBuffer extensionBuffer = new StringBuffer();
                        extensionBuffer.append("<cpsext:state xmlns:cpsext=\"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/\">");
                        extensionBuffer.append(externalRefsExtension);
                        extensionBuffer.append("</cpsext:state>");
                        customs.addParameter(CUSTOM_PORTLET_STATE_EXTENSION, extensionBuffer.toString());
                    }
                }
            }
            boolean metaonlyRequest = (controllerParams = context.getControllerParams()) != null && "meta-only".equals(controllerParams.getValue("frag-directive"));
            GetMarkupResponse markupResponse = null;
            String packageState = "";
            if (!metaonlyRequest) {
                this.loadPortletContext(queryPageletResponse, customs);
                GetMarkup getMarkup = this.getMarkupRequest(queryPageletResponse, fragment, context, transientPropertiesSuffix);
                this.loadState(getMarkup, state, transients, transientPropertiesSuffix);
                markupResponse = this.getPortletMarkup(getMarkup, cpsContext);
                if (markupResponse.getPortletMarkupCount() < 1) {
                    throw new PipelineException("the portlet did not return any markup");
                }
                if (markupResponse.getPortletMarkup()[0].getFaultContext() != null) {
                    Detail detail = markupResponse.getPortletMarkup()[0].getFaultContext().getDetail();
                    if (detail != null && detail.getAnyObjectCount() > 0 && detail.getAnyObject(0).toString().indexOf("InvalidCredentials") != -1) {
                        throw new com.cognos.portal.utils.exceptions.InvalidCredentialsFault("pf.fragment.server.invalidcredentials", null, null);
                    }
                    throw new PipelineException(markupResponse.getPortletMarkup()[0].getFaultContext().getFaultstring());
                }
                packageState = this.saveState(markupResponse, state, transients, transientPropertiesSuffix, fragment);
            }
            if (fragment != null) {
                Meta fragmentMeta = fragment.getMeta();
                if (fragmentMeta == null) {
                    fragmentMeta = new Meta();
                    fragment.setMeta(fragmentMeta);
                }
                this.writeFinalMeta(fragmentMeta, transientPropertiesSuffix, packageState, modeList, windowStateList);
            }
            if (!metaonlyRequest) {
                if (markupResponse.getUpdateState() != null) {
                    this.savePortletContext(markupResponse.getUpdateState().getNewPortletContext(), fragment);
                }
                PortletMarkup portletMarkup = markupResponse.getPortletMarkup()[0];
                PortletInstance instance = queryPageletResponse.getPagelet().getPortletInstance()[0];
                PortletRefs portletRefs = new PortletRefs(instance);
                if (portletMarkup.getMarkupContext() != null) {
                    Info info;
                    String title;
                    String preferredTitle = portletMarkup.getMarkupContext().getPreferredTitle();
                    if (preferredTitle != null) {
                        fragment.setPreferredTitle(preferredTitle);
                    }
                    if ((title = PortletToFragment.getLocalizedString(context.getEnv().getProductLocale(), portletProducer.getServiceDescription().getResourceList(), portletTitle)) != null && (info = fragment.getInfo()) != null) {
                        com.cognos.portal.schemas.fragments.LocalizedString value = new com.cognos.portal.schemas.fragments.LocalizedString();
                        value.setValue(title);
                        info.setTitle(value);
                    }
                    this.rewriteWSRPToFrag(portletMarkup.getMarkupContext().getMarkupString(), fragment);
                } else if (portletRefs.isAccessRights(AccessRightsType.DISABLED)) {
                    this.rewriteWSRPToFrag("<br/><br/><p class=\"portlet-font\" align=\"center\">This portlet cannot be displayed because it is disabled.</p><br/><br/>", fragment);
                } else {
                    this.rewriteWSRPToFrag("<br/><br/><p class=\"portlet-font\" align=\"center\">This portlet cannot be displayed. It may be deleted or you may not have sufficient privileges to see it.</p><br/><br/>", fragment);
                }
            }
        }
        catch (IOException e) {
            throw new PipelineException("Error while writing the markup string", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new PipelineException("Error while writing fragment xml", (Throwable)e);
        }
    }

    private boolean isExternalRef(String name) {
        return "display_folder".equals(name) || "display_folder_dep".equals(name) || "display_id".equals(name) || "display_id_dep".equals(name);
    }

    private void fixTransients(String name, XMLParameters transients, XMLParameters interactions) {
        String value = interactions.getValue(name);
        if (value != null) {
            interactions.remove(name);
            transients.addParameter(name, value);
        }
    }

    private void loadPortletContext(QueryPageletResponse queryPageletResponse, XMLParameters customs) throws PipelineException {
        Portlet[] portlets;
        PortletProducer[] producers;
        Metadata meta;
        String contextString = null;
        String contextHandle = null;
        String contextStateExtension = null;
        for (XMLParameter c : customs) {
            String name = c.getName();
            if (CUSTOM_PORTLET_CONTEXT.equals(name)) {
                contextString = c.getValue();
                continue;
            }
            if (CUSTOM_PORTLET_HANDLE.equals(name)) {
                contextHandle = c.getValue();
                continue;
            }
            if (!CUSTOM_PORTLET_STATE_EXTENSION.equals(name)) continue;
            contextStateExtension = c.getValue();
        }
        if (contextString != null && (meta = queryPageletResponse.getPagelet().getMetadata()) != null && (producers = meta.getPortletProducer()) != null && producers.length > 0 && (portlets = producers[0].getPortlet()) != null && portlets.length > 0) {
            PortletContext portletContext = new PortletContext();
            PortletInstance[] instances = queryPageletResponse.getPagelet().getPortletInstance();
            if (instances != null && instances.length > 0) {
                portletContext.setPortletHandle(contextHandle);
                portletContext.setPortletState(EncodingUtils.base64decode((String)contextString, (boolean)false));
                if (contextStateExtension != null && contextStateExtension.length() > 0) {
                    Extension extension = new Extension();
                    extension.setAnyW3CElement(XMLUtils.parse((String)contextStateExtension));
                    portletContext.addExtensions(extension);
                }
                instances[0].setPortletContext(portletContext);
            }
        }
    }

    private void savePortletContext(NewPortletContext newPortletContext, Fragment fragment) throws PipelineException {
        block4: {
            try {
                if (newPortletContext == null) break block4;
                PortletContext portletContext = newPortletContext.getPortletContext();
                Params customUpdate = new Params();
                fragment.setCustomUpdate(customUpdate);
                com.cognos.portal.schemas.fragments.Param param = new com.cognos.portal.schemas.fragments.Param();
                param.setName(CUSTOM_PORTLET_CONTEXT);
                param.setValue(EncodingUtils.base64encode((byte[])portletContext.getPortletState(), (boolean)false));
                customUpdate.addParam(param);
                param = new com.cognos.portal.schemas.fragments.Param();
                param.setName(CUSTOM_PORTLET_HANDLE);
                param.setValue(portletContext.getPortletHandle());
                customUpdate.addParam(param);
                Extension[] extensions = portletContext.getExtensions();
                if (extensions == null) break block4;
                for (int i = 0; i < extensions.length; ++i) {
                    AnyNode anyNode;
                    Object anyObject = extensions[i].getAnyObject();
                    if (!(anyObject instanceof AnyNode) || !"state".equals((anyNode = (AnyNode)anyObject).getLocalName()) || !"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/".equals(anyNode.getNamespaceURI())) continue;
                    param = new com.cognos.portal.schemas.fragments.Param();
                    param.setName(CUSTOM_PORTLET_STATE_EXTENSION);
                    param.setValue(AsmTypeHelper.serializeAsm(anyNode, "extensions"));
                    customUpdate.addParam(param);
                    break;
                }
            }
            catch (OperationFailedFault e) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("could not write the custom update", (Throwable)e);
                }
                throw new PipelineException("Error while writing the custom update", (Throwable)e);
            }
        }
    }

    private String saveState(GetMarkupResponse response, XMLParameters state, XMLParameters transients, String transientSuffix, Fragment fragment) throws PipelineException {
        PageletContext pageletContext;
        String value = null;
        PackageContext packageContext = AssemblerStateEncoder.encodePackageState(response.getUpdateState().getPackageState().getPath(), response.getUpdateState().getPackageState().getProducerRuntime());
        if (packageContext != null) {
            String newStateValue = EncodingUtils.base64encode((byte[])packageContext.getState(), (boolean)true);
            String pkgStateTransientName = TRANSIENT_PACKAGE_STATE + transientSuffix;
            String oldValue = transients.getValue(pkgStateTransientName);
            if (oldValue == null || !oldValue.equals(newStateValue)) {
                Fragment.TransientUpdate transientUpdate = new Fragment.TransientUpdate(fragment);
                transientUpdate.setName(pkgStateTransientName);
                transientUpdate.setScope("application");
                transientUpdate.setValue(newStateValue);
                fragment.addTransientUpdate(transientUpdate);
                value = newStateValue;
            }
        }
        if ((pageletContext = AssemblerStateEncoder.encodePageletState(response.getUpdateState().getPageletState())) != null) {
            state.setParameter("pgPath", pageletContext.getPath());
            state.setParameter("pgState", EncodingUtils.base64encode((byte[])pageletContext.getState(), (boolean)true));
        }
        return value;
    }

    private void loadState(GetMarkup markup, XMLParameters state, XMLParameters transients, String transientSuffix) throws PipelineException {
        if (transients != null) {
            PackageState packageState = new PackageState();
            String transientPkgState = transients.getValue(TRANSIENT_PACKAGE_STATE + transientSuffix);
            PackageState packageStateObj = AssemblerStateEncoder.decodePackageState("", EncodingUtils.base64decode((String)transientPkgState, (boolean)true));
            if (packageStateObj != null) {
                packageState.setPath(packageStateObj.getPath());
                packageState.setProducerRuntime(packageStateObj.getProducerRuntime());
            }
            markup.setPackageState(packageState);
        }
        if (state != null) {
            PageletState pageletState = new PageletState();
            PageletState pageletStateObj = AssemblerStateEncoder.decodePageletState(state.getValue("pgPath"), EncodingUtils.base64decode((String)state.getValue("pgState"), (boolean)true));
            if (pageletStateObj != null) {
                pageletState.setPath(pageletStateObj.getPath());
                pageletState.setPortletRuntime(pageletStateObj.getPortletRuntime());
            }
            markup.setPageletState(pageletState);
        }
    }

    private QueryPageletResponse queryPagelet(IContext cpsContext, StageContext context) throws PipelineException {
        QueryPagelet queryPagelet = new QueryPagelet();
        String path = this.getStoragePath(context);
        queryPagelet.setPath(path);
        try {
            return this.getStorage(path, cpsContext).queryPagelet(queryPagelet, cpsContext);
        }
        catch (OperationFailedFault e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("operation failed when trying to execute a storage command", (Throwable)e);
            }
            throw new PipelineException("Error while execution a storage command", (Throwable)e);
        }
        catch (InvalidCredentialsFault e) {
            throw new PipelineException("Invalid credentials", (Throwable)e);
        }
    }

    private GetMarkupResponse getPortletMarkup(GetMarkup getMarkup, IContext c) throws PipelineException {
        try {
            return this.m_consumer.getMarkup(getMarkup, c);
        }
        catch (com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("operation failed when trying to execute a consumer command", (Throwable)e);
            }
            throw new PipelineException("Error while execution a consumer command", (Throwable)e);
        }
    }

    private GetMarkup getMarkupRequest(QueryPageletResponse pagelet, Fragment fragment, StageContext context, String transientSuffix) throws PipelineException {
        GetMarkup markup = new GetMarkup();
        markup.setUserContext(this.createUserContext(context));
        markup.setPageletParams(this.createPageletParams(context));
        markup.setPortalContext(this.createPortalContext(context));
        markup.setPagelet(pagelet.getPagelet());
        XMLParameters interactions = context.getInteractionParams();
        Parameters controllerParams = context.getControllerParams();
        if (interactions != null) {
            Interaction interaction = this.createInteraction(interactions, controllerParams, fragment);
            Param param = new Param();
            param.setName("wsrp-portletInstanceKey");
            param.setContent("PORTLETID");
            interaction.addParam(param);
            markup.setInteraction(interaction);
            String interactionState = interactions.getValue("wsrp-interactionState");
            if (interactionState != null && interactionState.startsWith("set:")) {
                String channel = interactionState.substring("set:".length());
                String value = null;
                if (this.sharedParameters != null) {
                    StringBuffer transientUpdateValue = new StringBuffer();
                    transientUpdateValue.append(interactionState);
                    for (String name : this.sharedParameters) {
                        String sharedParamValue = interactions.getValue(name);
                        if (sharedParamValue != null) {
                            Fragment.TransientUpdate transientUpdate = new Fragment.TransientUpdate(fragment);
                            fragment.addTransientUpdate(transientUpdate);
                            transientUpdate.setName(name);
                            transientUpdate.setScope("application");
                            transientUpdate.setChannel(channel);
                            transientUpdate.setValue(sharedParamValue);
                        }
                        if (sharedParamValue == null) {
                            sharedParamValue = "";
                        }
                        transientUpdateValue.append(sharedParamValue);
                    }
                    value = transientUpdateValue.toString();
                } else {
                    value = String.valueOf(System.currentTimeMillis());
                }
                Fragment.TransientUpdate transientUpdate = new Fragment.TransientUpdate(fragment);
                fragment.addTransientUpdate(transientUpdate);
                transientUpdate.setName(TRANSIENT_P2P + transientSuffix);
                transientUpdate.setValue(value);
            }
        }
        return markup;
    }

    private void addTransientProperty(String name, String defaultValue, Meta fragmentMeta) throws XMLStreamException {
        Properties properties = new Properties();
        properties.setName(name);
        if (defaultValue != null) {
            Default default_ = new Default();
            default_.setValue(defaultValue);
            properties.setDefault(default_);
        }
        AnyType validate = new AnyType();
        XMLStreamWriter writer = validate.getXMLStreamWriter();
        writer.writeStartElement("validate");
        writer.writeNamespace(VALIDATE_NAMESPACE_PREFIX, VALIDATE_NAMESPACE_URI);
        writer.writeAttribute("skipJavaScript", "true");
        writer.writeStartElement(VALIDATE_NAMESPACE_PREFIX, "name", VALIDATE_NAMESPACE_URI);
        writer.writeCharacters(name);
        writer.writeEndElement();
        writer.writeStartElement(VALIDATE_NAMESPACE_PREFIX, "sign", VALIDATE_NAMESPACE_URI);
        writer.writeEndElement();
        writer.writeEndElement();
        properties.setValidate(validate);
        fragmentMeta.addTransientProperties(properties);
    }

    private void writeFinalMeta(Meta fragmentMeta, String transientSuffix, String state, List modes, List windowStates) throws XMLStreamException {
        String prefix;
        int sep;
        String s;
        int i;
        this.addTransientProperty(TRANSIENT_P2P + transientSuffix, null, fragmentMeta);
        this.addTransientProperty(TRANSIENT_PACKAGE_STATE + transientSuffix, state, fragmentMeta);
        if (modes != null) {
            for (i = 0; i < modes.size(); ++i) {
                s = (String)modes.get(i);
                sep = s.indexOf(58);
                String string = prefix = sep != -1 ? s.substring(0, sep) : "";
                if (sep != -1) {
                    s = s.substring(sep + 1);
                }
                String namespace = "cps".equals(prefix) ? "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/" : "";
                fragmentMeta.addModes(new QName(namespace, s, prefix));
            }
        }
        if (windowStates != null) {
            for (i = 0; i < windowStates.size(); ++i) {
                s = (String)windowStates.get(i);
                sep = s.indexOf(58);
                String string = prefix = sep != -1 ? s.substring(0, sep) : "";
                if (sep != -1) {
                    s = s.substring(sep + 1);
                }
                fragmentMeta.addWindowStates(new QName("", s, prefix));
            }
        }
    }

    private static String getLocalizedString(String productLocale, ResourceList rl, LocalizedString portletTitle) {
        Resource[] resources;
        String resourceName = portletTitle.getResourceName();
        if (rl != null && (resources = rl.getResources()) != null) {
            for (int i = 0; i < resources.length; ++i) {
                if (!resources[i].getResourceName().equals(resourceName)) continue;
                ResourceValue[] values = resources[i].getValues();
                SmallMap map = new SmallMap();
                map.put(portletTitle.getLang(), portletTitle.getValue());
                for (int j = 0; j < values.length; ++j) {
                    map.put(values[j].getLang(), values[j].getValue());
                }
                Object[] supportedLocales = map.keySet().toArray();
                String locale = CCLLocaleUtils.getValidProductLocale((String)productLocale, (Object[])supportedLocales, null);
                if (locale == null) continue;
                return map.get(locale).toString();
            }
        }
        return portletTitle.getValue();
    }
}

