/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.fragment;

import com.cognos.cps.bseries.xts.common.sax.BIBusBufferXMLContentHandler;
import com.cognos.cps.bseries.xts.common.sax.ParseUtils;
import com.cognos.cps.fragment.PortletRewriter;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Interaction;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletParams;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.pagelet.objects.v1.types.UserContext;
import com.cognos.cps.services.wsrp.v1.types.PersonName;
import com.cognos.cps.services.wsrp.v1.types.UserProfile;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.URLRewriter;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.fragment.meta.NamedList;
import com.cognos.portal.fragment.producer.helpers.XMLParameter;
import com.cognos.portal.fragment.producer.helpers.XMLParameters;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.schemas.QName;
import com.cognos.portal.schemas.fragments.Fragment;
import com.cognos.portal.schemas.fragments.Library;
import com.cognos.portal.schemas.fragments.Markup;
import com.cognos.portal.soap.SOAPConnectionProperties;
import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.XMLString;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.ext.XTSExt;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class WSRPBridge
extends Stage {
    protected static final String PARAM_ID = "id";
    protected static final String STATE_PACKAGE_PATH = "pkgPath";
    protected static final String STATE_PACKAGE_STATE = "pkgState";
    protected static final String STATE_PAGELET_PATH = "pgPath";
    protected static final String STATE_PAGELET_STATE = "pgState";
    private ServiceLogger logger;
    private PortletRewriter portletRewriter;
    private static final Pattern SCRIPT_TAG_WITH_SCR_PATTERN = Pattern.compile("(?:<script [^>]*src=.*?>)((\\r|\\n|.)*?)(?:<\\/script>)");
    private static final Pattern SCRIPT_SCR_PATTERN = Pattern.compile("(src=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");
    private static final Pattern SCRIPT_TYPE_PATTERN = Pattern.compile("(type=[\"|']?)([^ |^>|^'|^\"]*)(\"|'| |>)");

    public WSRPBridge(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(WSRPBridge.class) : null;
        this.portletRewriter = new PortletRewriter();
    }

    protected IContext getCpsContext(StageContext context) {
        IContext cpsContext = this.getCpsContext(Locale.ENGLISH);
        cpsContext.setProperty("SoapConnectionFactory", context.getEnv().getProperty("SoapConnectionFactory"));
        cpsContext.setProperty("trustedSoapConnectionFactory", context.getEnv().getProperty("trustedSoapConnectionFactory"));
        cpsContext.setProperty("httpSoapConnectionFactory", context.getEnv().getProperty("httpSoapConnectionFactory"));
        cpsContext.setProperty(SOAPConnectionProperties.PROP_PIPELINE_CONTEXT, (Object)context);
        NamedList cookies = context.getRequestCookies();
        if (cookies != null) {
            Cookie[] cpsCookies = new Cookie[cookies.size()];
            for (int i = 0; i < cookies.size(); ++i) {
                com.cognos.portal.fragment.meta.Cookie cookie = (com.cognos.portal.fragment.meta.Cookie)cookies.get(i);
                cpsCookies[i] = new Cookie();
                cpsCookies[i].setName(cookie.getName());
                cpsCookies[i].setContent(cookie.getValue());
            }
            cpsContext.setProperty("COOKIES", (Object)cpsCookies);
        }
        cpsContext.setProperty("PASSPORT", (Object)context.getEnv().getPassportID());
        XMLString header = context.getBusHeader();
        if (header != null) {
            BIBusBufferXMLContentHandler headerBufferHandler;
            javax.xml.namespace.QName busHeader;
            block6: {
                busHeader = new javax.xml.namespace.QName("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
                headerBufferHandler = new BIBusBufferXMLContentHandler(busHeader);
                XMLReader xmlReader = ParseUtils.getXMLReader();
                xmlReader.setContentHandler((ContentHandler)((Object)headerBufferHandler));
                try {
                    xmlReader.parse(new InputSource(new StringReader(header.toString())));
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block6;
                    this.logger.error("An error occurred while parsing the bus header in the WSRP bridge", (Throwable)e);
                }
            }
            cpsContext.setProperty("BUS_HEADER", (Object)headerBufferHandler.getElementAsString(busHeader));
        } else {
            cpsContext.setProperty("BUS_HEADER", null);
        }
        return cpsContext;
    }

    protected IContext getCpsContext(Locale locale) {
        ContextImpl cpsContext = new ContextImpl();
        XTSEnvironment xtsEnv = new XTSEnvironment("CRN");
        xtsEnv.setLocale(locale);
        xtsEnv.setRequestContext(ServiceLoggerImpl.getRequestId());
        xtsEnv.setSessionContext(ServiceLoggerImpl.getSessionId());
        cpsContext.setProperty("XTS_ENV", (Object)xtsEnv);
        cpsContext.setProperty("XTS_IDENTIFIER", (Object)"assembler");
        cpsContext.setProperty("CPS_SOAP_HEADER", (Object)"<cps/>");
        return cpsContext;
    }

    protected void rewriteWSRPToFrag(String markup, Fragment fragment) throws PipelineException {
        try {
            URLRewriter rewriter = new URLRewriter((URLRewriteHandler)this.portletRewriter, null);
            StringWriter writer = new StringWriter();
            rewriter.rewrite(markup, (Writer)writer);
            String rewrittenMarkup = writer.getBuffer().toString();
            if (fragment != null) {
                WSRPBridge.extractScriptTagWithSrc(rewrittenMarkup, fragment);
            }
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Process '" + this.getName() + "' failed to rewrite markup", (Throwable)e);
            }
            throw new PipelineException("error rewriting wsrp to fragment", (Throwable)e);
        }
    }

    protected static void extractScriptTagWithSrc(String markupString, Fragment fragment) throws XMLStreamException {
        Matcher m = SCRIPT_TAG_WITH_SCR_PATTERN.matcher(markupString);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
            String script = m.group();
            String scriptSrc = WSRPBridge.extractScriptSrc(script);
            if (scriptSrc == null) continue;
            Library library = new Library();
            library.setHref(scriptSrc);
            library.setType(WSRPBridge.extractScriptType(script));
            fragment.addLibrary(library);
        }
        m.appendTail(sb);
        Markup markup = new Markup();
        markup.setMarkupString(sb.toString());
        fragment.addMarkup(markup);
    }

    private static String extractScriptSrc(String s) {
        Matcher m = SCRIPT_SCR_PATTERN.matcher(s);
        if (m.find(0)) {
            if (m.groupCount() == 3) {
                return m.group(2);
            }
            return null;
        }
        return null;
    }

    private static String extractScriptType(String s) {
        Matcher m = SCRIPT_TYPE_PATTERN.matcher(s);
        if (m.find(0)) {
            if (m.groupCount() == 3) {
                return m.group(2);
            }
            return null;
        }
        return null;
    }

    protected String getStoragePath(StageContext context) throws PipelineException {
        String pageId = null;
        XMLParameters customParams = context.getCustomsParams();
        pageId = customParams.getValue(PARAM_ID);
        if (pageId == null) {
            pageId = context.getExtraInfo();
        }
        if (pageId == null) {
            throw new PipelineException("page id is missing");
        }
        return pageId;
    }

    protected PageletParams createPageletParams(StageContext context) {
        String productLocale;
        PageletParams pageletParams = new PageletParams();
        Parameters controller = context.getControllerParams();
        if (controller != null) {
            pageletParams.setUserAgent(controller.getValue("frag-agent"));
        }
        ArrayList<String> locales = new ArrayList<String>();
        String contentLocale = context.getEnv().getContentLocale();
        if (contentLocale != null) {
            locales.add(contentLocale);
        }
        if ((productLocale = context.getEnv().getProductLocale()) != null && !productLocale.equals(contentLocale)) {
            locales.add(productLocale);
        }
        pageletParams.setLocales(locales.toArray(new String[locales.size()]));
        return pageletParams;
    }

    protected UserContext createUserContext(StageContext context) {
        UserContext userContext = new UserContext();
        userContext.setUserContextKey(EncodingUtils.web64encode((byte[])context.getEnv().getUserID().getBytes(), (boolean)false));
        UserProfile profile = new UserProfile();
        PersonName name = new PersonName();
        name.setNickname(context.getEnv().getUserName());
        name.setFamily(context.getEnv().getUserName());
        profile.setName(name);
        userContext.setProfile(profile);
        return userContext;
    }

    protected Interaction createInteraction(XMLParameters interactions, Parameters controllerParams, Fragment fragment) throws PipelineException {
        try {
            Interaction interaction = new Interaction();
            StringBuffer navigationStateOverride = null;
            String navigationalState = null;
            String currentState = controllerParams.getValue("frag-state");
            for (XMLParameter nvp : interactions) {
                String name = nvp.getName();
                if ("wsrp-navigationalState".equals(name)) {
                    navigationalState = nvp.getValue();
                    continue;
                }
                if (name.startsWith("cpsnav_")) {
                    if (navigationalState != null || currentState != null && currentState.length() != 0) continue;
                    if (navigationStateOverride == null) {
                        navigationStateOverride = new StringBuffer();
                    }
                    navigationStateOverride.append("<param name=\"");
                    String navigationalStateParamName = name.substring("cpsnav_".length());
                    EncodingUtils.xmlEncode((String)navigationalStateParamName, (StringBuffer)navigationStateOverride);
                    navigationStateOverride.append("\">");
                    EncodingUtils.xmlEncode((String)nvp.getValue(), (StringBuffer)navigationStateOverride);
                    navigationStateOverride.append("</param>");
                    continue;
                }
                Param param = new Param();
                param.setName(name);
                param.setContent(nvp.getValue());
                interaction.addParam(param);
            }
            if (navigationalState == null && navigationStateOverride != null) {
                navigationalState = XTSExt.validator((String)"prepare", (String)"WSRPBridge", (String)EncodingUtils.base64encode((byte[])navigationStateOverride.toString().getBytes("UTF-8"), (boolean)true));
            }
            if (navigationalState != null) {
                Param param = new Param();
                param.setName("wsrp-navigationalState");
                param.setContent(navigationalState);
                interaction.addParam(param);
            }
            if (controllerParams != null) {
                String mode = controllerParams.getValue("frag-mode");
                if (interactions.getValue("wsrp-mode") == null) {
                    if (mode != null) {
                        if ("view".equals(mode) || "edit".equals(mode) || "help".equals(mode) || "preview".equals(mode)) {
                            mode = "wsrp:" + mode;
                        }
                        Param param = new Param();
                        param.setName("wsrp-mode");
                        param.setContent(mode);
                        interaction.addParam(param);
                    }
                } else {
                    String wsrpMode = interactions.getValue("wsrp-mode");
                    if (wsrpMode.startsWith("wsrp:")) {
                        wsrpMode = wsrpMode.substring(5);
                    }
                    if (mode == null || !wsrpMode.equals(mode)) {
                        fragment.setNewMode(new QName("", wsrpMode, ""));
                    }
                }
                String windowState = controllerParams.getValue("frag-windowState");
                if (interactions.getValue("wsrp-windowState") == null) {
                    if (windowState != null) {
                        if ("normal".equals(windowState) || "minimized".equals(windowState) || "maximized".equals(windowState) || "solo".equals(windowState)) {
                            windowState = "wsrp:" + windowState;
                        }
                        Param param = new Param();
                        param.setName("wsrp-windowState");
                        param.setContent(windowState);
                        interaction.addParam(param);
                    }
                } else {
                    String wsrpWindowState = interactions.getValue("wsrp-windowState");
                    if (wsrpWindowState.startsWith("wsrp:")) {
                        wsrpWindowState = wsrpWindowState.substring(5);
                    }
                    if (windowState == null || !wsrpWindowState.equals(mode)) {
                        fragment.setNewWindowState(new QName("", wsrpWindowState, ""));
                    }
                }
            }
            return interaction;
        }
        catch (Exception e) {
            throw new PipelineException("error rewriting wsrp to fragment", (Throwable)e);
        }
    }

    protected PortalContext createPortalContext(StageContext context) throws PipelineException {
        PortalContext portalContext = new PortalContext();
        try {
            XMLParameters params = context.getInteractionParams();
            Param webContent = new Param();
            webContent.setName("webContentURL");
            String webContentParam = params.getValue("bridge-webContentURL");
            if (webContentParam != null) {
                webContentParam = context.getEnv().getValidationManager().staticUnsign(webContentParam);
            }
            if (webContentParam != null && webContentParam.length() > 0) {
                webContent.setContent(webContentParam);
            } else {
                webContent.setContent(context.getEnv().getWebContent());
            }
            portalContext.addParam(webContent);
            Param gateway = new Param();
            gateway.setName("gatewayURL");
            String gatewayParam = params.getValue("bridge-gatewayURL");
            if (gatewayParam != null) {
                gatewayParam = context.getEnv().getValidationManager().staticUnsign(gatewayParam);
            }
            if (gatewayParam != null && gatewayParam.length() > 0) {
                gateway.setContent(gatewayParam);
            } else {
                gateway.setContent(context.getEnv().getGatewayURI());
            }
            portalContext.addParam(gateway);
            Param isIWidget = new Param();
            isIWidget.setName("isIWidget");
            String controllerAgent = context.getEnv().getControllerAgent();
            if ("fragment/1.1.0".equals(controllerAgent)) {
                isIWidget.setContent("true");
            } else {
                isIWidget.setContent("false");
            }
            portalContext.addParam(isIWidget);
            portalContext.setPortalAgent("cognosFragmentServer");
        }
        catch (DashboardException e) {
            throw new PipelineException("error creating portletContext", (Throwable)e);
        }
        return portalContext;
    }

    public boolean canShare() {
        return false;
    }
}

