/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.assembler.impl;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.LocaleUtils;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.pagelet.common.exception.ExceptionUtilities;
import com.cognos.cps.pagelet.common.log.LogManager;
import com.cognos.cps.pagelet.common.utils.AssemblerStateEncoder;
import com.cognos.cps.pagelet.common.utils.PageletFactory;
import com.cognos.cps.pagelet.consumer.impl.ConsumerImpl;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.assembler.v1.intf.IAssembler;
import com.cognos.cps.services.pagelet.assembler.v1.types.GetPagelet;
import com.cognos.cps.services.pagelet.assembler.v1.types.GetPageletResponse;
import com.cognos.cps.services.pagelet.assembler.v1.types.TypeFactory;
import com.cognos.cps.services.pagelet.consumer.v1.intf.IConsumer;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkupResponse;
import com.cognos.cps.services.pagelet.objects.v1.types.CacheControl;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.cps.services.pagelet.objects.v1.types.Layout;
import com.cognos.cps.services.pagelet.objects.v1.types.NewPortletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageState;
import com.cognos.cps.services.pagelet.objects.v1.types.Pagelet;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletMarkup;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletState;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.ProducerRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.UpdateResponse;
import com.cognos.cps.services.pagelet.objects.v1.types.UpdateState;
import com.cognos.cps.services.pagelet.processor.v1.intf.IProcessor;
import com.cognos.cps.services.pagelet.processor.v1.types.Render;
import com.cognos.cps.services.pagelet.processor.v1.types.RenderResponse;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPageletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContext;
import com.cognos.cps.services.soap.envelope.SOAPFault;
import com.cognos.portal.utils.TrustedSessionHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.exolab.castor.types.AnyNode;

public class AssemblerImpl
implements IAssembler,
IServiceImplementation {
    private static final String VAL_TAG_SEPARATOR = ":";
    private static final String AUTH_TOKEN_PARAM_NAME = "cps-authToken";
    Map m_storageMap;
    Map m_processorMap;
    IConsumer m_consumer;
    ServiceLogger m_logger;

    public AssemblerImpl(ServiceLogger logger) {
        this.m_logger = logger != null ? logger.cloneForClass(ConsumerImpl.class) : LogManager.getLogManager().getLogger(AssemblerImpl.class);
    }

    public GetPageletResponse getPagelet(GetPagelet getPagelet, IContext context) throws com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault, com.cognos.cps.services.pagelet.assembler.v1.types.InvalidCredentialsFault {
        String MN = "getPagelet()";
        if (this.m_consumer == null) {
            this.m_logger.error(MN);
            throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed", null, null);
        }
        if (getPagelet == null || getPagelet.getPath() == null || getPagelet.getPath().length() == 0) {
            this.m_logger.error(MN);
            Object[] args = new String[]{getPagelet == null ? "getPagelet" : "path"};
            throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.common.missingparameter.error", args, null);
        }
        try {
            String pathURN = getPagelet.getPath();
            IStorage storage = this.retrieveStorage(pathURN, context);
            GetPageletResponse getPageletResponse = TypeFactory.newInstance().createGetPageletResponse();
            try {
                int index;
                String valTag;
                Pagelet pagelet;
                QueryPagelet queryPagelet = com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory.newInstance().createQueryPagelet();
                queryPagelet.setPath(pathURN);
                Object timer = null;
                if (this.m_logger.isPerfLevelEnabled(2)) {
                    timer = this.m_logger.startTimer(2, "getPagelet", "queryPagelet", (Object)context);
                }
                QueryPageletResponse queryPageletResponse = storage.queryPagelet(queryPagelet, context);
                if (timer != null) {
                    this.m_logger.stopTimer(timer);
                }
                if ((pagelet = queryPageletResponse.getPagelet()) == null) {
                    IProcessor processor = this.retrieveProcessor(null, context);
                    Render render = com.cognos.cps.services.pagelet.processor.v1.types.TypeFactory.newInstance().createRender();
                    render.setPath(pathURN);
                    render.setPortalContext(getPagelet.getPortalContext());
                    render.setUserContext(getPagelet.getUserContext());
                    render.setPageletParams(getPagelet.getPageletParams());
                    RenderResponse renderResponse = processor.render(render, context);
                    getPageletResponse.setPageletMarkup(renderResponse.getPageletMarkup());
                    return getPageletResponse;
                }
                getPageletResponse.setId(pagelet.getId());
                getPageletResponse.setPath(pagelet.getPath());
                getPageletResponse.setName(pagelet.getName());
                getPageletResponse.setAccessRights(pagelet.getAccessRights());
                int checksumTag = 0;
                if (pagelet.getLayout() != null) {
                    checksumTag += pagelet.getLayout().hashCode();
                }
                if (pagelet.getPortletInstance() != null) {
                    checksumTag += Arrays.asList(pagelet.getPortletInstance()).hashCode();
                }
                String pageletTag = Integer.toString(checksumTag);
                boolean isPageletEquals = false;
                if (getPagelet.getPageletParams() != null && (valTag = getPagelet.getPageletParams().getValidateTag()) != null && (index = valTag.indexOf(VAL_TAG_SEPARATOR)) >= 0) {
                    isPageletEquals = pageletTag.equals(valTag.substring(0, index));
                    getPagelet.getPageletParams().setValidateTag(valTag.substring(index + 1));
                }
                GetMarkup getMarkup = com.cognos.cps.services.pagelet.consumer.v1.types.TypeFactory.newInstance().createGetMarkup();
                getMarkup.setPath(pathURN);
                getMarkup.setPagelet(pagelet);
                PackageState packageState = AssemblerStateEncoder.decodePackageState(pathURN, getPagelet.getPackageContext() != null ? getPagelet.getPackageContext().getState() : null);
                PageletState pageletState = AssemblerStateEncoder.decodePageletState(pathURN, getPagelet.getPageletContext() != null ? getPagelet.getPageletContext().getState() : null);
                getMarkup.setInteraction(getPagelet.getInteraction());
                getMarkup.setPackageState(packageState);
                getMarkup.setPageletState(pageletState);
                getMarkup.setPageletParams(getPagelet.getPageletParams());
                getMarkup.setPortalContext(getPagelet.getPortalContext());
                getMarkup.setUserContext(getPagelet.getUserContext());
                Object timer1 = null;
                if (this.m_logger.isPerfLevelEnabled(4)) {
                    timer1 = this.m_logger.startTimer(4, "getPagelet", "getMarkup", (Object)context);
                }
                GetMarkupResponse getMarkupResponse = this.m_consumer.getMarkup(getMarkup, context);
                if (timer1 != null) {
                    this.m_logger.stopTimer(timer1);
                }
                if (getMarkupResponse.getRedirectURL() != null && getMarkupResponse.getRedirectURL().length() > 0) {
                    getPageletResponse.setRedirectURL(getMarkupResponse.getRedirectURL());
                } else {
                    CacheControl cacheControl = getMarkupResponse.getCacheControl();
                    if (cacheControl != null) {
                        if (cacheControl.getValidateTag() != null) {
                            pageletTag = pageletTag + VAL_TAG_SEPARATOR + cacheControl.getValidateTag();
                        }
                        cacheControl.setValidateTag(pageletTag);
                    }
                    if (isPageletEquals && getMarkupResponse.getUseCachedMarkup() != null && getMarkupResponse.getUseCachedMarkup().getContent()) {
                        PageletMarkup pageletMarkup = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPageletMarkup();
                        pageletMarkup.setUseCachedMarkup(getMarkupResponse.getUseCachedMarkup());
                        pageletMarkup.setCacheControl(cacheControl);
                        getPageletResponse.setPageletMarkup(pageletMarkup);
                    } else {
                        AnyNode root;
                        String nsURI = null;
                        Layout layout = pagelet.getLayout();
                        if (layout != null && (root = (AnyNode)layout.getAnyObject()) != null) {
                            nsURI = root.getNamespaceURI();
                        }
                        IProcessor processor = this.retrieveProcessor(nsURI, context);
                        Render render = com.cognos.cps.services.pagelet.processor.v1.types.TypeFactory.newInstance().createRender();
                        render.setPath(pathURN);
                        render.setPortalContext(getPagelet.getPortalContext());
                        render.setUserContext(getPagelet.getUserContext());
                        if (getMarkupResponse.getUpdateState() != null) {
                            render.setPageletState(getMarkupResponse.getUpdateState().getPageletState());
                        }
                        render.setPageletParams(getPagelet.getPageletParams());
                        render.setPagelet(pagelet);
                        render.setCacheControl(cacheControl);
                        render.setPortletMarkup(getMarkupResponse.getPortletMarkup());
                        Object timer2 = null;
                        if (this.m_logger.isPerfLevelEnabled(4)) {
                            timer2 = this.m_logger.startTimer(4, "getPagelet", "render", (Object)context);
                        }
                        RenderResponse renderResponse = processor.render(render, context);
                        if (timer2 != null) {
                            this.m_logger.stopTimer(timer2);
                        }
                        getPageletResponse.setPageletMarkup(renderResponse.getPageletMarkup());
                    }
                    if (getMarkupResponse.getUpdateState() != null) {
                        UpdateState updateState = getMarkupResponse.getUpdateState();
                        if (updateState.getNewPortletContext() != null) {
                            this.verifyRequest(getPagelet, context);
                            AssemblerImpl.savePortletContext(updateState.getNewPortletContext(), storage, pathURN, context);
                        }
                        if (updateState.getPackageState() != null && updateState.getPackageState().equals((Object)packageState)) {
                            updateState.setPackageState(null);
                        }
                        if (updateState.getPageletState() != null && updateState.getPageletState().equals((Object)pageletState)) {
                            updateState.setPageletState(null);
                        }
                        getPageletResponse.setUpdateResponse(AssemblerImpl.encodeStates(getMarkupResponse.getUpdateState()));
                    }
                }
            }
            catch (OperationFailedFault e) {
                RenderResponse renderResponse = this.renderFault(getPagelet, context, (Fault)((Object)e));
                getPageletResponse.setPageletMarkup(renderResponse.getPageletMarkup());
            }
            catch (InvalidCredentialsFault e) {
                throw new com.cognos.cps.services.pagelet.assembler.v1.types.InvalidCredentialsFault("cps.pagelet.storage.client.failed", null, (Throwable)e);
            }
            catch (com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault e) {
                RenderResponse renderResponse = this.renderFault(getPagelet, context, (Fault)((Object)e));
                getPageletResponse.setPageletMarkup(renderResponse.getPageletMarkup());
            }
            catch (Throwable e) {
                this.m_logger.error(MN, e);
                throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed", null, e);
            }
            return getPageletResponse;
        }
        catch (com.cognos.cps.services.pagelet.processor.v1.types.OperationFailedFault e) {
            this.m_logger.error(MN, (Throwable)e);
            throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed", null, (Throwable)e);
        }
    }

    private void verifyRequest(GetPagelet getPagelet, IContext context) throws com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault {
        Cookie[] cookies;
        boolean isVerfied = false;
        Param[] params = getPagelet.getInteraction().getParam();
        String token = null;
        if (params != null) {
            int length = params.length;
            for (int i = 0; i < length; ++i) {
                String name = params[i].getName();
                if (!AUTH_TOKEN_PARAM_NAME.equals(name)) continue;
                token = params[i].getContent();
                break;
            }
        }
        if (token != null && (cookies = (Cookie[])context.getProperty("COOKIES")) != null) {
            int cookiesLength = cookies.length;
            for (int j = 0; j < cookiesLength; ++j) {
                if (!"usersessionid".equals(cookies[j].getName())) continue;
                isVerfied = TrustedSessionHelper.getInstance().verifyAuthenticityToken(token, cookies[j].getContent());
                break;
            }
        }
        if (!isVerfied) {
            if (this.m_logger.isErrorEnabled()) {
                this.m_logger.error("Verification of the cps authToken has failed.");
            }
            throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed");
        }
    }

    public synchronized void initialize(IContext context) {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter("initialize()");
        }
        this.m_consumer = PageletFactory.createConsumerObject(null, context, this.m_logger);
        this.m_storageMap = new SmallMap();
        this.m_processorMap = new SmallMap();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit("initialize()");
        }
    }

    public synchronized void terminate() throws ServiceException {
        IServiceImplementation service;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter("terminate()");
        }
        if (this.m_consumer != null) {
            ((IServiceImplementation)this.m_consumer).terminate();
            this.m_consumer = null;
        }
        for (Object key : this.m_storageMap.keySet()) {
            service = (IServiceImplementation)this.m_storageMap.get(key);
            if (service == null) continue;
            service.terminate();
        }
        this.m_storageMap.clear();
        this.m_storageMap = null;
        for (Object key : this.m_processorMap.keySet()) {
            service = (IServiceImplementation)this.m_processorMap.get(key);
            if (service == null) continue;
            service.terminate();
        }
        this.m_processorMap.clear();
        this.m_processorMap = null;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter("terminate()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStorage retrieveStorage(String pathURN, IContext context) throws com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault {
        IStorage storage;
        String storageURN = null;
        int index = pathURN.indexOf(47, 1);
        storageURN = index != -1 ? pathURN.substring(0, index) : pathURN;
        Map map = this.m_storageMap;
        synchronized (map) {
            storage = (IStorage)this.m_storageMap.get(storageURN);
            if (storage == null) {
                storage = PageletFactory.createStorageObject(storageURN, context, this.m_logger);
                if (storage != null) {
                    this.m_storageMap.put(storageURN, storage);
                } else {
                    this.m_logger.error("retrieveStorage is null");
                    throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed");
                }
            }
        }
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProcessor retrieveProcessor(String nsURI, IContext context) throws com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault {
        IProcessor processor;
        Map map = this.m_processorMap;
        synchronized (map) {
            processor = (IProcessor)this.m_processorMap.get(nsURI);
            if (processor == null) {
                processor = PageletFactory.createProcessorObject(nsURI, context, this.m_logger);
                if (processor != null) {
                    this.m_processorMap.put(nsURI, processor);
                } else {
                    this.m_logger.error("retrieveProcessor is null");
                    throw new com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault("cps.pagelet.assembler.operation.failed");
                }
            }
        }
        return processor;
    }

    private RenderResponse renderFault(GetPagelet getPagelet, IContext context, Fault rootFault) throws com.cognos.cps.services.pagelet.processor.v1.types.OperationFailedFault, com.cognos.cps.services.pagelet.assembler.v1.types.OperationFailedFault {
        IProcessor processor = this.retrieveProcessor(null, context);
        Render render = com.cognos.cps.services.pagelet.processor.v1.types.TypeFactory.newInstance().createRender();
        render.setPath(getPagelet.getPath());
        render.setPortalContext(getPagelet.getPortalContext());
        render.setUserContext(getPagelet.getUserContext());
        render.setPageletParams(getPagelet.getPageletParams());
        Object productLocale = context.getProperty("PRODUCT_LOCALE");
        Locale locale = productLocale != null ? LocaleUtils.toLocale((String)productLocale.toString()) : Locale.ENGLISH;
        SOAPFault fault = com.cognos.cps.services.soap.envelope.TypeFactory.newInstance().createFault();
        fault.setFaultcode(rootFault.getKey());
        fault.setFaultstring(rootFault.getLocalizedMsgString(locale));
        if (rootFault.getRootCause() != null) {
            fault.setDetail(ExceptionUtilities.convertFaultToDetail(rootFault.getRootCause()));
        }
        render.setFaultContext(fault);
        RenderResponse renderResponse = processor.render(render, context);
        return renderResponse;
    }

    private static void savePortletContext(NewPortletContext newPortletContext, IStorage storage, String path, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        SaveContext saveContext = com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory.newInstance().createSaveContext();
        saveContext.setPath(path);
        saveContext.setPortletId(newPortletContext.getPortletId());
        saveContext.setPortletContext(newPortletContext.getPortletContext());
        storage.saveContext(saveContext, context);
    }

    private static UpdateResponse encodeStates(UpdateState updateState) {
        ProducerRuntime[] producerRuntime;
        if (updateState.getPackageState() == null && updateState.getPageletState() == null) {
            return null;
        }
        UpdateResponse response = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createUpdateResponse();
        if (updateState.getPackageState() != null && (producerRuntime = updateState.getPackageState().getProducerRuntime()) != null) {
            PackageContext packageContext = AssemblerStateEncoder.encodePackageState(updateState.getPackageState().getPath(), producerRuntime);
            response.setPackageContext(packageContext);
        }
        if (updateState.getPageletState() != null && updateState.getPageletState().getPortletRuntimeCount() > 0) {
            PageletContext pageletContext = AssemblerStateEncoder.encodePageletState(updateState.getPageletState());
            response.setPageletContext(pageletContext);
        }
        return response;
    }
}

