/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.common.http;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPConnectionImpl;
import com.cognos.portal.soap.SOAPConnectionProperties;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.xml.sax.SAXException;

public class HttpSOAPConnectionImpl
extends SOAPConnectionImpl
implements HttpSOAPConnection {
    protected Cookie[] m_requestCookies = null;
    protected Cookie[] m_responseCookies = null;
    protected IContext context = null;
    protected PipelineContext pipelineContext = null;

    public HttpSOAPConnectionImpl(SOAPObjectHandler objectHandler, ServiceLogger logger) {
        super(objectHandler, logger);
    }

    public HttpSOAPConnectionImpl(SOAPObjectHandler objectHandler, SOAPObjectHandler soapHeaderHandler, ServiceLogger logger) {
        super(objectHandler, soapHeaderHandler, logger);
    }

    public void setContext(IContext context) {
        this.context = context;
        this.pipelineContext = (PipelineContext)context.getProperty(SOAPConnectionProperties.PROP_PIPELINE_CONTEXT);
    }

    protected boolean isDebug() {
        return this.m_logger.isDebugEnabled() || this.pipelineContext != null && this.pipelineContext.isDebugMode();
    }

    protected void writeRequestLog(char[] request) {
        block3: {
            super.writeRequestLog(request);
            if (this.pipelineContext != null && this.pipelineContext.isDebugMode()) {
                try {
                    this.pipelineContext.addTraceXML("http_soap_request", XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(new String(request))));
                }
                catch (XMLStreamException e) {
                    if (!this.m_logger.isDebugEnabled()) break block3;
                    this.m_logger.debug("http_soap_request XMLStreamException: " + e.getMessage());
                }
            }
        }
    }

    protected void writeResponseLog(byte[] response) {
        block5: {
            super.writeResponseLog(response);
            if (this.pipelineContext != null && this.pipelineContext.isDebugMode()) {
                try {
                    this.pipelineContext.addTraceXML("http_soap_response", XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(new String(response, "UTF-8"))));
                }
                catch (XMLStreamException e) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug("http_soap_response XMLStreamException: " + e.getMessage());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!this.m_logger.isDebugEnabled()) break block5;
                    this.m_logger.debug("http_soap_response UnsupportedEncodingException: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void setRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = cookies;
    }

    @Override
    public void addRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = HttpSOAPConnectionImpl.addCookies(this.m_requestCookies, cookies);
    }

    @Override
    public void addRequestCookie(Cookie cookie) {
        this.m_requestCookies = HttpSOAPConnectionImpl.addCookie(this.m_requestCookies, cookie);
    }

    @Override
    public Cookie[] getResponseCookies() {
        return this.m_responseCookies;
    }

    public SOAPMessage call(SOAPMessage requestMsg, String url) throws MalformedURLException, IOException, SOAPFault, SAXException {
        SOAPMessage message = super.call(requestMsg, url);
        this.m_responseCookies = HttpSOAPConnectionImpl.getSetCookies(this.m_connection);
        this.logResponseCookies();
        return message;
    }

    public void disconnect() {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("disconnect() called.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void logResponseCookies() {
        if (this.m_responseCookies != null) {
            block14: {
                if (this.pipelineContext != null && this.pipelineContext.isDebugMode()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("<cookies size=\"" + this.m_responseCookies.length + "\">");
                    for (int i = 0; i < this.m_responseCookies.length; ++i) {
                        String path;
                        String domain;
                        String content;
                        buffer.append("<cookie>");
                        String name = this.m_responseCookies[i].getName();
                        if (name != null) {
                            buffer.append("<name>");
                            buffer.append(name);
                            buffer.append("</name>");
                        }
                        if ((content = this.m_responseCookies[i].getContent()) != null) {
                            buffer.append("<content>");
                            buffer.append(content);
                            buffer.append("</content>");
                        }
                        if ((domain = this.m_responseCookies[i].getDomain()) != null) {
                            buffer.append("<domain>");
                            buffer.append(domain);
                            buffer.append("</domain>");
                        }
                        if ((path = this.m_responseCookies[i].getPath()) != null) {
                            buffer.append("<path>");
                            buffer.append(path);
                            buffer.append("</path>");
                        }
                        if (this.m_responseCookies[i].hasMaxAge()) {
                            buffer.append("<maxAge>");
                            buffer.append(this.m_responseCookies[i].getMaxAge());
                            buffer.append("</maxAge>");
                        }
                        buffer.append("</cookie>");
                    }
                    buffer.append("</cookies>");
                    try {
                        this.pipelineContext.addTraceXML("http_soap_response_cookies", XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(buffer.toString())));
                    }
                    catch (XMLStreamException e) {
                        if (!this.m_logger.isDebugEnabled()) break block14;
                        this.m_logger.debug("http_soap_response_cookies XMLStreamException: " + e.getMessage());
                    }
                }
            }
            if (!this.m_logger.isDebugEnabled()) return;
            this.m_logger.debug("Cookies returned in response: ");
            for (int i = 0; i < this.m_responseCookies.length; ++i) {
                this.m_logger.debug("Cookie: " + this.m_responseCookies[i].getName());
            }
            return;
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("No cookies returned in response.");
        }
        if (this.pipelineContext == null || !this.pipelineContext.isDebugMode()) return;
        try {
            this.pipelineContext.addTraceXML("http_soap_response_cookies", XMLStreamFactory.createXMLStreamReader((Reader)new StringReader("<cookies/>")));
            return;
        }
        catch (XMLStreamException e) {
            if (!this.m_logger.isDebugEnabled()) return;
            this.m_logger.debug("http_soap_response_cookies XMLStreamException: " + e.getMessage());
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("openConnection() called.");
        }
        this.m_connection = (HttpURLConnection)url.openConnection();
        HttpSOAPConnectionImpl.addCookies(this.m_connection, this.m_requestCookies);
        return this.m_connection;
    }

    protected static Cookie[] addCookie(Cookie[] cookies, Cookie cookie) {
        if (cookies == null) {
            cookies = new Cookie[1];
        } else {
            Cookie[] tempCookies = new Cookie[cookies.length + 1];
            System.arraycopy(cookies, 0, tempCookies, 0, cookies.length);
            cookies = tempCookies;
        }
        cookies[cookies.length - 1] = cookie;
        return cookies;
    }

    static Cookie[] addCookies(Cookie[] cookies1, Cookie[] cookies2) {
        if (cookies1 == null) {
            return cookies2;
        }
        if (cookies2 == null) {
            return cookies1;
        }
        Cookie[] tempCookies = new Cookie[cookies1.length + cookies2.length];
        System.arraycopy(cookies1, 0, tempCookies, 0, cookies1.length);
        System.arraycopy(cookies2, 0, tempCookies, cookies1.length, cookies2.length);
        return tempCookies;
    }

    static Cookie[] getSetCookies(HttpURLConnection connection) {
        Cookie[] cookies = null;
        int i = 1;
        while (connection.getHeaderFieldKey(i) != null) {
            String value;
            String key = connection.getHeaderFieldKey(i);
            if (key.equalsIgnoreCase("Set-Cookie") && (value = connection.getHeaderField(i)) != null) {
                Header header = new Header(key, value);
                HeaderElement[] headerElements = null;
                try {
                    headerElements = header.getValues();
                }
                catch (HttpException e) {
                    e.printStackTrace(System.err);
                    headerElements = new HeaderElement[]{};
                }
                for (int j = 0; j < headerElements.length; ++j) {
                    String cookieValue = headerElements[j].getValue();
                    if (cookieValue == null) {
                        cookieValue = "";
                    }
                    Cookie cookie = new Cookie();
                    cookie.setName(headerElements[j].getName());
                    cookie.setContent(cookieValue);
                    NameValuePair[] params = headerElements[j].getParameters();
                    if (params != null) {
                        for (int k = 0; k < params.length; ++k) {
                            if (params[k].getName().equalsIgnoreCase("Domain")) {
                                cookie.setDomain(params[k].getValue());
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Max-Age")) {
                                cookie.setMaxAge(Integer.parseInt(params[k].getValue()));
                                continue;
                            }
                            if (!params[k].getName().equalsIgnoreCase("Path")) continue;
                            cookie.setPath(params[k].getValue());
                        }
                    }
                    cookies = HttpSOAPConnectionImpl.addCookie(cookies, cookie);
                }
            }
            ++i;
        }
        return cookies;
    }

    public static void addCookies(HttpURLConnection connection, Cookie[] cookies) {
        if (cookies != null) {
            StringBuffer buf = new StringBuffer(256);
            for (int i = 0; i < cookies.length; ++i) {
                if (cookies[i] == null) continue;
                if (buf.length() > 0) {
                    buf.append("; ");
                }
                buf.append(cookies[i].getName());
                buf.append("=");
                String content = cookies[i].getContent();
                if (content == null) continue;
                buf.append(content);
            }
            String currentCookies = connection.getRequestProperty("Cookie");
            if (currentCookies != null) {
                buf.append(";");
                buf.append(currentCookies);
            }
            connection.setRequestProperty("Cookie", buf.toString());
        }
    }
}

