/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.common.log;

import com.cognos.cps.common.logging.ServiceLogger;

public class ServiceLoggerImpl
implements ServiceLogger,
Cloneable {
    private String className;

    public ServiceLoggerImpl() {
    }

    public ServiceLoggerImpl(Class class1) {
        this.className = class1.toString();
    }

    public void info(String message) {
        this.log("[INFO]", message);
    }

    public void warn(String message) {
        this.log("[WARN]", message);
    }

    public void error(String message) {
        this.log("[ERROR]", message);
    }

    public void error(String message, Throwable cause) {
        this.log("[ERROR]", message + ", nested: " + cause.toString());
    }

    public void debug(String message) {
        this.log("[DEBUG]", message);
    }

    public void enter(String method) {
        this.log("[ENTER]", method);
    }

    public void enter(String method, Object[] objects) {
        this.log("[ENTER]", method + " " + objects.toString());
    }

    public void exit(String method) {
        this.log("[EXIT]", method);
    }

    public void exit(String method, Object[] objects) {
        this.log("[EXIT]", method + " " + objects.toString());
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    private void log(String code, String message) {
        if (this.className != null) {
            System.out.println(code + " " + this.className + ": " + message);
        } else {
            System.out.println(code + " " + message);
        }
    }

    public ServiceLogger cloneForClass(Class className) {
        try {
            ServiceLoggerImpl newCopy = (ServiceLoggerImpl)this.clone();
            newCopy.className = className != null ? className.toString() : null;
            return newCopy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isAuditLevelEnabled(int level) {
        return false;
    }

    public void logAudit(int level, int operation, String message) {
    }

    public boolean isPerfLevelEnabled(int level) {
        return false;
    }

    public Object startTimer(int level, String method, String description, Object obj) {
        return null;
    }

    public void stopTimer(Object timer) {
    }
}

