/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.common.utils;

import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageState;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletState;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.ProducerRuntime;
import com.cognos.cps.services.wsrp.v1.types.SessionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class AssemblerStateEncoder {
    private static final char C_MARKER = '\u0000';

    public static PageletContext encodePageletState(PageletState pageletState) {
        String path = pageletState.getPath();
        PortletRuntime[] portletRuntime = pageletState.getPortletRuntime();
        PageletContext pageletContext = new PageletContext();
        pageletContext.setPath(path);
        if (portletRuntime != null) {
            StringBuffer sb = new StringBuffer();
            sb.append('t').append('1');
            if (portletRuntime != null) {
                sb.append('#').append(portletRuntime.length).append('\u0000');
                for (int i = 0; i < portletRuntime.length; ++i) {
                    if (portletRuntime[i].getId() != null) {
                        sb.append(portletRuntime[i].getId());
                    }
                    sb.append('\u0000');
                    if (portletRuntime[i].getMode() != null && !portletRuntime[i].getMode().equals("wsrp:view")) {
                        sb.append(portletRuntime[i].getMode());
                    }
                    sb.append('\u0000');
                    if (portletRuntime[i].getWindowState() != null && !portletRuntime[i].getWindowState().equals("wsrp:normal")) {
                        sb.append(portletRuntime[i].getWindowState());
                    }
                    sb.append('\u0000');
                    if (portletRuntime[i].getTitle() != null) {
                        sb.append(portletRuntime[i].getTitle());
                    }
                    sb.append('\u0000');
                    if (portletRuntime[i].getNavigationalState() != null) {
                        sb.append(portletRuntime[i].getNavigationalState());
                    }
                    sb.append('\u0000');
                    SessionContext sessionContext = portletRuntime[i].getSessionContext();
                    if (sessionContext != null) {
                        sb.append('#').append('1').append('\u0000');
                        if (sessionContext.getSessionID() != null) {
                            sb.append(sessionContext.getSessionID());
                        }
                        sb.append('\u0000');
                        if (sessionContext.hasExpires()) {
                            sb.append(sessionContext.getExpires());
                        }
                        sb.append('\u0000');
                        continue;
                    }
                    sb.append('#').append('0').append('\u0000');
                }
            } else {
                sb.append('#').append('0').append('\u0000');
            }
            pageletContext.setState(AssemblerStateEncoder.compressState(sb));
        }
        return pageletContext;
    }

    public static PageletState decodePageletState(String path, byte[] state) {
        if ((state = AssemblerStateEncoder.decompressState(state)) != null && state.length > 2 && state[0] == 116 && state[1] == 49) {
            PageletState pageletState = new PageletState();
            pageletState.setPath(path);
            int[] p = new int[]{2};
            int size = AssemblerStateEncoder.decodeArraySize(state, p);
            if (size > 0) {
                PortletRuntime[] portletRuntimes = new PortletRuntime[size];
                for (int i = 0; i < portletRuntimes.length; ++i) {
                    portletRuntimes[i] = new PortletRuntime();
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    portletRuntimes[i].setId(AssemblerStateEncoder.decodeString(state, p));
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    String value = AssemblerStateEncoder.decodeString(state, p);
                    portletRuntimes[i].setMode(value != null ? value : "wsrp:view");
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    value = AssemblerStateEncoder.decodeString(state, p);
                    portletRuntimes[i].setWindowState(value != null ? value : "wsrp:normal");
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    portletRuntimes[i].setTitle(AssemblerStateEncoder.decodeString(state, p));
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    portletRuntimes[i].setNavigationalState(AssemblerStateEncoder.decodeString(state, p));
                    if (!AssemblerStateEncoder.checkMarker(state, p) || (size = AssemblerStateEncoder.decodeArraySize(state, p)) <= 0 || !AssemblerStateEncoder.checkMarker(state, p)) continue;
                    SessionContext sessionContext = new SessionContext();
                    sessionContext.setSessionID(AssemblerStateEncoder.decodeString(state, p));
                    if (AssemblerStateEncoder.checkMarker(state, p)) {
                        sessionContext.setExpires(AssemblerStateEncoder.decodeInteger(state, p));
                    }
                    portletRuntimes[i].setSessionContext(sessionContext);
                }
                pageletState.setPortletRuntime(portletRuntimes);
            }
            return pageletState;
        }
        return null;
    }

    public static PackageContext encodePackageState(String path, ProducerRuntime[] runtimes) {
        PackageContext packageContext = new PackageContext();
        packageContext.setPath(path);
        if (runtimes != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("p1");
            sb.append("#").append(runtimes.length).append('\u0000');
            for (int i = 0; i < runtimes.length; ++i) {
                if (runtimes[i].getId() != null) {
                    sb.append(runtimes[i].getId());
                }
                sb.append('\u0000');
                Cookies[] cookies = runtimes[i].getCookies();
                if (cookies == null) continue;
                sb.append("#").append(cookies.length).append('\u0000');
                for (int j = 0; j < cookies.length; ++j) {
                    if (cookies[j].getGroupID() != null) {
                        sb.append(cookies[j].getGroupID());
                    }
                    sb.append('\u0000');
                    Cookie[] cookie = cookies[j].getCookie();
                    if (cookie == null) continue;
                    sb.append("#").append(cookie.length).append('\u0000');
                    for (int k = 0; k < cookie.length; ++k) {
                        if (cookie[k].getName() != null) {
                            sb.append(cookie[k].getName());
                        }
                        sb.append('\u0000');
                        if (cookie[k].getContent() != null) {
                            sb.append(cookie[k].getContent());
                        }
                        sb.append('\u0000');
                        if (cookie[k].getPath() != null) {
                            sb.append(cookie[k].getPath());
                        }
                        sb.append('\u0000');
                        if (cookie[k].getDomain() != null) {
                            sb.append(cookie[k].getDomain());
                        }
                        sb.append('\u0000');
                        if (cookie[k].hasMaxAge()) {
                            sb.append(cookie[k].getMaxAge());
                        }
                        sb.append('\u0000');
                    }
                }
            }
            packageContext.setState(AssemblerStateEncoder.compressState(sb));
        }
        return packageContext;
    }

    public static PackageState decodePackageState(String path, byte[] state) {
        if ((state = AssemblerStateEncoder.decompressState(state)) != null && state.length > 2 && state[0] == 112 && state[1] == 49) {
            PackageState packageState = new PackageState();
            packageState.setPath(path);
            int[] p = new int[]{2};
            int size = AssemblerStateEncoder.decodeArraySize(state, p);
            if (size > 0) {
                ProducerRuntime[] producerRuntimes = new ProducerRuntime[size];
                for (int i = 0; i < producerRuntimes.length; ++i) {
                    producerRuntimes[i] = new ProducerRuntime();
                    if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                    producerRuntimes[i].setId(AssemblerStateEncoder.decodeString(state, p));
                    if (!AssemblerStateEncoder.checkMarker(state, p) || (size = AssemblerStateEncoder.decodeArraySize(state, p)) <= 0) continue;
                    Cookies[] cookies = new Cookies[size];
                    for (int j = 0; j < cookies.length; ++j) {
                        cookies[j] = new Cookies();
                        if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                        cookies[j].setGroupID(AssemblerStateEncoder.decodeString(state, p));
                        if (!AssemblerStateEncoder.checkMarker(state, p) || (size = AssemblerStateEncoder.decodeArraySize(state, p)) <= 0) continue;
                        Cookie[] cookie = new Cookie[size];
                        for (int k = 0; k < cookie.length; ++k) {
                            String maxAge;
                            cookie[k] = new Cookie();
                            if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                            cookie[k].setName(AssemblerStateEncoder.decodeString(state, p));
                            if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                            cookie[k].setContent(AssemblerStateEncoder.decodeString(state, p));
                            if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                            cookie[k].setPath(AssemblerStateEncoder.decodeString(state, p));
                            if (!AssemblerStateEncoder.checkMarker(state, p)) continue;
                            cookie[k].setDomain(AssemblerStateEncoder.decodeString(state, p));
                            if (!AssemblerStateEncoder.checkMarker(state, p) || (maxAge = AssemblerStateEncoder.decodeString(state, p)) == null) continue;
                            cookie[k].setMaxAge(Integer.parseInt(maxAge));
                        }
                        cookies[j].setCookie(cookie);
                    }
                    producerRuntimes[i].setCookies(cookies);
                }
                packageState.setProducerRuntime(producerRuntimes);
            }
            return packageState;
        }
        return null;
    }

    private static byte[] compressState(StringBuffer sb) {
        int i = sb.length();
        while (i > 1 && sb.charAt(--i) == '\u0000') {
        }
        sb.delete(i + 1, sb.length());
        byte[] newState = null;
        try {
            newState = sb.toString().getBytes("UTF-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream(newState.length);
            GZIPOutputStream gzos = new GZIPOutputStream(bos);
            gzos.write(newState);
            gzos.close();
            newState = bos.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newState;
    }

    private static byte[] decompressState(byte[] state) {
        if (state != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(state);
            try {
                GZIPInputStream gzis = new GZIPInputStream(bis);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(state.length);
                int nByteRead = 0;
                byte[] buf = new byte[256];
                while ((nByteRead = gzis.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, nByteRead);
                }
                bos.close();
                gzis.close();
                return bos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int decodeArraySize(byte[] state, int[] _p) {
        if (state.length > _p[0]) {
            int n = _p[0];
            _p[0] = n + 1;
            if (state[n] == 35) {
                return AssemblerStateEncoder.decodeInteger(state, _p);
            }
        }
        return 0;
    }

    private static int decodeInteger(byte[] state, int[] _p) {
        int value = 0;
        int signed = 1;
        if (state[_p[0]] == 45) {
            signed = -1;
            _p[0] = _p[0] + 1;
        }
        while (state.length > _p[0] && state[_p[0]] >= 48 && state[_p[0]] <= 57) {
            value = value * 10 + (state[_p[0]] - 48);
            _p[0] = _p[0] + 1;
        }
        return signed * value;
    }

    private static String decodeString(byte[] state, int[] _p) {
        int count = 0;
        int startPos = _p[0];
        while (state.length > _p[0] && state[_p[0]] != 0) {
            _p[0] = _p[0] + 1;
            ++count;
        }
        byte[] newState = new byte[count];
        System.arraycopy(state, startPos, newState, 0, count);
        String str = null;
        try {
            str = new String(newState, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count > 0 ? str : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkMarker(byte[] state, int[] _p) {
        if (state.length <= _p[0]) return false;
        int n = _p[0];
        _p[0] = n + 1;
        if (state[n] != 0) return false;
        return true;
    }
}

