/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.common.utils;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.consumer.v1.intf.IConsumer;
import com.cognos.cps.services.pagelet.processor.v1.intf.IProcessor;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;

public class PageletFactory {
    static Map classes = new SmallMap();
    static Properties props;

    public static IStorage createStorageObject(String packagePath, IContext context, ServiceLogger logger) {
        if (packagePath != null && packagePath.charAt(0) == '/') {
            String packageName = packagePath.substring(1);
            context.setProperty("package", (Object)packageName);
            return (IStorage)PageletFactory.createObject(PageletFactory.buildKey("factory.storage.class.", packageName), IStorage.class, context, logger);
        }
        return null;
    }

    public static IConsumer createConsumerObject(String type, IContext context, ServiceLogger logger) {
        return (IConsumer)PageletFactory.createObject(PageletFactory.buildKey("factory.consumer.class.", type), IConsumer.class, context, logger);
    }

    public static IProcessor createProcessorObject(String nsURI, IContext context, ServiceLogger logger) {
        return (IProcessor)PageletFactory.createObject(PageletFactory.buildKey("factory.processor.class.", nsURI), IProcessor.class, context, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createObject(String aliasName, Class queryInterface, IContext context, ServiceLogger logger) {
        String MN = "createObject()";
        Class<PageletFactory> clazz = PageletFactory.class;
        synchronized (PageletFactory.class) {
            block23: {
                if (props == null) {
                    try {
                        InputStream stream = PageletFactory.class.getClassLoader().getResourceAsStream("cpsasm.properties");
                        props = new Properties();
                        props.load(stream);
                    }
                    catch (IOException e) {
                        logger.error(MN, (Throwable)e);
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                String className = props.getProperty(aliasName);
                if (className != null) {
                    Class<?> foundClass;
                    Map map = classes;
                    synchronized (map) {
                        foundClass = (Class<?>)classes.get(className);
                        if (foundClass == null) {
                            try {
                                foundClass = PageletFactory.class.getClassLoader().loadClass(className);
                                classes.put(className, foundClass);
                            }
                            catch (ClassNotFoundException e) {
                                logger.error(MN, (Throwable)e);
                            }
                        }
                    }
                    if (foundClass != null) {
                        try {
                            if (!queryInterface.isAssignableFrom(foundClass)) break block23;
                            Object newObject = null;
                            try {
                                Constructor<?> constructor = foundClass.getConstructor(ServiceLogger.class);
                                newObject = constructor.newInstance(logger);
                            }
                            catch (NoSuchMethodException e) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn(MN + " - no constructor with ServiceLogger - using default constructor");
                                }
                                newObject = foundClass.newInstance();
                            }
                            ((IServiceImplementation)newObject).initialize(context);
                            return newObject;
                        }
                        catch (InstantiationException e) {
                            logger.error(MN, (Throwable)e);
                        }
                        catch (IllegalAccessException e) {
                            logger.error(MN, (Throwable)e);
                        }
                        catch (ServiceException e) {
                            logger.error(MN, (Throwable)e);
                        }
                        catch (SecurityException e) {
                            logger.error(MN, (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            logger.error(MN, (Throwable)e);
                        }
                    }
                }
            }
            return null;
        }
    }

    private static String buildKey(String prefix, String key) {
        StringBuffer sb = new StringBuffer(prefix);
        if (key == null || "".equals(key)) {
            key = "default";
        }
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            ch = Character.toLowerCase(ch);
            switch (ch) {
                case '/': 
                case ':': 
                case '\\': {
                    ch = '.';
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

