/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.common.utils;

import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageState;
import com.cognos.cps.services.pagelet.objects.v1.types.Pagelet;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletState;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.ProducerRuntime;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import java.util.Map;

public class PortletRefs {
    public PortletInstance portletInstance;
    public PortletProducer producer;
    public Portlet portlet;
    public PortletDescription portletDescription;
    public PortletRuntime portletRuntime;
    public ProducerRuntime producerRuntime;

    public PortletRefs(PortletInstance portletInstance) {
        this.portletInstance = portletInstance;
    }

    public boolean isValid() {
        return this.portletInstance != null && this.producer != null && this.portlet != null && this.portletDescription != null;
    }

    public boolean isModeSupported(String mode) {
        String[] modes;
        if (this.portletInstance != null && (modes = this.portletInstance.getAccessModes()) != null) {
            for (int i = 0; i < modes.length; ++i) {
                if (!modes[i].equals(mode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAccessRights(AccessRightsType value) {
        AccessRightsType[] accessRights = this.portletInstance.getAccessRights();
        if (accessRights != null) {
            for (int i = 0; i < accessRights.length; ++i) {
                if (!accessRights[i].equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    protected static void resolveReferences(Map map, Pagelet pagelet, PackageState packageState, PageletState pageletState) {
        ProducerRuntime[] producerRuntimes = null;
        if (packageState != null) {
            producerRuntimes = packageState.getProducerRuntime();
        }
        PortletRuntime[] portletRuntimes = null;
        if (pageletState != null) {
            portletRuntimes = pageletState.getPortletRuntime();
        }
        if (pagelet.getMetadata() != null) {
            PortletProducer[] producers = pagelet.getMetadata().getPortletProducer();
            for (int i = 0; i < producers.length; ++i) {
                PortletDescription[] offeredPortlets = null;
                if (producers[i].getServiceDescription() != null) {
                    offeredPortlets = producers[i].getServiceDescription().getOfferedPortlets();
                }
                ProducerRuntime producerRuntime = null;
                if (producerRuntimes != null) {
                    for (int r = 0; r < producerRuntimes.length; ++r) {
                        if (!producerRuntimes[r].getId().equals(producers[i].getId())) continue;
                        producerRuntime = producerRuntimes[r];
                        break;
                    }
                }
                Portlet[] portlets = producers[i].getPortlet();
                block2: for (PortletRefs ref : map.values()) {
                    for (int j = 0; j < portlets.length; ++j) {
                        if (ref.portletInstance == null || !portlets[j].getId().equals(ref.portletInstance.getPortletId())) continue;
                        ref.producer = producers[i];
                        ref.producerRuntime = producerRuntime;
                        ref.portlet = portlets[j];
                        if (offeredPortlets != null) {
                            for (int k = 0; k < offeredPortlets.length; ++k) {
                                if (!offeredPortlets[k].getPortletHandle().equals(ref.portlet.getHandle())) continue;
                                ref.portletDescription = offeredPortlets[k];
                                break;
                            }
                        }
                        if (portletRuntimes == null) continue block2;
                        for (int r = 0; r < portletRuntimes.length; ++r) {
                            if (portletRuntimes[r] == null || !portletRuntimes[r].getId().equals(ref.portletInstance.getId())) continue;
                            ref.portletRuntime = portletRuntimes[r];
                            portletRuntimes[r] = null;
                            continue block2;
                        }
                        continue block2;
                    }
                }
            }
        }
        if (portletRuntimes != null) {
            for (int r = 0; r < portletRuntimes.length; ++r) {
                if (portletRuntimes[r] == null) continue;
                pageletState.removePortletRuntime(portletRuntimes[r]);
            }
        }
    }
}

