/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl;

import com.cognos.cps.cache.CacheManager;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.exception.PageletException;
import com.cognos.cps.pagelet.common.log.LogManager;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.pagelet.consumer.v1.intf.IConsumer;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkupResponse;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;

public class ConsumerImpl
implements IConsumer,
IServiceImplementation {
    ServiceLogger m_logger;
    CacheManager m_cacheManager;
    private int m_cacheMaxSizePerPortlet = -1;
    private boolean m_allowPortletStateChange = false;

    public ConsumerImpl(ServiceLogger logger) {
        this.m_logger = logger != null ? logger.cloneForClass(ConsumerImpl.class) : LogManager.getLogManager().getLogger(ConsumerImpl.class);
    }

    public ConsumerImpl() {
    }

    public GetMarkupResponse getMarkup(GetMarkup getMarkup, IContext context) throws OperationFailedFault {
        if (getMarkup == null || getMarkup.getPagelet() == null) {
            Object[] args = new String[]{getMarkup == null ? "markup" : "pagelet"};
            throw new OperationFailedFault("cps.pagelet.common.missingparameter.error", args, null);
        }
        try {
            RequestExecutor request = new RequestExecutor(getMarkup, context, this.m_cacheManager, this.m_cacheMaxSizePerPortlet, this.m_allowPortletStateChange, this.m_logger);
            return request.execute();
        }
        catch (PageletException e) {
            if (this.m_logger.isErrorEnabled()) {
                this.m_logger.error("ConsumerImpl.getMarkup()", (Throwable)e);
            }
            throw new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, (Throwable)e);
        }
    }

    public synchronized void initialize(IContext context) {
        String MN = "ConsumerImpl.initialize()";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        try {
            Integer intValue;
            this.m_cacheManager = (CacheManager)context.getProperty("CACHE_MANAGER");
            this.m_cacheMaxSizePerPortlet = this.m_cacheManager == null ? 0 : ((intValue = (Integer)context.getProperty("CACHE_MAXSIZEPERPORTLET")) != null ? intValue : -1);
            Boolean boolValue = (Boolean)context.getProperty("ALLOW_PORTLET_STATE_CHANGE");
            this.m_allowPortletStateChange = boolValue != null ? boolValue : false;
            RequestExecutor.initialize();
        }
        catch (PageletException e) {
            this.m_logger.error(MN, (Throwable)e);
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }

    public synchronized void terminate() {
        String MN = "ConsumerImpl.terminate()";
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter(MN);
        }
        RequestExecutor.terminate();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit(MN);
        }
    }
}

