/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl;

import com.cognos.cps.cache.Cache;
import com.cognos.cps.cache.CacheManager;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Boyer;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.common.utils.LocaleUtils;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.common.utils.Strings;
import com.cognos.cps.pagelet.common.exception.ExceptionUtilities;
import com.cognos.cps.pagelet.common.exception.PageletException;
import com.cognos.cps.pagelet.common.thread.IRerunnable;
import com.cognos.cps.pagelet.common.thread.RerunnableThread;
import com.cognos.cps.pagelet.common.thread.ThreadPool;
import com.cognos.cps.pagelet.consumer.impl.InteractionParamsHelper;
import com.cognos.cps.pagelet.consumer.impl.PortletRefs;
import com.cognos.cps.pagelet.consumer.impl.RerunnableImpl;
import com.cognos.cps.pagelet.consumer.impl.requests.GetMarkupRequest;
import com.cognos.cps.pagelet.consumer.impl.requests.InitCookieRequest;
import com.cognos.cps.pagelet.consumer.impl.requests.PerformBlockingInteractionRequest;
import com.cognos.cps.pagelet.consumer.impl.requests.WSRPRequest;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkupResponse;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.NewPortletContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PackageState;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletParams;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletState;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletMarkup;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.ProducerRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.UseCachedMarkup;
import com.cognos.cps.services.soap.envelope.SOAPFault;
import com.cognos.cps.services.soap.envelope.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.CacheControl;
import com.cognos.cps.services.wsrp.v1.types.CookieProtocol;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.PortletDescription;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exolab.castor.types.AnyNode;

public class RequestExecutor {
    private static final String EVENTS_EXTENSION_LOCALNAME = "events";
    private static final String EVENT_EXTENSION_LOCALNAME = "event";
    private static final String CPS_WSRP_EXTENSION_NAMESPACE_PREFIX = "cpsext";
    private static final String CPS_WSRP_EXTENSION_NAMESPACE_URI = "http://developer.cognos.com/schemas/cps/wsrp/extensions/1/";
    static ThreadPool requestsThreadPool;
    private static int THREAD_POOL_USE_COUNT;
    private IContext context;
    private CacheManager cacheManager;
    private Cache userCache = null;
    private int cacheMaxSizePerPortlet;
    private boolean allowPortletStateChange;
    private ServiceLogger logger;
    private GetMarkup getMarkup;
    private GetMarkupResponse getMarkupResponse;
    private InteractionParamsHelper interaction;
    private Map portletInstances = new SmallMap();
    private static final char VALTAG_ESCAPE_CHAR = '+';
    private static final char VALTAG_SEPARATOR = ':';

    RequestExecutor(GetMarkup getMarkup, IContext context, CacheManager cacheManager, int cacheMaxSizePerPortlet, boolean portletStateChange, ServiceLogger logger) throws PageletException {
        this.logger = logger.cloneForClass(RequestExecutor.class);
        if (getMarkup.getPagelet() == null) {
            Object[] args = new String[]{"pagelet"};
            throw new PageletException("cps.pagelet.common.missingparameter.error", args);
        }
        this.context = context;
        this.getMarkup = getMarkup;
        this.cacheManager = cacheManager;
        this.cacheMaxSizePerPortlet = cacheMaxSizePerPortlet;
        this.allowPortletStateChange = portletStateChange;
        this.initUserCache();
        this.getMarkupResponse = com.cognos.cps.services.pagelet.consumer.v1.types.TypeFactory.newInstance().createGetMarkupResponse();
        this.getMarkupResponse.setPath(getMarkup.getPagelet().getPath());
        this.getMarkupResponse.setUpdateState(com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createUpdateState());
        if (getMarkup.getInteraction() != null) {
            this.interaction = new InteractionParamsHelper(getMarkup);
            if ((this.interaction.wsrpPortletInstanceKey == null || "".equals(this.interaction.wsrpPortletInstanceKey)) && this.interaction.events == null) {
                Object[] args = new String[]{"wsrp-portletInstanceKey"};
                throw new PageletException("cps.pagelet.common.missingparameter.error", args);
            }
        }
        PortletInstance[] instances = getMarkup.getPagelet().getPortletInstance();
        for (int i = 0; i < instances.length; ++i) {
            this.portletInstances.put(instances[i].getId(), new PortletRefs(instances[i]));
        }
        PortletRefs.resolveReferences(getMarkup, this.portletInstances);
        if (this.interaction != null && this.interaction.wsrpPortletInstanceKey != null) {
            PortletRefs portletRefs = (PortletRefs)this.portletInstances.get(this.interaction.wsrpPortletInstanceKey);
            if (portletRefs == null) {
                throw new PageletException("cps.pagelet.consumer.invalidpik.error");
            }
            if (this.interaction.resetPortletContext && portletRefs.portletInstance.getPortletContext() != null && !portletRefs.isAccessRights(AccessRightsType.READONLY)) {
                portletRefs.portletInstance.setPortletContext(null);
                if (portletRefs.portletRuntime != null) {
                    portletRefs.portletRuntime.setSessionContext(null);
                }
                NewPortletContext newPortletContext = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createNewPortletContext();
                newPortletContext.setPortletId(this.interaction.wsrpPortletInstanceKey);
                this.getMarkupResponse.getUpdateState().setNewPortletContext(newPortletContext);
            }
        }
    }

    public GetMarkupResponse execute() throws PageletException {
        if (this.getMarkup.getPagelet().getMetadata() == null || this.getMarkup.getPagelet().getMetadata().getPortletProducer() == null || this.getMarkup.getPagelet().getPortletInstance() == null) {
            return this.getMarkupResponse;
        }
        ArrayList requests = new ArrayList();
        this.checkProducersCookies(requests);
        if (this.interaction != null && "blockingAction".equals(this.interaction.wsrpUrlType)) {
            this.performBlockingInteraction(requests);
            this.executeRequests(requests);
        }
        Object timer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            timer = this.logger.startTimer(4, "RequestExecutor", "getAllMarkups", (Object)this.context);
        }
        this.getAllMarkups(requests);
        if (timer != null) {
            this.logger.stopTimer(timer);
        }
        Object timer1 = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            timer1 = this.logger.startTimer(4, "RequestExecutor", "executeRequests", (Object)this.context);
        }
        this.executeRequests(requests);
        if (timer1 != null) {
            this.logger.stopTimer(timer1);
        }
        return this.buildResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequests(List requests) {
        while (true) {
            for (WSRPRequest request : requests) {
                if (!request.canRun()) continue;
                try {
                    RerunnableThread thread = requestsThreadPool.acquireThread();
                    IRerunnable req = thread.getRerunnable();
                    req.initialize(request, requests);
                    thread.execute();
                }
                catch (PageletException thread) {}
            }
            List list = requests;
            synchronized (list) {
                boolean allCompleted = true;
                Iterator it = requests.iterator();
                while (allCompleted && it.hasNext()) {
                    allCompleted = ((WSRPRequest)it.next()).isCompleted();
                }
                if (!allCompleted) {
                    try {
                        requests.wait();
                    }
                    catch (InterruptedException e) {
                    }
                }
                break;
            }
        }
    }

    public static synchronized void initialize() throws PageletException {
        requestsThreadPool = new ThreadPool("requests");
        requestsThreadPool.initialize(5, "wsrpRequest", 3600000L, RerunnableImpl.class.getName());
        ++THREAD_POOL_USE_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminate() {
        if (requestsThreadPool != null && --THREAD_POOL_USE_COUNT == 0) {
            ThreadPool threadPool = requestsThreadPool;
            synchronized (threadPool) {
                requestsThreadPool.terminate();
                requestsThreadPool = null;
            }
        }
    }

    private void checkProducersCookies(List requests) {
        PortletProducer[] producers = this.getMarkup.getPagelet().getMetadata().getPortletProducer();
        ProducerRuntime[] runtimes = this.getMarkup.getPackageState() != null ? this.getMarkup.getPackageState().getProducerRuntime() : null;
        ArrayList<Object[]> needInitCookies = new ArrayList<Object[]>();
        for (int p = 0; p < producers.length; ++p) {
            boolean needCookies;
            CookieProtocol requiresInitCookie = producers[p].getServiceDescription().getRequiresInitCookie();
            if (requiresInitCookie.getType() != 1 && requiresInitCookie.getType() != 2) continue;
            Cookies[] allCookies = null;
            if (runtimes != null) {
                for (int r = 0; r < runtimes.length; ++r) {
                    if (!runtimes[r].getId().equals(producers[p].getId())) continue;
                    allCookies = runtimes[r].getCookies();
                    break;
                }
            }
            if (requiresInitCookie.getType() == 2) {
                needCookies = true;
                boolean needPerUserCookies = false;
                PortletDescription[] offeredPortlets = producers[p].getServiceDescription().getOfferedPortlets();
                Portlet[] portlets = producers[p].getPortlet();
                block2: for (int pp = 0; pp < portlets.length; ++pp) {
                    for (int op = 0; op < offeredPortlets.length; ++op) {
                        if (!offeredPortlets[op].getPortletHandle().equals(portlets[pp].getHandle())) continue;
                        String groupID = offeredPortlets[op].getGroupID();
                        if (groupID == null || groupID.length() == 0) {
                            needPerUserCookies = true;
                            if (allCookies == null) continue block2;
                            for (int c = 0; c < allCookies.length; ++c) {
                                if (allCookies[c].getGroupID() != null && allCookies[c].getGroupID().length() != 0) continue;
                                needCookies = false;
                                continue block2;
                            }
                            continue block2;
                        }
                        boolean needGroupCookies = true;
                        if (allCookies != null) {
                            for (int c = 0; c < allCookies.length; ++c) {
                                if (allCookies[c].getGroupID() == null || !allCookies[c].getGroupID().equals(groupID)) continue;
                                needGroupCookies = false;
                                break;
                            }
                        }
                        if (!needGroupCookies) continue block2;
                        needInitCookies.add(new Object[]{producers[p], groupID});
                        continue block2;
                    }
                }
                if (!needPerUserCookies || !needCookies) continue;
                needInitCookies.add(new Object[]{producers[p], null});
                continue;
            }
            needCookies = true;
            if (allCookies != null) {
                for (int c = 0; c < allCookies.length; ++c) {
                    if (allCookies[c].getGroupID() != null && allCookies[c].getGroupID().length() != 0) continue;
                    needCookies = false;
                    break;
                }
            }
            if (!needCookies) continue;
            needInitCookies.add(new Object[]{producers[p], null});
        }
        for (int loop = 0; loop < needInitCookies.size(); ++loop) {
            Object[] vars = (Object[])needInitCookies.get(loop);
            PortletProducer portletProducer = (PortletProducer)vars[0];
            String groupID = (String)vars[1];
            PackageState packageState = this.getMarkupResponse.getUpdateState().getPackageState();
            if (packageState == null) {
                packageState = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPackageState();
                packageState.setPath(this.calculatePackagePath(this.getMarkup.getPagelet().getPath()));
                this.getMarkupResponse.getUpdateState().setPackageState(packageState);
            }
            ProducerRuntime producerRuntime = null;
            runtimes = packageState.getProducerRuntime();
            for (int r = 0; runtimes != null && r < runtimes.length; ++r) {
                if (!runtimes[r].getId().equals(portletProducer.getId())) continue;
                producerRuntime = runtimes[r];
                break;
            }
            if (producerRuntime == null) {
                producerRuntime = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createProducerRuntime();
                producerRuntime.setId(portletProducer.getId());
                packageState.addProducerRuntime(producerRuntime);
            }
            Cookies cookies = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createCookies();
            cookies.setGroupID(groupID);
            producerRuntime.addCookies(cookies);
            requests.add(new InitCookieRequest(this, portletProducer, cookies));
        }
    }

    private void performBlockingInteraction(List requests) {
        PortletRefs portletRefs = (PortletRefs)this.portletInstances.get(this.interaction.wsrpPortletInstanceKey);
        String groupID = portletRefs.getCookieGroupID();
        WSRPRequest parent = null;
        for (WSRPRequest request : requests) {
            String cookieGroup;
            InitCookieRequest initCookieRequest;
            if (!(request instanceof InitCookieRequest) || !(initCookieRequest = (InitCookieRequest)request).getProducer().getId().equals(portletRefs.producer.getId()) || (cookieGroup = initCookieRequest.getCookieGroup()) != groupID && (groupID == null || !groupID.equals(cookieGroup))) continue;
            parent = request;
            break;
        }
        requests.add(new PerformBlockingInteractionRequest(parent, this, portletRefs, portletRefs.templateComposer));
    }

    private void getAllMarkups(List requests) {
        String wsrpPortletInstanceKey = this.checkSinglePortlet();
        PortletInstance[] instances = this.getMarkup.getPagelet().getPortletInstance();
        for (int i = 0; i < instances.length; ++i) {
            PortletRefs portletRefs;
            if (wsrpPortletInstanceKey != null && (wsrpPortletInstanceKey == null || !wsrpPortletInstanceKey.equals(instances[i].getId())) || !(portletRefs = (PortletRefs)this.portletInstances.get(instances[i].getId())).isValid() || !portletRefs.isModeSupported("wsrp:view")) continue;
            String groupID = portletRefs.getCookieGroupID();
            WSRPRequest parent = null;
            for (WSRPRequest request : requests) {
                if (request instanceof InitCookieRequest && !(parent instanceof InitCookieRequest)) {
                    String cookieGroup;
                    InitCookieRequest initCookieRequest;
                    if (request.getProducer() == null || request.getProducer().getId() == null || !request.getProducer().getId().equals(portletRefs.producer.getId()) || !(initCookieRequest = (InitCookieRequest)request).getProducer().getId().equals(portletRefs.producer.getId()) || ((cookieGroup = initCookieRequest.getCookieGroup()) != null || groupID != null) && (groupID == null || !groupID.equals(cookieGroup))) continue;
                    parent = request;
                    continue;
                }
                if (!(request instanceof PerformBlockingInteractionRequest) || !request.getProducer().getId().equals(portletRefs.producer.getId())) continue;
                parent = request;
                break;
            }
            if (this.interaction != null && this.interaction.events != null) {
                portletRefs.extensions = new Extension[1];
                portletRefs.extensions[0] = RequestExecutor.buildEventExtension(this.interaction.events);
            }
            requests.add(new GetMarkupRequest(parent, this, portletRefs, portletRefs.templateComposer, this.logger));
        }
    }

    private static Extension buildEventExtension(List events) {
        Extension eventExtension = new Extension();
        AnyNode eventListNode = new AnyNode(1, EVENTS_EXTENSION_LOCALNAME, CPS_WSRP_EXTENSION_NAMESPACE_PREFIX, CPS_WSRP_EXTENSION_NAMESPACE_URI, null);
        eventListNode.addNamespace(new AnyNode(3, null, CPS_WSRP_EXTENSION_NAMESPACE_PREFIX, CPS_WSRP_EXTENSION_NAMESPACE_URI, null));
        eventExtension.setAnyObject((Object)eventListNode);
        for (String value : events) {
            AnyNode eventNode = new AnyNode(1, EVENT_EXTENSION_LOCALNAME, CPS_WSRP_EXTENSION_NAMESPACE_PREFIX, CPS_WSRP_EXTENSION_NAMESPACE_URI, null);
            eventNode.addChild(new AnyNode(6, null, null, null, value));
            eventListNode.addChild(eventNode);
        }
        return eventExtension;
    }

    private GetMarkupResponse buildResponse() throws PageletException {
        PackageState packageState;
        Object timer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            timer = this.logger.startTimer(4, "RequestExecutor", "buildResponse", (Object)this.context);
        }
        if (this.getMarkupResponse.getRedirectURL() != null) {
            return this.getMarkupResponse;
        }
        PageletParams pageletParams = this.getMarkup.getPageletParams();
        String[] cacheTags = null;
        if (pageletParams != null && pageletParams.getValidateTag() != null) {
            cacheTags = Strings.split((String)this.getMarkup.getPageletParams().getValidateTag(), (char)':', (char)'+');
        }
        if ((packageState = this.getMarkupResponse.getUpdateState().getPackageState()) == null) {
            packageState = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPackageState();
            packageState.setPath(this.calculatePackagePath(this.getMarkup.getPagelet().getPath()));
            this.getMarkupResponse.getUpdateState().setPackageState(packageState);
        }
        PortletProducer[] producers = this.getMarkup.getPagelet().getMetadata().getPortletProducer();
        ProducerRuntime[] runtimes = packageState.getProducerRuntime();
        if (this.getMarkup.getPackageState() != null) {
            ProducerRuntime[] prevRuntimes = this.getMarkup.getPackageState().getProducerRuntime();
            block0: for (int p = 0; p < producers.length; ++p) {
                int r;
                PortletProducer producer = producers[p];
                boolean found = false;
                for (r = 0; runtimes != null && r < runtimes.length; ++r) {
                    if (!runtimes[r].getId().equals(producer.getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                for (r = 0; r < prevRuntimes.length; ++r) {
                    if (!prevRuntimes[r].getId().equals(producer.getId())) continue;
                    packageState.addProducerRuntime(prevRuntimes[r]);
                    continue block0;
                }
            }
        }
        PageletState pageletState = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPageletState();
        pageletState.setPath(this.getMarkup.getPagelet().getPath());
        int countCacheControls = 0;
        int minExpiresTime = Integer.MAX_VALUE;
        StringBuffer valTag = new StringBuffer();
        boolean allFromCache = true;
        PortletInstance[] instances = this.getMarkup.getPagelet().getPortletInstance();
        for (int i = 0; i < instances.length; ++i) {
            boolean isWsrpInstance;
            PortletRefs portletRefs = (PortletRefs)this.portletInstances.get(instances[i].getId());
            allFromCache = allFromCache && portletRefs.cacheStats.copyFromCache;
            UpdateResponse updateResponse = null;
            if (portletRefs.blockingResponse != null && (updateResponse = portletRefs.blockingResponse.getUpdateResponse()) != null && updateResponse.getPortletContext() != null) {
                NewPortletContext newPortletContext = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createNewPortletContext();
                newPortletContext.setPortletId(this.interaction.wsrpPortletInstanceKey);
                newPortletContext.setPortletContext(updateResponse.getPortletContext());
                this.getMarkupResponse.getUpdateState().setNewPortletContext(newPortletContext);
            }
            PortletRuntime portletRuntime = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPortletRuntime();
            portletRuntime.setId(instances[i].getId());
            boolean bl = isWsrpInstance = this.interaction != null && this.interaction.wsrpPortletInstanceKey != null && this.interaction.wsrpPortletInstanceKey.equals(portletRefs.portletInstance.getId());
            if (portletRefs.markupResponse != null && portletRefs.markupResponse.getSessionContext() != null) {
                portletRuntime.setSessionContext(portletRefs.markupResponse.getSessionContext());
            } else if (updateResponse != null && updateResponse.getSessionContext() != null) {
                portletRuntime.setSessionContext(updateResponse.getSessionContext());
            } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getSessionContext() != null) {
                portletRuntime.setSessionContext(portletRefs.portletRuntime.getSessionContext());
            }
            if (isWsrpInstance && this.interaction.resetPortletContext) {
                portletRuntime.setNavigationalState(null);
            } else if (updateResponse != null && updateResponse.getNavigationalState() != null) {
                portletRuntime.setNavigationalState(updateResponse.getNavigationalState());
            } else if (isWsrpInstance && this.interaction.wsrpNavigationalState != null) {
                portletRuntime.setNavigationalState(this.interaction.wsrpNavigationalState);
            } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getNavigationalState() != null) {
                portletRuntime.setNavigationalState(portletRefs.portletRuntime.getNavigationalState());
            }
            if (portletRefs.markupResponse != null && portletRefs.markupResponse.getMarkupContext() != null) {
                portletRuntime.setTitle(portletRefs.markupResponse.getMarkupContext().getPreferredTitle());
            } else if (updateResponse != null && updateResponse.getMarkupContext() != null) {
                portletRuntime.setTitle(updateResponse.getMarkupContext().getPreferredTitle());
            } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getTitle() != null) {
                portletRuntime.setTitle(portletRefs.portletRuntime.getTitle());
            }
            if (updateResponse != null && updateResponse.getNewMode() != null && updateResponse.getNewMode().length() > 0) {
                portletRuntime.setMode(updateResponse.getNewMode());
            } else if (isWsrpInstance && this.interaction.wsrpMode != null && this.interaction.wsrpMode.length() > 0) {
                portletRuntime.setMode(this.interaction.wsrpMode);
            } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getMode() != null) {
                portletRuntime.setMode(portletRefs.portletRuntime.getMode());
            }
            if (updateResponse != null && updateResponse.getNewWindowState() != null && updateResponse.getNewWindowState().length() > 0) {
                portletRuntime.setWindowState(updateResponse.getNewWindowState());
            } else if (isWsrpInstance && this.interaction.wsrpWindowState != null && this.interaction.wsrpWindowState.length() > 0) {
                portletRuntime.setWindowState(this.interaction.wsrpWindowState);
            } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getWindowState() != null) {
                portletRuntime.setWindowState(portletRefs.portletRuntime.getWindowState());
            }
            pageletState.addPortletRuntime(portletRuntime);
            PortletMarkup portletMarkup = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPortletMarkup();
            portletMarkup.setId(instances[i].getId());
            if (portletRefs.markupResponse != null && portletRefs.markupResponse.getMarkupContext() != null) {
                String prefix = portletRefs.templateComposer != null ? portletRefs.templateComposer.getNamespacePrefix() : "";
                portletMarkup.setNamespacePrefix(prefix);
                portletMarkup.setMarkupContext(RequestExecutor.markupRewrite(portletRefs, prefix));
                CacheControl cacheControl = portletRefs.markupResponse.getMarkupContext().getCacheControl();
                if (cacheControl != null) {
                    ++countCacheControls;
                    if (cacheControl.getExpires() < minExpiresTime && cacheControl.getExpires() >= 0) {
                        minExpiresTime = cacheControl.getExpires();
                    }
                    if (cacheTags != null) {
                        for (int t = 0; t < cacheTags.length; ++t) {
                            if (cacheTags[t] == null || !cacheTags[t].equals(portletRefs.cacheStats.cacheID)) continue;
                            cacheTags[t] = null;
                        }
                    }
                    if (cacheControl.getValidateTag() != null && portletRefs.cacheStats.cacheID != null) {
                        if (valTag.length() > 0) {
                            valTag.append(':');
                        }
                        EncodingUtils.escapeString((String)portletRefs.cacheStats.cacheID, (String)String.valueOf(':'), (char)'+', (StringBuffer)valTag);
                    }
                }
            } else if (portletRefs.fault != null) {
                Locale locale;
                Object productLocale = this.context.getProperty("PRODUCT_LOCALE");
                if (productLocale != null) {
                    locale = LocaleUtils.toLocale((String)productLocale.toString());
                } else if (pageletParams != null && pageletParams.getLocales() != null && pageletParams.getLocales().length > 0) {
                    String[] locales = pageletParams.getLocales();
                    locale = LocaleUtils.toLocale((String)locales[0]);
                } else {
                    locale = Locale.ENGLISH;
                }
                SOAPFault fault = TypeFactory.newInstance().createFault();
                fault.setFaultcode(portletRefs.fault.getKey());
                fault.setFaultstring(portletRefs.fault.getLocalizedMsgString(locale));
                fault.setDetail(ExceptionUtilities.convertFaultToDetail(portletRefs.fault.getRootCause()));
                portletMarkup.setFaultContext(fault);
            }
            this.getMarkupResponse.addPortletMarkup(portletMarkup);
        }
        this.getMarkupResponse.getUpdateState().setPageletState(pageletState);
        UseCachedMarkup useCacheMarkup = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createUseCachedMarkup();
        useCacheMarkup.setContent(false);
        this.getMarkupResponse.setUseCachedMarkup(useCacheMarkup);
        if (allFromCache && cacheTags != null) {
            int i;
            for (i = 0; i < cacheTags.length && cacheTags[i] == null; ++i) {
            }
            if (i >= cacheTags.length) {
                useCacheMarkup.setContent(true);
            }
        }
        if (countCacheControls == instances.length) {
            com.cognos.cps.services.pagelet.objects.v1.types.CacheControl cacheControl = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createCacheControl();
            cacheControl.setExpires(minExpiresTime);
            cacheControl.setUserScope(null);
            cacheControl.setValidateTag(valTag.toString());
            this.getMarkupResponse.setCacheControl(cacheControl);
        }
        if (timer != null) {
            this.logger.stopTimer(timer);
        }
        return this.getMarkupResponse;
    }

    private String calculatePackagePath(String path) {
        if (path != null && path.length() > 1) {
            int i = path.indexOf(1, 47);
            if (i > 1) {
                return path.substring(0, i);
            }
            return path;
        }
        return null;
    }

    private String checkSinglePortlet() {
        String newMode = null;
        String newWindowState = null;
        String singlePortletID = null;
        if (this.getMarkup.getPageletState() != null) {
            PortletRuntime[] runtimes = this.getMarkup.getPageletState().getPortletRuntime();
            for (int p = 0; p < runtimes.length; ++p) {
                if (runtimes[p].getId() == null) continue;
                String mode = runtimes[p].getMode();
                String windowState = runtimes[p].getWindowState();
                if (this.interaction != null && this.interaction.wsrpPortletInstanceKey != null && runtimes[p].getId().equals(this.interaction.wsrpPortletInstanceKey)) {
                    UpdateResponse updateResponse;
                    PortletRefs portletRefs = (PortletRefs)this.portletInstances.get(this.interaction.wsrpPortletInstanceKey);
                    if (portletRefs.blockingResponse != null && (updateResponse = portletRefs.blockingResponse.getUpdateResponse()) != null && RequestExecutor.isSinglePortlet(newMode = updateResponse.getNewMode(), newWindowState = updateResponse.getNewWindowState())) {
                        singlePortletID = this.interaction.wsrpPortletInstanceKey;
                        continue;
                    }
                    if (newMode == null) {
                        newMode = this.interaction.wsrpMode;
                    }
                    if (newWindowState == null) {
                        newWindowState = this.interaction.wsrpWindowState;
                    }
                    if (RequestExecutor.isSinglePortlet(newMode, newWindowState)) {
                        singlePortletID = this.interaction.wsrpPortletInstanceKey;
                        continue;
                    }
                    if (newMode != null) {
                        mode = newMode;
                    }
                    if (newWindowState != null) {
                        windowState = newWindowState;
                    }
                    if (!RequestExecutor.isSinglePortlet(mode, windowState)) continue;
                    singlePortletID = this.interaction.wsrpPortletInstanceKey;
                    continue;
                }
                if (this.interaction == null) {
                    if (!RequestExecutor.isSinglePortlet(mode, windowState)) continue;
                    singlePortletID = runtimes[p].getId();
                    break;
                }
                if ("wsrp:edit".equals(mode) || "wsrp:help".equals(mode) || "cps:config".equals(mode)) {
                    runtimes[p].setMode("wsrp:view");
                }
                if (!"wsrp:maximized".equals(windowState) && !"wsrp:solo".equals(windowState)) continue;
                runtimes[p].setWindowState("wsrp:normal");
            }
        }
        return singlePortletID;
    }

    private static boolean isSinglePortletModes(String mode) {
        return "wsrp:edit".equals(mode) || "cps:config".equals(mode) || "wsrp:help".equals(mode);
    }

    private static boolean isSinglePortletWindowStates(String windowState) {
        return "wsrp:solo".equals(windowState) || "wsrp:maximized".equals(windowState);
    }

    private static boolean isSinglePortlet(String mode, String windowState) {
        return RequestExecutor.isSinglePortletModes(mode) || RequestExecutor.isSinglePortletWindowStates(windowState);
    }

    static MarkupContext markupRewrite(PortletRefs portletRefs, String namespacePrefix) throws PageletException {
        MarkupContext markupContext = portletRefs.markupResponse.getMarkupContext();
        String markup = null;
        if (markupContext.getMarkupBinary() != null) {
            if ("text/html".equalsIgnoreCase(markupContext.getMimeType())) {
                try {
                    markup = new String(markupContext.getMarkupBinary(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new PageletException("cps.pagelet.consumer.unsupportedencoding", e);
                }
            }
        } else if (markupContext.getMarkupString() != null) {
            markup = markupContext.getMarkupString();
        }
        if (markup != null) {
            String WSRP_REWRITE = "wsrp_rewrite";
            StringBuffer out = new StringBuffer(markup.length() + 1024);
            char[] buffer = markup.toCharArray();
            Boyer boyer = new Boyer(buffer, buffer.length);
            int index = 0;
            int curpos = 0;
            while ((index = boyer.indexOf("wsrp_rewrite", index)) >= 0) {
                int pos = index + "wsrp_rewrite".length();
                out.append(buffer, curpos, pos - curpos);
                if (buffer[pos] == '_') {
                    out.append("_").append(namespacePrefix);
                    index = pos + 1;
                } else if (buffer[pos] == '?') {
                    int endpos = boyer.indexOf("wsrp_rewrite", pos);
                    if (endpos <= 0 || buffer[endpos - 1] != '/') {
                        throw new PageletException("cps.pagelet.consumer.rewrite.error");
                    }
                    String content = new String(buffer, pos + 1, endpos - pos - 2);
                    if (content.indexOf("&amp;") >= 0) {
                        StringBuffer tmpBuffer = new StringBuffer(content.length());
                        EncodingUtils.xmldecode((String)content, (StringBuffer)tmpBuffer);
                        content = tmpBuffer.toString();
                    }
                    if (content.length() > 0) {
                        out.append("?").append(content).append("&");
                    }
                    out.append("cps-portlet").append("=").append(portletRefs.portletInstance.getId());
                    if (content.indexOf("wsrp-urlType=resource") >= 0) {
                        out.append("&").append("cps-producerId").append("=").append(portletRefs.producer.getId());
                        if (content.indexOf("wsrp-requiresRewrite=true") >= 0 || content.indexOf("wsrp-requiresRewrite=1") >= 0) {
                            out.append("&").append("cps-namespacePrefix").append("=").append(namespacePrefix);
                        }
                    }
                    out.append("/").append("wsrp_rewrite");
                    index = endpos + "wsrp_rewrite".length();
                } else {
                    index = pos;
                }
                curpos = index;
            }
            out.append(buffer, curpos, buffer.length - curpos);
            out.append("<!-- instanceID=").append(portletRefs.portletInstance.getId()).append(" cacheInfo=").append(portletRefs.cacheStats.toString()).append(" -->");
            markupContext.setMarkupBinary(null);
            markupContext.setMarkupString(out.toString());
        }
        return markupContext;
    }

    public int getCacheMaxSizePerPortlet() {
        return this.cacheMaxSizePerPortlet;
    }

    public IContext getContext() {
        return this.context;
    }

    public GetMarkup getGetMarkup() {
        return this.getMarkup;
    }

    public InteractionParamsHelper getInteraction() {
        return this.interaction;
    }

    public ServiceLogger getLogger() {
        return this.logger;
    }

    public Map getPortletInstances() {
        return this.portletInstances;
    }

    public GetMarkupResponse getGetMarkupResponse() {
        return this.getMarkupResponse;
    }

    public boolean isAllowPortletStateChange() {
        return this.allowPortletStateChange;
    }

    public Cache getUserCache() {
        return this.userCache;
    }

    public String getPageletId() {
        return this.getMarkup.getPagelet().getId();
    }

    private void initUserCache() {
        if (this.cacheManager != null) {
            Object timer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                timer = this.logger.startTimer(4, "RequestExecutor", "initUserCache", (Object)this.context);
            }
            Object region = this.context.getProperty("PASSPORT");
            if (this.getMarkup.getPagelet().getId() != null && region != null) {
                this.userCache = this.cacheManager.getCache(region.toString());
                if (this.userCache == null) {
                    this.userCache = this.cacheManager.createCache(region.toString());
                }
            }
            if (timer != null) {
                this.logger.stopTimer(timer);
            }
        }
    }

    static {
        THREAD_POOL_USE_COUNT = 0;
    }
}

