/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl.requests;

import com.cognos.cps.cache.Cache;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.pagelet.consumer.impl.PortletRefs;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.pagelet.consumer.impl.requests.MarkupRequest;
import com.cognos.cps.pagelet.consumer.impl.requests.WSRPRequest;
import com.cognos.cps.pagelet.consumer.intf.URLTemplateComposer;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.MarkupCacheEntry;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.types.CacheControl;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.GetMarkup;
import com.cognos.cps.services.wsrp.v1.types.InvalidCookieFault;
import com.cognos.cps.services.wsrp.v1.types.MarkupContext;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import java.util.Date;

public class GetMarkupRequest
extends MarkupRequest {
    private GetMarkup getMarkup;
    private String pageletId;
    private Cache userCache;
    private ServiceLogger logger;
    private Object key = null;
    static int guid;

    public GetMarkupRequest(WSRPRequest parent, RequestExecutor executor, PortletRefs portletRefs, URLTemplateComposer templateComposer, ServiceLogger logger) {
        super(parent, executor, portletRefs, templateComposer);
        this.logger = logger.cloneForClass(GetMarkupRequest.class);
        this.getMarkup = TypeFactory.newInstance().createGetMarkup();
        this.pageletId = executor.getPageletId();
        this.userCache = executor.getUserCache();
    }

    @Override
    public void execute() {
        if (this.getParent() != null && this.getParent().getFault() != null) {
            this.portletRefs.fault = this.getParent().getFault() instanceof OperationFailedFault ? (OperationFailedFault)this.getParent().getFault() : new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, this.getParent().getFault());
        } else if (this.portletRefs.fault == null && this.getMarkupResponse.getRedirectURL() == null) {
            if (this.portletRefs.markupResponse != null) {
                if (this.portletRefs.markupResponse.getMarkupContext() != null && this.portletRefs.markupResponse.getMarkupContext().getCacheControl() != null) {
                    MarkupCacheEntry cacheEntry = this.findCacheEntry(this.portletRefs.cacheStats.calculatedChecksum);
                    this.checkForCacheControl(cacheEntry, this.portletRefs.cacheStats.calculatedChecksum);
                }
            } else {
                try {
                    Cookies cookies = this.retrieveCookies(this.portletRefs);
                    WSRP_v1_Markup_PortType markupPort = this.createMarkupPortType(TypeFactory.newInstance(), this.addTransientCookies(cookies));
                    HttpSOAPConnection httpSOAPConnection = (HttpSOAPConnection)((IContext)markupPort).getProperty("SOAPConnection");
                    MarkupParams markupParams = this.getMarkupParams(this.portletRefs);
                    if (markupParams == null) {
                        this.portletRefs.markupResponse = TypeFactory.newInstance().createMarkupResponse();
                        this.portletRefs.markupResponse.setMarkupContext(GetMarkupRequest.createEmptyMarkupContext(this.portletRefs));
                        return;
                    }
                    if (this.portalContext != null) {
                        Extension portalContextExtension = ExtensionHelper.createPortalContextExtension((PortalContext)this.portalContext);
                        markupParams.addExtensions(portalContextExtension);
                    }
                    this.getMarkup.setMarkupParams(markupParams);
                    if (this.portletRefs.producer.getRegistration() != null && this.portletRefs.producer.getRegistration().getRegistrationContext() != null) {
                        this.getMarkup.setRegistrationContext(this.portletRefs.producer.getRegistration().getRegistrationContext());
                    } else {
                        this.getMarkup.setRegistrationContext(TypeFactory.newInstance().createRegistrationContext());
                    }
                    if (this.portletRefs.blockingResponse != null && this.portletRefs.blockingResponse.getUpdateResponse() != null && this.portletRefs.blockingResponse.getUpdateResponse().getPortletContext() != null) {
                        this.getMarkup.setPortletContext(this.portletRefs.blockingResponse.getUpdateResponse().getPortletContext());
                    } else if (this.portletRefs.portletInstance.getPortletContext() != null) {
                        this.getMarkup.setPortletContext(this.portletRefs.portletInstance.getPortletContext());
                    } else if (this.portletRefs.portlet.getPortletContext() != null) {
                        this.getMarkup.setPortletContext(this.portletRefs.portlet.getPortletContext());
                    } else {
                        PortletContext portletContext = TypeFactory.newInstance().createPortletContext();
                        portletContext.setPortletHandle(this.portletRefs.portlet.getHandle());
                        this.getMarkup.setPortletContext(portletContext);
                    }
                    this.getMarkup.setRuntimeContext(this.getRuntimeContext(this.portletRefs));
                    this.getMarkup.setUserContext(this.getUserContext());
                    this.portletRefs.cacheStats.calculatedChecksum = GetMarkupRequest.calculateChecksum(this.getMarkup.getMarkupParams(), this.getMarkup.getRegistrationContext(), this.getMarkup.getPortletContext());
                    MarkupCacheEntry cacheEntry = this.findCacheEntry(this.portletRefs.cacheStats.calculatedChecksum);
                    if (cacheEntry != null) {
                        long expireTime = cacheEntry.getTimestamp().getTime() + (long)(cacheEntry.getExpires() * 1000);
                        if (cacheEntry.getExpires() < 0 || expireTime > System.currentTimeMillis()) {
                            this.portletRefs.markupResponse = TypeFactory.newInstance().createMarkupResponse();
                            this.portletRefs.markupResponse.setMarkupContext(cacheEntry.getMarkupContext());
                            this.portletRefs.cacheStats.cacheID = cacheEntry.getId();
                            this.portletRefs.cacheStats.copyFromCache = true;
                            this.portletRefs.cacheStats.notExpired = true;
                            return;
                        }
                        this.getMarkup.getMarkupParams().setValidateTag(cacheEntry.getValidateTag());
                        this.portletRefs.cacheStats.sendingValTag = true;
                    }
                    try {
                        this.portletRefs.markupResponse = markupPort.getMarkup(this.getMarkup);
                        GetMarkupRequest.checkForNewCookies(cookies, httpSOAPConnection);
                        this.checkForCacheControl(cacheEntry, this.portletRefs.cacheStats.calculatedChecksum);
                    }
                    catch (InvalidCookieFault e) {
                        Cookie[] newCookies;
                        if (cookies != null) {
                            cookies.clearCookie();
                        }
                        if ((newCookies = this.retrieveNewCookies(this.portletRefs, markupPort, httpSOAPConnection)) != null) {
                            cookies.setCookie(newCookies);
                        }
                        httpSOAPConnection.setRequestCookies(this.addTransientCookies(cookies));
                        this.portletRefs.markupResponse = markupPort.getMarkup(this.getMarkup);
                        GetMarkupRequest.checkForNewCookies(cookies, httpSOAPConnection);
                        this.checkForCacheControl(cacheEntry, this.portletRefs.cacheStats.calculatedChecksum);
                    }
                }
                catch (OperationFailedFault e) {
                    this.portletRefs.fault = e;
                }
                catch (ServiceException e) {
                    this.portletRefs.fault = new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, (Throwable)e);
                }
                catch (Throwable e) {
                    this.portletRefs.fault = new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, e);
                }
            }
        }
    }

    private MarkupCacheEntry findCacheEntry(String checksum) {
        if (this.userCache != null) {
            Object timer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                timer = this.logger.startTimer(4, "GetMarkupRequest", "findCacheEntry", (Object)this.executor.getContext());
            }
            MarkupCacheEntry cacheEntry = null;
            this.key = this.pageletId + this.portletRefs.portletInstance.getId() + "#" + checksum;
            Object obj = this.userCache.get(this.key);
            if (obj instanceof MarkupCacheEntry) {
                cacheEntry = (MarkupCacheEntry)obj;
            }
            if (timer != null) {
                this.logger.stopTimer(timer);
            }
            return cacheEntry;
        }
        return null;
    }

    private void updateCacheEntry(Object value) {
        if (this.userCache != null && value != null && this.key != null) {
            Object timer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                timer = this.logger.startTimer(4, "GetMarkupRequest", "updateCacheEntry", (Object)this.executor.getContext());
            }
            this.userCache.put(this.key, value);
            if (timer != null) {
                this.logger.stopTimer(timer);
            }
        }
    }

    private void removeCacheEntry() {
        if (this.userCache != null && this.key != null) {
            Object timer = null;
            if (this.logger.isPerfLevelEnabled(4)) {
                timer = this.logger.startTimer(4, "GetMarkupRequest", "removeCacheEntry", (Object)this.executor.getContext());
            }
            this.userCache.remove(this.key);
            if (timer != null) {
                this.logger.stopTimer(timer);
            }
        }
    }

    private boolean isMaxSizeReached() {
        if (this.userCache != null && this.key != null) {
            return this.userCache.isMaxSizeReached(this.key);
        }
        return false;
    }

    private void checkForCacheControl(MarkupCacheEntry cacheEntry, String checksum) {
        if (this.userCache != null && this.portletRefs.markupResponse != null && this.portletRefs.markupResponse.getMarkupContext() != null) {
            MarkupContext markupContext = this.portletRefs.markupResponse.getMarkupContext();
            CacheControl newCacheControl = markupContext.getCacheControl();
            if (cacheEntry != null) {
                if (newCacheControl != null) {
                    if (markupContext.getUseCachedMarkup()) {
                        this.portletRefs.markupResponse.setMarkupContext(cacheEntry.getMarkupContext());
                        this.portletRefs.cacheStats.copyFromCache = true;
                    } else {
                        cacheEntry.setMarkupContext(markupContext);
                        this.portletRefs.cacheStats.copyToCache = true;
                    }
                    this.portletRefs.cacheStats.cacheID = cacheEntry.getId();
                    cacheEntry.setTimestamp(new Date(System.currentTimeMillis()));
                    cacheEntry.setExpires(newCacheControl.getExpires());
                    cacheEntry.setValidateTag(newCacheControl.getValidateTag());
                    cacheEntry.getMarkupContext().setCacheControl(newCacheControl);
                } else if (markupContext.getUseCachedMarkup()) {
                    this.portletRefs.markupResponse.setMarkupContext(cacheEntry.getMarkupContext());
                    this.portletRefs.cacheStats.cacheID = cacheEntry.getId();
                    this.portletRefs.cacheStats.copyFromCache = true;
                    cacheEntry.setTimestamp(new Date(System.currentTimeMillis()));
                } else {
                    this.removeCacheEntry();
                    cacheEntry = null;
                }
                this.updateCacheEntry(cacheEntry);
            } else if (newCacheControl != null) {
                if (markupContext.getUseCachedMarkup() && markupContext.getMarkupString() == null && markupContext.getMarkupBinary() == null) {
                    return;
                }
                cacheEntry = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createMarkupCacheEntry();
                cacheEntry.setId(this.getNextGUID());
                cacheEntry.setInstanceId(this.portletRefs.portletInstance.getId());
                cacheEntry.setChecksum(checksum);
                cacheEntry.setTimestamp(new Date(System.currentTimeMillis()));
                cacheEntry.setExpires(newCacheControl.getExpires());
                cacheEntry.setScope(null);
                cacheEntry.setValidateTag(newCacheControl.getValidateTag());
                cacheEntry.setMarkupContext(markupContext);
                this.updateCacheEntry(cacheEntry);
                this.portletRefs.cacheStats.reachedMaxCount = this.isMaxSizeReached();
                this.portletRefs.cacheStats.addedToCache = true;
                this.portletRefs.cacheStats.copyToCache = true;
                this.portletRefs.cacheStats.cacheID = cacheEntry.getId();
            }
        }
    }

    private synchronized String getNextGUID() {
        return "G" + Integer.toString(++guid);
    }

    private static MarkupContext createEmptyMarkupContext(PortletRefs portletRefs) {
        MarkupContext markupContext = TypeFactory.newInstance().createMarkupContext();
        markupContext.setMarkupString("");
        markupContext.setMimeType("text/html");
        markupContext.setPreferredTitle(portletRefs.portletRuntime != null ? portletRefs.portletRuntime.getTitle() : null);
        markupContext.setRequiresUrlRewriting(false);
        markupContext.setUseCachedMarkup(false);
        return markupContext;
    }

    @Override
    protected String getSoapAddress() {
        String address = this.getPortletSoapAddress(this.portletRefs.portlet.getHandle());
        if (address != null) {
            return address;
        }
        return super.getSoapAddress();
    }
}

