/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl.requests;

import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.pagelet.consumer.impl.requests.WSRPRequest;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.types.InitCookie;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;

public class InitCookieRequest
extends WSRPRequest {
    private InitCookie initCookie = TypeFactory.newInstance().createInitCookie();
    private PortletProducer producer;
    private Cookies cookies;

    public InitCookieRequest(RequestExecutor executor, PortletProducer producer, Cookies cookies) {
        super(null, executor);
        this.producer = producer;
        this.cookies = cookies;
        if (producer.getRegistration() != null) {
            this.initCookie.setRegistrationContext(producer.getRegistration().getRegistrationContext());
        }
    }

    @Override
    public PortletProducer getProducer() {
        return this.producer;
    }

    @Override
    public void execute() {
        try {
            WSRP_v1_Markup_PortType markupPort = this.createMarkupPortType(TypeFactory.newInstance(), null);
            markupPort.initCookie(this.initCookie);
            HttpSOAPConnection httpSOAPConnection = (HttpSOAPConnection)((IContext)markupPort).getProperty("SOAPConnection");
            if (httpSOAPConnection != null) {
                InitCookieRequest.checkForNewCookies(this.cookies, httpSOAPConnection);
            }
        }
        catch (ServiceException e) {
            this.fault = e;
        }
        catch (Throwable e) {
            this.fault = e;
        }
    }

    public String getCookieGroup() {
        if (this.cookies != null) {
            return this.cookies.getGroupID();
        }
        return null;
    }
}

