/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl.requests;

import com.cognos.cps.common.utils.GetVersion;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.pagelet.consumer.impl.InteractionParamsHelper;
import com.cognos.cps.pagelet.consumer.impl.PortletRefs;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.pagelet.consumer.impl.requests.WSRPRequest;
import com.cognos.cps.pagelet.consumer.intf.URLTemplateComposer;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkup;
import com.cognos.cps.services.pagelet.consumer.v1.types.GetMarkupResponse;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletParams;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.pagelet.objects.v1.types.ProducerRuntime;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.types.AccessDeniedFault;
import com.cognos.cps.services.wsrp.v1.types.ClientData;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.InitCookie;
import com.cognos.cps.services.wsrp.v1.types.InvalidRegistrationFault;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.MarkupType;
import com.cognos.cps.services.wsrp.v1.types.PersonName;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.RegistrationContext;
import com.cognos.cps.services.wsrp.v1.types.RuntimeContext;
import com.cognos.cps.services.wsrp.v1.types.Templates;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UserContext;
import com.cognos.cps.services.wsrp.v1.types.UserProfile;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import java.util.Enumeration;

public abstract class MarkupRequest
extends WSRPRequest {
    protected PortletRefs portletRefs;
    protected URLTemplateComposer templateComposer;
    protected PortalContext portalContext;
    protected boolean isPreviewMode;
    protected GetMarkupResponse getMarkupResponse;
    protected String userAuthentication = "wsrp:password";
    private static final String[] CONSUMER_MODES = new String[]{"wsrp:view", "wsrp:preview", "wsrp:edit", "wsrp:help"};
    private static final String[] CONSUMER_WINDOW_STATES = new String[]{"wsrp:normal", "wsrp:maximized", "wsrp:minimized"};
    private static final Extension VERSIONS_EXTENSION = ExtensionHelper.createVersionExtension((String)GetVersion.getVersion((String[])new String[]{"com.cognos.cps.pagelet.consumer.impl", "javax.xml.parsers", "javax.xml.transform", "org.exolab.castor", "org.xml.sax", "java.lang"}, (boolean)false));

    public MarkupRequest(WSRPRequest parent, RequestExecutor executor, PortletRefs portletRefs, URLTemplateComposer templateComposer) {
        super(parent, executor);
        this.portletRefs = portletRefs;
        this.templateComposer = templateComposer;
        this.executor = executor;
        GetMarkup getMarkup = executor.getGetMarkup();
        this.portalContext = getMarkup.getPortalContext();
        this.isPreviewMode = getMarkup.getPageletParams() != null && "cps:preview".equals(getMarkup.getPageletParams().getPageletMode());
        this.getMarkupResponse = executor.getGetMarkupResponse();
    }

    @Override
    public PortletProducer getProducer() {
        return this.portletRefs.producer;
    }

    protected Cookie[] retrieveNewCookies(PortletRefs portletRefs, WSRP_v1_Markup_PortType markupPort, HttpSOAPConnection httpSOAPConnection) throws Exception, InvalidRegistrationFault, OperationFailedFault, AccessDeniedFault {
        InitCookie initCookie = TypeFactory.newInstance().createInitCookie();
        if (portletRefs.producer.getRegistration() != null) {
            initCookie.setRegistrationContext(portletRefs.producer.getRegistration().getRegistrationContext());
        }
        httpSOAPConnection.setRequestCookies(this.addTransientCookies(null));
        markupPort.initCookie(initCookie);
        return httpSOAPConnection.getResponseCookies();
    }

    protected Cookies retrieveCookies(PortletRefs portletRefs) {
        String groupID = portletRefs.getCookieGroupID();
        if (this.getMarkupResponse.getUpdateState() != null && this.getMarkupResponse.getUpdateState().getPackageState() != null) {
            ProducerRuntime[] runtimes = this.getMarkupResponse.getUpdateState().getPackageState().getProducerRuntime();
            for (int r = 0; runtimes != null && r < runtimes.length; ++r) {
                if (!runtimes[r].getId().equals(portletRefs.producer.getId())) continue;
                Cookies[] cookies = runtimes[r].getCookies();
                for (int c = 0; c < cookies.length; ++c) {
                    if (!(cookies[c].getGroupID() != null && cookies[c].getGroupID().length() > 0 ? groupID != null && cookies[c].getGroupID().equals(groupID) : groupID == null)) continue;
                    return cookies[c];
                }
            }
        }
        if (portletRefs.producerRuntime != null) {
            Cookies[] cookies = portletRefs.producerRuntime.getCookies();
            for (int c = 0; c < cookies.length; ++c) {
                if (!(cookies[c].getGroupID() != null && cookies[c].getGroupID().length() > 0 ? groupID != null && cookies[c].getGroupID().equals(groupID) : groupID == null)) continue;
                return cookies[c];
            }
        }
        return null;
    }

    protected Cookie[] addTransientCookies(Cookies cookies) {
        Cookie[] producerCookies;
        Cookie[] transientCookies = (Cookie[])this.executor.getContext().getProperty("COOKIES");
        Cookie[] cookieArray = producerCookies = cookies != null ? cookies.getCookie() : null;
        if (transientCookies == null) {
            return producerCookies;
        }
        if (producerCookies == null) {
            return transientCookies;
        }
        int count = transientCookies.length;
        Cookie[] mergedCookies = new Cookie[count + producerCookies.length];
        System.arraycopy(transientCookies, 0, mergedCookies, 0, count);
        for (int i = 0; i < producerCookies.length; ++i) {
            boolean found = false;
            for (int j = 0; j < transientCookies.length; ++j) {
                if (!mergedCookies[j].getName().equals(producerCookies[i].getName())) continue;
                mergedCookies[j].setContent(producerCookies[i].getContent());
                found = true;
                break;
            }
            if (found) continue;
            mergedCookies[count++] = producerCookies[i];
        }
        return mergedCookies;
    }

    protected RuntimeContext getRuntimeContext(PortletRefs portletRefs) {
        RuntimeContext runtimeContext = TypeFactory.newInstance().createRuntimeContext();
        runtimeContext.setUserAuthentication(this.userAuthentication);
        runtimeContext.setPortletInstanceKey(portletRefs.portletInstance.getId());
        if (this.templateComposer != null) {
            runtimeContext.setNamespacePrefix(this.templateComposer.getNamespacePrefix());
            if (portletRefs.portletDescription.getDoesUrlTemplateProcessing()) {
                Templates templates = TypeFactory.newInstance().createTemplates();
                templates.setBlockingActionTemplate(this.templateComposer.createBlockingActionTemplate(true, true, true, true));
                templates.setRenderTemplate(this.templateComposer.createRenderTemplate(true, true, true, true));
                templates.setDefaultTemplate(this.templateComposer.createDefaultTemplate(true, true, true, true));
                templates.setResourceTemplate(this.templateComposer.createResourceTemplate(true, true, true, true));
                templates.setSecureBlockingActionTemplate(this.templateComposer.createSecureBlockingActionTemplate(true, true, true, true));
                templates.setSecureRenderTemplate(this.templateComposer.createSecureRenderTemplate(true, true, true, true));
                templates.setSecureDefaultTemplate(this.templateComposer.createSecureDefaultTemplate(true, true, true, true));
                templates.setSecureResourceTemplate(this.templateComposer.createSecureResourceTemplate(true, true, true, true));
                runtimeContext.setTemplates(templates);
            }
        }
        InteractionParamsHelper interaction = this.executor.getInteraction();
        if (portletRefs.blockingResponse != null && portletRefs.blockingResponse.getUpdateResponse() != null && portletRefs.blockingResponse.getUpdateResponse().getSessionContext() != null) {
            runtimeContext.setSessionID(portletRefs.blockingResponse.getUpdateResponse().getSessionContext().getSessionID());
        } else if (interaction != null && interaction.wsrpPortletInstanceKey != null && interaction.wsrpPortletInstanceKey.equals(portletRefs.portletInstance.getId()) && interaction.wsrpSessionID != null) {
            runtimeContext.setSessionID(interaction.wsrpSessionID);
        } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getSessionContext() != null && portletRefs.portletRuntime.getSessionContext().getSessionID() != null) {
            runtimeContext.setSessionID(portletRefs.portletRuntime.getSessionContext().getSessionID());
        }
        return runtimeContext;
    }

    protected UserContext getUserContext() {
        com.cognos.cps.services.pagelet.objects.v1.types.UserContext userContext = this.executor.getGetMarkup().getUserContext();
        UserContext newUserContext = TypeFactory.newInstance().createUserContext();
        newUserContext.setUserContextKey(userContext.getUserContextKey());
        if (newUserContext.getProfile() != null) {
            newUserContext.setProfile(userContext.getProfile());
        } else {
            UserProfile userProfile = TypeFactory.newInstance().createUserProfile();
            PersonName name = TypeFactory.newInstance().createPersonName();
            name.setNickname(userContext.getUserName());
            name.setFamily(userContext.getUserName());
            userProfile.setName(name);
            newUserContext.setProfile(userProfile);
        }
        return newUserContext;
    }

    protected MarkupParams getMarkupParams(PortletRefs portletRefs) {
        int j;
        int i;
        PageletParams pageletParams;
        String[] modes;
        String[] windowStates;
        InteractionParamsHelper interaction;
        boolean isWsrpInstance;
        MarkupParams markupParams = TypeFactory.newInstance().createMarkupParams();
        markupParams.setSecureClientCommunication(false);
        PortletRuntime portletRuntime = portletRefs.portletRuntime;
        MarkupType foundTextHtml = null;
        Enumeration markupTypes = portletRefs.portletDescription.enumerateMarkupTypes();
        while (markupTypes.hasMoreElements()) {
            MarkupType markupType = (MarkupType)markupTypes.nextElement();
            if (!markupType.getMimeType().equalsIgnoreCase("text/html")) continue;
            foundTextHtml = markupType;
            break;
        }
        boolean bl = isWsrpInstance = (interaction = this.executor.getInteraction()) != null && interaction.wsrpPortletInstanceKey != null && interaction.wsrpPortletInstanceKey.equals(portletRefs.portletInstance.getId());
        String windowState = portletRefs.blockingResponse != null && portletRefs.blockingResponse.getUpdateResponse() != null && portletRefs.blockingResponse.getUpdateResponse().getNewWindowState() != null ? portletRefs.blockingResponse.getUpdateResponse().getNewWindowState() : (isWsrpInstance && interaction.wsrpWindowState != null && interaction.wsrpWindowState.length() != 0 ? interaction.wsrpWindowState : (portletRuntime != null && portletRuntime.getWindowState() != null && portletRuntime.getWindowState().length() != 0 ? portletRuntime.getWindowState() : "wsrp:normal"));
        String[] stringArray = windowStates = foundTextHtml != null ? foundTextHtml.getWindowStates() : null;
        if (windowStates != null) {
            for (int i2 = 0; i2 < windowStates.length; ++i2) {
                if (!windowStates[i2].toString().equalsIgnoreCase(windowState)) continue;
                markupParams.setWindowState(windowState);
                break;
            }
            if (markupParams.getWindowState() == null) {
                if (windowState.equals("wsrp:minimized")) {
                    return null;
                }
                markupParams.setWindowState("wsrp:normal");
            }
        } else {
            markupParams.setWindowState(windowState);
        }
        String mode = portletRefs.blockingResponse != null && portletRefs.blockingResponse.getUpdateResponse() != null && portletRefs.blockingResponse.getUpdateResponse().getNewMode() != null ? portletRefs.blockingResponse.getUpdateResponse().getNewMode() : (isWsrpInstance && interaction.wsrpMode != null && interaction.wsrpMode.length() != 0 ? interaction.wsrpMode : (portletRuntime != null && portletRuntime.getMode() != null && portletRuntime.getMode().length() != 0 ? portletRuntime.getMode() : "wsrp:view"));
        if (this.isPreviewMode) {
            mode = "wsrp:help".equals(mode) ? mode : "wsrp:preview";
        }
        String[] stringArray2 = modes = foundTextHtml != null ? foundTextHtml.getModes() : null;
        if (modes != null) {
            for (int i3 = 0; i3 < modes.length; ++i3) {
                if (!modes[i3].toString().equalsIgnoreCase(mode)) continue;
                markupParams.setMode(mode);
                break;
            }
            if (markupParams.getMode() == null) {
                markupParams.setMode("wsrp:view");
            }
        } else {
            markupParams.setMode(mode);
        }
        if ((pageletParams = this.executor.getGetMarkup().getPageletParams()) != null && pageletParams.getLocales() != null && pageletParams.getLocalesCount() > 0) {
            markupParams.setLocales(pageletParams.getLocales());
        } else {
            markupParams.setLocales(new String[]{"en"});
        }
        if (pageletParams != null && pageletParams.getMimeTypes() != null && pageletParams.getMimeTypesCount() > 0) {
            markupParams.setMimeTypes(pageletParams.getMimeTypes());
        } else {
            markupParams.setMimeTypes(new String[]{"text/html"});
        }
        ClientData clientData = TypeFactory.newInstance().createClientData();
        clientData.setUserAgent(pageletParams != null ? pageletParams.getUserAgent() : "");
        markupParams.setClientData(clientData);
        String navigationalState = isWsrpInstance && interaction.resetPortletContext ? null : (portletRefs.blockingResponse != null && portletRefs.blockingResponse.getUpdateResponse() != null && portletRefs.blockingResponse.getUpdateResponse().getNavigationalState() != null ? portletRefs.blockingResponse.getUpdateResponse().getNavigationalState() : (isWsrpInstance && interaction.wsrpNavigationalState != null ? interaction.wsrpNavigationalState : (portletRuntime != null && portletRuntime.getNavigationalState() != null ? portletRuntime.getNavigationalState() : null)));
        markupParams.setNavigationalState(navigationalState);
        markupParams.setMarkupCharacterSets(new String[]{"UTF-8"});
        if (markupParams.getMode().equals("wsrp:help")) {
            markupParams.addValidNewModes("wsrp:help");
        } else if (this.isPreviewMode) {
            markupParams.addValidNewModes("wsrp:preview");
            markupParams.addValidNewModes("wsrp:help");
        } else if (modes != null) {
            block3: for (i = 0; i < CONSUMER_MODES.length; ++i) {
                for (j = 0; j < modes.length; ++j) {
                    if (!CONSUMER_MODES[i].equalsIgnoreCase(modes[j])) continue;
                    markupParams.addValidNewModes(CONSUMER_MODES[i]);
                    continue block3;
                }
            }
        } else {
            markupParams.setValidNewModes(CONSUMER_MODES);
        }
        if (windowStates != null) {
            block5: for (i = 0; i < CONSUMER_WINDOW_STATES.length; ++i) {
                for (j = 0; j < windowStates.length; ++j) {
                    if (!CONSUMER_WINDOW_STATES[i].equalsIgnoreCase(windowStates[j])) continue;
                    markupParams.addValidNewWindowStates(CONSUMER_WINDOW_STATES[i]);
                    continue block5;
                }
            }
        } else {
            markupParams.setValidNewWindowStates(CONSUMER_WINDOW_STATES);
        }
        if (markupParams.getMode().equals("cps:config")) {
            markupParams.addExtensions(VERSIONS_EXTENSION);
        }
        if (portletRefs.extensions != null) {
            markupParams.setExtensions(portletRefs.extensions);
        }
        return markupParams;
    }

    protected static String calculateChecksum(MarkupParams markupParams, RegistrationContext registrationContext, PortletContext portletContext) {
        int checksumValue = markupParams != null ? markupParams.hashCode() : 0;
        checksumValue += registrationContext != null ? registrationContext.hashCode() : 0;
        return Integer.toString(checksumValue += portletContext != null ? portletContext.hashCode() : 0);
    }
}

