/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl.requests;

import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.pagelet.consumer.impl.InteractionParamsHelper;
import com.cognos.cps.pagelet.consumer.impl.PortletRefs;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.pagelet.consumer.impl.requests.MarkupRequest;
import com.cognos.cps.pagelet.consumer.impl.requests.WSRPRequest;
import com.cognos.cps.pagelet.consumer.intf.URLTemplateComposer;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.InteractionParams;
import com.cognos.cps.services.wsrp.v1.types.InvalidCookieFault;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.NamedString;
import com.cognos.cps.services.wsrp.v1.types.PerformBlockingInteraction;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.StateChange;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;

public class PerformBlockingInteractionRequest
extends MarkupRequest {
    private PerformBlockingInteraction performBlockingInteraction = TypeFactory.newInstance().createPerformBlockingInteraction();

    public PerformBlockingInteractionRequest(WSRPRequest parent, RequestExecutor executor, PortletRefs portletRefs, URLTemplateComposer templateComposer) {
        super(parent, executor, portletRefs, templateComposer);
    }

    @Override
    public void execute() {
        if (this.getParent() != null && this.getParent().getFault() != null) {
            this.fault = this.getParent().getFault();
        } else {
            try {
                Cookies cookies = this.retrieveCookies(this.portletRefs);
                WSRP_v1_Markup_PortType markupPort = this.createMarkupPortType(TypeFactory.newInstance(), this.addTransientCookies(cookies));
                HttpSOAPConnection httpSOAPConnection = (HttpSOAPConnection)((IContext)markupPort).getProperty("SOAPConnection");
                try {
                    if (this.portletRefs.producer.getRegistration() != null && this.portletRefs.producer.getRegistration().getRegistrationContext() != null) {
                        this.performBlockingInteraction.setRegistrationContext(this.portletRefs.producer.getRegistration().getRegistrationContext());
                    } else {
                        this.performBlockingInteraction.setRegistrationContext(TypeFactory.newInstance().createRegistrationContext());
                    }
                    if (this.portletRefs.portletInstance.getPortletContext() != null) {
                        this.performBlockingInteraction.setPortletContext(this.portletRefs.portletInstance.getPortletContext());
                    } else if (this.portletRefs.portlet.getPortletContext() != null) {
                        this.performBlockingInteraction.setPortletContext(this.portletRefs.portlet.getPortletContext());
                    } else {
                        PortletContext portletContext = TypeFactory.newInstance().createPortletContext();
                        portletContext.setPortletHandle(this.portletRefs.portlet.getHandle());
                        this.performBlockingInteraction.setPortletContext(portletContext);
                    }
                    this.performBlockingInteraction.setRuntimeContext(this.getRuntimeContext(this.portletRefs));
                    this.performBlockingInteraction.setUserContext(this.getUserContext());
                    MarkupParams markupParams = this.getMarkupParams(this.portletRefs);
                    if (markupParams != null && this.portalContext != null) {
                        Extension portalContextExtension = ExtensionHelper.createPortalContextExtension((PortalContext)this.portalContext);
                        markupParams.addExtensions(portalContextExtension);
                    }
                    this.performBlockingInteraction.setMarkupParams(markupParams);
                    this.performBlockingInteraction.setInteractionParams(this.getInteractionParams(this.portletRefs));
                    this.portletRefs.cacheStats.calculatedChecksum = PerformBlockingInteractionRequest.calculateChecksum(this.performBlockingInteraction.getMarkupParams(), this.performBlockingInteraction.getRegistrationContext(), this.performBlockingInteraction.getPortletContext());
                    this.portletRefs.blockingResponse = markupPort.performBlockingInteraction(this.performBlockingInteraction);
                    PerformBlockingInteractionRequest.checkForNewCookies(cookies, httpSOAPConnection);
                }
                catch (InvalidCookieFault e) {
                    Cookie[] newCookies;
                    if (cookies != null) {
                        cookies.clearCookie();
                    }
                    if ((newCookies = this.retrieveNewCookies(this.portletRefs, markupPort, httpSOAPConnection)) != null) {
                        cookies.setCookie(newCookies);
                    }
                    httpSOAPConnection.setRequestCookies(this.addTransientCookies(cookies));
                    this.portletRefs.blockingResponse = markupPort.performBlockingInteraction(this.performBlockingInteraction);
                    PerformBlockingInteractionRequest.checkForNewCookies(cookies, httpSOAPConnection);
                }
                if (this.portletRefs.blockingResponse != null) {
                    if (this.portletRefs.blockingResponse.getRedirectURL() != null && this.portletRefs.blockingResponse.getRedirectURL().length() > 0) {
                        if (this.getMarkupResponse != null) {
                            this.getMarkupResponse.setRedirectURL(this.portletRefs.blockingResponse.getRedirectURL());
                        }
                    } else {
                        UpdateResponse updateResponse = this.portletRefs.blockingResponse.getUpdateResponse();
                        if (updateResponse != null && updateResponse.getMarkupContext() != null) {
                            this.portletRefs.markupResponse = TypeFactory.newInstance().createMarkupResponse();
                            this.portletRefs.markupResponse.setMarkupContext(updateResponse.getMarkupContext());
                            this.portletRefs.markupResponse.setSessionContext(updateResponse.getSessionContext());
                        }
                    }
                }
            }
            catch (OperationFailedFault e) {
                this.portletRefs.fault = e;
            }
            catch (ServiceException e) {
                this.portletRefs.fault = new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, (Throwable)e);
            }
            catch (Throwable e) {
                this.portletRefs.fault = new OperationFailedFault("cps.pagelet.consumer.operation.failed", null, e);
            }
        }
    }

    protected InteractionParams getInteractionParams(PortletRefs portletRefs) {
        String curMode;
        InteractionParams interactionParams = TypeFactory.newInstance().createInteractionParams();
        PortletRuntime portletRuntime = portletRefs.portletRuntime;
        String string = curMode = portletRuntime != null && portletRuntime.getMode() != null ? portletRuntime.getMode() : "";
        if ((this.executor.isAllowPortletStateChange() || curMode.equals("wsrp:edit") || curMode.equals("cps:config")) && !portletRefs.isAccessRights(AccessRightsType.READONLY)) {
            if (portletRefs.portletInstance.getPortletContext() != null) {
                interactionParams.setPortletStateChange(StateChange.READWRITE);
            } else {
                interactionParams.setPortletStateChange(StateChange.CLONEBEFOREWRITE);
            }
        } else {
            interactionParams.setPortletStateChange(StateChange.READONLY);
        }
        InteractionParamsHelper interaction = this.executor.getInteraction();
        interactionParams.setInteractionState(interaction.wsrpInteractionState);
        NamedString[] params = new NamedString[interaction.otherParameters.size()];
        for (int i = 0; i < params.length; ++i) {
            Param param = (Param)interaction.otherParameters.get(i);
            params[i] = TypeFactory.newInstance().createNamedString();
            params[i].setName(param.getName());
            params[i].setValue(param.getContent());
        }
        interactionParams.setFormParameters(params);
        return interactionParams;
    }

    @Override
    protected String getSoapAddress() {
        String address = this.getPortletSoapAddress(this.portletRefs.portlet.getHandle());
        if (address != null) {
            return address;
        }
        return super.getSoapAddress();
    }
}

