/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.consumer.impl.requests;

import com.cognos.cps.bseries.xts.common.utils.XTSHttpSOAPConnectionImpl;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnection;
import com.cognos.cps.pagelet.common.http.HttpSOAPConnectionFactory;
import com.cognos.cps.pagelet.consumer.impl.RequestExecutor;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.consumer.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookie;
import com.cognos.cps.services.pagelet.objects.v1.types.Cookies;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.wsdl.Port;
import com.cognos.cps.services.wsdl.Service;
import com.cognos.cps.services.wsdl.soap.Address;
import com.cognos.cps.services.wsrp.v1.WSRPService;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import org.exolab.castor.types.AnyNode;

public abstract class WSRPRequest {
    static final String CPS_EXTENSION_NAMESPACE_URI = "http://developer.cognos.com/schemas/cps/wsdl/extensions/1/";
    protected RequestExecutor executor;
    protected Throwable fault;
    private boolean isCompleted;
    private boolean isInitialized;
    private WSRPRequest parent;

    public WSRPRequest(WSRPRequest parent, RequestExecutor executor) {
        this.parent = parent;
        this.executor = executor;
    }

    public abstract PortletProducer getProducer();

    public void initialize() {
        this.isInitialized = true;
    }

    public abstract void execute();

    public synchronized boolean canRun() {
        return !this.isBlocked() && !this.isExecuting() && !this.isCompleted();
    }

    public synchronized boolean isCompleted() {
        return this.isCompleted;
    }

    public Throwable getFault() {
        return this.fault;
    }

    public synchronized void setCompleted() {
        this.isCompleted = true;
    }

    private boolean isExecuting() {
        return this.isInitialized && !this.isCompleted;
    }

    private boolean isBlocked() {
        return this.parent != null && !this.parent.isCompleted();
    }

    protected WSRPRequest getParent() {
        return this.parent;
    }

    protected WSRP_v1_Markup_PortType createMarkupPortType(TypeFactory factory, Cookie[] cookies) throws OperationFailedFault {
        String soapAddress = this.getSoapAddress();
        if (soapAddress == null) {
            throw new OperationFailedFault("cps.pagelet.consumer.operation.failed");
        }
        WSRP_v1_Markup_PortType markupPort = WSRPService.getMarkupPortType((String)soapAddress, (ServiceLogger)this.executor.getLogger());
        if (markupPort instanceof IContext) {
            HttpSOAPConnection httpSOAPConnection = ((HttpSOAPConnectionFactory)this.executor.getContext().getProperty("httpSoapConnectionFactory")).createConnection(factory, soapAddress, this.executor.getContext(), this.executor.getLogger());
            if (cookies == null) {
                cookies = (Cookie[])this.executor.getContext().getProperty("COOKIES");
            }
            httpSOAPConnection.setRequestCookies(cookies);
            ((IContext)markupPort).setProperty("SOAPConnection", (Object)httpSOAPConnection);
            if (httpSOAPConnection instanceof XTSHttpSOAPConnectionImpl) {
                ((IContext)markupPort).setProperty("SOAPHeaders", (Object)new Object[]{this.executor.getContext().getProperty("BUS_HEADER").toString(), this.executor.getContext().getProperty("CPS_SOAP_HEADER").toString()});
            } else {
                ((IContext)markupPort).setProperty("SOAPHeaders", (Object)new Object[]{this.executor.getContext().getProperty("CPS_SOAP_HEADER").toString()});
            }
        }
        return markupPort;
    }

    protected String getSoapAddress() {
        String soapAddress = null;
        Service[] services = this.getProducer().getBinding().getService();
        block0: for (int s = 0; s < services.length; ++s) {
            if (!services[s].getName().equals("WSRPService")) continue;
            Port[] ports = services[s].getPort();
            for (int p = 0; p < ports.length; ++p) {
                if (!ports[p].getName().equals("WSRPBaseService")) continue;
                Object obj = ports[p].getAnyObject(0);
                if (AnyNode.class.isInstance(obj)) {
                    for (AnyNode attr = ((AnyNode)obj).getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
                        if (!attr.getLocalName().equals("location")) continue;
                        soapAddress = attr.getStringValue();
                        break block0;
                    }
                    break block0;
                }
                if (!Address.class.isInstance(obj)) break block0;
                soapAddress = ((Address)obj).getLocation();
                break block0;
            }
            break;
        }
        return soapAddress;
    }

    protected final String getPortletSoapAddress(String handle) {
        if (handle != null) {
            Service[] services = this.getProducer().getBinding().getService();
            block0: for (int s = 0; s < services.length; ++s) {
                if (!services[s].getName().equals("WSRPService")) continue;
                Port[] ports = services[s].getPort();
                for (int p = 0; p < ports.length; ++p) {
                    if (!ports[p].getName().equals("WSRPBaseService")) continue;
                    int extensionsCount = ports[p].getAnyObjectCount();
                    if (extensionsCount <= 0) break block0;
                    for (int i = 0; i < extensionsCount; ++i) {
                        AnyNode anyNode;
                        Object obj = ports[p].getAnyObject(i);
                        if (!AnyNode.class.isInstance(obj) || (anyNode = (AnyNode)obj).getNodeType() != 1 || !CPS_EXTENSION_NAMESPACE_URI.equals(anyNode.getNamespaceURI()) || !"portletAddress".equals(anyNode.getLocalName())) continue;
                        String portletHandle = null;
                        String location = null;
                        for (AnyNode attr = anyNode.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
                            if (attr.getLocalName().equals("handle")) {
                                portletHandle = attr.getStringValue();
                                continue;
                            }
                            if (!attr.getLocalName().equals("location")) continue;
                            location = attr.getStringValue();
                        }
                        if (!handle.equals(portletHandle) || location == null) continue;
                        return location;
                    }
                    break block0;
                }
                break;
            }
        }
        return null;
    }

    protected static void checkForNewCookies(Cookies cookies, HttpSOAPConnection httpSOAPConnection) {
        Cookie[] newCookies = httpSOAPConnection.getResponseCookies();
        if (newCookies != null) {
            for (int i = 0; i < newCookies.length; ++i) {
                boolean found = false;
                for (int j = 0; j < cookies.getCookieCount(); ++j) {
                    Cookie curCookie = cookies.getCookie(j);
                    if (!curCookie.getName().equals(newCookies[i].getName())) continue;
                    curCookie.setContent(newCookies[i].getContent());
                    found = true;
                    break;
                }
                if (found) continue;
                cookies.addCookie(newCookies[i]);
            }
        }
    }
}

