/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.processor.impl;

import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.utils.SmallMap;
import com.cognos.cps.pagelet.processor.impl.Column;
import com.cognos.cps.pagelet.processor.impl.LayoutProperties;
import com.cognos.cps.pagelet.processor.impl.PortletOptions;
import com.cognos.cps.pagelet.processor.impl.PortletRefs;
import com.cognos.cps.pagelet.processor.impl.Row;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Param;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletRuntime;
import com.cognos.cps.services.pagelet.processor.v1.types.Render;
import com.cognos.cps.services.soap.envelope.SOAPFault;
import com.cognos.cps.services.wsrp.v1.types.ItemDescription;
import com.cognos.cps.services.wsrp.v1.types.LocalizedString;
import com.cognos.cps.services.wsrp.v1.types.MarkupType;
import com.cognos.cps.services.wsrp.v1.types.Resource;
import com.cognos.cps.services.wsrp.v1.types.ResourceList;
import com.cognos.cps.services.wsrp.v1.types.ResourceValue;
import com.cognos.cps.services.wsrp.v1.types.ServiceDescription;
import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.utils.EncodingUtils;
import com.ibm.cognos.i18n.util.Bidi;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class LayoutHandler
extends DefaultHandler {
    Render render;
    Map portletInstances = new SmallMap();
    Locale productLocale;
    Locale contentLocale;
    private final TagObject nonBreakingSpace = new TagCData("&#160;");
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_TITLE = "title";
    private static final String TAG_INSTRUCTIONS = "instructions";
    private static final String TAG_VALUE = "value";
    private static final String TAG_PORTLET_OPTIONS = "portletOptions";
    private static final String TAG_LAYOUT_PROPERTIES = "layoutProperties";
    private static final String TAG_PARAM = "param";
    private static final String TAG_ROW = "row";
    private static final String TAG_COLUMN = "column";
    private static final String TAG_PORTLET = "portlet";
    private static final String ATT_ID = "id";
    private LocalizableHeader title;
    private LocalizableHeader instructions;
    private PortletOptions portletOptions;
    LayoutProperties layoutProperties = new LayoutProperties();
    private int context = 0;
    private String lang;
    private String paramName;
    private StringBuilder paramValue = new StringBuilder();
    private ArrayList rows = new ArrayList();
    private Row currentRow;
    private Column currentColumn;
    String webImagesURL;
    String skinImagesURL;
    String portalImagesURL;
    private int portlets = 0;

    public LayoutHandler(Render render, IContext context) {
        this.render = render;
        if (render.getPagelet() != null) {
            PortletInstance[] instances = render.getPagelet().getPortletInstance();
            for (int i = 0; i < instances.length; ++i) {
                this.portletInstances.put(instances[i].getId(), new PortletRefs(instances[i]));
            }
            PortletRefs.resolveReferences(render, this.portletInstances);
        }
        String webContent = LayoutHandler.getParamValue("webContentURL", render.getPortalContext() != null ? render.getPortalContext().getParam() : null, "..");
        String webSkin = LayoutHandler.getParamValue("skin", render.getUserContext() != null && render.getUserContext().getPreferences() != null ? render.getUserContext().getPreferences().getParam() : null, "corporate");
        this.webImagesURL = webContent + "/ps/images";
        this.skinImagesURL = webContent + "/skins/" + webSkin + "/portal/images";
        this.portalImagesURL = webContent + "/ps/portal/images";
        String strProductLocale = null;
        String strContentLocale = null;
        if (context != null) {
            Object value = context.getProperty("PRODUCT_LOCALE");
            strProductLocale = value != null ? value.toString() : null;
            value = context.getProperty("CONTENT_LOCALE");
            String string = strContentLocale = value != null ? value.toString() : null;
        }
        if (strProductLocale == null || strContentLocale == null) {
            String[] localeIDs = render.getPageletParams().getLocales();
            if (localeIDs != null && localeIDs.length > 0) {
                Object[] supportedProductLocales = CCLLocaleUtils.getProductLocales();
                Object[] supportedContentLocales = CCLLocaleUtils.getContentLocales();
                for (int i = 0; i < localeIDs.length; ++i) {
                    if (strProductLocale != null) {
                        strProductLocale = CCLLocaleUtils.getValidProductLocale((String)localeIDs[i], (Object[])supportedProductLocales, null);
                    }
                    if (strContentLocale == null) continue;
                    strContentLocale = CCLLocaleUtils.getValidContentLocale((String)localeIDs[i], (Object[])supportedContentLocales, null);
                }
            }
            if (strProductLocale == null && (strProductLocale = CCLLocaleUtils.getServerLocale()) == null) {
                strProductLocale = "en";
            }
            if (strContentLocale == null && (strContentLocale = CCLLocaleUtils.getServerLocale()) == null) {
                strContentLocale = "en";
            }
        }
        this.productLocale = MessagesManager.createLocale(strProductLocale);
        this.contentLocale = MessagesManager.createLocale(strContentLocale);
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public String getMarkupString(IContext context) {
        TagTD td;
        TagTR tr;
        boolean unavailable;
        TagTABLE table;
        PortletRuntime[] portletRuntimes;
        ArrayList<TagObject> tags = new ArrayList<TagObject>();
        StringBuilder script = new StringBuilder();
        script.append("var wsrp_rewrite_isIE = navigator.userAgent.toLowerCase().indexOf('msie')!=-1 ;\r\n");
        script.append("var wsrp_rewrite_contentIDs = new Array();\r\n");
        script.append("function wsrp_rewrite_fixIEScrollbarForAllContent(){\r\n    var i, l = wsrp_rewrite_contentIDs.length;\r\n    for (i =0 ; i < l; i++){\r\n        _ASM_fixIEScrollbar(wsrp_rewrite_contentIDs[i]);\r\n    }\r\n}\r\n");
        script.append("if(wsrp_rewrite_isIE){\r\n    window.attachEvent(\"onload\", wsrp_rewrite_fixIEScrollbarForAllContent);\r\n    window.attachEvent(\"onresize\", wsrp_rewrite_fixIEScrollbarForAllContent);\r\n}\r\n");
        script.append("function _ASM_fixIEScrollbar(id){\r\n    if (wsrp_rewrite_isIE){\r\n        var container = document.getElementById(id);\r\n        if (container && container.style.display != \"none\") {\r\n            var fixScrollbar = function(){\r\n                if (container.scrollHeight > container.clientHeight ){\r\n                    if (!container.ieScrollFix){\r\n                        container.style.paddingBottom = \"20px\";\r\n                        container.ieScrollFix = true;\r\n                    }\r\n                }else if (container.ieScrollFix){\r\n                    container.style.paddingBottom = \"\";\r\n                    container.ieScrollFix = false;\r\n                }\r\n            }\r\n            window.setTimeout(fixScrollbar, 1);\r\n        }\r\n    }\r\n}");
        script.append("\nfunction wsrp_rewrite_popup(sURL,e) {\nvar sFeatures = \"toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=680,height=500\";\nwindowHelp = window.open(sURL, \"helpWindow\", sFeatures);\n windowHelp.focus();\n   if (e!=null){\nif (e.srcElement) {\n    e.returnValue = false;\n} else {\n  e.preventDefault();\n}\n}\n}\n");
        tags.add(new TagSCRIPT(script.toString()));
        boolean hideHeaders = false;
        String singlePortletID = null;
        if (this.render.getPageletState() != null && (portletRuntimes = this.render.getPageletState().getPortletRuntime()) != null) {
            for (int i = 0; i < portletRuntimes.length; ++i) {
                PortletRuntime runtime = portletRuntimes[i];
                if ("wsrp:edit".equals(runtime.getMode()) || "cps:config".equals(runtime.getMode()) || "wsrp:help".equals(runtime.getMode()) || "wsrp:solo".equals(runtime.getWindowState())) {
                    singlePortletID = runtime.getId();
                    hideHeaders = true;
                    if (!"wsrp:edit".equals(runtime.getMode()) && !"cps:config".equals(runtime.getMode())) break;
                    StringBuffer jscript = new StringBuffer();
                    jscript.append("\nfunction wsrp_rewrite_reset(sURL) {\n").append("if (!window.confirm(\"").append(com.cognos.cps.common.utils.EncodingUtils.javascriptEncode((String)MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.resetportlet"))).append("\")) {\nreturn;\n}\n");
                    jscript.append("var f = document.createElement(\"form\");\r\nf.setAttribute(\"name\",\"wsrp_rewrite_reset_form\");\r\nf.setAttribute(\"method\",\"POST\");\r\nf.setAttribute(\"action\",sURL);\r\n");
                    String blockingActionToken = (String)context.getProperty("AuthToken");
                    if (blockingActionToken != null) {
                        jscript.append("var e = document.createElement(\"input\");\r\ne.setAttribute(\"type\",\"hidden\");    \r\ne.setAttribute(\"name\",\"cps-authToken\");\r\ne.setAttribute(\"value\",\"").append(com.cognos.cps.common.utils.EncodingUtils.javascriptEncode((String)blockingActionToken)).append("\");\r\nf.appendChild(e);\r\n");
                    }
                    jscript.append("document.body.appendChild(f);\r\nf.submit();\r\ndocument.body.removeChild(f);}\n");
                    tags.add(new TagSCRIPT(jscript.toString()));
                    break;
                }
                if (!"wsrp:maximized".equals(runtime.getWindowState())) continue;
                singlePortletID = runtime.getId();
            }
        }
        if (!hideHeaders && (this.title != null && !this.title.hidden || this.instructions != null && !this.instructions.hidden)) {
            table = new TagTABLE();
            tags.add(table);
            if (this.title != null && !this.title.hidden) {
                TagTR tr2 = new TagTR();
                table.add(tr2);
                tr2.add(this.title);
            }
            if (this.instructions != null && !this.instructions.hidden) {
                TagTR tr3 = new TagTR();
                table.add(tr3);
                tr3.add(this.instructions);
            }
        }
        if ((unavailable = this.isPageletAccessRights(AccessRightsType.UNAVAILABLE, this.render)) || this.render.getFaultContext() != null || this.portlets == 0) {
            table = new TagTABLE();
            tags.add(table);
            tr = new TagTR();
            table.add(tr);
            td = new TagTD(null, "top", "100%", null, null);
            tr.add(td);
            table = new TagTABLE(this.render.getFaultContext() != null ? "boxBorder" : null, null, null, null, "width=\"100%\"");
            td.add(table);
            tr = new TagTR("100%", null);
            table.add(tr);
            td = this.render.getPageletParams().getPageletMode() == null || !"cps:view".equals(this.render.getPageletParams().getPageletMode()) ? new TagTD("boxBody", null, null, null, null) : new TagTD();
            tr.add(td);
            if (this.render.getFaultContext() != null) {
                this.createFaultHTML(td, this.render.getFaultContext());
            } else if (unavailable || this.render.getPagelet() == null || this.render.getPagelet().getMetadata() == null) {
                td.add(this.renderMessageContent(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.pageunavailable")));
            } else {
                td.add(this.renderMessageContent(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.emptypage")));
            }
        } else {
            String flexibleColumnLayout = this.layoutProperties.getProperty("flexibleColumnLayout");
            table = new TagTABLE(null, "true".equals(flexibleColumnLayout) ? null : "table-layout:fixed", null, null, "width=\"100%\"");
            tags.add(table);
            tr = new TagTR();
            table.add(tr);
            td = new TagTD(null, "top", "100%", null, null);
            tr.add(td);
            if (singlePortletID != null) {
                this.createPortletHTML(td, singlePortletID);
            } else {
                for (int r = 0; r < this.rows.size(); ++r) {
                    Row row = (Row)this.rows.get(r);
                    this.createRowHTML(row, td);
                }
            }
        }
        StringBuffer out = new StringBuffer(65536);
        for (TagObject tag : tags) {
            tag.render(out);
        }
        return out.toString();
    }

    private boolean isPageletAccessRights(AccessRightsType value, Render render) {
        AccessRightsType[] accessRights;
        if (render.getPagelet() != null && (accessRights = render.getPagelet().getAccessRights()) != null) {
            for (int i = 0; i < accessRights.length; ++i) {
                if (!accessRights[i].equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void createRowHTML(Row row, TagTD td) {
        TagTABLE table = new TagTABLE();
        td.add(table);
        TagTR tr = new TagTR();
        table.add(tr);
        int widthTotal = 0;
        for (int i = 0; i < row.columns.size(); ++i) {
            Column column = (Column)row.columns.get(i);
            if (column.width == 0) {
                column.width = 100 / row.columns.size();
            }
            widthTotal += column.width;
        }
        int remaining = 100;
        for (int i = 0; i < row.columns.size(); ++i) {
            boolean isNext;
            Column column = (Column)row.columns.get(i);
            boolean bl = isNext = i < row.columns.size() - 1;
            if (isNext) {
                column.width = (int)(100.0 * (double)column.width) / widthTotal;
                remaining -= column.width;
            } else {
                column.width = remaining;
            }
            this.createColumnHTML(column, tr, isNext);
        }
    }

    private void createColumnHTML(Column column, TagTR tr, boolean spacing) {
        TagTD td = new TagTD(spacing ? "boxSpacing" : null, "top", Integer.toString(column.width) + "%", null, null);
        tr.add(td);
        if (column.containsRows) {
            for (int j = 0; j < column.children.size(); ++j) {
                Row row = (Row)column.children.get(j);
                this.createRowHTML(row, td);
            }
        } else if (column.children.size() > 0) {
            for (int j = 0; j < column.children.size(); ++j) {
                String portletID = column.children.get(j).toString();
                this.createPortletHTML(td, portletID);
            }
        } else {
            td.add(new TagBR());
        }
    }

    private TagCData renderMessageContent(String s) {
        return new TagCData("<br/><br/><p class=\"portlet-font\" align=\"center\">" + s + "</p><br/><br/>");
    }

    private void createPortletHTML(TagObject parent, String portletID) {
        TagTD td;
        TagTR tr;
        String pageletMode = this.render.getPageletParams().getPageletMode() != null ? this.render.getPageletParams().getPageletMode() : "";
        boolean inEditMode = "cps:edit".equals(pageletMode);
        boolean notInViewMode = !"cps:view".equals(pageletMode);
        boolean showBorders = inEditMode || notInViewMode && !this.portletOptions.hideBorders;
        boolean showTitleBar = inEditMode || notInViewMode && !this.portletOptions.hideTitleBars;
        String flexibleColumnLayout = this.layoutProperties.getProperty("flexibleColumnLayout");
        TagTABLE table = new TagTABLE(showBorders ? "boxBorder" : null, "true".equals(flexibleColumnLayout) ? null : "table-layout:fixed", null, null, "width=\"100%\"");
        parent.add(table);
        PortletRefs portletRefs = (PortletRefs)this.portletInstances.get(portletID);
        if (portletRefs != null && portletRefs.markup != null) {
            TagTD td2;
            TagTR tr2;
            String curWindowState;
            String prefix = portletRefs.markup != null && portletRefs.markup.getNamespacePrefix() != null ? portletRefs.markup.getNamespacePrefix() : "";
            String curMode = portletRefs.portletRuntime != null && portletRefs.portletRuntime.getMode() != null ? portletRefs.portletRuntime.getMode() : "wsrp:view";
            String string = curWindowState = portletRefs.portletRuntime != null && portletRefs.portletRuntime.getWindowState() != null ? portletRefs.portletRuntime.getWindowState() : "wsrp:normal";
            if (showTitleBar) {
                String title = null;
                MarkupType foundTextHtml = null;
                if (portletRefs.producer != null) {
                    if (portletRefs.markup.getMarkupContext() != null && portletRefs.markup.getMarkupContext().getPreferredTitle() != null && portletRefs.markup.getMarkupContext().getPreferredTitle().length() > 0) {
                        title = portletRefs.markup.getMarkupContext().getPreferredTitle();
                    } else if (portletRefs.portletRuntime != null && portletRefs.portletRuntime.getTitle() != null && portletRefs.portletRuntime.getTitle().length() > 0) {
                        title = portletRefs.portletRuntime.getTitle();
                    } else if (portletRefs.portlet.getName() != null && portletRefs.portlet.getName().getContent() != null && portletRefs.portlet.getName().getContent().length() > 0) {
                        title = portletRefs.portlet.getName().getContent();
                    } else if (portletRefs.portletDescription.getShortTitle() != null && portletRefs.portletDescription.getShortTitle().getValue() != null && portletRefs.portletDescription.getShortTitle().getValue().length() > 0 && "wsrp:minimized".equals(curWindowState)) {
                        title = portletRefs.portletDescription.getShortTitle().getValue();
                    } else if (portletRefs.portletDescription.getTitle() != null && portletRefs.portletDescription.getTitle().getValue() != null && portletRefs.portletDescription.getTitle().getValue().length() > 0) {
                        title = portletRefs.portletDescription.getTitle().getValue();
                    } else if (portletRefs.portletDescription.getDisplayName() != null && portletRefs.portletDescription.getDisplayName().getValue() != null && portletRefs.portletDescription.getDisplayName().getValue().length() > 0) {
                        title = portletRefs.portletDescription.getDisplayName().getValue();
                    }
                    Enumeration markupTypes = portletRefs.portletDescription.enumerateMarkupTypes();
                    while (markupTypes.hasMoreElements()) {
                        MarkupType markupType = (MarkupType)markupTypes.nextElement();
                        if (!markupType.getMimeType().equalsIgnoreCase("text/html")) continue;
                        foundTextHtml = markupType;
                        break;
                    }
                }
                TagTR trHeader = new TagTR();
                table.add(trHeader);
                TagTD tdHeader = new TagTD("boxHeaderBackground", null, "100%", null, null);
                trHeader.add(tdHeader);
                TagTABLE tableCaption = new TagTABLE();
                tdHeader.add(tableCaption);
                TagTR trCaption = new TagTR();
                tableCaption.add(trCaption);
                TagTD tdCaption = new TagTD("boxHeader", null, "100%", null, "id='wsrp_rewrite_" + prefix + "caption'");
                trCaption.add(tdCaption);
                if (title == null || title.length() == 0) {
                    title = MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.titleunavailable");
                } else if ("wsrp:edit".equals(curMode) || "cps:config".equals(curMode)) {
                    title = MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.editmode.title", (Object[])new String[]{title});
                }
                String isBidiEnabled = this.getBidiEnabled();
                String textDirection = this.getTextDirection();
                tdCaption.add(this.nonBreakingSpace);
                if (isBidiEnabled.equals("true")) {
                    title = Bidi.enforceBTD((String)title, (String)textDirection, (String)this.getProductLocale().toString());
                }
                tdCaption.add(new TagText(title));
                tdCaption.add(this.nonBreakingSpace);
                if (portletRefs.producer != null) {
                    TagTD tdBar = new TagTD(null, "middle", null, null, null);
                    trCaption.add(tdBar);
                    TagTABLE tableBar = new TagTABLE("boxButtonBar", null, "2", "0", null);
                    tdBar.add(tableBar);
                    TagTR trBar = new TagTR();
                    tableBar.add(trBar);
                    trBar.add(new TagTD("boxButtonNormal", null, null, null, "id='wsrp_rewrite_" + prefix + "caption_busy' style='display:none;'"));
                    if ("wsrp:help".equals(curMode)) {
                        TagTD tdClose = new TagTD("boxButtonNormal", null, null, null, "onmouseover=\"this.className='boxButtonOver';\" onmouseout=\"this.className='boxButtonNormal';\"");
                        trBar.add(tdClose);
                        TagA a = new TagA("#", "window.close();", null);
                        tdClose.add(a);
                        a.add(new TagIMG(1, "close.gif", "14", "14", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.close")));
                    } else if ("cps:preview".equals(pageletMode) || "wsrp:preview".equals(curMode)) {
                        if (portletRefs.isModeSupported("wsrp:help")) {
                            this.createButtonHTML(trBar, portletID, "wsrp:help", curWindowState, "help", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.help"), null);
                        }
                    } else {
                        if (portletRefs.isModeSupported("wsrp:help")) {
                            this.createButtonHTML(trBar, portletID, "wsrp:help", curWindowState, "help", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.help"), null);
                        }
                        if ("wsrp:edit".equals(curMode) || "cps:config".equals(curMode)) {
                            if (!portletRefs.isAccessRights(AccessRightsType.READONLY)) {
                                this.createButtonHTML(trBar, portletID, "wsrp:view", curWindowState, "reset", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.reset"), "cps-action=reset");
                            }
                        } else {
                            if (inEditMode || notInViewMode && !this.portletOptions.hideEditMode) {
                                String winState;
                                String string2 = winState = "wsrp:minimized".equals(curWindowState) ? "wsrp:normal" : curWindowState;
                                if (portletRefs.isModeSupported("wsrp:edit")) {
                                    this.createButtonHTML(trBar, portletID, "wsrp:edit", winState, "edit", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.edit"), null);
                                }
                                if (portletRefs.isModeSupported("cps:config")) {
                                    String tooltip = LayoutHandler.getLocalizedStringForMode(MessagesManager.buildJavaLocaleName((Locale)this.productLocale), portletRefs.producer.getServiceDescription(), "cps:config");
                                    this.createButtonHTML(trBar, portletID, "cps:config", winState, "configuration", tooltip, null);
                                }
                            }
                            if (!"wsrp:minimized".equals(curWindowState)) {
                                this.createButtonHTML(trBar, portletID, curMode, "wsrp:minimized", "minimize", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.minimize"), null);
                            }
                            if (!"wsrp:normal".equals(curWindowState)) {
                                this.createButtonHTML(trBar, portletID, curMode, "wsrp:normal", "restore", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.normal"), null);
                            }
                            if (!"wsrp:maximized".equals(curWindowState) && LayoutHandler.isWindowStateSupported(foundTextHtml, "wsrp:maximized")) {
                                this.createButtonHTML(trBar, portletID, curMode, "wsrp:maximized", "maximize", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.maximize"), null);
                            }
                        }
                        if (!"wsrp:view".equals(curMode)) {
                            this.createButtonHTML(trBar, portletID, "wsrp:view", curWindowState, "return", MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.return"), null);
                        }
                    }
                }
            } else if ("wsrp:view".equals(curMode) && "wsrp:maximized".equals(curWindowState)) {
                StringBuffer url = new StringBuffer().append("wsrp_rewrite?wsrp-urlType=render&wsrp-mode=").append(EncodingUtils.urlencode((String)curMode, (String)"UTF-8", (boolean)false)).append("&wsrp-windowState=").append("wsrp:normal").append("&").append("cps-portlet").append("=").append(EncodingUtils.urlencode((String)portletID, (String)"UTF-8", (boolean)false)).append("/wsrp_rewrite");
                tr2 = new TagTR(null, "100%");
                td2 = notInViewMode ? new TagTD("boxBody", null, "100%", null, "align=\"right\"") : new TagTD(null, null, "100%", null, "align=\"right\"");
                tr2.add(td2);
                td2.add(new TagA(url.toString(), null, MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.tooltip.return")));
                table.add(tr2);
            }
            tr2 = new TagTR(null, "100%");
            td2 = notInViewMode ? new TagTD("boxBody", null, null, null, null) : new TagTD();
            tr2.add(td2);
            if (portletRefs.markup.getFaultContext() != null) {
                this.createFaultHTML(td2, portletRefs.markup.getFaultContext());
                table.add(tr2);
            } else if (portletRefs.markup.getMarkupContext() != null && portletRefs.isModeSupported("wsrp:view")) {
                String markup = portletRefs.markup.getMarkupContext().getMarkupString();
                if (markup != null && markup.length() > 0) {
                    StringBuilder styleBuilder = new StringBuilder();
                    styleBuilder.append("width:100%;overflow-x:auto;");
                    String userAgent = this.render.getPageletParams().getUserAgent();
                    if (userAgent != null && userAgent.indexOf("MSIE") != -1) {
                        styleBuilder.append("position:relative;");
                    }
                    String divId = "wsrp_rewrite_" + prefix + "_content";
                    TagDIV div = new TagDIV(divId, styleBuilder.toString());
                    div.add(new TagCData(markup));
                    td2.add(div);
                    td2.add(new TagSCRIPT("wsrp_rewrite_contentIDs.push(\"" + com.cognos.cps.common.utils.EncodingUtils.javascriptEncode((String)divId) + "\");"));
                    table.add(tr2);
                }
            } else if (portletRefs.isAccessRights(AccessRightsType.DISABLED)) {
                td2.add(this.renderMessageContent(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.portletdisabled")));
                table.add(tr2);
            } else {
                td2.add(this.renderMessageContent(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.portletunavailable")));
                table.add(tr2);
            }
        } else {
            if (showTitleBar) {
                TagTR trHeader = new TagTR();
                table.add(trHeader);
                TagTD tdHeader = new TagTD("boxHeaderBackground", null, "100%", null, null);
                trHeader.add(tdHeader);
                TagTABLE tableCaption = new TagTABLE();
                tdHeader.add(tableCaption);
                TagTR trCaption = new TagTR();
                tableCaption.add(trCaption);
                TagTD tdCaption = new TagTD("boxHeader", null, "100%", null, null);
                trCaption.add(tdCaption);
                tdCaption.add(this.nonBreakingSpace);
                tdCaption.add(new TagText(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.titleunavailable")));
                tdCaption.add(this.nonBreakingSpace);
            }
            tr = new TagTR(null, "100%");
            td = notInViewMode ? new TagTD("boxBody", null, null, null, null) : new TagTD();
            tr.add(td);
            td.add(this.renderMessageContent(MessagesManager.getInstance().getMessage(this.productLocale, "cps.pagelet.processor.layout.portletunavailable")));
            table.add(tr);
        }
        table = new TagTABLE();
        parent.add(table);
        tr = new TagTR();
        table.add(tr);
        td = new TagTD();
        tr.add(td);
        td.add(new TagIMG(0, "space.gif", "1", "5", ""));
    }

    private void createButtonHTML(TagObject parent, String portletID, String mode, String windowState, String image, String alt, String extraParams) {
        TagTD td = new TagTD("boxButtonNormal", null, null, null, "onmouseover=\"this.className='boxButtonOver';\" onmouseout=\"this.className='boxButtonNormal';\"");
        parent.add(td);
        StringBuffer url = new StringBuffer().append("wsrp_rewrite?wsrp-urlType=render&wsrp-mode=").append(EncodingUtils.urlencode((String)mode, (String)"UTF-8", (boolean)false)).append("&wsrp-windowState=").append(EncodingUtils.urlencode((String)windowState, (String)"UTF-8", (boolean)false)).append("&").append("cps-portlet").append("=").append(EncodingUtils.urlencode((String)portletID, (String)"UTF-8", (boolean)false));
        if (extraParams != null && extraParams.length() > 0) {
            if (extraParams.charAt(0) != '&') {
                url.append('&');
            }
            url.append(extraParams);
        }
        url.append("/wsrp_rewrite");
        TagA a = new TagA(url.toString(), null, null);
        td.add(a);
        a.add(new TagIMG(1, "action_" + image + "_module.gif", "14", "14", alt));
    }

    private void createFaultHTML(TagObject parent, SOAPFault faultContext) {
        String faultCode = faultContext.getFaultcode();
        String faultString = faultContext.getFaultstring();
        if (faultString != null) {
            int firstDash;
            int firstSpace = faultString.indexOf(32);
            if (firstSpace > (firstDash = faultString.indexOf(45)) && firstDash >= 0) {
                faultCode = faultString.substring(0, firstSpace);
                faultString = faultString.substring(firstSpace);
            }
        } else {
            faultString = faultCode;
        }
        TagTABLE table = new TagTABLE();
        parent.add(table);
        TagTR tr = new TagTR();
        table.add(tr);
        TagTD td = new TagTD();
        tr.add(td);
        td.add(new TagIMG(0, "space.gif", "1", "10", ""));
        table = new TagTABLE(null, "padding-left:5px;", null, null, "width=\"100%\"");
        parent.add(table);
        tr = new TagTR();
        table.add(tr);
        td = new TagTD("portlet-msg-error", null, null, null, null);
        tr.add(td);
        td.setText(faultCode);
        table = new TagTABLE();
        parent.add(table);
        tr = new TagTR();
        table.add(tr);
        td = new TagTD(null, null, "100%", "10", null);
        tr.add(td);
        td.add(new TagIMG(0, "space.gif", "1", "10", ""));
        table = new TagTABLE(null, null, null, "3", "width=\"100%\"");
        parent.add(table);
        tr = new TagTR();
        table.add(tr);
        td = new TagTD(null, null, "1", "1", null);
        tr.add(td);
        td.add(new TagIMG(0, "space.gif", "1", "10", ""));
        td = new TagTD(null, null, "100%", null, null);
        tr.add(td);
        table = new TagTABLE(null, null, null, null, null);
        td.add(table);
        tr = new TagTR();
        table.add(tr);
        td = new TagTD(null, "top", null, null, null);
        tr.add(td);
        td.add(new TagIMG(2, "msg_error.gif", "32", "32", null));
        td = new TagTD("portlet-font", null, null, null, null);
        tr.add(td);
        td.add(new TagCData("&#160;&#160;&#160;&#160;"));
        td = new TagTD("portlet-font", "top", null, null, null);
        tr.add(td);
        if (faultContext.getDetail() != null) {
            StringBuffer sb = new StringBuffer(1024);
            sb.append(faultString);
            Object[] details = faultContext.getDetail().getAnyObject();
            if (details != null && details.length > 0) {
                sb.append("<br><br><textarea rows=\"15\" cols=\"80\" readonly>");
                for (int i = 0; i < details.length; ++i) {
                    sb.append(details[i].toString());
                }
                sb.append("</textarea>");
            }
            td.add(new TagCData(sb.toString()));
        } else {
            td.setText(faultString);
        }
    }

    private static boolean isWindowStateSupported(MarkupType markupType, String windowState) {
        if (markupType != null) {
            String[] windowStates = markupType.getWindowStates();
            for (int i = 0; i < windowStates.length; ++i) {
                if (!windowStates[i].equals(windowState)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getParamValue(String name, Param[] params, String defaultContent) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].getName().equals(name)) continue;
                String value = params[i].getContent();
                if (value == null || value.length() <= 0) break;
                return params[i].getContent();
            }
        }
        return defaultContent;
    }

    private static String getLocalizedStringForMode(String productLocale, ServiceDescription serviceDescription, String customMode) {
        ItemDescription[] modes = serviceDescription.getCustomModeDescriptions();
        for (int i = 0; i < modes.length; ++i) {
            if (!modes[i].getItemName().equals(customMode)) continue;
            return LayoutHandler.getLocalizedString(productLocale, serviceDescription.getResourceList(), modes[i].getDescription());
        }
        return null;
    }

    private static String getLocalizedString(String productLocale, ResourceList resourceList, LocalizedString localizedString) {
        Resource[] resources;
        String resourceName = localizedString.getResourceName();
        if (resourceList != null && (resources = resourceList.getResources()) != null) {
            for (int i = 0; i < resources.length; ++i) {
                if (!resources[i].getResourceName().equals(resourceName)) continue;
                ResourceValue[] values = resources[i].getValues();
                SmallMap map = new SmallMap();
                map.put(localizedString.getLang(), localizedString.getValue());
                for (int j = 0; j < values.length; ++j) {
                    map.put(values[j].getLang(), values[j].getValue());
                }
                Object[] supportedLocales = map.keySet().toArray();
                String locale = CCLLocaleUtils.getValidProductLocale((String)productLocale, (Object[])supportedLocales, null);
                if (locale == null) continue;
                return map.get(locale).toString();
            }
        }
        return localizedString.getValue();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (!TAG_LAYOUT.equals(localName)) {
            if (TAG_TITLE.equals(localName)) {
                this.title = new LocalizableHeader(atts, "defaultTitleText");
                this.context = 1;
            } else if (TAG_INSTRUCTIONS.equals(localName)) {
                this.instructions = new LocalizableHeader(atts, "defaultInstructionsText");
                this.context = 2;
            } else if (TAG_VALUE.equals(localName)) {
                this.lang = CCLLocaleUtils.normalizeLocale((String)atts.getValue("xml:lang"));
            } else if (TAG_LAYOUT_PROPERTIES.equals(localName)) {
                this.context = 3;
            } else if (TAG_PARAM.equals(localName)) {
                if (this.context == 3) {
                    this.paramName = atts.getValue("name");
                    this.paramValue.setLength(0);
                }
            } else if (TAG_PORTLET_OPTIONS.equals(localName)) {
                this.portletOptions = new PortletOptions(atts);
            } else if (TAG_ROW.equals(localName)) {
                this.currentRow = new Row(atts);
                if (this.currentColumn != null) {
                    this.currentColumn.add(this.currentRow);
                } else {
                    this.rows.add(this.currentRow);
                }
            } else if (TAG_COLUMN.equals(localName)) {
                this.currentColumn = new Column(atts);
                if (this.currentRow == null) {
                    this.currentRow = new Row(null);
                    this.rows.add(this.currentRow);
                }
                this.currentRow.add(this.currentColumn);
            } else if (TAG_PORTLET.equals(localName)) {
                this.currentColumn.add(atts.getValue(ATT_ID));
                ++this.portlets;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String isBidiEnabled = this.getBidiEnabled();
        String textDirection = this.getTextDirection();
        switch (this.context) {
            case 1: {
                if (isBidiEnabled.equals("true")) {
                    this.title.values.put(this.lang, Bidi.enforceBTD((String)new String(ch, start, length), (String)textDirection, (String)this.getProductLocale().toString()));
                    break;
                }
                this.title.values.put(this.lang, new String(ch, start, length));
                break;
            }
            case 2: {
                if (isBidiEnabled.equals("true")) {
                    this.instructions.values.put(this.lang, Bidi.enforceBTD((String)new String(ch, start, length), (String)textDirection, (String)this.getProductLocale().toString()));
                    break;
                }
                this.instructions.values.put(this.lang, new String(ch, start, length));
                break;
            }
            case 3: {
                if (this.paramName == null) break;
                this.paramValue.append(new String(ch, start, length));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!TAG_VALUE.equals(localName)) {
            if (TAG_ROW.equals(localName)) {
                this.currentColumn = this.currentRow.parent;
                this.currentRow = null;
            } else if (TAG_COLUMN.equals(localName)) {
                this.currentRow = this.currentColumn.parent;
                this.currentColumn = null;
            } else if (TAG_PARAM.equals(localName) && this.context == 3) {
                if (this.paramName != null) {
                    this.layoutProperties.setProperty(this.paramName, this.paramValue.toString());
                }
            } else {
                this.context = 0;
            }
        }
    }

    public String getBidiEnabled() {
        String bidiEnabled = LayoutHandler.getParamValue("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#biDirectionalFeaturesEnabled", this.render.getUserContext() != null && this.render.getUserContext().getPreferences() != null ? this.render.getUserContext().getPreferences().getParam() : null, "false");
        return bidiEnabled;
    }

    public String getTextDirection() {
        String textDirection = LayoutHandler.getParamValue("http://developer.cognos.com/ceba/constants/biDirectionalOptionEnum#baseTextDirection", this.render.getUserContext() != null && this.render.getUserContext().getPreferences() != null ? this.render.getUserContext().getPreferences().getParam() : null, "auto");
        if (textDirection.lastIndexOf("#") != -1) {
            textDirection = textDirection.substring(textDirection.lastIndexOf("#") + 1).toLowerCase();
        }
        return textDirection;
    }

    class LocalizableHeader
    extends TagTD {
        private static final String ATT_HIDDEN = "hidden";
        private static final String ATT_FONT = "font";
        private static final String ATT_SIZE = "size";
        private static final String ATT_COLOUR = "colour";
        private static final String ATT_BOLD = "bold";
        private static final String ATT_ITALIC = "italic";
        private static final String ATT_UNDERLINE = "underline";
        private static final String ATT_ALIGN = "align";
        boolean hidden;
        String font;
        String size;
        String color;
        boolean bold;
        boolean italic;
        boolean underline;
        String align;
        String cssClass;
        Map values;

        public LocalizableHeader(Attributes atts, String cssClass) {
            this.values = new SmallMap();
            this.hidden = Boolean.valueOf(atts.getValue(ATT_HIDDEN));
            this.font = atts.getValue(ATT_FONT);
            this.size = atts.getValue(ATT_SIZE);
            this.color = atts.getValue(ATT_COLOUR);
            this.bold = Boolean.valueOf(atts.getValue(ATT_BOLD));
            this.italic = Boolean.valueOf(atts.getValue(ATT_ITALIC));
            this.underline = Boolean.valueOf(atts.getValue(ATT_UNDERLINE));
            this.align = atts.getValue(ATT_ALIGN);
            this.cssClass = cssClass;
        }

        @Override
        public void render(StringBuffer out) {
            String value = null;
            if (this.values.size() > 0) {
                Object[] supportedLocales = this.values.keySet().toArray();
                String locale = CCLLocaleUtils.getValidContentLocale((String)MessagesManager.buildJavaLocaleName((Locale)LayoutHandler.this.contentLocale), (Object[])supportedLocales, null);
                if (locale != null) {
                    value = this.values.get(locale).toString();
                }
                if (value == null) {
                    value = (String)this.values.values().iterator().next();
                }
            }
            if (!this.hidden && value != null) {
                out.append("<").append(this.tagName).append(" class=\"").append(this.cssClass).append("\" style=\"");
                if (this.font != null && this.font.length() > 0) {
                    out.append("font-family:").append(this.font).append(";");
                }
                if (this.size != null && this.size.length() > 0) {
                    out.append("font-size:").append(this.size).append(";");
                }
                if (this.color != null && this.color.length() > 0) {
                    out.append("color:").append(this.color).append(";");
                }
                if (this.bold) {
                    out.append("font-weight:bold;");
                }
                if (this.italic) {
                    out.append("font-style:italic;");
                }
                if (this.underline) {
                    out.append("text-decoration:underline;");
                }
                if (this.align != null && this.align.length() > 0) {
                    out.append("text-align:").append(this.align).append(";");
                }
                out.append("\">");
                com.cognos.cps.common.utils.EncodingUtils.htmlEncode((String)value, (StringBuffer)out);
                out.append("</").append(this.tagName).append(">");
            }
        }
    }

    class TagDIV
    extends TagObject {
        TagDIV() {
            this(null, null);
        }

        TagDIV(String id, String style) {
            this.tagName = "div";
            StringBuffer atts = new StringBuffer(128);
            if (style != null) {
                atts.append(" id=\"").append(id).append("\"");
            }
            if (style != null) {
                atts.append(" style=\"").append(style).append("\"");
            }
            this.attribs = atts.toString().trim();
        }
    }

    class TagBR
    extends TagObject {
        TagBR() {
            this.tagName = "br";
            this.noClosingTag = true;
        }
    }

    class TagA
    extends TagObject {
        private static final String ATT_HIDE = " onmouseover=\"window.status='';return true;\" onmouseout=\"window.status='';return true;\"";

        TagA(String href, String onclick, String text) {
            this.tagName = "a";
            if (text != null) {
                this.attribs = "class=\"cognos-anchor\" ";
                this.text = text;
            } else {
                this.attribs = "";
            }
            if (href != null) {
                this.attribs = onclick != null ? this.attribs + "href=\"" + href + "\" onclick=\"" + onclick + "\"" + ATT_HIDE : this.attribs + "href=\"" + href + "\"" + ATT_HIDE;
            } else if (onclick != null) {
                this.attribs = this.attribs + "onclick=\"" + onclick + "\"" + ATT_HIDE;
            }
        }
    }

    class TagIMG
    extends TagObject {
        static final int PATH_WEBCONTENT = 0;
        static final int PATH_SKIN = 1;
        static final int PATH_PORTAL = 2;

        TagIMG(int path, String image, String width, String height, String alt) {
            this.tagName = "img";
            StringBuffer atts = new StringBuffer(128);
            atts.append("border=\"0\" src=\"");
            switch (path) {
                case 1: {
                    atts.append(LayoutHandler.this.skinImagesURL);
                    break;
                }
                case 2: {
                    atts.append(LayoutHandler.this.portalImagesURL);
                    break;
                }
                default: {
                    atts.append(LayoutHandler.this.webImagesURL);
                }
            }
            atts.append("/").append(image).append("\"");
            if (width != null) {
                atts.append(" width=\"").append(width).append("\"");
            }
            if (height != null) {
                atts.append(" height=\"").append(height).append("\"");
            }
            if (alt != null) {
                atts.append(" alt=\"").append(alt).append("\"").append(" title=\"").append(alt).append("\"");
            }
            this.attribs = atts.toString();
            this.noClosingTag = true;
        }
    }

    class TagSCRIPT
    extends TagObject {
        TagSCRIPT(String code) {
            this.tagName = "script";
            this.text = code;
        }

        @Override
        void renderChildren(StringBuffer out) {
            out.append(this.text);
        }
    }

    class TagComment
    extends TagObject {
        TagComment(String text) {
            this.text = text;
        }

        @Override
        void render(StringBuffer out) {
            this.renderChildren(out);
        }

        @Override
        void renderChildren(StringBuffer out) {
            out.append("<!--");
            com.cognos.cps.common.utils.EncodingUtils.htmlEncode((String)this.text, (StringBuffer)out);
            out.append("-->");
        }
    }

    class TagText
    extends TagObject {
        TagText(String text) {
            this.text = text;
        }

        @Override
        void render(StringBuffer out) {
            this.renderChildren(out);
        }

        @Override
        void renderChildren(StringBuffer out) {
            com.cognos.cps.common.utils.EncodingUtils.htmlEncode((String)this.text, (StringBuffer)out);
        }
    }

    class TagCData
    extends TagObject {
        TagCData(String text) {
            this.text = text;
        }

        @Override
        void render(StringBuffer out) {
            this.renderChildren(out);
        }

        @Override
        void renderChildren(StringBuffer out) {
            out.append(this.text);
        }
    }

    class TagTD
    extends TagObject {
        TagTD() {
            this.tagName = "td";
        }

        TagTD(String cssClass, String valign, String width, String height, String moreAttrs) {
            this.tagName = "td";
            StringBuffer atts = new StringBuffer(128);
            if (cssClass != null) {
                atts.append(" class=\"").append(cssClass).append("\"");
            }
            if (valign != null) {
                atts.append(" valign=\"").append(valign).append("\"");
            }
            if (width != null) {
                atts.append(" width=\"").append(width).append("\"");
            }
            if (height != null) {
                atts.append(" height=\"").append(height).append("\"");
            }
            if (moreAttrs != null) {
                atts.append(" ").append(moreAttrs);
            }
            this.attribs = atts.toString().trim();
        }
    }

    class TagTR
    extends TagObject {
        TagTR() {
            this.tagName = "tr";
        }

        TagTR(String width, String height) {
            this.tagName = "tr";
            if (height != null) {
                this.attribs = width != null ? "width=\"" + width + "\" height=\"" + height + "\"" : "height=\"" + height + "\"";
            } else if (width != null) {
                this.attribs = "width=\"" + width + "\"";
            }
        }
    }

    class TagTABLE
    extends TagObject {
        TagTABLE() {
            this.tagName = "table";
            this.attribs = "border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" role=\"presentation\"";
        }

        TagTABLE(String cssClass, String style, String cellspacing, String cellpadding, String moreAttrs) {
            this.tagName = "table";
            StringBuffer atts = new StringBuffer(128);
            atts.append(" border=\"0\"");
            atts.append(" role=\"presentation\"");
            if (cssClass != null) {
                atts.append(" class=\"").append(cssClass).append("\"");
            }
            if (style != null) {
                atts.append(" style=\"").append(style).append("\"");
            }
            atts.append(" cellspacing=\"").append(cellspacing != null ? cellspacing : "0").append("\"");
            atts.append(" cellpadding=\"").append(cellpadding != null ? cellpadding : "0").append("\"");
            if (moreAttrs != null) {
                atts.append(" ").append(moreAttrs);
            }
            this.attribs = atts.toString();
        }
    }

    abstract class TagObject {
        protected ArrayList children;
        protected String tagName;
        protected String attribs;
        protected String text;
        protected boolean noClosingTag;

        TagObject() {
        }

        void render(StringBuffer out) {
            out.append("<");
            out.append(this.tagName);
            if (this.attribs != null) {
                out.append(" ");
                out.append(this.attribs);
            }
            out.append(">");
            if (!this.noClosingTag) {
                this.renderChildren(out);
                out.append("</");
                out.append(this.tagName);
                out.append(">");
            }
        }

        void renderChildren(StringBuffer out) {
            if (this.text != null) {
                com.cognos.cps.common.utils.EncodingUtils.htmlEncode((String)this.text, (StringBuffer)out);
            } else if (this.children != null) {
                for (TagObject tag : this.children) {
                    tag.render(out);
                }
            }
        }

        void add(TagObject child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        void add(ArrayList tags) {
            this.children.addAll(tags);
        }

        void setText(String text) {
            this.text = text;
        }
    }
}

