/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.processor.impl;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.sax.SAXUtils;
import com.cognos.cps.pagelet.common.exception.ExceptionUtilities;
import com.cognos.cps.pagelet.common.log.LogManager;
import com.cognos.cps.pagelet.processor.impl.LayoutHandler;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.pagelet.objects.v1.types.PageletMarkup;
import com.cognos.cps.services.pagelet.objects.v1.types.UseCachedMarkup;
import com.cognos.cps.services.pagelet.processor.v1.intf.IProcessor;
import com.cognos.cps.services.pagelet.processor.v1.types.Render;
import com.cognos.cps.services.pagelet.processor.v1.types.RenderResponse;
import com.cognos.cps.services.soap.envelope.SOAPFault;
import com.cognos.cps.services.soap.envelope.TypeFactory;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.util.AnyNode2SAX2;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ProcessorImpl
implements IProcessor,
IServiceImplementation {
    ServiceLogger m_logger;
    private static final String DEFAULT_LAYOUT = "<layout><portletOptions hideBorders=\"false\" hideTitleBars=\"false\" hideEditMode=\"false\"/><column width=\"100\"><portlet id=\"PORTLETID\"/></column></layout>";

    public ProcessorImpl(ServiceLogger logger) {
        this.m_logger = logger != null ? logger.cloneForClass(ProcessorImpl.class) : LogManager.getLogManager().getLogger(ProcessorImpl.class);
    }

    public RenderResponse render(Render render, IContext context) {
        RenderResponse renderResponse = com.cognos.cps.services.pagelet.processor.v1.types.TypeFactory.newInstance().createRenderResponse();
        PageletMarkup pageletMarkup = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createPageletMarkup();
        LayoutHandler handler = new LayoutHandler(render, context);
        try {
            if (render.getPagelet() != null) {
                if (render.getPagelet().getLayout() != null && render.getPagelet().getLayout().getAnyObject() != null) {
                    AnyNode2SAX2 layoutSAX = new AnyNode2SAX2((AnyNode)render.getPagelet().getLayout().getAnyObject());
                    layoutSAX.setContentHandler((ContentHandler)handler);
                    layoutSAX.start();
                    pageletMarkup.setCacheControl(render.getCacheControl());
                } else if (render.getPagelet().getId() != null) {
                    XMLReader reader = SAXUtils.getSAXParser().getXMLReader();
                    reader.setContentHandler(handler);
                    reader.parse(new InputSource(new StringReader(DEFAULT_LAYOUT)));
                    pageletMarkup.setCacheControl(render.getCacheControl());
                }
            }
            pageletMarkup.setMimeType("text/html");
            pageletMarkup.setMarkupString(handler.getMarkupString(context));
            pageletMarkup.setRequiresURLRewriting("true");
            UseCachedMarkup useCachedMarkup = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance().createUseCachedMarkup();
            useCachedMarkup.setContent(false);
            pageletMarkup.setUseCachedMarkup(useCachedMarkup);
        }
        catch (SAXException e) {
            pageletMarkup.setFaultContext(ProcessorImpl.createSOAPFault(handler, e));
        }
        catch (ParserConfigurationException e) {
            pageletMarkup.setFaultContext(ProcessorImpl.createSOAPFault(handler, e));
        }
        catch (IOException e) {
            pageletMarkup.setFaultContext(ProcessorImpl.createSOAPFault(handler, e));
        }
        renderResponse.setPath(render.getPath());
        renderResponse.setPageletMarkup(pageletMarkup);
        return renderResponse;
    }

    private static SOAPFault createSOAPFault(LayoutHandler handler, Throwable e) {
        SOAPFault fault = TypeFactory.newInstance().createFault();
        fault.setFaultcode("cps.pagelet.processor.operation.failed");
        fault.setFaultstring(MessagesManager.getInstance().getMessage(handler.getProductLocale(), "cps.pagelet.processor.operation.failed"));
        fault.setDetail(ExceptionUtilities.convertFaultToDetail(e));
        return fault;
    }

    public synchronized void initialize(IContext context) {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter("initialize()");
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit("initialize()");
        }
    }

    public synchronized void terminate() {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.enter("terminate()");
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.exit("terminate()");
        }
    }
}

