/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.storage.common;

import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.QNameFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class AsmTypeHelper {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static SAXParserFactory parserFactory = null;

    public static Object deserializeStorage(Reader body, String name) throws OperationFailedFault {
        com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory factory = com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory.newInstance();
        return AsmTypeHelper.deserialize(body, name, "http://developer.cognos.com/schemas/cps/asm/storage/1/", (SOAPObjectHandler)factory);
    }

    public static Object deserializeAsmObj(Reader body, String name) throws OperationFailedFault {
        com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory factory = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance();
        return AsmTypeHelper.deserialize(body, name, "http://developer.cognos.com/schemas/cps/asm/objects/1/", (SOAPObjectHandler)factory);
    }

    public static Object deserializeWsrp(Reader body, String name) throws OperationFailedFault {
        TypeFactory factory = TypeFactory.newInstance();
        return AsmTypeHelper.deserialize(body, name, "urn:oasis:names:tc:wsrp:v1:types", (SOAPObjectHandler)factory);
    }

    public static String serializeStorage(Object obj, String name) throws OperationFailedFault {
        com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory factory = com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory.newInstance();
        return AsmTypeHelper.serialize(obj, name, "http://developer.cognos.com/schemas/cps/asm/storage/1/", "ast", (SOAPObjectHandler)factory);
    }

    public static String serializeAsm(Object obj, String name) throws OperationFailedFault {
        com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory factory = com.cognos.cps.services.pagelet.objects.v1.types.TypeFactory.newInstance();
        return AsmTypeHelper.serialize(obj, name, "http://developer.cognos.com/schemas/cps/asm/objects/1/", "cps", (SOAPObjectHandler)factory);
    }

    public static String serializeWsrp(Object obj, String name) throws OperationFailedFault {
        TypeFactory factory = TypeFactory.newInstance();
        return AsmTypeHelper.serialize(obj, name, "urn:oasis:names:tc:wsrp:v1:types", "wsrp", (SOAPObjectHandler)factory);
    }

    private static String serialize(Object obj, String name, String uri, String prefix, SOAPObjectHandler factory) throws OperationFailedFault {
        StringWriter out = new StringWriter();
        try {
            QName qName = QNameFactory.createQName((String)uri, (String)name, (String)prefix);
            factory.serialize(obj, (Writer)out, qName);
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new OperationFailedFault("cps.common.serialize.io.error", args, null);
        }
        return out.getBuffer().toString();
    }

    private static Object deserialize(Reader body, String name, String type, SOAPObjectHandler factory) throws OperationFailedFault {
        try {
            XMLReader xmlreader = AsmTypeHelper.createXMLReader();
            ContentHandler handler = factory.getContentHandler(type, name);
            if (handler == null) {
                Object[] args = new String[]{name};
                throw new OperationFailedFault("cps.common.deserializeundefinedobject.error", args, null);
            }
            xmlreader.setContentHandler(handler);
            xmlreader.parse(new InputSource(body));
            Object obj = factory.getObject(handler);
            return obj;
        }
        catch (IOException e) {
            Object[] args = new String[]{name};
            throw new OperationFailedFault("cps.common.parse.io.error", args, (Throwable)e);
        }
        catch (SAXException e) {
            Object[] args = new String[]{name};
            throw new OperationFailedFault("cps.common.parse.sax.error", args, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            Object[] args = new String[]{name};
            throw new OperationFailedFault("cps.common.parse.sax.error", args, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        SAXParser parser = null;
        SAXParserFactory sAXParserFactory = parserFactory;
        synchronized (sAXParserFactory) {
            parser = parserFactory.newSAXParser();
        }
        return parser.getXMLReader();
    }

    static {
        parserFactory = SAXParserFactory.newInstance();
        try {
            parserFactory.setFeature(NAMESPACE_FEATURE, true);
            parserFactory.setFeature(NAMESPACE_PREFIXES_FEATURE, false);
            parserFactory.setFeature(VALIDATION_FEATURE, false);
        }
        catch (SAXNotRecognizedException e) {
            parserFactory.setNamespaceAware(true);
        }
        catch (SAXNotSupportedException e) {
            parserFactory.setNamespaceAware(true);
        }
        catch (ParserConfigurationException e) {
            parserFactory.setNamespaceAware(true);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }
}

