/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.pagelet.storage.impl;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.pagelet.common.log.LogManager;
import com.cognos.cps.pagelet.storage.common.AsmTypeHelper;
import com.cognos.cps.pagelet.storage.common.Cache;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.IServiceImplementation;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.pagelet.objects.v1.types.AccessRightsType;
import com.cognos.cps.services.pagelet.objects.v1.types.Layout;
import com.cognos.cps.services.pagelet.objects.v1.types.Metadata;
import com.cognos.cps.services.pagelet.objects.v1.types.Pagelet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalPackage;
import com.cognos.cps.services.pagelet.objects.v1.types.Portlet;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletFolder;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletInstance;
import com.cognos.cps.services.pagelet.objects.v1.types.PortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.InvalidCredentialsFault;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPageletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBinding;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBindingResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContext;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContextResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortlet;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistration;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistrationResponse;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;

public class StorageImpl
implements IStorage,
IServiceImplementation {
    private static final String PORTAL_PACKAGE_BASE = "/cps4/asm/resource/portalPackage/";
    private static final String WSRP_VIEW_MODE = "wsrp:view";
    public static final String PORTLET_VIRTUAL_ID = "PORTLETID";
    protected PortalPackage portalPackage;
    private Map cache;
    protected ServiceLogger logger;

    public StorageImpl(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(StorageImpl.class) : LogManager.getLogManager().getLogger(StorageImpl.class);
        this.cache = new Cache(1800L, 7200L);
    }

    protected String getPackagePath(IContext context) throws ServiceException {
        String packageName = (String)context.getProperty("package");
        if (packageName == null) {
            this.logger.error("Cannot find portal package in the context");
            Object[] args = new String[]{StorageImpl.class.toString()};
            throw new ServiceException("cps.services.initializefailed", args);
        }
        return PORTAL_PACKAGE_BASE + packageName + ".xml";
    }

    public void initialize(IContext context) throws ServiceException {
        String path = StorageImpl.class.getPackage().getName().replace('.', '/') + this.getPackagePath(context);
        InputStream inputStream = StorageImpl.class.getClassLoader().getResourceAsStream(path);
        if (inputStream != null) {
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                this.portalPackage = (PortalPackage)AsmTypeHelper.deserializeAsmObj(reader, "portalPackage");
            }
            catch (Exception e) {
                this.logger.error("Could not load portal package : " + path, (Throwable)e);
                Object[] args = new String[]{StorageImpl.class.toString(), e.getLocalizedMessage()};
                throw new ServiceException("cps.services.initializefailed", args);
            }
        } else {
            this.logger.error("Cannot find portal package: " + path);
            Object[] args = new String[]{StorageImpl.class.toString()};
            throw new ServiceException("cps.services.initializefailed", args);
        }
    }

    public void terminate() throws ServiceException {
    }

    private QueryPageletResponse queryPortletAsPagelet(QueryPagelet queryPagelet, StoragePath storagePath, IContext context) throws OperationFailedFault {
        Pagelet pagelet = new Pagelet();
        pagelet.setPath(queryPagelet.getPath());
        PortletRef portletRef = new PortletRef();
        StorageImpl.findPortlet(this.portalPackage, storagePath, portletRef);
        if (portletRef.portlet != null) {
            pagelet.setDescription(portletRef.portlet.getDescription());
            pagelet.setName(portletRef.portlet.getName());
            PortletInstance portletInstance = new PortletInstance();
            portletInstance.setId(PORTLET_VIRTUAL_ID);
            portletInstance.setPortletId(portletRef.portlet.getId());
            portletInstance.setPortletContext((PortletContext)this.clone(portletRef.portlet.getPortletContext()));
            portletInstance.addAccessRights(AccessRightsType.READONLY);
            portletInstance.addAccessModes(WSRP_VIEW_MODE);
            pagelet.addPortletInstance(portletInstance);
            String defaultLayout = "<cps:layout xmlns:cps=\"http://developer.cognos.com/schemas/cps/asm/objects/1/\"><layout><portletOptions hideBorders=\"false\" hideTitleBars=\"false\" hideEditMode=\"false\"/><column width=\"100\"><portlet id=\"PORTLETID\"/></column></layout></cps:layout>";
            Layout layout = (Layout)AsmTypeHelper.deserializeAsmObj(new StringReader(defaultLayout), "layout");
            pagelet.setLayout(layout);
            Metadata metadata = new Metadata();
            pagelet.setMetadata(metadata);
            PortletProducer portletProducer = (PortletProducer)this.clone(portletRef.portletProducer);
            portletProducer.clearPortlet();
            Portlet portlet = (Portlet)this.clone(portletRef.portlet);
            portletProducer.addPortlet(portlet);
            metadata.addPortletProducer(portletProducer);
        }
        QueryPageletResponse queryPageletResponse = new QueryPageletResponse();
        queryPageletResponse.setPagelet(pagelet);
        return queryPageletResponse;
    }

    public QueryPageletResponse queryPagelet(QueryPagelet queryPagelet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        StoragePath storagePath = this.resolvePath(queryPagelet.getPath());
        if (!storagePath.isPortletPath || this.portalPackage == null) {
            throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
        }
        Object cacheEntry = this.cache.get(queryPagelet.getPath());
        if (cacheEntry != null) {
            return (QueryPageletResponse)this.toObject((byte[])cacheEntry);
        }
        QueryPageletResponse response = this.queryPortletAsPagelet(queryPagelet, storagePath, context);
        this.cache.put(queryPagelet.getPath(), this.toByteArray(response));
        return response;
    }

    public QueryPortletProducerResponse queryPortletProducer(QueryPortletProducer queryPortletProducer, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    public SavePortletProducerResponse savePortletProducer(SavePortletProducer savePortletProducer, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    public SavePortletResponse savePortlet(SavePortlet savePortlet, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    public SaveRegistrationResponse saveRegistration(SaveRegistration saveRegistration, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    public SaveBindingResponse saveBinding(SaveBinding saveBinding, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    public SaveContextResponse saveContext(SaveContext saveContext, IContext context) throws OperationFailedFault, InvalidCredentialsFault {
        throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)new UnsupportedOperationException());
    }

    private StoragePath resolvePath(String path) throws OperationFailedFault {
        if (path == null || !path.startsWith("/") || path.indexOf("/", 1) == -1) {
            Object[] args = new String[]{path};
            throw new OperationFailedFault("cps.pagelet.storage.invalidpath.failed", args, null);
        }
        int index = path.indexOf("/", 1);
        StoragePath storagePath = new StoragePath();
        storagePath.packageName = path.substring(1, index);
        String tempPath = path.substring(index + 1);
        if (tempPath.startsWith("portlet:")) {
            tempPath = tempPath.substring(8);
            storagePath.isPortletPath = true;
        }
        if (tempPath.startsWith("path:")) {
            tempPath = tempPath.substring(5);
            storagePath.isPath = true;
        }
        storagePath.path = tempPath;
        return storagePath;
    }

    private static void findPortlet(PortalPackage portalPackage, StoragePath storagePath, PortletRef portletRef) {
        if (storagePath.isPath) {
            StringTokenizer tokens = new StringTokenizer(storagePath.path, "/");
            StorageImpl.findPortletByPath(portalPackage, tokens, portletRef);
        } else {
            StorageImpl.findPortletById(portalPackage, storagePath.path, portletRef);
        }
    }

    private static void findPortletByPath(PortletProducer portletProducer, String portletName, PortletRef portletRef) {
        Portlet[] portlets = portletProducer.getPortlet();
        if (portlets != null) {
            for (int i = 0; i < portlets.length; ++i) {
                Portlet portlet = portlets[i];
                if (!portletName.equals(portlet.getName())) continue;
                portletRef.portlet = portlet;
                return;
            }
        }
    }

    private static void findPortletByPath(PortletFolder parentFolder, StringTokenizer tokens, PortletRef portletRef) {
        block5: {
            int tokenCount;
            block4: {
                tokenCount = tokens.countTokens();
                if (tokenCount <= 2) break block4;
                String folderName = tokens.nextToken();
                PortletFolder[] portletFolders = parentFolder.getPortletFolder();
                if (portletFolders == null) break block5;
                for (int i = 0; i < portletFolders.length; ++i) {
                    PortletFolder portletFolder = portletFolders[i];
                    if (!folderName.equals(portletFolder.getName())) continue;
                    StorageImpl.findPortletByPath(portletFolder, tokens, portletRef);
                    return;
                }
                break block5;
            }
            if (tokenCount == 2) {
                String producerName = tokens.nextToken();
                PortletProducer[] portletProducers = parentFolder.getPortletProducer();
                if (portletProducers != null) {
                    for (int i = 0; i < portletProducers.length; ++i) {
                        PortletProducer portletProducer = portletProducers[i];
                        if (!producerName.equals(portletProducer.getName())) continue;
                        portletRef.portletProducer = portletProducer;
                        StorageImpl.findPortletByPath(portletProducer, tokens.nextToken(), portletRef);
                        return;
                    }
                }
            }
        }
    }

    private static void findPortletByPath(PortalPackage portalPackage, StringTokenizer tokens, PortletRef portletRef) {
        int tokenCount = tokens.countTokens();
        if (tokenCount > 2) {
            String folderName = tokens.nextToken();
            PortletFolder[] portletFolders = portalPackage.getPortletFolder();
            if (portletFolders != null) {
                for (int i = 0; i < portletFolders.length; ++i) {
                    PortletFolder portletFolder = portletFolders[i];
                    if (!folderName.equals(portletFolder.getName())) continue;
                    StorageImpl.findPortletByPath(portletFolder, tokens, portletRef);
                    return;
                }
            }
        }
    }

    private static boolean findPortletById(PortletProducer portletProducer, String id, PortletRef portletRef) {
        Portlet[] portlets = portletProducer.getPortlet();
        if (portlets != null) {
            for (int i = 0; i < portlets.length; ++i) {
                Portlet portlet = portlets[i];
                if (!id.equals(portlet.getId())) continue;
                portletRef.portlet = portlet;
                return true;
            }
        }
        return false;
    }

    private static boolean findPortletById(PortletFolder parentFolder, String id, PortletRef portletRef) {
        PortletFolder[] portletFolders;
        PortletProducer[] portletProducers = parentFolder.getPortletProducer();
        if (portletProducers != null) {
            for (int i = 0; i < portletProducers.length; ++i) {
                PortletProducer portletProducer = portletProducers[i];
                if (!StorageImpl.findPortletById(portletProducer, id, portletRef)) continue;
                portletRef.portletProducer = portletProducer;
                return true;
            }
        }
        if ((portletFolders = parentFolder.getPortletFolder()) != null) {
            for (int i = 0; i < portletFolders.length; ++i) {
                PortletFolder portletFolder = portletFolders[i];
                if (!StorageImpl.findPortletById(portletFolder, id, portletRef)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findPortletById(PortalPackage portalPackage, String id, PortletRef portletRef) {
        PortletFolder[] portletFolders = portalPackage.getPortletFolder();
        if (portletFolders != null) {
            for (int i = 0; i < portletFolders.length; ++i) {
                PortletFolder portletFolder = portletFolders[i];
                if (!StorageImpl.findPortletById(portletFolder, id, portletRef)) continue;
                return true;
            }
        }
        return false;
    }

    private Object clone(Object oldObj) throws OperationFailedFault {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(oldObj);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            this.logger.error("Error while trying to clone object from cache ", (Throwable)e);
            throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)e);
        }
        finally {
            try {
                oos.close();
                ois.close();
            }
            catch (IOException e1) {
                this.logger.error("Could not close input/output when trying to clone object ", (Throwable)e1);
            }
        }
    }

    private Object toObject(byte[] bytes) throws OperationFailedFault {
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bin);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            this.logger.error("Could not deserialize byte[] to object ", (Throwable)e);
            throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)e);
        }
        finally {
            try {
                ois.close();
            }
            catch (IOException e1) {
                this.logger.error("Could not close input stream while deserialize byte[] to object ", (Throwable)e1);
            }
        }
    }

    private byte[] toByteArray(Object object) throws OperationFailedFault {
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            this.logger.error("Could not serialize object into bytes ", (Throwable)e);
            throw new OperationFailedFault("cps.pagelet.storage.operation.failed", null, (Throwable)e);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException e1) {
                this.logger.error("Could close outputSteam while serializing object into bytes ", (Throwable)e1);
            }
        }
    }

    class PortletRef {
        Portlet portlet;
        PortletProducer portletProducer;

        PortletRef() {
        }
    }

    class StoragePath {
        String path;
        String packageName;
        boolean isPath;
        boolean isPortletPath;

        StoragePath() {
        }
    }
}

