/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.portlet;

import com.cognos.cps.portlet.HandlerManager;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.interpreter.instructions.AXTSInstruction;
import com.cognos.xts.interpreter.instructions.IXTSInstructionResult;
import com.cognos.xts.interpreter.instructions.XTSInstructionException;
import com.cognos.xts.interpreter.instructions.transform.IXTSTransformInstruction;
import com.cognos.xts.interpreter.instructions.transform.XTSTransformResult;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CPSWebRewriter
extends AXTSInstruction
implements IXTSTransformInstruction {
    private String m_identifier = null;

    public String getIdentifier() {
        return this.m_identifier;
    }

    public void initialize(XTSEnvironment env, String identifier, Map instAtts, Map instParams) throws XTSInstructionException {
        this.m_identifier = identifier;
    }

    public void terminate() {
        this.m_identifier = null;
    }

    public boolean isInitialized() {
        return this.m_identifier != null;
    }

    public IXTSInstructionResult execute(XTSEnvironment env, Map instAtts, Map instParams, Reader body) throws XTSInstructionException {
        try {
            SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler th = stf.newTransformerHandler();
            DOMResult dr = new DOMResult();
            th.setResult(dr);
            Parser parser = new Parser();
            parser.setContentHandler((ContentHandler)th);
            InputSource htmlBody = new InputSource(body);
            parser.parse(htmlBody);
            Node root = dr.getNode();
            if (instAtts.get("scope") == null || ((String)instAtts.get("scope")).length() == 0) {
                instAtts.put("scope", "CognosConnect");
            }
            if (instAtts.get("namespacePrefix") == null) {
                instAtts.put("namespacePrefix", "");
            }
            HandlerManager manager = new HandlerManager(instAtts);
            CPSWebRewriter.wrapRoot(root);
            CPSWebRewriter.insertRequiredNodes(root, instAtts, manager);
            CPSWebRewriter.domSearcher(root, manager);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "html");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(root);
            transformer.transform(source, result);
            String strTemp = writer.toString();
            StringReader reader = new StringReader(strTemp);
            return new XTSTransformResult((IXTSTransformInstruction)this, (Reader)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void domSearcher(Node current, HandlerManager manager) {
        if (!current.hasChildNodes()) {
            manager.modifyNode(current);
            return;
        }
        Node childNode = current.getFirstChild();
        while (childNode != null) {
            Node nextChild = childNode.getNextSibling();
            CPSWebRewriter.domSearcher(childNode, manager);
            childNode = nextChild;
        }
        manager.modifyNode(current);
    }

    private static Element wrapRoot(Node docRoot) {
        ArrayList<Node> childList = new ArrayList<Node>();
        while (docRoot.hasChildNodes()) {
            Node child = docRoot.getFirstChild();
            docRoot.removeChild(child);
            childList.add(child);
        }
        Element newRoot = ((Document)docRoot).createElement("div");
        newRoot.setAttribute("rwroot", "");
        docRoot.appendChild(newRoot);
        for (int i = 0; i < childList.size(); ++i) {
            newRoot.appendChild((Node)childList.get(i));
        }
        return newRoot;
    }

    private static void insertRequiredNodes(Node docRoot, Map instAttr, HandlerManager manager) {
        manager.addRequiredNode(docRoot, "addLocalizationScript");
        manager.addRequiredNode(docRoot, "addForm");
        manager.addRequiredNode(docRoot, "addInstAttr");
        manager.addRequiredNode(docRoot, "addPortletAPIScript");
        manager.addRequiredNode(docRoot, "addLibMapScript");
    }
}

