/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.portlet;

import com.cognos.cps.portlet.RewriterHandler;
import com.cognos.cps.portlet.RewriterUtils;
import com.cognos.portal.utils.Parameters;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenericHandler
implements RewriterHandler {
    protected Map instAttr;
    protected Parameters cssMappings;

    public GenericHandler(Map instAttr) {
        this.instAttr = instAttr;
        this.cssMappings = Parameters.parse((String)((String)instAttr.get("cssMappingQuery")));
    }

    @Override
    public boolean canHandle(Node node) {
        return true;
    }

    @Override
    public void modify(Node node) {
        this.makeAbsoluteURI(node);
        this.addAttributeNamespacePrefix(node);
        this.replaceCSSClasses(node);
    }

    protected boolean makeAbsoluteURI(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String url = "";
        if (attributes == null) {
            return false;
        }
        Node path = attributes.getNamedItem("src");
        if (path != null) {
            url = path.getNodeValue();
        } else {
            path = attributes.getNamedItem("href");
            if (path != null) {
                url = path.getNodeValue();
            } else {
                return false;
            }
        }
        String absolute = url;
        String remoteUrl = (String)this.instAttr.get("remoteUrl");
        if (!url.startsWith("http") && !url.startsWith("wsrp_rewrite") && remoteUrl != null) {
            int index;
            if (url.startsWith("/")) {
                int startIndex = remoteUrl.indexOf("://");
                startIndex = startIndex > -1 ? (startIndex += 3) : 0;
                index = remoteUrl.indexOf(47, startIndex);
            } else {
                index = remoteUrl.lastIndexOf(47);
            }
            if (index != -1) {
                String base = remoteUrl.substring(0, index);
                if (!url.startsWith("/")) {
                    base = base + "/";
                }
                absolute = base + url;
            }
        }
        path.setNodeValue(absolute);
        return true;
    }

    protected void addAttributeNamespacePrefix(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        String scope = (String)this.instAttr.get("scope");
        String nsPrefix = (String)this.instAttr.get("namespacePrefix");
        Pattern scopePattern = RewriterUtils.buildNamespacePattern(scope);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String value = attr.getNodeValue();
            attr.setNodeValue(RewriterUtils.namespaceMatcher(scopePattern, value, nsPrefix));
        }
    }

    protected void replaceCSSClasses(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        Node classNode = attributes.getNamedItem("class");
        if (classNode == null) {
            return;
        }
        String[] originalClasses = classNode.getNodeValue().split(" ");
        StringBuilder replacedClasses = new StringBuilder();
        for (int i = 0; i < originalClasses.length; ++i) {
            replacedClasses.append(this.getMappedCssClass(originalClasses[i]));
            if (i >= originalClasses.length - 1) continue;
            replacedClasses.append(" ");
        }
        classNode.setNodeValue(replacedClasses.toString());
    }

    private String getMappedCssClass(String original) {
        String value = this.cssMappings.getValue(original);
        if (value == null) {
            return original;
        }
        return value;
    }
}

