/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.portlet;

import com.cognos.cps.portlet.GenericHandler;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ScriptHandler
extends GenericHandler {
    public ScriptHandler(Map instAttr) {
        super(instAttr);
    }

    @Override
    public boolean canHandle(Node node) {
        String nodeName = node.getNodeName();
        return nodeName.equalsIgnoreCase("script");
    }

    @Override
    public void modify(Node node) {
        this.makeAbsoluteURI(node);
        this.addAttributeNamespacePrefix(node);
        this.addToScriptMap(node);
        this.addScriptNamespacePrefix(node);
        this.replaceCSSClasses(node);
    }

    private boolean addToScriptMap(Node node) {
        Node text = node.getFirstChild();
        if (text != null && !text.getNodeValue().equalsIgnoreCase("")) {
            return false;
        }
        Element replacement = node.getOwnerDocument().createElement("script");
        replacement.setAttribute("language", "javascript");
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        StringBuilder scriptTag = new StringBuilder("<" + node.getNodeName());
        String src = "";
        String srcAttrName = node.getNodeName().equalsIgnoreCase("script") ? "src" : "href";
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if (attr.getNodeName().equalsIgnoreCase(srcAttrName)) {
                src = attr.getNodeValue();
            }
            scriptTag.append(" " + attr.getNodeName() + "=" + "'" + attr.getNodeValue() + "'");
        }
        scriptTag.append(">");
        String key = "k_" + String.valueOf(src.hashCode()).replace('-', '_');
        StringBuffer scriptDocumentWrite = new StringBuffer();
        scriptDocumentWrite.append("if (!window.CognosCPSLoadedLibMap['" + key + "']){\r\n" + "document.write(\"");
        scriptDocumentWrite.append(scriptTag.toString());
        scriptDocumentWrite.append("</\" + \"script>\");\r\nwindow.CognosCPSLoadedLibMap['" + key + "'] = true;\r\n" + "}");
        Text textNode = node.getOwnerDocument().createTextNode(scriptDocumentWrite.toString());
        replacement.appendChild(textNode);
        Node parent = node.getParentNode();
        parent.insertBefore(replacement, node);
        parent.removeChild(node);
        return true;
    }

    private void addScriptNamespacePrefix(Node node) {
        String scope = (String)this.instAttr.get("scope");
        String nsPrefix = (String)this.instAttr.get("namespacePrefix");
        Node textNode = node.getFirstChild();
        if (textNode == null) {
            return;
        }
        String text = textNode.getNodeValue();
        if (text == null || text.equalsIgnoreCase("")) {
            return;
        }
        StringBuilder prefixPattern = new StringBuilder();
        prefixPattern.append("(?<![A-Za-z0-9])");
        prefixPattern.append(scope);
        prefixPattern.append("(?![A-Za-z0-9])");
        Pattern scopePattern = Pattern.compile(prefixPattern.toString());
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = scopePattern.matcher(text);
        while (matcher.find()) {
            String group = matcher.group();
            if (group == null) continue;
            matcher.appendReplacement(buffer, nsPrefix + group);
        }
        matcher.appendTail(buffer);
        node.getFirstChild().setNodeValue(buffer.toString());
    }
}

