/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.portlet.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;
import org.dom4j.Element;

public class LegacyApplicationConverter {
    Document applicationDocument;

    public LegacyApplicationConverter(Document applicationDocument) {
        this.applicationDocument = applicationDocument;
    }

    public void writeApplications(XMLStreamWriter writer) throws XMLStreamException {
        List applications = this.applicationDocument.selectNodes("/StudioApplicationIndex/ApplicationList/Application[@Cps='true']");
        for (int i = 0; i < applications.size(); ++i) {
            this.convertApplication((Element)applications.get(i), writer);
        }
    }

    private void convertApplication(Element element, XMLStreamWriter writer) throws XMLStreamException {
        String component = element.valueOf("Component");
        if ("TEST".equals(component)) {
            return;
        }
        String alias = element.valueOf("Alias");
        String title = element.valueOf("Title");
        String description = element.valueOf("Description");
        ArrayList<String> urlParams = new ArrayList<String>();
        String urlValue = this.getUrlParamValue(element, urlParams);
        writer.writeStartElement("application");
        writer.writeStartElement("id");
        writer.writeCharacters(alias);
        writer.writeEndElement();
        writer.writeStartElement("title");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeStartElement("description");
        writer.writeCharacters(description);
        writer.writeEndElement();
        writer.writeStartElement("url");
        writer.writeCharacters(urlValue);
        writer.writeEndElement();
        this.writeProperties(element, writer, urlParams);
        if ("CPS".equals(component)) {
            writer.writeStartElement("features");
            writer.writeStartElement("feature");
            writer.writeCharacters("legacy");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeProperties(Element element, XMLStreamWriter writer, List<String> excludeParams) throws XMLStreamException {
        boolean isProps = false;
        List parameters = element.selectNodes("Param");
        for (int i = 0; i < parameters.size(); ++i) {
            Element parameter = (Element)parameters.get(i);
            String name = parameter.valueOf("@UseGlobalParam");
            if (excludeParams.contains(name)) continue;
            if (!isProps) {
                writer.writeStartElement("properties");
                writer.writeStartElement("propertyGroup");
                writer.writeStartElement("title");
                writer.writeEndElement();
                writer.writeStartElement("description");
                writer.writeEndElement();
                isProps = true;
            }
            String value = parameter.getTextTrim();
            String label = this.applicationDocument.valueOf("/StudioApplicationIndex/GlobalParamList/GlobalParam[@Name='" + name + "']/@Label");
            String type = this.applicationDocument.valueOf("/StudioApplicationIndex/GlobalParamList/GlobalParam[@Name='" + name + "']/@Type");
            writer.writeStartElement("property");
            writer.writeStartElement("name");
            writer.writeCharacters(name);
            writer.writeEndElement();
            if ("boolean".equals(type)) {
                this.writeBooleanType(label, "true".equalsIgnoreCase(value), writer);
            } else if ("enum".equals(type)) {
                HashMap<String, String> values = new HashMap<String, String>();
                List valueNodes = this.applicationDocument.selectNodes("/StudioApplicationIndex/GlobalParamList/GlobalParam[@Name='" + name + "']/Value");
                for (int j = 0; j < valueNodes.size(); ++j) {
                    Element e = (Element)valueNodes.get(j);
                    values.put(e.valueOf("@Name"), e.getTextTrim());
                }
                this.writeEnumType(label, values, value, writer);
            } else {
                String size = this.applicationDocument.valueOf("/StudioApplicationIndex/GlobalParamList/GlobalParam[@Name='" + name + "']/@Size");
                this.writeTextType(label, size, value, writer);
            }
            writer.writeEndElement();
        }
        if (isProps) {
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeTextType(String label, String size, String defaultValue, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("control");
        writer.writeStartElement("type");
        writer.writeCharacters("text");
        writer.writeEndElement();
        if (size != null && size.length() > 0) {
            writer.writeStartElement("size");
            writer.writeCharacters(size);
            writer.writeEndElement();
        }
        if (defaultValue != null) {
            writer.writeStartElement("defaultValue");
            writer.writeCharacters(defaultValue);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeEnumType(String label, Map<String, String> values, String defaultValue, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("control");
        writer.writeStartElement("type");
        writer.writeCharacters("checkbox");
        writer.writeEndElement();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            writer.writeStartElement("choice");
            writer.writeStartElement("label");
            writer.writeCharacters(entry.getValue());
            writer.writeEndElement();
            writer.writeStartElement("value");
            writer.writeCharacters(entry.getKey());
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (defaultValue != null) {
            writer.writeStartElement("defaultValue");
            writer.writeCharacters(defaultValue);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeBooleanType(String label, boolean defaultValue, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("control");
        writer.writeStartElement("type");
        writer.writeCharacters("checkbox");
        writer.writeEndElement();
        writer.writeStartElement("choice");
        writer.writeStartElement("label");
        writer.writeCharacters(label);
        writer.writeEndElement();
        writer.writeStartElement("value");
        writer.writeCharacters("true");
        writer.writeEndElement();
        writer.writeEndElement();
        if (defaultValue) {
            writer.writeStartElement("defaultValue");
            writer.writeCharacters("true");
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String getUrlParamValue(Element element, List<String> urlParams) {
        String component = element.valueOf("Component");
        String service = this.applicationDocument.valueOf("/StudioApplicationIndex/ComponentList/Component[@Name='" + component + "']/@Service");
        String url = this.applicationDocument.valueOf("/StudioApplicationIndex/ServiceList/Service[@Name='" + service + "']/Url");
        List parameters = element.selectNodes("Param");
        for (int i = 0; i < parameters.size(); ++i) {
            Element parameter = (Element)parameters.get(0);
            String name = parameter.valueOf("@UseGlobalParam");
            String value = parameter.getTextTrim();
            String pattern = "[$" + name + "$]";
            if (url.indexOf(pattern) == -1) continue;
            url = url.replace(pattern, value);
            urlParams.add(name);
        }
        return url;
    }
}

