/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.portlet.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.portlet.service.LegacyApplicationConverter;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.StringUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.service.IInputStreamRetriever;
import com.cognos.portal.service.InputStreamRetriever;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PortletService
extends BasicHandler {
    private PogoEngine engine;
    private IInputStreamRetriever retriever;
    private String legacyApplicationUrl;
    private final ServiceLogger serviceLogger;
    private static final String APP_LOCATION = "/WEB-INF/cpsapps/";
    private static final String APP_SPEC_NAME = "application.xml";
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(PortletService.class.getName());
    private final ReadWriteLock mutex = new ReadWriteLock();

    public void configure(Configuration configuration) {
        block2: {
            ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
            try {
                Element e = cclConfiguration.getValueElement("CPS", true);
                this.legacyApplicationUrl = e.valueOf("./*[@name='applications']/crn:value");
            }
            catch (CCLConfigurationException e) {
                if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block2;
                this.serviceLogger.error("an exception was encountered when attempting to configure the portlet service", (Throwable)e);
            }
        }
    }

    public void reconfigure(Configuration configuration) {
        super.configure(configuration);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.engine = engine;
        this.retriever = new InputStreamRetriever(engine);
        super.compose_impl(engine);
    }

    public PortletService() {
        this(category);
    }

    public PortletService(Logger logger) {
        super(logger);
        this.serviceLogger = new ServiceLoggerImpl(PortletService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            this.mutex.acquireReadLock();
            try {
                String path = (String)mc.getProperty("path_info");
                String action = "";
                int position = path.indexOf("/", 1);
                if (position != -1) {
                    action = path.substring(path.indexOf("/", 1));
                }
                ArrayList<String> additionalHeaders = new ArrayList<String>();
                String contentType = "";
                InputStream result = null;
                String[] actions = action.split("/");
                if (actions.length >= 2 && actions[1].equalsIgnoreCase("applications")) {
                    contentType = "text/xml;charset=UTF-8";
                    if (actions.length >= 3) {
                        String application = actions[2];
                        result = this.getApplications(application);
                    } else {
                        result = this.getApplications("");
                    }
                }
                if (result != null && result.available() > 0) {
                    String statusCode = "200";
                    String statusMessage = "OK";
                    this.createSuccessResponse(mc, contentType, additionalHeaders, result, statusCode, statusMessage);
                } else {
                    this.createNotFoundResponse(mc);
                }
            }
            finally {
                this.mutex.releaseReadLock();
            }
        }
        catch (Exception e) {
            if (this.serviceLogger != null && this.serviceLogger.isErrorEnabled()) {
                this.serviceLogger.error("an exception was encountered when attempting acquire read lock to handle request", (Throwable)e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    private void createSuccessResponse(MessageContext mc, String ctype, List<String> additionalHeaders, InputStream stream, String statusCode, String statusMessage) throws UnsupportedEncodingException {
        StringBuffer header = new StringBuffer(32);
        header.append("Content-Type: ").append(ctype).append("\r\n");
        if (additionalHeaders != null) {
            for (String value : additionalHeaders) {
                header.append(value).append("\r\n");
            }
        }
        header.append("\r\n");
        mc.setProperty("response.status_code", (Object)statusCode);
        mc.setProperty("response.status_msg", (Object)statusMessage);
        InternetHeaders headers = new InternetHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=utf-8");
        mc.setProperty(".responseheaders", (Object)headers);
        BIBusEnvelope env = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)env);
        ArrayList<SequenceInputStream> attachments = new ArrayList<SequenceInputStream>();
        attachments.add(new SequenceInputStream(new ByteArrayInputStream(header.toString().getBytes("UTF-8")), stream));
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        mc.setProperty("response.attachments", attachments.iterator());
    }

    private void createNotFoundResponse(MessageContext mc) {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        mc.setProperty("response.envelope", (Object)responseEnvelope);
        mc.setProperty("response.status_code", (Object)"404");
    }

    private InputStream getApplications(String application) throws Exception {
        String[] appFiles = this.engine.getContext().getResourcePaths(APP_LOCATION).toArray(new String[0]);
        String[] appPaths = new String[appFiles.length];
        for (int i = 0; i < appFiles.length; ++i) {
            String path = appFiles[i].replaceFirst(APP_LOCATION, "");
            appPaths[i] = path.replaceAll("/", "");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLStreamWriter writer = XMLStreamFactory.createXMLStreamWriter((OutputStream)output);
        writer.writeStartElement("applications");
        XMLStreamReader reader = null;
        InputStream inputStream = null;
        for (int i = 0; i < appFiles.length; ++i) {
            if (!application.equalsIgnoreCase("") && !appFiles[i].contains("/" + application + "/") || (inputStream = this.engine.getContext().getResourceAsStream(appFiles[i] + APP_SPEC_NAME)) == null || (reader = XMLStreamFactory.createXMLStreamReader((InputStream)inputStream, (String)"UTF-8")).nextTag() == -1) continue;
            writer.writeStartElement(reader.getLocalName());
            writer.writeStartElement("path");
            writer.writeCharacters(appPaths[i]);
            writer.writeEndElement();
            StaxUtils.copyChildren((XMLStreamReader)reader, (XMLStreamWriter)writer);
            writer.writeEndElement();
            reader.close();
        }
        this.getLegacyApplications(writer);
        writer.writeEndElement();
        writer.close();
        return new ByteArrayInputStream(output.toByteArray());
    }

    private void getLegacyApplications(XMLStreamWriter writer) {
        block3: {
            if (this.legacyApplicationUrl != null && this.legacyApplicationUrl.length() > 0) {
                try {
                    URL url = new URL(this.legacyApplicationUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.connect();
                    InputStream in = connection.getInputStream();
                    SAXReader saxReader = new SAXReader();
                    Document applicationDocument = saxReader.read(in);
                    LegacyApplicationConverter applicationConverter = new LegacyApplicationConverter(applicationDocument);
                    applicationConverter.writeApplications(writer);
                }
                catch (Exception e) {
                    if (this.serviceLogger == null || !this.serviceLogger.isErrorEnabled()) break block3;
                    this.serviceLogger.error("an exception was encountered when attempting to request the legacy application xml file", (Throwable)e);
                }
            }
        }
    }
}

