<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/request-common.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/"
	xmlns:bus="http://developer.cognos.com/schemas/bibus/3/"
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>

	<xsl:variable name="op" select="/root/SOAP-ENV:Envelope/SOAP-ENV:Body/*[1]"/>
	<xsl:variable name="op-name" select="local-name($op)"/>
	<xsl:variable name="skipObjects" select="$op/nav:skipObjects"/>
	<xsl:variable name="maxObjects" select="$op/nav:maxObjects"/>
	<xsl:variable name="validateTag">
		<xsl:if test="starts-with($op/nav:validateTag, /root/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/bus:CAM/CAMPassport/id)">
			<xsl:value-of select="substring-after($op/nav:validateTag, /root/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/bus:CAM/CAMPassport/id)"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="sort-order">
		<xsl:choose>
			<xsl:when test="$op/nav:sort/@order"><xsl:value-of select="$op/nav:sort/@order"/></xsl:when>
			<xsl:otherwise>ascending</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="sort-usage">
		<xsl:choose>
			<xsl:when test="$op/nav:sort/@usage"><xsl:value-of select="$op/nav:sort/@usage"/></xsl:when>
			<xsl:otherwise>ascending</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="sort-prop">
		<xsl:choose>
			<xsl:when test="$op/nav:sort = 'lastModifiedDate'">modificationTime</xsl:when>
			<xsl:when test="$op/nav:sort = 'displaySequence'">displaySequence</xsl:when>
			<xsl:otherwise>defaultName</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:template name="properties">
		<xsl:param name="context"/>
		<xsl:param name="all-base-props" select="true()"/>
		<xsl:param name="is-outer-container" select="false()"/>
		<xsl:param name="is-target" select="false()"/>

		<xsl:variable name="properties" select="$context/nav:property"/>
		<xsl:variable name="description" select="$properties[@name = 'description']"/>
		<xsl:variable name="screenTip" select="$properties[@name = 'screenTip']"/>
		<xsl:variable name="createDate" select="$properties[@name = 'createDate']"/>
		<xsl:variable name="lastModifiedDate" select="$properties[@name = 'lastModifiedDate']"/>
		<xsl:variable name="hasChildren" select="$properties[@name = 'hasChildren']"/>
		<xsl:variable name="disabled" select="$properties[@name = 'icons']"/>
		<!-- fullPath always retrieved for container, optional for children -->
		<xsl:variable name="fullPath" select="$properties[@name = 'fullPath' or @name = 'fullName'  or $is-outer-container]"/>
		<!-- optimization: all container children will have the container's id as parent, don't request it -->
		<xsl:variable name="container-child" select="$op-name = 'getContainer' and not($is-outer-container)"/>
		<xsl:variable name="parentId" select="$properties[@name = 'parentId' and ($is-target or not($container-child))]"/>

		<!-- calculate count for property array, including the 14 base properties -->
		<xsl:variable name="propCount" select="5 + 13 * number( $all-base-props ) + count($description | $screenTip  | $createDate  | $lastModifiedDate  | $fullPath  | $hasChildren | $parentId | $disabled)"/>

		<properties xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:propEnum[{ $propCount }]">
			<!-- base properties -->
			<item xsi:type="cm:propEnum">searchPath</item>                <!-- nav:id, nav:fullName, nav:url, nav:action -->
			<item xsi:type="cm:propEnum">storeID</item>
			<item xsi:type="cm:propEnum">defaultName</item>               <!-- nav:name, nav:url, nav:action -->
			<item xsi:type="cm:propEnum">objectClass</item>               <!-- nav:imgURL, nav:url, nav:action -->
			<item xsi:type="cm:propEnum">permissions</item>               <!-- nav:url, nav:action -->

			<xsl:if test="$all-base-props = true()">
				<item xsi:type="cm:propEnum">defaultOutputFormat</item>    <!-- nav:imgURL, nav:url -->
				<item xsi:type="cm:propEnum">defaultPortalAction</item>     <!-- nav:url -->				
				<item xsi:type="cm:propEnum">format</item>                 <!-- nav:url -->
				<item xsi:type="cm:propEnum">target</item>                 <!-- nav:url, nav:action -->
				<item xsi:type="cm:propEnum">base</item>                   <!-- nav:url, nav:action -->
				<item xsi:type="cm:propEnum">uri</item>                    <!-- nav:url -->
				<item xsi:type="cm:propEnum">position</item>               <!-- nav:content -->
				<item xsi:type="cm:propEnum">userInterfaces</item>         <!-- package type calculation -->

				<item xsi:type="cm:propEnum">hasPrompts</item>             <!-- powerplay support -->
				<item xsi:type="cm:propEnum">gateway</item>                <!-- powerplay support -->
				<item xsi:type="cm:propEnum">cubeContentName</item>        <!-- powerplay support -->
				<item xsi:type="cm:propEnum">options</item>                <!-- powerplay support -->
				<item xsi:type="cm:propEnum">executionFormat</item>
			</xsl:if>

			<!-- optional properties -->
			<xsl:if test="$description">
				<item xsi:type="cm:propEnum">defaultDescription</item>     <!-- nav:description, nav:screenTip -->
			</xsl:if>
			<xsl:if test="$screenTip">
				<item xsi:type="cm:propEnum">defaultScreenTip</item>       <!-- nav:screenTip -->
			</xsl:if>
			<xsl:if test="$createDate">
				<item xsi:type="cm:propEnum">creationTime</item>           <!-- nav:createDate -->
			</xsl:if>
			<xsl:if test="$lastModifiedDate">
				<item xsi:type="cm:propEnum">modificationTime</item>       <!-- nav:lastModifiedDate -->
			</xsl:if>
			<xsl:if test="$fullPath">
				<item xsi:type="cm:propEnum">ancestors</item>              <!-- nav:fullPath -->
			</xsl:if>
			<xsl:if test="$hasChildren">
				<item xsi:type="cm:propEnum">hasChildren</item>            <!-- nav:hasChildren -->
			</xsl:if>
			<xsl:if test="$parentId">
				<item xsi:type="cm:propEnum">parent</item>                 <!-- nav:parentId -->
			</xsl:if>
			<xsl:if test="$disabled">
				<item xsi:type="cm:propEnum">disabled</item>                 <!-- nav:parentId -->
			</xsl:if>			
			<!-- not supported (yet) in baltic/bering:
			<xsl:if test="$context/nav:property[@name = 'newState']">
			</xsl:if>
			<xsl:if test="$context/nav:property[@name = 'readState']">
			</xsl:if>
			<xsl:if test="$context/nav:property[@name = 'status']">
			</xsl:if>
			-->
		</properties>
	</xsl:template>

	<xsl:template name="base-refprop-properties">
		<xsl:param name="context"/>

		<xsl:variable name="properties" select="$context/nav:property"/>
		<xsl:variable name="disabled" select="$properties[@name = 'icons']"/>

		<!-- calculate count for property array, including the 14 base properties -->
		<xsl:variable name="propCount" select="4 + count($disabled)"/>

		<properties xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:propEnum[{ $propCount }]">			
			<item xsi:type="cm:propEnum">searchPath</item>
			<item xsi:type="cm:propEnum">storeID</item>
			<item xsi:type="cm:propEnum">permissions</item>
			<item xsi:type="cm:propEnum">executionFormat</item>
			<xsl:if test="$disabled">
				<item xsi:type="cm:propEnum">disabled</item> 
			</xsl:if>			
		</properties>
	</xsl:template>

	<xsl:template name="userFolderIdRequest">
		<item xsi:type="cm:queryRequest">
			<search xsi:type="xsd:string">~/folder[permission("traverse")]</search>
			<properties xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:propEnum[2]">
				<item xsi:type="cm:propEnum">defaultName</item>
				<item xsi:type="cm:propEnum">searchPath</item>
				<item xsi:type="cm:propEnum">storeID</item>
			</properties>
		</item>
	</xsl:template>

</xsl:stylesheet>