<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/request-query.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/"
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/"
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>

	<xsl:variable name="rootDefaultPath">root</xsl:variable>
	<xsl:variable name="systemDefaultPath">/content</xsl:variable>
	<xsl:variable name="userDefaultPath">~/folder</xsl:variable>

	<xsl:include href="nav/request-common.xslt"/>

	<xsl:variable name="path">
		<xsl:choose>
			<xsl:when test="$op/nav:id = 'rootDefault'">
				<xsl:value-of select="$rootDefaultPath"/>
			</xsl:when>
			<xsl:when test="$op/nav:id = 'systemDefault'">
				<xsl:value-of select="$systemDefaultPath"/>
			</xsl:when>
			<xsl:when test="$op/nav:id = 'userDefault'">
				<xsl:value-of select="$userDefaultPath"/>
			</xsl:when>
			<xsl:when test="(/root/useDeploymentId and $op/nav:deploymentId != '')">
					<xsl:value-of select="xtsext:web64decode( string( $op/nav:deploymentId ), false())"/>
			</xsl:when>
			<xsl:when test="starts-with(string($op/nav:id), '_')">
				<xsl:text>storeID("</xsl:text><xsl:value-of select="substring-after(string($op/nav:id), '_')"/><xsl:text>")</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="xtsext:web64decode( string( $op/nav:id ), false())"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!--
		query - construct a cm query with special handling for fake root
	-->
	<xsl:template match="/">
		<bus:query xmlns:bus="http://developer.cognos.com/schemas/bibus/3/" xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:choose>
				<xsl:when test="$path = $rootDefaultPath">
					<requests xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="bus:queryRequest[2]">
						<xsl:call-template name="userFolderIdRequest"/>
						<xsl:call-template name="queryRequest">
							<xsl:with-param name="path" select="$systemDefaultPath"/>
						</xsl:call-template>
						<xsl:call-template name="queryRequest">
							<xsl:with-param name="path" select="$userDefaultPath"/>
						</xsl:call-template>
					</requests>
				</xsl:when>
				<xsl:when test="$op-name = 'getItem'">
					<requests xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="bus:queryRequest[1]">
						<xsl:call-template name="userFolderIdRequest"/>
						<xsl:call-template name="itemRequest">
							<xsl:with-param name="path" select="$path"/>
						</xsl:call-template>
					</requests>
				</xsl:when>
				<xsl:otherwise>
					<requests xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="bus:queryRequest[2]">
						<xsl:call-template name="userFolderIdRequest"/>
						<xsl:call-template name="containerRequest">
							<xsl:with-param name="path" select="$path"/>
						</xsl:call-template>
						<xsl:if test="$op/nav:childObjects and $op/nav:childObjects != 'none'">
						
							<xsl:call-template name="queryRequest">
								<xsl:with-param name="path">
									<xsl:value-of select="$path"/>
									<xsl:choose>
										<xsl:when test="$op/nav:childObjects = 'all'">
											<xsl:text>/*[@objectClass!='model' and @objectClass!='drillPath' and @objectClass!='packageConfiguration']</xsl:text>
										</xsl:when>
										<xsl:when test="$op/nav:childObjects = 'containers'">
											<xsl:text>/*[@objectClass='folder' or @objectClass='package' or @objectClass='content']</xsl:text>
										</xsl:when>
										<xsl:when test="$op/nav:childObjects = 'items'">
											<xsl:text>/*[@objectClass!='model' and @objectClass!='drillPath' and @objectClass!='packageConfiguration' and @objectClass!='folder' and @objectClass!='package' and @objectClass!='content']</xsl:text>
										</xsl:when>
										<xsl:when test="$op/nav:childObjects = 'urls'">
											<xsl:text>/*[@objectClass='URL']</xsl:text>
										</xsl:when>
										<xsl:when test="$op/nav:childObjects = 'rss'">
											<xsl:text>/*[@objectClass='URL' or @objectClass='shortcut']</xsl:text>
										</xsl:when>
									</xsl:choose>
								</xsl:with-param>
								<xsl:with-param name="skip" select="$skipObjects"/>
								<xsl:with-param name="max" select="$maxObjects"/>
								<xsl:with-param name="sort" select="true()"/>								
							</xsl:call-template>
						</xsl:if>
					</requests>
				</xsl:otherwise>
			</xsl:choose>
			<options xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="bus:queryMultipleOptions">
				<cacheValidator xsi:type="xsd:string">
					<xsl:value-of select="$validateTag"/>
				</cacheValidator>
			</options>
		</bus:query>
	</xsl:template>

	<!--
		containerRequest - generate a single cm query request for the container only
	-->
	<xsl:template name="containerRequest">
		<xsl:param name="path"/>
		<item xsi:type="cm:queryRequest">
			<search xsi:type="xsd:string"><xsl:value-of select="$path"/></search>
			<xsl:call-template name="properties">
				<xsl:with-param name="context" select="$op"/>
				<xsl:with-param name="all-base-props" select="false()"/>
				<xsl:with-param name="is-outer-container" select="true()"/>
			</xsl:call-template>
		</item>			
	</xsl:template>

	<!--
		itemRequest - generate a single cm query request for the item only
	-->
	<xsl:template name="itemRequest">
		<xsl:param name="path"/>
		<item xsi:type="cm:queryRequest">
			<search xsi:type="xsd:string"><xsl:value-of select="$path"/></search>
			<xsl:call-template name="properties">
				<xsl:with-param name="context" select="$op"/>
			</xsl:call-template>
			<options xsi:type="xsd:queryOptions">
				<refProps xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:refProp[2]">
					<item xsi:type="cm:refProp">
						<refPropName xsi:type="cm:propEnum">target</refPropName>
						<xsl:call-template name="properties">
							<xsl:with-param name="context" select="$op"/>
						</xsl:call-template>
					</item>
					<item xsi:type="cm:refProp">
						<refPropName xsi:type="cm:propEnum">base</refPropName>
						<xsl:call-template name="base-refprop-properties">
							<xsl:with-param name="context" select="$op"/>
						</xsl:call-template>
					</item>
				</refProps>
			</options>
		</item>
	</xsl:template>

	<!--
		queryRequest - generate a single cm query request
	-->
	<xsl:template name="queryRequest">
		<xsl:param name="path"/>
		<xsl:param name="skip"/>
		<xsl:param name="max"/>
		<xsl:param name="sort" select="false()"/>	

		<item xsi:type="cm:queryRequest">
			<search xsi:type="xsd:string">
				<xsl:value-of select="$path"/>
				<xsl:text>[permission("read") or permission("write") or permission("execute") or permission("traverse") or permission("setPolicy")]</xsl:text>
			</search>
			<xsl:call-template name="properties">
				<xsl:with-param name="context" select="$op"/>
			</xsl:call-template>			
			<sortBy xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:sort[3]">
				<xsl:choose>
					<xsl:when test="$sort">					
						<item xsi:type="cm:sort">
							<propName xsi:type="cm:propEnum">usage</propName>
							<order xsi:type="cm:orderEnum"><xsl:value-of select="$sort-usage"/></order>
						</item>						
						<item xsi:type="cm:sort">						
							<propName xsi:type="cm:propEnum">displaySequence</propName>
							<order xsi:type="cm:orderEnum">
								<xsl:choose>
									<xsl:when test="$sort-prop = 'displaySequence'"><xsl:value-of select="$sort-order"/></xsl:when>
									<xsl:otherwise>descending</xsl:otherwise>
								</xsl:choose>							
							</order>
						</item>						
						<xsl:if test="$sort-prop != 'displaySequence'">
							<item xsi:type="cm:sort">
								<propName xsi:type="cm:propEnum"><xsl:value-of select="$sort-prop"/></propName>
								<order xsi:type="cm:orderEnum"><xsl:value-of select="$sort-order"/></order>
							</item>					
						</xsl:if>						
					</xsl:when>
					<xsl:otherwise>
						<!-- Default sorting -->
						<item xsi:type="cm:sort">
							<propName xsi:type="cm:propEnum">usage</propName>
							<order xsi:type="cm:orderEnum">ascending</order>
						</item>
						<item xsi:type="cm:sort">
							<propName xsi:type="cm:propEnum">displaySequence</propName>
							<order xsi:type="cm:orderEnum">descending</order>
						</item>
						<item xsi:type="cm:sort">
							<propName xsi:type="cm:propEnum">defaultName</propName>
							<order xsi:type="cm:orderEnum">ascending</order>
						</item>
					</xsl:otherwise>
				</xsl:choose>				
			</sortBy>
			<options xsi:type="xsd:queryOptions">
				<refProps xsi:type="SOAP-ENC:Array" SOAP-ENC:arrayType="cm:refProp[2]">
					<item xsi:type="cm:refProp">
						<refPropName xsi:type="cm:propEnum">target</refPropName>
						<xsl:call-template name="properties">
							<xsl:with-param name="context" select="$op"/>
							<xsl:with-param name="is-target" select="true()"/>
						</xsl:call-template>
					</item>
					<item xsi:type="cm:refProp">
						<refPropName xsi:type="cm:propEnum">base</refPropName>
						<xsl:call-template name="base-refprop-properties">
							<xsl:with-param name="context" select="$op"/>
						</xsl:call-template>
					</item>
				</refProps>
				<xsl:if test="$skip">
					<skipObjects xsi:type="xsd:integer">
						<xsl:value-of select="$skip"/>
					</skipObjects>
				</xsl:if>
				<xsl:if test="$max">
					<maxObjects xsi:type="xsd:integer">
						<xsl:value-of select="$max + 1"/>
					</maxObjects>
				</xsl:if>
			</options>
		</item>
	</xsl:template>

</xsl:stylesheet>