<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/response-common.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/"  
	xmlns:bus="http://developer.cognos.com/schemas/bibus/3/" 
	xmlns:crn="http://developer.cognos.com/schemas/crconfig/1/"
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" 
	xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>

	<xsl:key name="ui-objects" match="/root/system/param[@name = 'ui_objects']/object" use="@class"/>
	<xsl:key name="ui-object-actions" match="/root/system/param[@name = 'base-object-actions']/actions/object" use="@class"/>
	<xsl:variable name="ui-graphics" select="/root/system/param[@name = 'ui_graphics']/param"/>

	<xsl:variable name="op" select="/root/request/SOAP-ENV:Envelope/SOAP-ENV:Body/*[1]"/>
	<xsl:variable name="op-name" select="local-name($op)"/>
	<xsl:variable name="properties" select="$op/nav:property"/>
	<xsl:variable name="maxObjects" select="$op/nav:maxObjects"/>
	<xsl:variable name="skipObjects" select="$op/nav:skipObjects"/>

	<xsl:variable name="bus-header" select="/root/request/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader"/>
	<xsl:variable name="passport" select="$bus-header/bus:CAM/CAMPassport/id"/>
	<xsl:variable name="timeZone" select="$bus-header/bus:userPreferenceVars/item[name='timeZoneID']/value"/>
	<xsl:variable name="productLocale" select="$bus-header/bus:userPreferenceVars/item[name='productLocale']/value"/>
	<xsl:variable name="contentLocale" select="$bus-header/bus:userPreferenceVars/item[name='contentLocale']/value"/>
	<xsl:variable name="format" select="$bus-header/bus:userPreferenceVars/item[name='format']/value"/>
	<xsl:variable name="userCapabilities" select="$bus-header/bus:hdrSession/bus:cookieVars/item[name='userCapabilities']/value"/>

	<xsl:variable name="queryResponse" select="/root/response/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse"/>
	<xsl:variable name="userFolderId" select="$queryResponse/queryResult/replies/item[1]/queryResult/item/searchPath/value"/>

	<xsl:variable name="rootDefaultId">rootDefault</xsl:variable>
	<xsl:variable name="systemDefaultPath">/content</xsl:variable>
	<xsl:variable name="rv">portal/view-output.xts</xsl:variable>
	<xsl:variable name="re">portal/report-viewer.xts</xsl:variable>

	<xsl:variable name="gateway">
		<xsl:value-of select="/root/configProps/param[@name='cps']/property[@name = 'gateway']"/>
	</xsl:variable>

	<xsl:variable name="webcontent">
		<xsl:choose>
			<xsl:when test="/root/configProps/param[@name='cps']/property[@name = 'CPS']/crn:value/crn:parameter[@name = 'webcontent']/crn:value != ''">
				<xsl:value-of select="/root/configProps/param[@name='cps']/property[@name='CPS']/crn:value/crn:parameter[@name = 'webcontent']/crn:value"/>
			</xsl:when>
			<xsl:when test="contains($gateway,'/cgi-bin')">
				<xsl:value-of select="substring-before($gateway,'/cgi-bin')"/>
			</xsl:when>			
			<xsl:otherwise>
				<xsl:value-of select="/root/system/param[@name = 'crn_webcontent']"/>
			</xsl:otherwise> 
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="image_root" select="concat($webcontent, '/ps/portal/images/')"/>

	<xsl:variable name="rootStrings" select="/root/system/param[@name = 'localizedStrings']/rootDefaultLabel/value"/>
	<xsl:variable name="rootDefaultLabel">
		<xsl:choose>
			<xsl:when test="$rootStrings[@xml:lang = $productLocale]">
				<xsl:value-of select="$rootStrings[@xml:lang = $productLocale]"/>
			</xsl:when>
			<xsl:when test="$rootStrings[@xml:lang = 'en']">
				<xsl:value-of select="$rootStrings[@xml:lang = 'en']"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>Cognos</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="gateway">
		<xsl:choose>
			<xsl:when test="/root/configProps/param[@name='cps']/property[@name = 'gateway'] != ''">
				<xsl:value-of select="/root/configProps/param[@name='cps']/property[@name = 'gateway']"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="/root/system/param[@name = 'crn_cgi']"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="base-query-string">
		<xsl:text>?b_action=xts.run&amp;m=portal/main.xts&amp;m_passportID=</xsl:text>
		<xsl:value-of select="string( $passport )"/>
		<xsl:text>&amp;m_productLocale=</xsl:text>
		<xsl:value-of select="$productLocale"/>
		<xsl:text>&amp;m_contentLocale=</xsl:text>
		<xsl:value-of select="$contentLocale"/>
	</xsl:variable>

	<xsl:variable name="redirect-url" select="concat( $gateway, xtsext:protect( concat( $base-query-string, '&amp;m_redirect=' ), 'url', 'url', 'getdata' ) )"/>
	<xsl:variable name="back-url">javascript:close()</xsl:variable>
	<xsl:variable name="encoded-back-url" select="xtsext:protect(xtsext:urlencode(string($back-url)), 'url', 'url', 'getdata' )"/>
	<xsl:variable name="container-id">
		<xsl:if test="$properties[@name = 'parentId'] and $op-name = 'getContainer'">
			<xsl:value-of select="xtsext:web64encode(string($queryResponse/queryResult/replies/item[2]/queryResult/item/searchPath/value), false())"/>
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="m_path">
		<xsl:choose>
			<xsl:when test="$op-name = 'getItem'">
				<!-- path of item's parent -->
				<xsl:value-of select="xtsext:protect( xtsext:urlencode( string( $queryResponse/queryResult/replies/item[2]/queryResult/item/parent/value/item/searchPath/value ) ), 'url', 'searchPath', 'getdata' )"/>
			</xsl:when>
			<xsl:otherwise>
				<!-- path of container -->
				<xsl:value-of select="xtsext:protect( xtsext:urlencode( string( $queryResponse/queryResult/replies/item[2]/queryResult/item/searchPath/value ) ), 'url', 'searchPath', 'getdata' )"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<!-- 
		match "item" - creates a nav:container, nav:item or nav:shortcut based on the current cm object. 
	-->
	<xsl:template match="item">
		<xsl:param name="contents"/>
		<xsl:param name="is-outer-container" select="false()"/>
		<xsl:variable name="objectClass">
			<xsl:choose>
				<xsl:when test="searchPath/value = $userFolderId">
					<xsl:text>pfr</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="objectClass/value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="folder" select="key('ui-objects', string( $objectClass ) )/@container = 'T'"/>
		<xsl:choose>
			<xsl:when test="$folder">
				<nav:container>
					<xsl:call-template name="container-properties">
						<xsl:with-param name="class" select="$objectClass"/>
						<xsl:with-param name="contents" select="$contents"/>
						<xsl:with-param name="is-outer-container" select="$is-outer-container"/>
					</xsl:call-template>
				</nav:container>
			</xsl:when>
			<xsl:when test="$objectClass = 'shortcut'">
				<nav:shortcut>
					<xsl:call-template name="shortcut-properties"/>
				</nav:shortcut>
			</xsl:when>
			<xsl:otherwise>
				<nav:item>
					<xsl:call-template name="item-properties"/>
				</nav:item>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		content - creates the container's nav:content element and sets $contents as the children
	-->
	<xsl:template name="content">
		<xsl:param name="contents"/>
		
		<xsl:variable name="itemCount" select="count($contents)"/>
		<xsl:variable name="skip" select="$contents[1]/position/value"/>
		
		<xsl:choose>
			<xsl:when test="$itemCount = 0">
				<nav:content start="0" end="0" more="false" total="0"/>
			</xsl:when>
			<xsl:when test="$maxObjects != ''">
				<xsl:variable name="moreObjects" select="$itemCount > $maxObjects"/>
				<xsl:variable name="countObjects">
					<xsl:choose>
						<xsl:when test="$moreObjects">
							<xsl:value-of select="number($maxObjects)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="number($itemCount)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<nav:content start="{ $skip + 1 }" end="{ $skip + $countObjects }" max="{ $maxObjects }" more="{ $moreObjects }">
					<xsl:if test="not($moreObjects)">
						<xsl:attribute name="total">
							<xsl:value-of select="$skip + $countObjects"/>
						</xsl:attribute>
					</xsl:if>
					<xsl:apply-templates select="$contents[position() &lt;= $countObjects]"/>
				</nav:content>
			</xsl:when>
			<xsl:otherwise>
				<nav:content start="{ $skip + 1 }" end="{ $skip + $itemCount }" more="false" total="{ $skip + $itemCount }">
					<xsl:apply-templates select="$contents"/>
				</nav:content>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		container-properties - adds the properties specific to the container object
	-->
	<xsl:template name="container-properties">
		<xsl:param name="class"/>
		<xsl:param name="contents"/>
		<xsl:param name="is-outer-container" select="false()"/>
		<xsl:call-template name="base-properties">
			<xsl:with-param name="class" select="$class"/>
			<xsl:with-param name="is-outer-container" select="$is-outer-container"/>
		</xsl:call-template>

		<xsl:if test="$properties[@name = 'hasChildren']">
			<nav:hasChildren>
				<xsl:value-of select="hasChildren/value"/>
			</nav:hasChildren>
		</xsl:if>

		<xsl:if test="$contents">
			<xsl:call-template name="content">
				<xsl:with-param name="contents" select="$contents"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!--
		item-properties - adds the properties specific to the item object
	-->
	<xsl:template name="item-properties">
		<xsl:call-template name="base-properties"/>

		<xsl:if test="$properties[@name = 'newState']">
			<nav:newState/>
		</xsl:if>

		<xsl:if test="$properties[@name = 'readState']">
			<nav:readState/>
		</xsl:if>

		<xsl:if test="$properties[@name = 'status']">
			<nav:status/>
		</xsl:if>
	</xsl:template>

	<!--
		shortcut-properties - adds the properties specific to the shortcut object
	-->
	<xsl:template name="shortcut-properties">
		<xsl:call-template name="base-properties"/>
		<xsl:apply-templates select="target/value/item"/>
	</xsl:template>

	<!--
		base-properties - adds the properties common to all objects
	-->
	<xsl:template name="base-properties">
		<xsl:param name="class" select="objectClass/value"/>
		<xsl:param name="is-outer-container" select="false()"/>

		<xsl:variable name="target-class">
			<!-- this is the effective class.  i.e. it is the class of the target object in case of a shortcut. -->
			<xsl:choose>
				<xsl:when test="$class = 'shortcut'">
					<xsl:value-of select="target/value/item/objectClass/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$class"/>
				</xsl:otherwise>
			</xsl:choose>				
		</xsl:variable>

		<!-- Current object's permissions -->
		<xsl:variable name="objlvl">
			<xsl:call-template name="create-list">
				<xsl:with-param name="items" select="permissions/value/item"/>
			</xsl:call-template>
		</xsl:variable>
		<!-- Current target object's permissions for 'shortcut' object -->
		<xsl:variable name="trgobjlvl">
			<xsl:if test="$class= 'shortcut'">
				<xsl:call-template name="create-list">
					<xsl:with-param name="items" select="target/value/item/permissions/value/item"/>
				</xsl:call-template>
			</xsl:if>
		</xsl:variable>
		<!-- Current base object's permissions for 'reportView' object (reportView and shortcut)-->
		<xsl:variable name="bsobjlvl">
			<xsl:choose>
				<xsl:when test="$class= 'shortcut' and target/value/item/objectClass/value = 'reportView'">
					<xsl:call-template name="create-list">
						<xsl:with-param name="items" select="target/value/item/base/value/item/permissions/value/item"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$class= 'reportView'">
					<xsl:call-template name="create-list">
						<xsl:with-param name="items" select="base/value/item/permissions/value/item"/>
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<!-- Variable created, which contains all permissions for the current object; can be a combination of current and determined permissions -->
		<xsl:variable name="accessAvailable">
			<xsl:choose>
				<xsl:when test="$class= 'shortcut'">
					<xsl:value-of select="' '"/>
					<xsl:if test="$objlvl != ''">
						<xsl:if test="contains($objlvl, ' read ')">scr </xsl:if>
						<xsl:if test="contains($objlvl, ' write ')">scw </xsl:if>
					</xsl:if>
					<xsl:if test="$trgobjlvl != ''">
						<xsl:if test="contains($trgobjlvl, ' read ')">r </xsl:if>
						<xsl:if test="contains($trgobjlvl, ' write ')">w </xsl:if>
						<xsl:if test="contains($trgobjlvl, ' traverse ')">t </xsl:if>
						<xsl:if test="contains($trgobjlvl, ' setPolicy ')">sp </xsl:if>
					</xsl:if>
					<xsl:if test="$bsobjlvl = '' and $trgobjlvl != '' and contains($trgobjlvl, ' execute ')">x </xsl:if>
					<xsl:if test="$bsobjlvl != '' and contains($bsobjlvl, ' execute ') and $trgobjlvl != '' and contains($trgobjlvl, ' execute ')">x </xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="' '"/>
					<xsl:if test="contains($objlvl, ' read ')">r </xsl:if>
					<xsl:if test="contains($objlvl, ' write ')">w </xsl:if>
					<xsl:if test="contains($objlvl, 'traverse')">t </xsl:if>
					<xsl:if test="contains($objlvl, 'setPolicy')">sp </xsl:if>
					<xsl:choose>
						<xsl:when test="$class= 'reportView'">
							<xsl:if test="$bsobjlvl != '' and contains($bsobjlvl, ' execute ') and $objlvl != '' and contains($objlvl, 'execute')">x </xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:if test="contains($objlvl, 'execute')">x </xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="canRead" select="contains($accessAvailable, ' r ')"/>
		<xsl:variable name="canWrite" select="contains($accessAvailable, ' w ')"/>
		<xsl:variable name="canExecute" select="contains($accessAvailable, ' x ')"/>
		<xsl:variable name="canTraverse" select="contains($accessAvailable, ' t ')"/>
		<xsl:variable name="canSetPolicy" select="contains($accessAvailable, ' sp ')"/>
		<xsl:variable name="canReadShort">
			<xsl:choose>
				<xsl:when test="$class= 'shortcut'"><xsl:value-of select="contains($accessAvailable, ' scr ')"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="contains($accessAvailable, ' r ')"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="canWriteShort">
			<xsl:choose>
				<xsl:when test="$class= 'shortcut'"><xsl:value-of select="contains($accessAvailable, ' scw ')"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="contains($accessAvailable, ' w ')"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="output_format">
			<xsl:choose>
				<xsl:when test="target/value/item/defaultOutputFormat/value/item">
					<xsl:value-of select="target/value/item/defaultOutputFormat/value/item[1]"/>
				</xsl:when>
				<xsl:when test="defaultOutputFormat/value/item">
					<xsl:value-of select="defaultOutputFormat/value/item[1]"/>
				</xsl:when>				
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="default_portal_action">
			<xsl:choose>
				<xsl:when test="target/value/item/defaultPortalAction/value">
					<xsl:value-of select="target/value/item/defaultPortalAction/value"/>
				</xsl:when>
				<xsl:when test="defaultPortalAction/value">
					<xsl:value-of select="defaultPortalAction/value"/>
				</xsl:when>				
			</xsl:choose>
		</xsl:variable>
			
		<!--   An entry is considered "dangling" if it is:
			- a shortcut to a none existent object
			- a custom view of a none existent report or query
			- a shortcut to a custom view of a none existent report or query 	
		 -->
		
 		<xsl:variable name="isDangling" select=" ($class = 'shortcut' and (target/value/item/@xsi:type = 'cm:nil' or target/value/item/base/value/item/@xsi:type = 'cm:nil')) or (($class = 'reportView' or $class = 'agentDefinitionView') and base/value/item/@xsi:type = 'cm:nil')"/>
		<xsl:variable name="isContainer" select="key( 'ui-objects', string($target-class) )/@container = 'T'"/>
		<xsl:variable name="hasURI" select="uri/value"/>

		<!-- start of base properties -->
		<nav:id>
			<xsl:value-of select="xtsext:web64encode( string( searchPath/value ), false())"/>
		</nav:id>
		<xsl:if test="$properties[@name = 'parentId']">
			<nav:parentId>
				<xsl:variable name="object-path" select="searchPath/value"/>
				<xsl:choose>
					<xsl:when test="$object-path = $userFolderId or $object-path = $systemDefaultPath">
						<xsl:value-of select="$rootDefaultId"/>
					</xsl:when>
					<xsl:when test="parent/value/item/searchPath/value">
						<xsl:value-of select="xtsext:web64encode( string( parent/value/item/searchPath/value ), false())"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$container-id"/>
					</xsl:otherwise>
				</xsl:choose> 
			</nav:parentId>
		</xsl:if>
		<nav:name>
			<xsl:value-of select="defaultName/value"/>
		</nav:name>
		<nav:imgURL>
			<xsl:call-template name="gen-icon">
				<xsl:with-param name="class" select="$class"/>
				<xsl:with-param name="isDangling" select="$isDangling"/>
				<xsl:with-param name="output_format" select="$output_format"/>
			</xsl:call-template>
		</nav:imgURL>
				
		<xsl:variable name="userCanUseRS" select="contains($userCapabilities, 'R')"/>
		<nav:url>
			<!--  Only hyperlink the entry if it is:
					- not a dangling reference.
					- It is a container and the user can traverse it.
					- It is a URL to an external web site
					- it is a query, report, a report view or a shortcut to any of these where there is output to view and the user has read access to the base report. 
					- it is a query, report, a report view, analysis object or a shortcut to any of these where there is not output to view and the user has at least execute access. 
					- it is a reportTemplate to which the user has read access and the user can use Report Studio
			-->
			<xsl:if test="not($isDangling) and (
								($isContainer and $canTraverse) or 
								($hasURI and $canRead)	or 
								($output_format != '' and (($canRead and $canTraverse) or $canExecute)) or 
								($output_format = '' and (($target-class = 'URL' and $canRead) or (($target-class = 'report' or $target-class = 'reportView' or $target-class = 'query' or $target-class = 'analysis') and $canExecute))) or
								(starts-with(string($target-class),'powerPlay') and $canRead and $canExecute) or
								($target-class = 'reportTemplate' and $canRead and $userCanUseRS)
								)">
				<xsl:choose>
					<xsl:when test="$hasURI">
						<xsl:attribute name="type">external</xsl:attribute>
						<xsl:value-of select="$hasURI"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="gen-url">
							<xsl:with-param name="canWrite" select="$canWrite"/>
							<xsl:with-param name="canExecute" select="$canExecute"/>
							<xsl:with-param name="canRead" select="$canRead"/>
							<xsl:with-param name="output_format" select="$output_format"/>
							<xsl:with-param name="default_portal_action" select="$default_portal_action"/>
							<xsl:with-param name="class" select="$target-class"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</nav:url>
		<!-- end of base properties -->

		<!-- start of optional properties -->
		<xsl:if test="$properties[@name = 'description']">
			<nav:description>
				<xsl:value-of select="defaultDescription/value"/>
			</nav:description>
		</xsl:if>
		<xsl:if test="$properties[@name = 'screenTip']">
			<nav:screenTip>
				<xsl:value-of select="defaultName/value"/>
				<xsl:if test="defaultScreenTip/value != '' ">
					<xsl:text/> - <xsl:value-of select="defaultScreenTip/value"/>
				</xsl:if>
			</nav:screenTip>
		</xsl:if>
		<xsl:if test="$properties[@name = 'createDate']">
			<nav:createDate>
				<!-- this will give us the time formatted with the java long(2) date and medium(3) time using the locale date and time patterns provided by java -->
				<xsl:value-of select="xtsext:formatDateFromUTC( string( creationTime/value ), number( '2' ), number( '3' ),  string( $timeZone ),  string( $contentLocale ) )"/>
			</nav:createDate>
		</xsl:if>
		<xsl:if test="$properties[@name = 'lastModifiedDate']">
			<nav:lastModifiedDate>
				<xsl:value-of select="xtsext:formatDateFromUTC( string( modificationTime/value ), number( '2' ), number( '3' ),  string( $timeZone ),  string( $contentLocale ) )"/>
			</nav:lastModifiedDate>
		</xsl:if>
		<xsl:if test="$properties[@name = 'fullPath'] or $is-outer-container">
			<nav:fullPath>
				<xsl:variable name="ancestors" select="ancestors/value"/>
				<xsl:variable name="object-path" select="searchPath/value"/>
				<xsl:variable name="myfolders" select="$ancestors/item[searchPath = $userFolderId]"/>
				<xsl:choose>
					<xsl:when test="$ancestors/item[1]/searchPath = $systemDefaultPath">
						<!-- If top ancestor is "public folders", insert fake root as top ancestor -->
						<xsl:call-template name="path-step-root">
							<xsl:with-param name="item" select="$ancestors/item[1]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$object-path = $userFolderId or $object-path = $systemDefaultPath">
						<!-- if object is  "my folders" or "public folders", replace ancestors with fake root -->
						<xsl:call-template name="path-step-root"/>
					</xsl:when>
					<xsl:when test="$myfolders">
						<!-- if ancestors contains "my folders", eliminate items before and replace with fake root -->
						<xsl:call-template name="path-step-root">
							<xsl:with-param name="item" select="$myfolders | $myfolders/following-sibling::item"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!-- otherwise the base is not public folders or my folders, show true ancestors -->
						<xsl:call-template name="path-step">
							<xsl:with-param name="item" select="$ancestors/item[1]"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</nav:fullPath>
		</xsl:if>
		<xsl:if test="$properties[@name = 'action'] and not($is-outer-container)">
			<xsl:variable name="userCanUseQS" select="contains($userCapabilities, 'Q')"/>
			<xsl:call-template name="action-properties">
				<xsl:with-param name="supportScheduleAction" select="true()"/>
				<xsl:with-param name="canRead" select="$canRead"/>
				<xsl:with-param name="canWrite" select="$canWrite"/>
				<xsl:with-param name="canExecute" select="$canExecute"/>
				<xsl:with-param name="canTraverse" select="$canTraverse"/>
				<xsl:with-param name="class">
					<!-- this is the effective class.  i.e. it is the class of the target object in case of a shortcut. -->
					<xsl:choose>
						<xsl:when test="$class = 'shortcut'">
							<xsl:value-of select="target/value/item/objectClass/value"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$class"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param> 
				<xsl:with-param name="output_format" select="$output_format"/>
				<xsl:with-param name="isDangling" select="$isDangling"/>
				<xsl:with-param name="canUseRS" select="$userCanUseRS"/>
				<xsl:with-param name="canUseQS" select="$userCanUseQS"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$properties[@name = 'actionsURL'] and not($is-outer-container)">
			<nav:actionsURL>
				<xsl:call-template name="gen-action-url">
					<xsl:with-param name="cmname" select="defaultName/value"/>
					<xsl:with-param name="cmclass" select="objectClass/value"/>
					<xsl:with-param name="cmpath" select="searchPath/value"/>
					<xsl:with-param name="target" select="'actions.xts'"/>
				</xsl:call-template>
			</nav:actionsURL>
		</xsl:if>
		<!-- end of optional properties -->
	</xsl:template>

	<!--
		path-step-root - Create a root pathStep and apply the given list as descenents of that root
	-->
	<xsl:template name="path-step-root">
		<xsl:param name="item"/>
		<nav:pathStep>
			<nav:id>rootDefault</nav:id>
			<nav:name>
				<xsl:value-of select="$rootDefaultLabel"/>
			</nav:name>
			<xsl:if test="$item">
				<xsl:call-template name="path-step">
					<xsl:with-param name="item" select="$item"/>
				</xsl:call-template>
			</xsl:if>
		</nav:pathStep>
	</xsl:template>

	<!--
		path-step - create list of ancestors, recursively traversing ancestor list, given current element in $item
	-->
	<xsl:template name="path-step">
		<xsl:param name="item"/>
		<xsl:if test="$item">
			<nav:pathStep>
				<nav:id>
					<xsl:value-of select="xtsext:web64encode( string( $item/searchPath ), false())"/>
				</nav:id>
				<nav:name>
					<xsl:value-of select="$item/title"/>
				</nav:name>
				<xsl:if test="$item/following-sibling::item">
					<xsl:call-template name="path-step">
						<xsl:with-param name="item" select="$item/following-sibling::item"/>
					</xsl:call-template>
				</xsl:if>
			</nav:pathStep>
		</xsl:if>
	</xsl:template>

	<!-- 
		gen-url - Cognos Connection rules for generating a url 
	-->
	<xsl:template name="gen-url">
		<xsl:param name="canWrite" select="true()"/>
		<xsl:param name="canExecute" select="true()"/>
		<xsl:param name="canRead" select="true()"/>
		<xsl:param name="output_format" select="''"/>
		<xsl:param name="default_report_action" select="''"/>
		<xsl:param name="class"/>		
		<xsl:param name="morphlet" select="''"/>
		<xsl:param name="use-back-url" select="true()"/>
		<xsl:param name="force-prompt" select="false()"/>
		
		<!-- path -->
		<xsl:variable name="target-path">
			<xsl:choose>
				<!-- Shortcut -->
				<xsl:when test="target/value/item/searchPath">
					<xsl:value-of select="target/value/item/searchPath/value"/>
				</xsl:when>
				<!-- Base object -->
				<xsl:otherwise>
					<xsl:value-of select="searchPath/value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>	
		
		<xsl:choose>	
			<!-- absorb fake root (i.e. don't generate an URL for the fake root -->
			<xsl:when test="$target-path = 'root'"/>

			<!-- URL -->
			<xsl:when test="uri/value">
				<xsl:attribute name="type">external</xsl:attribute>
				<xsl:value-of select="uri/value"/>
			</xsl:when>
			
			<!-- Shortcut to a URL -->
			<xsl:when test="target/value/item/uri/value">
				<xsl:attribute name="type">external</xsl:attribute>
				<xsl:value-of select="target/value/item/uri/value"/>
			</xsl:when>
			
			<!-- powerPlayReport/powerPlayCube or a shortcut to any of these two -->
			<xsl:when test="starts-with(string($class),'powerPlay')">
				<xsl:variable name="item" select="current() | current()/target/value/item"/>
				<xsl:variable name="ppformat">
					<xsl:choose>
						<xsl:when test="$output_format != ''">
							<xsl:value-of select="$output_format"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$item[last()]/options/value/item[name='outputFormat']/value"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<xsl:value-of select="$item[last()]/gateway/value"/>
				<xsl:text>?crnobj=</xsl:text>
				<xsl:value-of select="xtsext:protect(xtsext:urlencode( string( $target-path ) ),'url','searchPath','getdata')"/>
				<xsl:text>&amp;crnccn=</xsl:text>
				<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($item[last()]/cubeContentName/value)),'url','userData','getdata')"/>

				<xsl:if test="$item[last()]/objectClass/value = 'powerPlayReport'">
					<xsl:text>&amp;crnfrm=</xsl:text>
					<xsl:value-of select="$ppformat"/>
					<xsl:choose>
						<xsl:when test="string($ppformat) = 'PDF'">
							<xsl:if test="string($item[last()]/hasPrompts/value) = 'true'">
								<xsl:text>&amp;crnp=</xsl:text>
								<xsl:choose>
									<xsl:when test="$force-prompt = 'true'">true</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$item[last()]/options/value/item[name='prompt']/value"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>&amp;crngnd=</xsl:text>
							<xsl:value-of select="not( string($item[last()]/options/value/item[name='data']/value) = 'runWithAllData' )"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:text>&amp;LA=</xsl:text>
				<xsl:value-of select="$productLocale"/>
				<xsl:text>&amp;LO=</xsl:text>
				<xsl:value-of select="$contentLocale"/>
				<xsl:if test="$use-back-url = 'true'">
					<xsl:text>&amp;BACK=</xsl:text>
					<xsl:value-of select="$encoded-back-url"/>
				</xsl:if>
			</xsl:when>
			<!--  Run action for analysis studio -->
			<!--  This happens regardless of the default_report_action value-->
			<xsl:when test="$class='analysis'">
				<xsl:if test="$canExecute">
					<xsl:value-of select="$webcontent"/>
					<xsl:text>/explore/explore.htm?appname=main</xsl:text>
					<xsl:text>&amp;gateway=</xsl:text>
					<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($gateway)),'url','url','getdata')"/>
					<xsl:text>&amp;query=</xsl:text>
					<xsl:value-of select="xtsext:protect( xtsext:urlencode(string($target-path)), 'url', 'searchPath', 'getdata' )"/>
				</xsl:if>
			</xsl:when>
			<!-- edit the report or report template -->
			<xsl:when test="$class='reportTemplate' or ($class='report' and $default_report_action='edit' and $canExecute and $canWrite)">				
					<xsl:value-of select="concat( $gateway, xtsext:protect( string( $base-query-string ), 'url', 'url', 'getdata' ) )"/>
					<xsl:text>&amp;m_launchRS=yes</xsl:text>							
					<xsl:text>&amp;m_obj=</xsl:text>
					<xsl:value-of select="xtsext:protect( xtsext:urlencode(string($target-path)), 'url', 'searchPath', 'getdata' )"/>	
			</xsl:when>		
			<!-- report/query/reportView/output or a shortcut to any of these -->
			<xsl:when test="contains(' report query reportView output ', concat(' ', $class, ' ' ))">					
				<!-- Base url -->
				<xsl:value-of select="$gateway"/>
				<xsl:text>?b_action=xts.run&amp;m=</xsl:text>
				
				<!-- Figure out what kind of action it is .. -->
				<xsl:choose>
					<!-- View action for an output object -->
					<xsl:when test="$class = 'output'">
						<xsl:value-of select="$rv"/>
						<xsl:text>&amp;method=view&amp;m_obj=</xsl:text>
						<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($target-path)), 'url', 'searchPath', 'getdata' )"/>
						<xsl:text>&amp;m_name=</xsl:text>
						<xsl:value-of select="xtsext:protect(xtsext:urlencode(string(defaultName/value)), 'url', 'userData', 'getdata' )"/>
						<xsl:text>&amp;outputFormat=</xsl:text>
						<xsl:value-of select="$output_format"/>
					</xsl:when>						
					<!-- View action for a query, report or a reportView (or shortcut to any of these) -->
					<xsl:when test="$output_format != '' and not($default_report_action='edit' and $canExecute and $canWrite) and not($default_report_action='run' and $canExecute)">
						<xsl:value-of select="$rv"/>
						<xsl:text>&amp;method=view&amp;m_obj=</xsl:text>
						<xsl:value-of select="xtsext:protect( xtsext:urlencode( concat('defaultOutput(',  $target-path, ')' ) ), 'url', 'searchPath', 'getdata' )"/>
						<xsl:text>&amp;m_name=</xsl:text>
						<xsl:value-of select="xtsext:protect(xtsext:urlencode(string(defaultName/value)), 'url', 'userData', 'getdata' )"/>
						<xsl:text>&amp;outputFormat=</xsl:text>
						<xsl:value-of select="$output_format"/>
					</xsl:when>
					<!-- Edit action - Query objects only -->					
					<xsl:when test="$class = 'query' and not($default_report_action='run') and $canExecute and $canWrite">
						<xsl:text>qs/qs.xts&amp;method=editQuery&amp;obj=</xsl:text>
						<xsl:value-of select="xtsext:protect(xtsext:urlencode( string( $target-path ) ), 'url', 'searchPath', 'getdata' )"/>
					</xsl:when>
					<!-- Run action - Default for Reports, reportView objects or query objects where the user does not have write access . -->	
					<xsl:when test="$canExecute">
						<xsl:value-of select="$re"/>
						<xsl:text>&amp;method=execute&amp;m_obj=</xsl:text>
						<xsl:value-of select="xtsext:protect(xtsext:urlencode( string( $target-path ) ), 'url', 'searchPath', 'getdata' )"/>
						<xsl:text>&amp;outputFormat=</xsl:text>
						<xsl:value-of select="$format"/>
					</xsl:when>
				</xsl:choose>
				
				<!-- Add the back URL -->			
				<xsl:if test="$use-back-url = 'true'">
					<xsl:text>&amp;backURL=</xsl:text>
					<xsl:value-of select="$encoded-back-url"/>
				</xsl:if>

				<!-- we don't want a CC header -->
				<xsl:text>&amp;nh=1</xsl:text>
				
				<xsl:if test="$properties[@name = 'windowState']">
					<xsl:text>&amp;tb=</xsl:text>
					<xsl:choose>
						<xsl:when test="$properties[@name = 'windowState'] = 'wsrp:maximized'">1</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:when>

			<!-- Container / Shortcut -->
			<xsl:otherwise>
				<xsl:value-of select="$gateway"/>?b_action=xts.run&amp;m=portal/<xsl:text/>
				<!-- morphlet -->
				<xsl:choose>
					<xsl:when test="$morphlet = ''">
						<xsl:value-of select="'ccentral.xts'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$morphlet"/>
					</xsl:otherwise>
				</xsl:choose>
									
				<xsl:text/>&amp;m_path=<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($target-path)), 'url', 'searchPath', 'getdata' )"/>
							
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		gen-icon - Cognos Connection rules for generating icon urls 
	-->
	<xsl:template name="gen-icon">
		<xsl:param name="class" select="''"/>
		<!-- this is the effective class.  i.e. it is the class of the target object in case of a shortcut. Only usefull for morphlets that care about shortcuts. -->
		<xsl:param name="output_format" select="''"/>
		<!-- Set this to blank by default -->
		<xsl:param name="isDangling" select="false()"/>
		<!-- instead of displaying the deaultName, display this -->
		<xsl:variable name="system_icon">
			<xsl:choose>
				<xsl:when test="objectClass/value = 'shortcut'">
					<xsl:value-of select="key('ui-objects', target/value/item/objectClass/value)/@icon"/>
				</xsl:when>
				<xsl:when test="$class != ''">
					<xsl:value-of select="key('ui-objects', $class)/@icon"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="key('ui-objects', objectClass/value)/@icon"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<!-- If this object has an explicit icon then use it. -->
			<xsl:when test="icon/value">
				<xsl:value-of select="icon/value"/>
			</xsl:when>
			<!-- Build the icon name based on object type and system.xml -->
			<xsl:otherwise>
				<xsl:variable name="ppformat">
					<xsl:if test="$class = 'powerPlayReport'">
						<xsl:choose>
							<xsl:when test="objectClass/value = 'shortcut'">
								<xsl:value-of select="target/value/item/options/value/item[name='outputFormat']/value"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="options/value/item[name='outputFormat']/value"/>
							</xsl:otherwise>	
						</xsl:choose>			
					</xsl:if>
				</xsl:variable>
				<xsl:value-of select="$image_root"/>icon_<xsl:text/>
				<xsl:choose>
					<!-- output-specific icon here if there is an output -->
					<xsl:when test="starts-with(string($class),'powerPlay') and string($ppformat)='PDF'">
						<xsl:value-of select="/root/system/param[@name='ui_graphics']/param[@name='output_format']/format[@name='PDF']/@icon"/>
					</xsl:when>
					<xsl:when test="$output_format != '' and not( $isDangling )">
						<xsl:value-of select="$ui-graphics[@name = 'output_format']/format[@name = $output_format]/@icon"/>
						<xsl:if test="$class = 'reportView'">
							<xsl:value-of select="$ui-graphics[@name='reportview_suffix']"/>
						</xsl:if>
						<xsl:if test="$class = 'agentDefinitionView'">
							<xsl:value-of select="$ui-graphics[@name='agentview_suffix']"/>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$system_icon != '' and not( $isDangling )">
						<xsl:value-of select="$system_icon"/>
					</xsl:when>
					<xsl:when test="$isDangling">
						<xsl:value-of select="$ui-graphics[@name='dang_ref']"/>
						<xsl:if test="$class = 'reportView'">
							<xsl:value-of select="$ui-graphics[@name='reportview_suffix']"/>
						</xsl:if>
						<xsl:if test="$class = 'agentDefinitionView'">
							<xsl:value-of select="$ui-graphics[@name='agentview_suffix']"/>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$ui-graphics[@name='default_icon']"/>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Add _ref if it is a shortcut.. -->
				<xsl:if test="objectClass/value = 'shortcut'">
					<xsl:value-of select="$ui-graphics[@name='shortcut_suffix']"/>
				</xsl:if>
				<!-- Add the extension.. -->
				<xsl:text/>.gif<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 
		create-list - helper function for base-properties permissions
	-->
	<xsl:template name="create-list">
		<xsl:param name="items"/>
		<xsl:text> </xsl:text>
		<xsl:for-each select="$items">
			<xsl:value-of select="."/>
			<xsl:text> </xsl:text>
		</xsl:for-each>
	</xsl:template>

	<!--
		action properties - Cognos Connection rules to generate actions based on passed in item information
	-->
	<xsl:template name="action-properties">
		<xsl:param name="obj-name" select="defaultName/value"/>
		<xsl:param name="obj-path" select="searchPath/value"/>
		<xsl:param name="obj-class" select="objectClass/value"/>
		<xsl:param name="history-path" select="''"/>
		<xsl:param name="canRead" select="true()"/>
		<xsl:param name="canWrite" select="true()"/>
		<xsl:param name="canExecute" select="true()"/>
		<xsl:param name="canTraverse" select="true()"/>
		<xsl:param name="class">
			<xsl:choose>
				<xsl:when test="target/value/item/objectClass">
					<xsl:value-of select="target/value/item/objectClass/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="objectClass/value"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<!-- this is the effective class.  i.e. it is the class of the target object in case of a shortcut. -->
		<xsl:param name="output_format" select="''"/>
		<xsl:param name="isDangling" select="false()"/>
		<xsl:param name="canUseRS" select="true()"/>
		<xsl:param name="canUseQS" select="true()"/>
		<!-- supported actions - host morphlet can list which actions it wants to show when listing CM entries. -->
		<xsl:param name="supportScheduleAction" select="false()"/>

		<!-- Effective object name -->
		<xsl:variable name="name">
			<xsl:choose>
				<xsl:when test="$obj-class = 'shortcut'">
					<xsl:value-of select="target/value/item/defaultName/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$obj-name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="toolTipName">
			<xsl:value-of select="$obj-name"/>
		</xsl:variable>
		<!-- Effective object path -->
		<xsl:variable name="path">
			<xsl:choose>
				<xsl:when test="$obj-class = 'shortcut'">
					<xsl:value-of select="target/value/item/searchPath/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$obj-path"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Ref to UI object actions -->
		<xsl:variable name="ui-object" select="key( 'ui-object-actions', string($class) )"/>

		<!-- Properties ============= -->
		<!-- We do not apply any security on this since it could be used for shortcuts.  The canRead, canWrite flags refer to the target in case of shortcut objects. -->
		<xsl:call-template name="render-action">
			<xsl:with-param name="name" select="'properties'"/>
			<xsl:with-param name="href">
				<xsl:call-template name="gen-action-url">
					<xsl:with-param name="cmname" select="$obj-name"/>
					<xsl:with-param name="cmclass" select="$obj-class"/>
					<xsl:with-param name="cmpath" select="$obj-path"/>
					<xsl:with-param name="target">properties_general.xts</xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="icon" select="'action_properties.gif'"/>
			<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_PROPERTIES"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
		</xsl:call-template>

		<!-- Previous versions ============= -->
		<xsl:if test="$output_format != '' and (($canRead and $canTraverse) or $canExecute) and $ui-object/action[@name = 'previous_versions']">
			<xsl:call-template name="render-action">
				<xsl:with-param name="name" select="'previous_versions'"/>
				<xsl:with-param name="href">
					<xsl:call-template name="gen-action-url">
						<xsl:with-param name="cmname" select="$name"/>
						<xsl:with-param name="cmclass" select="$class"/>
						<xsl:with-param name="cmpath" select="$path"/>
						<xsl:with-param name="target">
							<xsl:choose>
								<xsl:when test="/root/system[@name = 'versions']/target">
									<xsl:value-of select="/root/system[@name = 'versions']/target"/>
								</xsl:when>
								<xsl:otherwise>outputs.xts</xsl:otherwise>
							</xsl:choose>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:with-param>
				<xsl:with-param name="icon" select="'action_view_report_output.gif'"/>
				<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_IMG_VIEW_RPT_ALT"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:variable name="item" select="current() | current()/target/value/item"/>
		
		<!-- we only return either run, or run_options -->
		<xsl:choose>
			<!-- if dangling, no run/run_options/edit/custom_view/schedule actions are available -->
			<xsl:when test="$isDangling"/>
			
			<xsl:otherwise>
				<!-- Run PowerPlay action -->
				<xsl:if test="($class='analysis' or starts-with(string($class),'powerPlay')) and $canExecute">
					<xsl:call-template name="render-action">
						<xsl:with-param name="name" select="'run'"/>
						<xsl:with-param name="href">
							<xsl:call-template name="gen-url">
								<xsl:with-param name="canWrite" select="$canWrite"/>
								<xsl:with-param name="canExecute" select="$canExecute"/>
								<xsl:with-param name="canRead" select="$canRead"/>
								<xsl:with-param name="class" select="$class"/>
								<xsl:with-param name="use-back-url" select="false()"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="icon" select="'action_run_16.gif'"/>
						<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_RUN"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				
				<xsl:choose>
					<!-- Run Options - PowerPlay Report (not supported) ======================= -->
					<xsl:when test="$class='powerPlayReport' and $canExecute and $canRead and $ui-object/action[@name = 'run_options']"/>

					<!-- Run (run only) - all others ============================== -->		
					<xsl:when test="($properties[@name = 'action'] = 'run') and $canExecute and $ui-object/action[@name = 'run_once']">
					
						<xsl:call-template name="render-action">
							<xsl:with-param name="name" select="'run_options'"/>
							<xsl:with-param name="href">
							
								<xsl:choose>
									<!-- Handle run_once for analysis objects. We execute the analysis sutdio -->
									<xsl:when test="$class = 'analysis'">
										<xsl:value-of select="$webcontent"/>
										<xsl:text>/explore/explore.htm?appname=main</xsl:text>
										<xsl:text>&amp;gateway=</xsl:text>
										<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($gateway)),'url','url','getdata')"/>
										<xsl:text>&amp;query=</xsl:text>
										<xsl:value-of select="xtsext:protect( xtsext:urlencode(string($path)), 'url', 'searchPath', 'getdata' )"/>					
									</xsl:when>
									<xsl:otherwise>
									
										<!-- Base url -->
										<xsl:value-of select="$gateway"/>
										<xsl:text>?b_action=xts.run&amp;m=</xsl:text>
		
										<xsl:value-of select="$re"/>
										<xsl:text>&amp;method=execute&amp;m_obj=</xsl:text>
										<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($path)), 'url', 'searchPath', 'getdata' )"/>
										<xsl:text>&amp;outputFormat=</xsl:text>
										<xsl:value-of select="$format"/>
		
										<!-- don't include headers-->
										<xsl:text/>&amp;nh=1<xsl:text/>
										<xsl:if test="$properties[@name = 'windowState']">
											<xsl:text>&amp;tb=</xsl:text>
											<xsl:choose>
												<xsl:when test="$properties[@name = 'windowState'] = 'wsrp:maximized'">1</xsl:when>
												<xsl:otherwise>0</xsl:otherwise>
											</xsl:choose>
										</xsl:if>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:with-param>
							<xsl:with-param name="icon" select="'action_run_16.gif'"/>
							<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_RUN"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>

					<!-- Run Options - all others ============= -->
					<xsl:when test="$canExecute and $ui-object/action[@name = 'run_options'] and not(contains(' report query reportView ', concat(' ', $class, ' ' )) and not(contains($userCapabilities, 'O')))">
						<xsl:variable name="run_target">
							<xsl:choose>
								<xsl:when test="$class = 'jobDefinition'">other_run_options_job.xts</xsl:when>
								<xsl:otherwise>runWithOptions/report.xts</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:call-template name="render-action">
							<xsl:with-param name="name" select="'run_options'"/>
							<xsl:with-param name="href">
								<xsl:call-template name="gen-action-url">
									<xsl:with-param name="cmname" select="$name"/>
									<xsl:with-param name="cmclass" select="$class"/>
									<xsl:with-param name="cmpath" select="$path"/>
									<xsl:with-param name="target" select="$run_target"/>
								</xsl:call-template>

								<!-- don't include headers-->
								<xsl:text/>&amp;nh=1<xsl:text/>
								<xsl:if test="$properties[@name = 'windowState']">
									<xsl:text>&amp;tb=</xsl:text>
									<xsl:choose>
										<xsl:when test="$properties[@name = 'windowState'] = 'wsrp:maximized'">1</xsl:when>
										<xsl:otherwise>0</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
							</xsl:with-param>
							<xsl:with-param name="icon" select="'action_run_16.gif'"/>
							<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_RUN"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>

				<!-- Edit - Report Studio / Query Studio  / Analysis studio / Agent studio============= -->
				<xsl:if test="$canWrite and $ui-object/action[@name = 'edit']">
					<xsl:variable name="url-encoded-path">
						<xsl:choose>
							<xsl:when test="$obj-class = 'shortcut'">
								<xsl:value-of select="xtsext:protect( xtsext:urlencode(string( target/value/item/searchPath/value )), 'url', 'searchPath', 'getdata' ) "/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="xtsext:protect( xtsext:urlencode(string($obj-path)), 'url', 'searchPath', 'getdata' )"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="starts-with(string($class),'powerPlay') and $canExecute">
							<xsl:variable name="ppdesignmode" select="$item[last()]/options/value/item[name='data']/value"/>

							<xsl:call-template name="render-action">
								<xsl:with-param name="name" select="'edit'"/>
								<xsl:with-param name="href">
									<xsl:call-template name="gen-url">
										<xsl:with-param name="canWrite" select="$canWrite"/>
										<xsl:with-param name="canExecute" select="$canExecute"/>
										<xsl:with-param name="canRead" select="$canRead"/>
										<xsl:with-param name="output_format" select="'HTML'"/>
										<xsl:with-param name="class" select="$class"/>
									</xsl:call-template>
								</xsl:with-param>
								<xsl:with-param name="icon">
									<xsl:choose>
										<xsl:when test="string($class)='powerPlayCube' or string($ppdesignmode)='runWithAllData'">action_edit_with_pp.gif</xsl:when>
										<xsl:otherwise>action_edit_with_pp_design.gif</xsl:otherwise>
									</xsl:choose>
								</xsl:with-param>
								<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_EDIT_WPPWX"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$canUseRS and ($class = 'report' or $class='reportTemplate')">
							<xsl:call-template name="render-action">
								<xsl:with-param name="name" select="'edit'"/>
								<xsl:with-param name="redirectURL">
									<xsl:value-of select="concat( $gateway, xtsext:protect( string( $base-query-string ), 'url', 'url', 'getdata' ) )"/>
									<xsl:text>&amp;m_launchRS=yes</xsl:text>							
									<xsl:text>&amp;m_obj=</xsl:text>
									<xsl:value-of select="$url-encoded-path"/>							
								</xsl:with-param>
								<!-- the location of RS is owned by CC -->
								<xsl:with-param name="href"/>
								<xsl:with-param name="icon" select="'action_edit_with_RS.gif'"/>
								<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_EDIT_WRS"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
								<xsl:with-param name="windowProperties">menubar=no,toolbar=no,status=no,location=no,resizable=yes,width=700,height=500</xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<!-- Open with Analysis Studio  -->
						<xsl:when test="$canUseRS  and $class='analysis'">
							<xsl:call-template name="render-action">
								<xsl:with-param name="name" select="'edit'"/>
								<xsl:with-param name="redirectURL">
									<xsl:value-of select="$webcontent"/>
									<xsl:text>/explore/explore.htm?appname=main</xsl:text>
									<xsl:text>&amp;gateway=</xsl:text>
									<xsl:value-of select="xtsext:protect(xtsext:urlencode(string($gateway)),'url','url','getdata')"/>
									<xsl:text>&amp;query=</xsl:text>
									<xsl:value-of select="$url-encoded-path"/>
								</xsl:with-param>
								<!-- the location of RS is owned by CC -->
								<xsl:with-param name="href"/>
								<xsl:with-param name="icon" select="'action_edit_with_PS.gif'"/>
								<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_EDIT_WPS"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
								<xsl:with-param name="windowProperties">menubar=no,toolbar=no,status=no,location=no,resizable=yes,width=700,height=500</xsl:with-param>		
							</xsl:call-template>
						</xsl:when>
						<!-- Open with Agent Studio  -->
						<xsl:when test="$canUseRS and $class = 'agentDefinition' ">
							<xsl:call-template name="render-action">
								<xsl:with-param name="name" select="'edit'"/>
								<xsl:with-param name="href">
									<xsl:value-of select="$gateway"/>
									<xsl:text>?b_action=xts.run&amp;m=ags/ags.xts&amp;method=editQuery&amp;obj=</xsl:text>
									<xsl:value-of select="xtsext:protect($url-encoded-path,'url','searchPath','getdata')"/>
								</xsl:with-param>
								<xsl:with-param name="icon" select="'action_edit_with_AS.gif'"/>
								<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_EDIT_WAG"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>	
						<xsl:when test="$canUseQS and $class = 'query' and $canExecute">
							<xsl:variable name="qs-url" select="concat($gateway, '?b_action=xts.run&amp;m=qs/qs.xts&amp;method=editQuery&amp;obj=', $url-encoded-path, '&amp;backURL=', $encoded-back-url)"/>
							<xsl:call-template name="render-action">
								<xsl:with-param name="name" select="'edit'"/>
								<xsl:with-param name="href" select="$qs-url"/>
								<xsl:with-param name="icon" select="'action_edit_with_QS.gif'"/>
								<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_EDIT_WQS"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
					</xsl:choose>
				</xsl:if>

				<!-- Custom View ============= -->
				<xsl:if test="($canRead or $canExecute) and $ui-object/action[@name = 'customview']">
					<xsl:call-template name="render-action">
						<xsl:with-param name="name" select="'customview'"/>
						<xsl:with-param name="href">
							<xsl:call-template name="gen-action-url">
								<xsl:with-param name="cmname" select="$name"/>
								<xsl:with-param name="cmclass" select="$class"/>
								<xsl:with-param name="cmpath" select="$path"/>
								<xsl:with-param name="target" select="'new_general.xts'"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="icon" select="'action_new_custom_view.gif'"/>
						<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_CUSTOM"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>

				<!-- Schedule -->
				<xsl:if test="$supportScheduleAction = 'true' and $canRead and $canTraverse and $ui-object/action[@name = 'schedule']">
					<xsl:call-template name="render-action">
						<xsl:with-param name="name" select="'schedule'"/>
						<xsl:with-param name="href">
							<xsl:call-template name="gen-action-url">
								<xsl:with-param name="cmname" select="$name"/>
								<xsl:with-param name="cmclass" select="$class"/>
								<xsl:with-param name="cmpath" select="$path"/>
								<xsl:with-param name="target" select="'schedule/report.xts'"/>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="icon" select="'action_schedule.gif'"/>
						<xsl:with-param name="tooltip"><xsl:value-of select="$IDS_ACT_SCHEDULE"/> - <xsl:value-of select="$toolTipName"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--
		render-action - generate nav:action 
	-->
	<xsl:template name="render-action">
		<xsl:param name="redirectURL" select="''"/>		
		<xsl:param name="name" select="''"/>
		<xsl:param name="tooltip"/>
		<xsl:param name="href" select="''"/>
		<xsl:param name="icon"/>
		<xsl:param name="windowProperties" select="''"/>		

		<nav:action>
			<xsl:if test="$redirectURL != ''">
				<nav:redirectURL>
					<xsl:value-of select="$redirectURL"/>
				</nav:redirectURL>
			</xsl:if>
			<nav:name>
				<xsl:value-of select="$name"/>
			</nav:name>
			<nav:alt>
				<xsl:value-of select="$tooltip"/>
			</nav:alt>
			<nav:url>
				<xsl:value-of select="$href"/>
			</nav:url>
			<nav:imgName>
				<xsl:value-of select="$image_root"/>
				<xsl:value-of select="$icon"/>
			</nav:imgName>
			<xsl:if test="$windowProperties != ''">
				<nav:windowProperties>
					<xsl:value-of select="$windowProperties"/>
				</nav:windowProperties>
			</xsl:if>
		</nav:action>
	</xsl:template>

	<!--
		gen-action-url - Cognos Connection rules to generate "launch actions page" url
	-->
	<xsl:template name="gen-action-url">
		<xsl:param name="cmname"/>
		<xsl:param name="cmclass"/>
		<xsl:param name="cmpath"/>
		<xsl:param name="target"/>

		<xsl:value-of select="$gateway"/>
		<xsl:text>?b_action=xts.run&amp;m=portal/</xsl:text>
		<xsl:value-of select="$target"/>
		<xsl:if test="$target = 'new_general.xts'">
			<xsl:text>&amp;m_new_class=reportView</xsl:text>
		</xsl:if>
		<xsl:text>&amp;m_class=</xsl:text>
		<xsl:value-of select="$cmclass"/>
		<xsl:text>&amp;m_name=</xsl:text>
		<xsl:value-of select="xtsext:protect( xtsext:urlencode(string($cmname)), 'url', 'userData', 'getdata' )"/>
		<xsl:text>&amp;m_path=</xsl:text>
		<xsl:choose>
			<xsl:when test="$m_path != ''">
				<xsl:value-of select="$m_path"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>~/Folder</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>&amp;m_obj=</xsl:text>
		<xsl:value-of select="xtsext:protect( xtsext:urlencode( string( $cmpath ) ), 'url', 'searchPath', 'getdata' )"/>
		<xsl:text>&amp;backURL=</xsl:text>
		<xsl:value-of select="$encoded-back-url"/>
	</xsl:template>

</xsl:stylesheet>