<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/response-login.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" 
	xmlns:faults="http://www.w3.org/2001/09/soap-faults" 
	xmlns:bus="http://developer.cognos.com/schemas/bibus/3/"
	xmlns:xts="http://developer.cognos.com/schemas/xts/"
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>
	
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="/root/errorResponse">
				<xsl:variable name="xts-fault" select="/root/errorResponse/detail/xts:exception"/>
				<xsl:variable name="CAM-exception" select="$xts-fault/xts:exceptionDetail/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/CAM/exception"/>
				<xsl:variable name="misunderstood-exception" select="$xts-fault/xts:exceptionDetail/SOAP-ENV:Envelope/SOAP-ENV:Header/faults:Misunderstood"/>
				<xsl:variable name="details">
					<xsl:choose>
						<xsl:when test="$xts-fault/xts:exceptionCode = 'Client'">
							<xsl:choose>
								<xsl:when test="$xts-fault/xts:exceptionDetail/bus:exception/errorCode = 'cmHeaderFault' and $CAM-exception">
									<xsl:for-each select="$CAM-exception/messages/item/messageString">
										<xsl:value-of select="."/>
										<xsl:text> </xsl:text>
									</xsl:for-each>
									<!-- grab CRN errors from the bus header -->
									<xsl:for-each select="$CAM-exception/promptInfo/captions/item">
										<xsl:value-of select="."/>
										<xsl:text> </xsl:text>
									</xsl:for-each>
								</xsl:when>
								<xsl:when test="$xts-fault/xts:exceptionDetail/bus:exception/errorCode = 'cmHeaderFault' and $misunderstood-exception">
									<xsl:value-of select="$misunderstood-exception/bus:errorDetailDocument/bus:errorMessage"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:for-each select="$xts-fault/xts:exceptionDetail/bus:exception/bus:message/messageString">
										<xsl:value-of select="."/>
										<xsl:text> </xsl:text>
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$xts-fault/xts:exceptionMsg"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<SOAP-ENV:Fault>
					<faultcode xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/">
						<xsl:choose>
							<xsl:when test="$CAM-exception/errorCodeString = 'camAuthUserRecoverable' or $CAM-exception/errorCodeString = 'camAuthSystemRecoverable'">nav:LoginFailed</xsl:when>
							<xsl:otherwise>nav:OperationFailed</xsl:otherwise>
						</xsl:choose>
					</faultcode>
					<faultstring>
						<xsl:value-of select="$details"/>
					</faultstring>
					<detail>
						<xts:traceRequestPath>
							<xsl:value-of select="/root/debug/traceRequestPath"/>
						</xts:traceRequestPath>
						<xsl:copy-of select="$xts-fault"/>
					</detail>
				</SOAP-ENV:Fault>
			</xsl:when>
			<xsl:otherwise>
				<nav:loginResponse xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/">
					<!-- save current user's write capabilities -->
					<xsl:variable name="account" select="/root/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/returns/item[1]/queryResult/item"/>
					<nav:credential name="userWriteCapabilities" maxAge="0" path="/">
						<xsl:if test="$account/permissions/value/item='write'">canWriteToAccount</xsl:if>
					</nav:credential>
				</nav:loginResponse>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>