<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/response-query.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xts="http://developer.cognos.com/schemas/xts/" 
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt" 
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>

	<!-- Because XTS can't process <xts:string> inside an include file, these strings -->
	<!-- must be defined globally here as variables. -->
	<xsl:variable name="IDS_PROPERTIES"><xts:string id="IDS_PROPERTIES"/></xsl:variable>
	<xsl:variable name="IDS_IMG_VIEW_RPT_ALT"><xts:string id="IDS_IMG_VIEW_RPT_ALT"/></xsl:variable>
	<xsl:variable name="IDS_ACT_RUN"><xts:string id="IDS_ACT_RUN"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WPPWX"><xts:string id="IDS_ACT_EDIT_WPPWX"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WRS"><xts:string id="IDS_ACT_EDIT_WRS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WQS"><xts:string id="IDS_ACT_EDIT_WQS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WPS"><xts:string id="IDS_ACT_EDIT_WPS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WAG"><xts:string id="IDS_ACT_EDIT_WAG"/></xsl:variable>
	<xsl:variable name="IDS_ACT_CUSTOM"><xts:string id="IDS_ACT_CUSTOM"/></xsl:variable>
	<xsl:variable name="IDS_ACT_SCHEDULE"><xts:string id="IDS_ACT_SCHEDULE"/></xsl:variable>
	

	<xsl:include href="nav/response-common.xslt"/>

	<xsl:variable name="is-root" select="$op/nav:id[. = 'rootDefault']"/>

	<xsl:template match="/">
		<xsl:element name="nav:{ $op-name }Response" namespace="http://developer.cognos.com/schemas/cps/navigation/1/">
			<xsl:choose>
				<xsl:when test="$queryResponse/queryResult/cacheValidator and not($queryResponse/queryResult/replies/*)">
					<nav:validateTag>
						<xsl:value-of select="$queryResponse/queryResult/cacheValidator"/>
					</nav:validateTag>
				</xsl:when>
				<xsl:otherwise>
					<nav:redirectURL>
						<xsl:value-of select="$redirect-url"/>
					</nav:redirectURL>
					<xsl:choose>
						<xsl:when test="$op-name = 'getContainer'">
							<xsl:choose>
								<xsl:when test="$is-root">
									<xsl:call-template name="root-container">
										<xsl:with-param name="contents" select="$queryResponse/queryResult/replies/item[position() != 1]/queryResult/item"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:when test="$queryResponse/queryResult/replies/item[3]">
									<xsl:apply-templates select="$queryResponse/queryResult/replies/item[2]/queryResult/item">
										<xsl:with-param name="contents" select="$queryResponse/queryResult/replies/item[3]/queryResult/item"/>
										<xsl:with-param name="is-outer-container" select="true()"/>
									</xsl:apply-templates>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates select="$queryResponse/queryResult/replies/item[2]/queryResult/item">
										<xsl:with-param name="is-outer-container" select="true()"/>
									</xsl:apply-templates>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="$op-name = 'getItem'">
							<xsl:choose>
								<xsl:when test="$is-root">
									<xsl:call-template name="root-container"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates select="$queryResponse/queryResult/replies/item[2]/queryResult/item"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
					</xsl:choose>
					<xsl:if test="$queryResponse/queryResult/cacheValidator">
						<nav:validateTag>
							<xsl:value-of select="$queryResponse/queryResult/cacheValidator"/>
						</nav:validateTag>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>

	<!--
		root-container - create fake root container and set $contents as children of root
	-->
	<xsl:template name="root-container">
		<xsl:param name="contents"/>
		
		<nav:container>
			<nav:id>
				<xsl:value-of select="$rootDefaultId"/>
			</nav:id>
			<xsl:if test="$properties[@name = 'parentId']">
				<nav:parentId/>
			</xsl:if>
			<nav:name>
				<xsl:value-of select="$rootDefaultLabel"/>
			</nav:name>
			<nav:imgURL>
				<xsl:call-template name="gen-icon">
					<xsl:with-param name="class" select="'content'"/>
					<xsl:with-param name="isDangling" select="false()"/>
					<xsl:with-param name="output_format" select="''"/>
				</xsl:call-template>
			</nav:imgURL>
			<nav:url/>

			<xsl:if test="$properties[@name = 'description']">
				<nav:description/>
			</xsl:if>
			<xsl:if test="$properties[@name = 'screenTip']">
				<nav:screenTip/>
			</xsl:if>
			<xsl:if test="$properties[@name = 'createDate']">
				<nav:createDate>
					<xsl:value-of select="xtsext:formatDateFromUTC( string( $contents[1]/creationTime/value ), number( '2' ), number( '3' ),  string( $timeZone ),  string( $contentLocale ) )"/>
				</nav:createDate>
			</xsl:if>
			<xsl:if test="$properties[@name = 'lastModifiedDate']">
				<nav:lastModifiedDate>
					<xsl:value-of select="xtsext:formatDateFromUTC( string( $contents[1]/modificationTime/value ), number( '2' ), number( '3' ),  string( $timeZone ),  string( $contentLocale ) )"/>
				</nav:lastModifiedDate>
			</xsl:if>
			<xsl:if test="$properties[@name = 'fullPath']">
				<nav:fullPath/>
			</xsl:if>
			<xsl:if test="$properties[@name = 'action']">
				<xsl:call-template name="action-properties">
					<xsl:with-param name="supportScheduleAction" select="false()"/>
					<xsl:with-param name="canRead" select="true()"/>
					<xsl:with-param name="canWrite" select="false()"/>
					<xsl:with-param name="canExecute" select="false()"/>
					<xsl:with-param name="canTraverse" select="true()"/>
					<xsl:with-param name="class" select="'content'"/>
					<xsl:with-param name="output_format" select="''"/>
					<xsl:with-param name="isDangling" select="false()"/>
				</xsl:call-template>
			</xsl:if>
			<xsl:if test="$properties[@name = 'actionsURL']">
				<nav:actionsURL>
					<xsl:call-template name="gen-action-url">
						<xsl:with-param name="cmname" select="$rootDefaultLabel"/>
						<xsl:with-param name="cmclass" select="'content'"/>
						<xsl:with-param name="cmpath" select="rootDefault"/>
						<xsl:with-param name="target" select="'actions.xts'"/>
					</xsl:call-template>
				</nav:actionsURL>
			</xsl:if>
			<xsl:if test="$properties[@name = 'hasChildren']">
				<nav:hasChildren>true</nav:hasChildren>
			</xsl:if>
			
			<xsl:if test="$contents">
				<!--
					if skip = 0 and max > 1
						show all
					if skip = 0 and max = 1
						show only item 1
					if skip = 1 and max >= 1
						show only item 2
					show nothing
				-->
				<xsl:variable name="skip">
					<xsl:choose>
						<xsl:when test="$skipObjects != ''">
							<xsl:value-of select="number($skipObjects)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="0"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="max">
					<xsl:choose>
						<xsl:when test="$maxObjects != '' and $maxObjects != 0">
							<xsl:value-of select="number($maxObjects)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="10000"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$skip = 0 and $max > 1">
						<!-- show both -->
						<nav:content start="1" end="2" more="false" total="2">
							<xsl:if test="$maxObjects != ''">
								<xsl:attribute name="max">
									<xsl:value-of select="$maxObjects"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:apply-templates select="$contents"/>
						</nav:content>
					</xsl:when>
					<xsl:when test="$skip = 0 and $max = 1">
						<!-- show only item 1 -->
						<nav:content start="1" end="1" max="1" more="true" total="2">
							<xsl:apply-templates select="$contents[1]"/>
						</nav:content>
					</xsl:when>
					<xsl:when test="$skip = 1 and $max >= 1">
						<!-- show only item 2 -->
						<xsl:variable name="item" select="$contents[objectClass/value = 'folder']"/>
						<nav:content start="2" end="2" more="false" total="2">
							<xsl:if test="$maxObjects != ''">
								<xsl:attribute name="max">
									<xsl:value-of select="$maxObjects"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:apply-templates select="$item"/>
						</nav:content>
					</xsl:when>
					<xsl:otherwise>
						<!-- out of range, show none -->
						<nav:content start="0" end="0" more="false" total="2">
							<xsl:if test="$maxObjects != ''">
								<xsl:attribute name="max">
									<xsl:value-of select="$maxObjects"/>
								</xsl:attribute>
							</xsl:if>
						</nav:content>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</nav:container>
	</xsl:template>

</xsl:stylesheet>