<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
   Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
   Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<!-- $Header: //cpscrn/main/src/java/src/com/cognos/cps/bseries/xts/request/nav/stylesheets/nav/response-search.xslt#1 $ -->
<!-- $DateTime: 2008/10/22 11:12:04 $ -->
<!-- $Change: 25109 $ -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xts="http://developer.cognos.com/schemas/xts/" 
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>

	<!-- Because XTS can't process <xts:string> inside an include file, these strings -->
	<!-- must be defined globally here as variables. -->
	<xsl:variable name="IDS_PROPERTIES"><xts:string id="IDS_PROPERTIES"/></xsl:variable>
	<xsl:variable name="IDS_IMG_VIEW_RPT_ALT"><xts:string id="IDS_IMG_VIEW_RPT_ALT"/></xsl:variable>
	<xsl:variable name="IDS_ACT_RUN"><xts:string id="IDS_ACT_RUN"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WPPWX"><xts:string id="IDS_ACT_EDIT_WPPWX"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WRS"><xts:string id="IDS_ACT_EDIT_WRS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WQS"><xts:string id="IDS_ACT_EDIT_WQS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WPS"><xts:string id="IDS_ACT_EDIT_WPS"/></xsl:variable>
	<xsl:variable name="IDS_ACT_EDIT_WAG"><xts:string id="IDS_ACT_EDIT_WAG"/></xsl:variable>
	<xsl:variable name="IDS_ACT_CUSTOM"><xts:string id="IDS_ACT_CUSTOM"/></xsl:variable>
	<xsl:variable name="IDS_ACT_SCHEDULE"><xts:string id="IDS_ACT_SCHEDULE"/></xsl:variable>

	<xsl:include href="nav/response-common.xslt"/>

	<xsl:template match="/">
		<xsl:element name="nav:{ $op-name }Response" namespace="http://developer.cognos.com/schemas/cps/navigation/1/">
			<xsl:choose>
				<xsl:when test="$queryResponse/queryResult/cacheValidator and not($queryResponse/queryResult/replies/*)">
					<nav:validateTag>
						<xsl:value-of select="$queryResponse/queryResult/cacheValidator"/>
					</nav:validateTag>
				</xsl:when>
				<xsl:otherwise>
					<nav:redirectURL>
						<xsl:value-of select="$redirect-url"/>
					</nav:redirectURL>
					<xsl:call-template name="content">
						<xsl:with-param name="contents" select="$queryResponse/queryResult/replies/item[2]/queryResult/item"/>
					</xsl:call-template>
					<xsl:if test="$queryResponse/queryResult/cacheValidator">
						<nav:validateTag>
							<xsl:value-of select="$queryResponse/queryResult/cacheValidator"/>
						</nav:validateTag>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>