/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.converters;

import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.CCLTypeCode;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.DecimalUtils;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReadableRecord
implements ReadableRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVReadableRecord.class);
    private static final String PARSE_ERROR_MSG = "Cannot parse value '%s' for column (%s, %s) at row %d.";
    private static final Pattern STRING_PATTERN = Pattern.compile("\\s++$");
    private static final String SPACE = " ";
    private static final HashSet<String> RSV_NULL_STATE_INDICATORS = new HashSet();
    private final RowSchema schema;
    private final Set<Integer> columnIdsWithUnscaledNumbers;
    private final Set<Integer> columnsIdsWithEmptyAsNull;
    private final Map<Integer, DecimalType> originalDecimalTypeMap;
    private final DecimalFormat decimalFormat;
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter timeTZFormatter;
    private final DateTimeFormatter dateTimeFormatter;
    private final DateTimeFormatter dateTimeFormatterISO;
    private final DateTimeFormatter dateTimeTZFormatter;
    private final ParquetVersionEnum pqVersion;
    private final ConverterOptions converterOptions;
    private CSVRecord csvRecord;
    private int rowId;

    public CSVReadableRecord(RowSchema schema, Set<Integer> columnIdsWithUnscaledNumbers, Set<Integer> columnsIdsWithEmptyAsNull, Map<Integer, DecimalType> originalDecimalTypeMap, ParquetVersionEnum parquetVersion, ConverterOptions convOpts) {
        if (null == schema || 0 == schema.getNumOfColumns()) {
            throw new IllegalArgumentException("Expected a non-empty provided schema.");
        }
        this.schema = schema;
        this.columnIdsWithUnscaledNumbers = columnIdsWithUnscaledNumbers;
        this.columnsIdsWithEmptyAsNull = columnsIdsWithEmptyAsNull;
        this.originalDecimalTypeMap = originalDecimalTypeMap;
        this.pqVersion = parquetVersion;
        this.converterOptions = convOpts;
        this.decimalFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        this.decimalFormat.setParseBigDecimal(true);
        this.dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        this.timeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        this.timeTZFormatter = DateTimeFormatter.ISO_OFFSET_TIME;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("y-MM-dd HH:mm:ss[.n]");
        this.dateTimeFormatterISO = DateTimeFormatter.ISO_DATE_TIME;
        this.dateTimeTZFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    }

    public void setRecord(CSVRecord record, int row) {
        this.csvRecord = record;
        this.rowId = row;
    }

    @Override
    public int size() {
        return this.schema.getNumOfColumns();
    }

    @Override
    public boolean isNull(int index) {
        String rawValue = this.csvRecord.get(index);
        if (null == rawValue) {
            return true;
        }
        if (RSV_NULL_STATE_INDICATORS.contains(rawValue)) {
            return true;
        }
        if (rawValue.isEmpty()) {
            return this.columnsIdsWithEmptyAsNull.contains(index) || !MetadataUtils.isTextType(this.schema.getColumnMetadata(index).getType().getCCLTypeCode());
        }
        return false;
    }

    @Override
    public boolean getBoolean(int index) {
        return Boolean.parseBoolean(this.csvRecord.get(index));
    }

    @Override
    public ByteBuffer getBinary(int index) {
        throw new UnsupportedOperationException("CSV Readable Record does not support parsing binary data.");
    }

    @Override
    public byte getByte(int index) {
        try {
            return Byte.parseByte(this.csvRecord.get(index));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public BigDecimal getDecimal(int index) {
        String rawValue = this.csvRecord.get(index);
        if ((rawValue = rawValue.trim()).charAt(0) == '+') {
            rawValue = rawValue.substring(1);
        }
        try {
            BigDecimal decimalValue;
            DecimalType decimalType;
            DecimalType originalDecimalType = decimalType = (DecimalType)this.schema.getColumnMetadata(index).getType();
            if (this.originalDecimalTypeMap.containsKey(index)) {
                originalDecimalType = this.originalDecimalTypeMap.get(index);
            }
            if (!rawValue.contains(".") && this.columnIdsWithUnscaledNumbers.contains(index)) {
                BigInteger bigInteger = new BigInteger(rawValue);
                decimalValue = new BigDecimal(bigInteger, originalDecimalType.getScale());
            } else {
                decimalValue = (BigDecimal)this.decimalFormat.parse(rawValue);
                decimalValue = decimalValue.setScale(originalDecimalType.getScale(), RoundingMode.DOWN);
            }
            if (ParquetVersionEnum.LEGACY != this.pqVersion) {
                decimalValue = DecimalPolicy.LEAST_SIGNIFICANT_DIGITS_REMOVAL == this.converterOptions.getDecimalPolicy() ? DecimalUtils.truncateDecimalValue(decimalValue, originalDecimalType.getPrecision(), decimalType.getScale()) : DecimalUtils.fitDecimalValue(this.schema.getColumnMetadata(index).getName(), this.rowId, decimalValue);
            }
            return decimalValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot convert the csv raw value ''%s'' to data type %s.", rawValue, CCLTypeCode.getCCLTypeName(this.schema.getColumnMetadata(index).getType().getCCLTypeCode())), e);
        }
    }

    @Override
    public double getDouble(int index) {
        try {
            return Double.parseDouble(this.csvRecord.get(index));
        }
        catch (NullPointerException | NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public float getFloat(int index) {
        try {
            return Float.parseFloat(this.csvRecord.get(index));
        }
        catch (NullPointerException | NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public int getInt(int index) {
        try {
            return Integer.parseInt(this.csvRecord.get(index));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public long getLong(int index) {
        try {
            return Long.parseLong(this.csvRecord.get(index));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public short getShort(int index) {
        try {
            return Short.parseShort(this.csvRecord.get(index));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw nfe;
        }
    }

    @Override
    public String getString(int index) {
        if (this.converterOptions.shouldRemoveTrailingSpaces()) {
            String trimmedRecord = STRING_PATTERN.matcher(this.csvRecord.get(index)).replaceFirst("");
            if (trimmedRecord.isEmpty() && !this.csvRecord.get(index).isEmpty()) {
                trimmedRecord = SPACE;
            }
            return trimmedRecord;
        }
        return this.csvRecord.get(index);
    }

    @Override
    public LocalDate getDate(int index) {
        try {
            return LocalDate.parse(this.csvRecord.get(index), this.dateFormatter);
        }
        catch (DateTimeParseException dtpe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw dtpe;
        }
    }

    @Override
    public LocalTime getTime(int index) {
        try {
            return LocalTime.parse(this.csvRecord.get(index).trim(), this.timeFormatter);
        }
        catch (DateTimeParseException dtpe) {
            LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
            throw dtpe;
        }
    }

    @Override
    public OffsetTime getOffsetTime(int index) {
        OffsetTime offsetTime;
        String rawValue = this.csvRecord.get(index).trim();
        try {
            offsetTime = OffsetTime.parse(rawValue, this.timeTZFormatter);
        }
        catch (DateTimeParseException dtpe) {
            LOGGER.warn("Raw value '{}' cannot be parsed as {}. Attempting to parse it assuming it is at UTC.", (Object)rawValue, (Object)CCLTypeCode.getCCLTypeName(52));
            LocalTime localTime = this.getTime(index);
            offsetTime = localTime.atOffset(ZoneOffset.UTC);
        }
        return offsetTime;
    }

    @Override
    public LocalDateTime getDateTime(int index) {
        try {
            return LocalDateTime.parse(this.csvRecord.get(index).trim(), this.dateTimeFormatterISO);
        }
        catch (DateTimeParseException dtpe) {
            try {
                return LocalDateTime.parse(this.csvRecord.get(index).trim(), this.dateTimeFormatter);
            }
            catch (DateTimeParseException dtpe2) {
                LOGGER.error(String.format(PARSE_ERROR_MSG, this.csvRecord.get(index), this.schema.getColumnMetadata(index).getName(), this.schema.getColumnMetadata(index).getType().toXQETypeString(), this.rowId));
                throw dtpe2;
            }
        }
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        OffsetDateTime offsetDateTime;
        String rawValue = this.csvRecord.get(index).trim();
        try {
            offsetDateTime = OffsetDateTime.parse(rawValue, this.dateTimeTZFormatter);
        }
        catch (DateTimeParseException dtpe) {
            LOGGER.warn("Raw value '{}' cannot be parsed as {}. Attempting to parse it assuming it is at UTC.", (Object)rawValue, (Object)CCLTypeCode.getCCLTypeName(53));
            LocalDateTime localDateTime = this.getDateTime(index);
            offsetDateTime = localDateTime.atOffset(ZoneOffset.UTC);
        }
        return offsetDateTime;
    }

    public String toString() {
        return this.csvRecord.toString();
    }

    static {
        RSV_NULL_STATE_INDICATORS.add("--");
        RSV_NULL_STATE_INDICATORS.add("#!Security");
        RSV_NULL_STATE_INDICATORS.add("/0");
        RSV_NULL_STATE_INDICATORS.add("#!Error");
        RSV_NULL_STATE_INDICATORS.add("#!Casting Error");
        RSV_NULL_STATE_INDICATORS.add("#!Overflow");
        RSV_NULL_STATE_INDICATORS.add("?");
        RSV_NULL_STATE_INDICATORS.add("\\N");
    }
}

