/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata;

import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.metadata.types.TypeFactory;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Column
implements ColumnMetadata {
    private final String columnName;
    private final boolean canBeNullable;
    private final Type dataType;

    public Column(String name, boolean isNullable, Type type) {
        this.columnName = name;
        this.canBeNullable = isNullable;
        this.dataType = type;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public boolean isNullable() {
        return this.canBeNullable;
    }

    @Override
    public Type getType() {
        return this.dataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnMetadata)) {
            return false;
        }
        ColumnMetadata other = (ColumnMetadata)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)other.getName()).append(this.isNullable(), other.isNullable()).append((Object)this.getType(), (Object)other.getType()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append(this.isNullable()).append((Object)this.getType()).toHashCode();
    }

    public String toString() {
        try {
            return this.toJson().serialize(false);
        }
        catch (IOException ex) {
            return "";
        }
    }

    @Override
    public JSONObject toJson() {
        OrderedJSONObject json = new OrderedJSONObject();
        json.put((Object)"name", (Object)this.getName());
        json.put((Object)"nullable", (Object)this.isNullable());
        json.put((Object)"type", (Object)this.getType().toJson());
        return json;
    }

    public static Column fromJson(JSONObject json) {
        String name = json.get((Object)"name").toString();
        boolean nullable = (Boolean)json.get((Object)"nullable");
        Type type = TypeFactory.fromJson((JSONObject)json.get((Object)"type"));
        return new Column(name, nullable, type);
    }
}

