/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BaseType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.json.java.JSONObject;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DecimalType
extends BaseType {
    static final String JSON_PRECISION = "precision";
    static final String JSON_SCALE = "scale";
    private static final String DECIMAL_FORMATTER = "DECIMAL(%1$d,%2$d)";
    private final int precision;
    private final int scale;

    protected DecimalType(int thePrecision, int theScale) {
        this.precision = thePrecision;
        this.scale = theScale;
    }

    @Override
    public EIntrinsicType getIntrinsicType() {
        return EIntrinsicType.DECIMAL;
    }

    @Override
    public byte getCCLTypeCode() {
        return 12;
    }

    @Override
    public String toXQETypeString() {
        return String.format(DECIMAL_FORMATTER, this.getPrecision(), this.getScale());
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put((Object)JSON_PRECISION, (Object)this.getPrecision());
        json.put((Object)JSON_SCALE, (Object)this.getScale());
        return json;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.precision).append(this.scale).toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof DecimalType) {
            DecimalType other = (DecimalType)o;
            return this.getPrecision() == other.getPrecision() && this.getScale() == other.getScale();
        }
        return false;
    }
}

