/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.metadata.types;

import com.ibm.bi.platform.datasetutils.metadata.types.BinaryType;
import com.ibm.bi.platform.datasetutils.metadata.types.BooleanType;
import com.ibm.bi.platform.datasetutils.metadata.types.ByteType;
import com.ibm.bi.platform.datasetutils.metadata.types.DateType;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.DoubleType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.FloatType;
import com.ibm.bi.platform.datasetutils.metadata.types.IntegerType;
import com.ibm.bi.platform.datasetutils.metadata.types.LongType;
import com.ibm.bi.platform.datasetutils.metadata.types.ShortType;
import com.ibm.bi.platform.datasetutils.metadata.types.StringType;
import com.ibm.bi.platform.datasetutils.metadata.types.TimeType;
import com.ibm.bi.platform.datasetutils.metadata.types.TimestampType;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.json.java.JSONObject;
import org.apache.parquet.schema.DecimalMetadata;

public class TypeFactory {
    public static final BinaryType BINARY_TYPE = new BinaryType();
    public static final BooleanType BOOLEAN_TYPE = new BooleanType();
    public static final ByteType BYTE_TYPE = new ByteType();
    public static final DateType DATE_TYPE = new DateType();
    public static final DoubleType DOUBLE_TYPE = new DoubleType();
    public static final FloatType FLOAT_TYPE = new FloatType();
    public static final IntegerType INTEGER_TYPE = new IntegerType();
    public static final LongType LONG_TYPE = new LongType();
    public static final ShortType SHORT_TYPE = new ShortType();
    public static final StringType STRING_TYPE = new StringType();
    public static final TimestampType TIMESTAMP_TYPE = new TimestampType();
    public static final TimestampType TIMESTAMP_TZ_TYPE = new TimestampType(53);
    public static final TimeType TIME_TYPE = new TimeType();
    public static final TimeType TIME_TZ_TYPE = new TimeType(52);
    public static final StringType INTERVAL_DAY_TIME_TYPE = new StringType(16);
    public static final StringType INTERVAL_YEAR_MONTH_TYPE = new StringType(17);

    private TypeFactory() {
    }

    public static DecimalType getDecimalType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static DecimalType getDecimalType(DecimalMetadata decimalMeta) {
        return new DecimalType(decimalMeta.getPrecision(), decimalMeta.getScale());
    }

    public static IntegerType getIntegerType(byte cclType) {
        if (6 == cclType) {
            return INTEGER_TYPE;
        }
        return new IntegerType(cclType);
    }

    public static ShortType getShortType(byte cclType) {
        if (4 == cclType) {
            return SHORT_TYPE;
        }
        return new ShortType(cclType);
    }

    public static StringType getStringType(byte cclType) {
        if (17 == cclType) {
            return INTERVAL_YEAR_MONTH_TYPE;
        }
        if (16 == cclType || 60 == cclType) {
            return INTERVAL_DAY_TIME_TYPE;
        }
        return STRING_TYPE;
    }

    public static TimestampType getTimestampType(byte cclType) {
        if (59 == cclType) {
            return TIMESTAMP_TYPE;
        }
        if (53 == cclType) {
            return TIMESTAMP_TZ_TYPE;
        }
        return new TimestampType(cclType);
    }

    public static TimeType getTimeType(byte cclType) {
        if (58 == cclType) {
            return TIME_TYPE;
        }
        if (52 == cclType) {
            return TIME_TZ_TYPE;
        }
        return new TimeType(cclType);
    }

    public static Type fromJson(JSONObject json) {
        EIntrinsicType intrinsicType = EIntrinsicType.valueOf(json.get((Object)"intrinsicType").toString().toUpperCase());
        switch (intrinsicType) {
            case BINARY: {
                return BINARY_TYPE;
            }
            case BOOLEAN: {
                return BOOLEAN_TYPE;
            }
            case BYTE: {
                return BYTE_TYPE;
            }
            case DATE: {
                return DATE_TYPE;
            }
            case DECIMAL: {
                return TypeFactory.getDecimalType(((Number)json.get((Object)"precision")).intValue(), ((Number)json.get((Object)"scale")).intValue());
            }
            case DOUBLE: {
                return DOUBLE_TYPE;
            }
            case FLOAT: {
                return FLOAT_TYPE;
            }
            case INT: {
                return TypeFactory.getIntegerType(((Number)json.get((Object)"cclTypeCode")).byteValue());
            }
            case LONG: {
                return LONG_TYPE;
            }
            case SHORT: {
                return TypeFactory.getShortType(((Number)json.get((Object)"cclTypeCode")).byteValue());
            }
            case STRING: {
                return TypeFactory.getStringType(((Number)json.get((Object)"cclTypeCode")).byteValue());
            }
            case TIME: {
                return TypeFactory.getTimeType(((Number)json.get((Object)"cclTypeCode")).byteValue());
            }
            case TIMESTAMP: {
                return TypeFactory.getTimestampType(((Number)json.get((Object)"cclTypeCode")).byteValue());
            }
        }
        throw new IllegalArgumentException("Unsupported intrinsic type:" + intrinsicType.name());
    }
}

