/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.parquet.DatasetReadSupport;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import java.time.ZoneId;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.MessageType;
import shaded.org.apache.hadoop.fs.Path;

public class DatasetParquetReaderBuilder
extends ParquetReader.Builder<ReadableRecord> {
    private ParquetOptions customOptions = null;
    private ParquetVersionEnum version = null;
    private ZoneId timeZoneId = null;
    private MessageType projectionSchema = null;
    private List<String> projectionFields = null;

    public DatasetParquetReaderBuilder(Path path) {
        super(path);
    }

    public DatasetParquetReaderBuilder withCustomOptions(ParquetOptions options) {
        this.customOptions = options;
        return this;
    }

    public DatasetParquetReaderBuilder withParquetVersion(ParquetVersionEnum version) {
        this.version = version;
        return this;
    }

    public DatasetParquetReaderBuilder withTimeZoneId(ZoneId zoneId) {
        this.timeZoneId = zoneId;
        return this;
    }

    public DatasetParquetReaderBuilder withProjectionSchema(MessageType schema) {
        this.projectionSchema = schema;
        return this;
    }

    public DatasetParquetReaderBuilder withProjectionFields(List<String> fields) {
        this.projectionFields = fields;
        return this;
    }

    protected ReadSupport<ReadableRecord> getReadSupport() {
        ParquetOptions effectiveOptions = new ParquetOptions();
        if (null != this.customOptions) {
            effectiveOptions.putAll(effectiveOptions);
        }
        if (null != this.version) {
            effectiveOptions.put("parquet.ca.version", this.version.getValue());
        }
        if (null != this.timeZoneId) {
            effectiveOptions.put("parquet.time.zone-id", this.timeZoneId.getId());
        }
        if (null != this.projectionSchema) {
            effectiveOptions.put("parquet.projection.schema", this.projectionSchema.toString());
        } else if (null != this.projectionFields) {
            effectiveOptions.put("parquet.projection.fields", this.projectionFields.stream().collect(Collectors.joining(",")));
        }
        return new DatasetReadSupport(effectiveOptions);
    }
}

