/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.TimeType;
import com.ibm.bi.platform.datasetutils.metadata.types.TimestampType;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ArrayRecord;
import com.ibm.bi.platform.datasetutils.utils.DateTimeUtils;
import com.ibm.bi.platform.datasetutils.utils.DecimalUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.datasetutils.utils.UTF8Decoder;
import com.ibm.bi.platform.datasetutils.utils.WritableRecord;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;

class DatasetReadSupport
extends ReadSupport<ReadableRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetReadSupport.class);
    private final ParquetOptions initialOptions;

    public DatasetReadSupport(ParquetOptions options) {
        this.initialOptions = new ParquetOptions(options);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        Configuration config = context.getConfiguration();
        Map metadata = context.getMergedKeyValueMetaData();
        MessageType requestedSchema = DatasetParquetReadHelper.getProjectedMessageType(context.getFileSchema(), this.initialOptions, config);
        return new ReadSupport.ReadContext(requestedSchema, metadata);
    }

    public RecordMaterializer<ReadableRecord> prepareForRead(Configuration config, Map<String, String> extraMetadata, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType requestedSchema = readContext.getRequestedSchema();
        ParquetOptions options = new ParquetOptions(this.initialOptions);
        LOGGER.debug("Preparing for read with requested schema [{}] and extra metadata [{}]", (Object)requestedSchema, extraMetadata);
        DatasetParquetReadHelper.setOptionsFromMetadata(options, extraMetadata);
        LOGGER.debug("Final parquet options: {}", (Object)options);
        RowSchema recordSchema = DatasetParquetReadHelper.getRecordSchema(requestedSchema, extraMetadata, options);
        return new DatasetRecordMaterializer(requestedSchema, recordSchema, options);
    }

    private static class TimestampWithTZGroupConverter
    extends GroupConverter {
        private long millisAsINT64part;
        private int nanosAsINT32part;
        private int tzAsINT32part;
        private final ParentContainerUpdater updater;
        private Converter[] converters = new Converter[3];

        TimestampWithTZGroupConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
            this.converters[0] = new LongConverter(new ParentContainerUpdater(){

                @Override
                public void addLong(long value) {
                    millisAsINT64part = value;
                }
            });
            this.converters[1] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    nanosAsINT32part = value;
                }
            });
            this.converters[2] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    tzAsINT32part = value;
                }
            });
        }

        public void end() {
            ZoneOffset zoneOffset = null;
            try {
                zoneOffset = ZoneOffset.ofTotalSeconds(-this.tzAsINT32part * 60);
            }
            catch (DateTimeException dte) {
                zoneOffset = ZoneOffset.ofTotalSeconds(this.tzAsINT32part / 1000);
            }
            this.updater.addOffsetDateTime(Instant.ofEpochMilli(this.millisAsINT64part).plusNanos(this.nanosAsINT32part).atOffset(zoneOffset));
        }

        public Converter getConverter(int arg0) {
            return this.converters[arg0];
        }

        public void start() {
        }
    }

    private static class LocalDateTimeGroupConverter
    extends GroupConverter {
        private long millisAsINT64part;
        private int nanosAsINT32part;
        private final ParentContainerUpdater updater;
        private final ZoneId zoneId;
        private Converter[] converters = new Converter[2];

        LocalDateTimeGroupConverter(ParentContainerUpdater parentUpdater, ParquetOptions pqOptions) {
            this.updater = parentUpdater;
            this.zoneId = pqOptions.getTimeZoneId();
            this.converters[0] = new LongConverter(new ParentContainerUpdater(){

                @Override
                public void addLong(long value) {
                    millisAsINT64part = value;
                }
            });
            this.converters[1] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    nanosAsINT32part = value;
                }
            });
        }

        public void end() {
            this.updater.addDateTime(Instant.ofEpochMilli(this.millisAsINT64part).plusNanos(this.nanosAsINT32part).atZone(this.zoneId).toLocalDateTime());
        }

        public Converter getConverter(int arg0) {
            return this.converters[arg0];
        }

        public void start() {
        }
    }

    private static class TimeWithTZGroupConverter
    extends GroupConverter {
        private long millisAsINT64part;
        private int nanosAsINT32part;
        private int tzAsINT32part;
        private final ParentContainerUpdater updater;
        private Converter[] converters = new Converter[3];

        TimeWithTZGroupConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
            this.converters[0] = new LongConverter(new ParentContainerUpdater(){

                @Override
                public void addLong(long value) {
                    millisAsINT64part = value;
                }
            });
            this.converters[1] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    nanosAsINT32part = value;
                }
            });
            this.converters[2] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    tzAsINT32part = value;
                }
            });
        }

        public void end() {
            ZoneOffset zoneOffset;
            try {
                zoneOffset = ZoneOffset.ofTotalSeconds(-this.tzAsINT32part * 60);
            }
            catch (DateTimeException dte) {
                zoneOffset = ZoneOffset.ofTotalSeconds(this.tzAsINT32part / 1000);
            }
            this.updater.addOffsetTime(Instant.ofEpochMilli(this.millisAsINT64part).plusNanos(this.nanosAsINT32part).atOffset(zoneOffset).toOffsetTime());
        }

        public Converter getConverter(int arg0) {
            return this.converters[arg0];
        }

        public void start() {
        }
    }

    private static class LocalTimeGroupConverter
    extends GroupConverter {
        private long millisAsINT64part;
        private int nanosAsINT32part;
        private final ParentContainerUpdater updater;
        private final ZoneId zoneId;
        private Converter[] converters = new Converter[2];

        LocalTimeGroupConverter(ParentContainerUpdater parentUpdater, ParquetOptions pqOptions) {
            this.updater = parentUpdater;
            this.zoneId = pqOptions.getTimeZoneId();
            this.converters[0] = new LongConverter(new ParentContainerUpdater(){

                @Override
                public void addLong(long value) {
                    millisAsINT64part = value;
                }
            });
            this.converters[1] = new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    nanosAsINT32part = value;
                }
            });
        }

        public void end() {
            this.updater.addTime(Instant.ofEpochMilli(this.millisAsINT64part).plusNanos(this.nanosAsINT32part).atZone(this.zoneId).toLocalTime());
        }

        public Converter getConverter(int arg0) {
            return this.converters[arg0];
        }

        public void start() {
        }
    }

    private static class StringConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;
        private final boolean dictionarySupport;
        private final UTF8Decoder decoder = new UTF8Decoder();
        private String[] stringDictionary;

        StringConverter(ParentContainerUpdater parentUpdater, boolean hasDictionarySupport) {
            this.updater = parentUpdater;
            this.dictionarySupport = hasDictionarySupport;
        }

        public boolean hasDictionarySupport() {
            return this.dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this.stringDictionary = new String[dictionary.getMaxId() + 1];
            for (int id = 0; id <= dictionary.getMaxId(); ++id) {
                this.stringDictionary[id] = this.decoder.decode(dictionary.decodeToBinary(id).toByteBuffer());
            }
        }

        public void addValueFromDictionary(int id) {
            this.updater.addString(this.stringDictionary[id]);
        }

        public void addBinary(Binary value) {
            this.updater.addString(this.decoder.decode(value.toByteBuffer()));
        }
    }

    private static class DateTimeAsINT96Converter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;
        private final boolean isTimestampWithTZ;
        private final ZoneId zoneId;

        DateTimeAsINT96Converter(ParentContainerUpdater parentUpdater, boolean withTZ, ParquetOptions theParquetOptions) {
            this.updater = parentUpdater;
            this.isTimestampWithTZ = withTZ;
            this.zoneId = theParquetOptions.getTimeZoneId();
        }

        public void addBinary(Binary value) {
            if (this.isTimestampWithTZ) {
                LocalDateTime localDateTime = DateTimeUtils.fromInt96(value);
                this.updater.addOffsetDateTime(localDateTime.atZone(this.zoneId).toOffsetDateTime());
            } else {
                this.updater.addDateTime(DateTimeUtils.fromInt96(value));
            }
        }
    }

    private static class TimeAsINT96Converter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;
        private final boolean isTimeWithTZ;
        private final ZoneOffset zoneOffset;

        TimeAsINT96Converter(ParentContainerUpdater parentUpdater, boolean withTZ, ParquetOptions pqOptions) {
            this.updater = parentUpdater;
            this.isTimeWithTZ = withTZ;
            this.zoneOffset = pqOptions.getTimeZoneOffset();
        }

        public void addBinary(Binary value) {
            if (this.isTimeWithTZ) {
                LocalTime localTime = DateTimeUtils.fromInt96(value).toLocalTime();
                this.updater.addOffsetTime(localTime.atOffset(this.zoneOffset));
            } else {
                this.updater.addTime(DateTimeUtils.fromInt96(value).toLocalTime());
            }
        }
    }

    private static class DecimalBinaryDictionaryAwareConverter
    extends DecimalConverter {
        DecimalBinaryDictionaryAwareConverter(ParentContainerUpdater parentUpdater, boolean hasDictionarySupport, int thePrecision, int theScale, boolean useDecimalAsStringEncoding) {
            super(parentUpdater, hasDictionarySupport, thePrecision, theScale, useDecimalAsStringEncoding);
        }

        public void setDictionary(Dictionary dictionary) {
            this.decimalDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            if (this.isDecimalEncodedAsBinaryString) {
                for (int i = 0; i < this.decimalDictionary.length; ++i) {
                    this.decimalDictionary[i] = new BigDecimal(dictionary.decodeToBinary(i).toStringUsingUTF8(), this.mathContext).setScale(this.scale);
                }
            } else {
                for (int i = 0; i < this.decimalDictionary.length; ++i) {
                    this.decimalDictionary[i] = DecimalUtils.decimalFromBinary(dictionary.decodeToBinary(i), this.precision, this.scale);
                }
            }
        }
    }

    private static class DecimalLongDictionaryAwareConverter
    extends DecimalConverter {
        DecimalLongDictionaryAwareConverter(ParentContainerUpdater parentUpdater, boolean hasDictionarySupport, int thePrecision, int theScale) {
            super(parentUpdater, hasDictionarySupport, thePrecision, theScale, false);
        }

        public void setDictionary(Dictionary dictionary) {
            this.decimalDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            for (int i = 0; i < this.decimalDictionary.length; ++i) {
                this.decimalDictionary[i] = DecimalUtils.decimalFromUnscaledLong(dictionary.decodeToLong(i), this.precision, this.scale);
            }
        }
    }

    private static class DecimalIntDictionaryAwareConverter
    extends DecimalConverter {
        DecimalIntDictionaryAwareConverter(ParentContainerUpdater parentUpdater, boolean hasDictionarySupport, int thePrecision, int theScale) {
            super(parentUpdater, hasDictionarySupport, thePrecision, theScale, false);
        }

        public void setDictionary(Dictionary dictionary) {
            this.decimalDictionary = new BigDecimal[dictionary.getMaxId() + 1];
            for (int i = 0; i < this.decimalDictionary.length; ++i) {
                this.decimalDictionary[i] = DecimalUtils.decimalFromUnscaledInt(dictionary.decodeToInt(i), this.precision, this.scale);
            }
        }
    }

    private static abstract class DecimalConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;
        private final boolean dictionarySupport;
        protected final int scale;
        protected final int precision;
        protected final MathContext mathContext;
        protected final boolean isDecimalEncodedAsBinaryString;
        protected BigDecimal[] decimalDictionary;

        DecimalConverter(ParentContainerUpdater parentUpdater, boolean hasDictionarySupport, int thePrecision, int theScale, boolean useDecimalAsStringEncoding) {
            this.updater = parentUpdater;
            this.dictionarySupport = hasDictionarySupport;
            this.scale = theScale;
            this.precision = thePrecision;
            this.mathContext = new MathContext(thePrecision);
            this.isDecimalEncodedAsBinaryString = useDecimalAsStringEncoding;
        }

        public boolean hasDictionarySupport() {
            return this.dictionarySupport;
        }

        public void addValueFromDictionary(int id) {
            this.updater.addDecimal(this.decimalDictionary[id]);
        }

        public void addInt(int value) {
            this.updater.addDecimal(DecimalUtils.decimalFromUnscaledInt(value, this.precision, this.scale));
        }

        public void addLong(long value) {
            this.updater.addDecimal(DecimalUtils.decimalFromUnscaledLong(value, this.precision, this.scale));
        }

        public void addBinary(Binary value) {
            if (this.isDecimalEncodedAsBinaryString) {
                this.updater.addDecimal(new BigDecimal(value.toStringUsingUTF8(), this.mathContext).setScale(this.scale));
            } else {
                this.updater.addDecimal(DecimalUtils.decimalFromBinary(value, this.precision, this.scale));
            }
        }
    }

    private static class DateConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;
        private final ZoneId zoneId;

        DateConverter(ParentContainerUpdater parentUpdater, ParquetOptions pqOptions) {
            this.updater = parentUpdater;
            this.zoneId = pqOptions.getTimeZoneId();
        }

        public void addInt(int value) {
            this.updater.addDate(LocalDate.ofEpochDay(value));
        }

        public void addLong(long value) {
            this.updater.addDate(Instant.ofEpochMilli(value).atZone(this.zoneId).toLocalDate());
        }
    }

    private static class DoubleConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        DoubleConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addDouble(double value) {
            this.updater.addDouble(value);
        }
    }

    private static class FloatConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        FloatConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addFloat(float value) {
            this.updater.addFloat(value);
        }
    }

    private static class LongConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        LongConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addLong(long value) {
            this.updater.addLong(value);
        }
    }

    private static class IntConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        IntConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addInt(int value) {
            this.updater.addInt(value);
        }
    }

    private static class ShortConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        ShortConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addInt(int value) {
            this.updater.addShort((short)value);
        }
    }

    private static class BinaryConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        BinaryConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addBinary(Binary value) {
            this.updater.addBinary(value.toByteBuffer());
        }
    }

    private static class ByteConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        ByteConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addInt(int value) {
            this.updater.addByte((byte)value);
        }
    }

    private static class BooleanConverter
    extends PrimitiveConverter {
        private final ParentContainerUpdater updater;

        BooleanConverter(ParentContainerUpdater parentUpdater) {
            this.updater = parentUpdater;
        }

        public void addBoolean(boolean value) {
            this.updater.addBoolean(value);
        }
    }

    private static class DatasetRecordConverter
    extends GroupConverter {
        private final ArrayRecord record;
        private final Converter[] converters;

        DatasetRecordConverter(MessageType parquetSchema, RowSchema recordSchema, ParquetOptions options) {
            this.record = new ArrayRecord(parquetSchema.getFieldCount());
            this.converters = DatasetRecordConverter.createConverters(parquetSchema, recordSchema, this.record, options);
        }

        ReadableRecord getRecord() {
            return this.record;
        }

        public void start() {
            for (int fieldIndex = 0; fieldIndex < this.record.size(); ++fieldIndex) {
                this.record.setNull(fieldIndex);
            }
        }

        public void end() {
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        private static Converter[] createConverters(MessageType parquetSchema, RowSchema recordSchema, WritableRecord record, ParquetOptions options) {
            int numFields = parquetSchema.getFieldCount();
            Converter[] converters = new Converter[numFields];
            for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
                converters[fieldIndex] = DatasetRecordConverter.createConverter(parquetSchema.getType(fieldIndex), recordSchema.getColumnMetadata(fieldIndex), record, fieldIndex, options);
            }
            return converters;
        }

        private static Converter createConverter(Type parquetType, ColumnMetadata columnMeta, WritableRecord record, int fieldIndex, ParquetOptions options) {
            if (parquetType.isPrimitive()) {
                return DatasetRecordConverter.createPrimitiveConverter(parquetType.asPrimitiveType(), columnMeta, record, fieldIndex, options);
            }
            return DatasetRecordConverter.createGroupConverter(parquetType.asGroupType(), columnMeta, record, fieldIndex, options);
        }

        private static PrimitiveConverter createPrimitiveConverter(PrimitiveType primitiveType, ColumnMetadata columnMeta, WritableRecord record, int fieldIndex, ParquetOptions options) {
            switch (columnMeta.getType().getIntrinsicType()) {
                case BOOLEAN: {
                    return DatasetRecordConverter.createBooleanConverter(record, fieldIndex);
                }
                case BYTE: {
                    return DatasetRecordConverter.createByteConverter(record, fieldIndex);
                }
                case SHORT: {
                    return DatasetRecordConverter.createShortConverter(record, fieldIndex);
                }
                case INT: {
                    return DatasetRecordConverter.createIntConverter(record, fieldIndex);
                }
                case LONG: {
                    return DatasetRecordConverter.createLongConverter(record, fieldIndex);
                }
                case FLOAT: {
                    return DatasetRecordConverter.createFloatConverter(record, fieldIndex);
                }
                case DOUBLE: {
                    return DatasetRecordConverter.createDoubleConverter(record, fieldIndex);
                }
                case BINARY: {
                    return DatasetRecordConverter.createBinaryConverter(record, fieldIndex);
                }
                case STRING: {
                    return DatasetRecordConverter.createStringConverter(record, fieldIndex, true);
                }
                case DECIMAL: {
                    return DatasetRecordConverter.createDecimalConverter(record, fieldIndex, primitiveType, options.getParquetCAVersion());
                }
                case DATE: {
                    return DatasetRecordConverter.createDateConverter(record, fieldIndex, options);
                }
                case TIME: {
                    return DatasetRecordConverter.createTimeAsINT96Converter(record, fieldIndex, (TimeType)columnMeta.getType(), options);
                }
                case TIMESTAMP: {
                    return DatasetRecordConverter.createDateTimeAsINT96Converter(record, fieldIndex, (TimestampType)columnMeta.getType(), options);
                }
            }
            throw new ParquetDecodingException(String.format("Unsupported column type (%s) for decoding it using a Primitive Converter.", columnMeta.getType()));
        }

        private static GroupConverter createGroupConverter(GroupType groupType, ColumnMetadata columnMeta, WritableRecord record, int fieldIndex, ParquetOptions options) {
            switch (columnMeta.getType().getIntrinsicType()) {
                case TIME: {
                    return DatasetRecordConverter.createTimeGroupConverter(record, fieldIndex, (TimeType)columnMeta.getType(), options);
                }
                case TIMESTAMP: {
                    return DatasetRecordConverter.createTimestampGroupConverter(record, fieldIndex, (TimestampType)columnMeta.getType(), options);
                }
            }
            throw new ParquetDecodingException(String.format("Unsupported column type (%s) for decoding it using a Group Converter.", columnMeta.getType()));
        }

        private static PrimitiveConverter createStringConverter(final WritableRecord record, final int fieldIndex, boolean hasDictionarySupport) {
            return new StringConverter(new ParentContainerUpdater(){

                @Override
                public void addString(String value) {
                    record.setString(fieldIndex, value);
                }
            }, hasDictionarySupport);
        }

        private static PrimitiveConverter createBooleanConverter(final WritableRecord record, final int fieldIndex) {
            return new BooleanConverter(new ParentContainerUpdater(){

                @Override
                public void addBoolean(boolean value) {
                    record.setBoolean(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createByteConverter(final WritableRecord record, final int fieldIndex) {
            return new ByteConverter(new ParentContainerUpdater(){

                @Override
                public void addByte(byte value) {
                    record.setByte(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createBinaryConverter(final WritableRecord record, final int fieldIndex) {
            return new BinaryConverter(new ParentContainerUpdater(){

                @Override
                public void addBinary(ByteBuffer byteBuffer) {
                    record.setBinary(fieldIndex, byteBuffer);
                }
            });
        }

        private static PrimitiveConverter createShortConverter(final WritableRecord record, final int fieldIndex) {
            return new ShortConverter(new ParentContainerUpdater(){

                @Override
                public void addShort(short value) {
                    record.setShort(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createIntConverter(final WritableRecord record, final int fieldIndex) {
            return new IntConverter(new ParentContainerUpdater(){

                @Override
                public void addInt(int value) {
                    record.setInt(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createLongConverter(final WritableRecord record, final int fieldIndex) {
            return new LongConverter(new ParentContainerUpdater(){

                @Override
                public void addLong(long value) {
                    record.setLong(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createFloatConverter(final WritableRecord record, final int fieldIndex) {
            return new FloatConverter(new ParentContainerUpdater(){

                @Override
                public void addFloat(float value) {
                    record.setFloat(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createDoubleConverter(final WritableRecord record, final int fieldIndex) {
            return new DoubleConverter(new ParentContainerUpdater(){

                @Override
                public void addDouble(double value) {
                    record.setDouble(fieldIndex, value);
                }
            });
        }

        private static PrimitiveConverter createDateConverter(final WritableRecord record, final int fieldIndex, ParquetOptions pqOptions) {
            return new DateConverter(new ParentContainerUpdater(){

                @Override
                public void addDate(LocalDate value) {
                    record.setDate(fieldIndex, value);
                }
            }, pqOptions);
        }

        private static PrimitiveConverter createTimeAsINT96Converter(final WritableRecord record, final int fieldIndex, TimeType timeType, ParquetOptions pqOptions) {
            return new TimeAsINT96Converter(new ParentContainerUpdater(){

                @Override
                public void addTime(LocalTime value) {
                    record.setTime(fieldIndex, value);
                }

                @Override
                public void addOffsetTime(OffsetTime value) {
                    record.setOffsetTime(fieldIndex, value);
                }
            }, timeType.hasTimeZone(), pqOptions);
        }

        private static PrimitiveConverter createDateTimeAsINT96Converter(final WritableRecord record, final int fieldIndex, TimestampType timestampType, ParquetOptions pqOptions) {
            return new DateTimeAsINT96Converter(new ParentContainerUpdater(){

                @Override
                public void addDateTime(LocalDateTime value) {
                    record.setDateTime(fieldIndex, value);
                }

                @Override
                public void addOffsetDateTime(OffsetDateTime value) {
                    record.setOffsetDateTime(fieldIndex, value);
                }
            }, timestampType.hasTimeZone(), pqOptions);
        }

        private static PrimitiveConverter createDecimalConverter(final WritableRecord record, final int fieldIndex, PrimitiveType pqPrimitiveType, ParquetVersionEnum pqVersion) {
            int precision = pqPrimitiveType.getDecimalMetadata().getPrecision();
            int scale = pqPrimitiveType.getDecimalMetadata().getScale();
            PrimitiveType.PrimitiveTypeName pqPrimitiveTypeName = pqPrimitiveType.getPrimitiveTypeName();
            switch (pqPrimitiveTypeName) {
                case INT32: {
                    return new DecimalIntDictionaryAwareConverter(new ParentContainerUpdater(){

                        @Override
                        public void addDecimal(BigDecimal value) {
                            record.setDecimal(fieldIndex, value);
                        }
                    }, true, precision, scale);
                }
                case INT64: {
                    return new DecimalLongDictionaryAwareConverter(new ParentContainerUpdater(){

                        @Override
                        public void addDecimal(BigDecimal value) {
                            record.setDecimal(fieldIndex, value);
                        }
                    }, true, precision, scale);
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    if (ParquetVersionEnum.LEGACY == pqVersion) {
                        return new DecimalBinaryDictionaryAwareConverter(new ParentContainerUpdater(){

                            @Override
                            public void addDecimal(BigDecimal value) {
                                record.setDecimal(fieldIndex, value);
                            }
                        }, true, precision, scale, true);
                    }
                    return new DecimalBinaryDictionaryAwareConverter(new ParentContainerUpdater(){

                        @Override
                        public void addDecimal(BigDecimal value) {
                            record.setDecimal(fieldIndex, value);
                        }
                    }, true, precision, scale, false);
                }
            }
            throw new ParquetDecodingException(String.format("Invalid Parquet Primitive Type (%s) detected for reading decimal encoded values.", pqPrimitiveTypeName.name()));
        }

        private static GroupConverter createTimeGroupConverter(final WritableRecord record, final int fieldIndex, TimeType timeType, ParquetOptions pqOptions) {
            if (!timeType.hasTimeZone()) {
                return new LocalTimeGroupConverter(new ParentContainerUpdater(){

                    @Override
                    public void addTime(LocalTime value) {
                        record.setTime(fieldIndex, value);
                    }
                }, pqOptions);
            }
            return new TimeWithTZGroupConverter(new ParentContainerUpdater(){

                @Override
                public void addOffsetTime(OffsetTime value) {
                    record.setOffsetTime(fieldIndex, value);
                }
            });
        }

        private static GroupConverter createTimestampGroupConverter(final WritableRecord record, final int fieldIndex, TimestampType timestampType, ParquetOptions pqOptions) {
            if (!timestampType.hasTimeZone()) {
                return new LocalDateTimeGroupConverter(new ParentContainerUpdater(){

                    @Override
                    public void addDateTime(LocalDateTime value) {
                        record.setDateTime(fieldIndex, value);
                    }
                }, pqOptions);
            }
            return new TimestampWithTZGroupConverter(new ParentContainerUpdater(){

                @Override
                public void addOffsetDateTime(OffsetDateTime value) {
                    record.setOffsetDateTime(fieldIndex, value);
                }
            });
        }
    }

    private static class DatasetRecordMaterializer
    extends RecordMaterializer<ReadableRecord> {
        private final DatasetRecordConverter rootConverter;

        public DatasetRecordMaterializer(MessageType parquetSchema, RowSchema recordSchema, ParquetOptions options) {
            this.rootConverter = new DatasetRecordConverter(parquetSchema, recordSchema, options);
        }

        public ReadableRecord getCurrentRecord() {
            return this.rootConverter.getRecord();
        }

        public GroupConverter getRootConverter() {
            return this.rootConverter;
        }
    }

    static interface ParentContainerUpdater {
        default public void addBoolean(boolean value) {
        }

        default public void addBinary(ByteBuffer value) {
        }

        default public void addByte(byte value) {
        }

        default public void addDate(LocalDate value) {
        }

        default public void addTime(LocalTime value) {
        }

        default public void addOffsetTime(OffsetTime value) {
        }

        default public void addDateTime(LocalDateTime value) {
        }

        default public void addOffsetDateTime(OffsetDateTime value) {
        }

        default public void addDecimal(BigDecimal value) {
        }

        default public void addDouble(double value) {
        }

        default public void addFloat(float value) {
        }

        default public void addInt(int value) {
        }

        default public void addLong(long value) {
        }

        default public void addShort(short value) {
        }

        default public void addString(String value) {
        }
    }
}

