/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.StringType;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.parquet.SparkRowMetadataBuilder;
import com.ibm.bi.platform.datasetutils.parquet.XQERowTypeBuilder;
import com.ibm.bi.platform.datasetutils.utils.DecimalUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class ParquetMetadataGenerator {
    private final ParquetOptions options;
    private final Map<String, String> extraMetadata = new TreeMap<String, String>();
    private final List<Type> fields = new ArrayList<Type>();
    private final SparkRowMetadataBuilder sparkRowMetaBuilder = new SparkRowMetadataBuilder();
    private final XQERowTypeBuilder xqeRowTypeBuilder = new XQERowTypeBuilder();

    public ParquetMetadataGenerator(ParquetOptions opts) {
        this.options = opts;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public MessageType getMessageType() {
        return new MessageType("SCHEMA", this.fields);
    }

    public void process(RowSchema recordSchema) {
        this.extraMetadata.clear();
        this.fields.clear();
        this.sparkRowMetaBuilder.clear();
        this.xqeRowTypeBuilder.clear();
        int numFields = recordSchema.getNumOfColumns();
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            this.processField(recordSchema.getColumnMetadata(fieldIndex));
        }
        try {
            this.extraMetadata.put("com.ibm.bi.platform.dataset.parquet.row.metadata", recordSchema.toJson().serialize(false));
            this.extraMetadata.put("org.apache.spark.sql.parquet.row.metadata", this.sparkRowMetaBuilder.build().serialize(false));
            this.extraMetadata.put("rowType", this.xqeRowTypeBuilder.build());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected error", ex);
        }
    }

    private void processField(ColumnMetadata fieldMeta) {
        EIntrinsicType instrinsicType = fieldMeta.getType().getIntrinsicType();
        switch (instrinsicType) {
            case BINARY: {
                this.processBinaryField(fieldMeta);
                break;
            }
            case BOOLEAN: {
                this.processBooleanField(fieldMeta);
                break;
            }
            case BYTE: {
                this.processByteField(fieldMeta);
                break;
            }
            case DATE: {
                this.processDateField(fieldMeta);
                break;
            }
            case DECIMAL: {
                this.processDecimalField(fieldMeta);
                break;
            }
            case DOUBLE: {
                this.processDoubleField(fieldMeta);
                break;
            }
            case FLOAT: {
                this.processFloatField(fieldMeta);
                break;
            }
            case INT: {
                this.processIntField(fieldMeta);
                break;
            }
            case LONG: {
                this.processLongField(fieldMeta);
                break;
            }
            case SHORT: {
                this.processShortField(fieldMeta);
                break;
            }
            case STRING: {
                this.processStringField(fieldMeta);
                break;
            }
            case TIME: 
            case TIMESTAMP: {
                this.processTimestampField(fieldMeta);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported instrinsic type: " + (Object)((Object)instrinsicType));
            }
        }
        this.xqeRowTypeBuilder.addField(fieldMeta.getName(), fieldMeta.getType().toXQETypeString());
    }

    private void processTimestampField(ColumnMetadata fieldMeta) {
        Type type;
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        TemporalType temporalType = (TemporalType)fieldMeta.getType();
        HashMap<String, Object> extraFieldMeta = new HashMap<String, Object>();
        if (temporalType.hasTime() && !temporalType.hasDate()) {
            extraFieldMeta.put("isTime", Boolean.TRUE);
        }
        if (temporalType.hasTime() && temporalType.hasTimeZone()) {
            extraFieldMeta.put("hasTimeZone", Boolean.TRUE);
        }
        if (this.options.isTimestampAsGroupEnabled()) {
            Types.GroupBuilder groupBuilder = (Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildGroup((Type.Repetition)repetition).required(PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.INT_64)).named("ms")).required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_32)).named("ns");
            SparkRowMetadataBuilder sparkMetaBuilder = new SparkRowMetadataBuilder().addLongField("ms", false, null).addIntegerField("ns", false, null);
            if (temporalType.hasTimeZone()) {
                ((Types.PrimitiveBuilder)groupBuilder.required(PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_32)).named("tz");
                sparkMetaBuilder.addIntegerField("tz", false, null);
            }
            type = (Type)groupBuilder.named(fieldMeta.getName());
            this.sparkRowMetaBuilder.addComplexField(fieldMeta.getName(), fieldMeta.isNullable(), sparkMetaBuilder.build(), extraFieldMeta);
        } else {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(fieldMeta.getName());
            this.sparkRowMetaBuilder.addTimestampField(fieldMeta.getName(), fieldMeta.isNullable(), extraFieldMeta);
        }
        this.fields.add(type);
    }

    private void processStringField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        StringType stringType = (StringType)fieldMeta.getType();
        Type type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(fieldMeta.getName());
        HashMap<String, Object> extraMeta = null;
        if (stringType.isIntervalDT()) {
            extraMeta = new HashMap<String, Object>(1);
            extraMeta.put("isIntervalDT", Boolean.TRUE);
        } else if (stringType.isIntervalYM()) {
            extraMeta = new HashMap(1);
            extraMeta.put("isIntervalYM", Boolean.TRUE);
        }
        this.fields.add(type);
        this.sparkRowMetaBuilder.addStringField(fieldMeta.getName(), fieldMeta.isNullable(), extraMeta);
    }

    private void processShortField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        com.ibm.bi.platform.datasetutils.metadata.types.Type fieldMetaType = fieldMeta.getType();
        Type type = 2 == fieldMetaType.getCCLTypeCode() ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(fieldMeta.getName()) : (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addShortField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processLongField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.INT_64)).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addLongField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processIntField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        com.ibm.bi.platform.datasetutils.metadata.types.Type fieldMetaType = fieldMeta.getType();
        Type type = 2 == fieldMetaType.getCCLTypeCode() ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(fieldMeta.getName()) : (4 == fieldMetaType.getCCLTypeCode() ? (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(fieldMeta.getName()) : (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_32)).named(fieldMeta.getName()));
        this.fields.add(type);
        this.sparkRowMetaBuilder.addIntegerField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processFloatField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addFloatField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processDoubleField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addDoubleField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processDecimalField(ColumnMetadata fieldMeta) {
        Types.PrimitiveBuilder builder;
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        DecimalType decType = (DecimalType)fieldMeta.getType();
        int precision = decType.getPrecision();
        int scale = decType.getScale();
        if (precision <= 9) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
            this.sparkRowMetaBuilder.addDecimalField(fieldMeta.getName(), fieldMeta.isNullable(), precision, scale, null);
        } else if (precision <= 18) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
            this.sparkRowMetaBuilder.addDecimalField(fieldMeta.getName(), fieldMeta.isNullable(), precision, scale, null);
        } else if (this.options.isDecimalAsStringEnabled()) {
            builder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
            this.sparkRowMetaBuilder.addStringField(fieldMeta.getName(), fieldMeta.isNullable(), null);
        } else {
            builder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(DecimalUtils.minBytesForPrecision(precision));
            this.sparkRowMetaBuilder.addDecimalField(fieldMeta.getName(), fieldMeta.isNullable(), precision, scale, null);
        }
        Type type = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)builder.as(OriginalType.DECIMAL)).precision(precision)).scale(scale)).named(fieldMeta.getName());
        this.fields.add(type);
    }

    private void processDateField(ColumnMetadata fieldMeta) {
        Type type;
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        if (this.options.isDateAsEpochMillisEnabled()) {
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(fieldMeta.getName());
            this.sparkRowMetaBuilder.addLongField(fieldMeta.getName(), fieldMeta.isNullable(), null);
        } else {
            type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(fieldMeta.getName());
            this.sparkRowMetaBuilder.addDateField(fieldMeta.getName(), fieldMeta.isNullable(), null);
        }
        this.fields.add(type);
    }

    private void processByteField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addByteField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processBooleanField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addBooleanField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private void processBinaryField(ColumnMetadata fieldMeta) {
        Type.Repetition repetition = ParquetMetadataGenerator.getRepetition(fieldMeta);
        Type type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(fieldMeta.getName());
        this.fields.add(type);
        this.sparkRowMetaBuilder.addBinaryField(fieldMeta.getName(), fieldMeta.isNullable(), null);
    }

    private static Type.Repetition getRepetition(ColumnMetadata fieldMeta) {
        if (fieldMeta.isNullable()) {
            return Type.Repetition.OPTIONAL;
        }
        return Type.Repetition.REQUIRED;
    }
}

