/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.parquet;

import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.DateTimeUtils;
import java.text.Normalizer;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ParquetOptions
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String PARQUET_CA_VERSION = "parquet.ca.version";
    public static final String UNICODE_NORMALIZE = "parquet.unicode.normalize";
    public static final String UNICODE_NORMALIZER_FORM = "parquet.unicode.normalizer.form";
    public static final String TIME_ZONE_ID = "parquet.time.zone-id";
    public static final String TIME_ZONE_OFFSET_ID = "parquet.time.zone-offset-id";
    public static final String PROJECTION_SCHEMA = "parquet.projection.schema";
    public static final String PROJECTION_FIELDS = "parquet.projection.fields";
    public static final String LEGACY_ZONE_OFFSET_IN_MINUTES_BEHIND_UTC = "parquet.legacy.zone-offset-in-minutes-behind-utc";
    public static final String LEGACY_DATE_AS_EPOCH_MILLIS = "parquet.legacy.date-as-epoch-millis";
    public static final String LEGACY_TIMESTAMP_AS_GROUP = "parquet.legacy.timestamp-as-group";
    public static final String LEGACY_DECIMAL_AS_STRING = "parquet.legacy.decimal-as-string";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String NFD = "NFD";

    public ParquetOptions() {
    }

    public ParquetOptions(Map<String, String> initialOptions) {
        super(initialOptions);
    }

    public ParquetVersionEnum getParquetCAVersion() {
        String versionStr = this.getOrDefault(PARQUET_CA_VERSION, ParquetVersionEnum.LEGACY.getValue());
        try {
            return ParquetVersionEnum.valueOf(versionStr);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported Parquet CA version: " + versionStr, ex);
        }
    }

    public ZoneId getTimeZoneId() {
        String zoneIdStr = this.getOrDefault(TIME_ZONE_ID, ZoneId.systemDefault().getId());
        return ZoneId.of(zoneIdStr);
    }

    public ZoneOffset getTimeZoneOffset() {
        String offsetId = (String)this.get(TIME_ZONE_OFFSET_ID);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{offsetId})) {
            return ZoneOffset.of(offsetId);
        }
        ZoneId zoneId = this.getTimeZoneId();
        return DateTimeUtils.EPOCH_ZERO_DATE.atStartOfDay(zoneId).getOffset();
    }

    public boolean isUnicodeNormalizeEnabled() {
        return Boolean.parseBoolean(this.getOrDefault(UNICODE_NORMALIZE, FALSE));
    }

    public Normalizer.Form getUnicodeNormalizerForm() {
        try {
            String form = this.getOrDefault(UNICODE_NORMALIZER_FORM, NFD);
            return Normalizer.Form.valueOf(form);
        }
        catch (IllegalArgumentException ex) {
            return Normalizer.Form.NFD;
        }
    }

    public boolean isDateAsEpochMillisEnabled() {
        return Boolean.parseBoolean(this.getOrDefault(LEGACY_DATE_AS_EPOCH_MILLIS, FALSE));
    }

    public boolean isTimestampAsGroupEnabled() {
        return Boolean.parseBoolean(this.getOrDefault(LEGACY_TIMESTAMP_AS_GROUP, FALSE));
    }

    public boolean isDecimalAsStringEnabled() {
        return Boolean.parseBoolean(this.getOrDefault(LEGACY_DECIMAL_AS_STRING, FALSE));
    }

    public boolean isTimeZoneOffsetInMinutesBehindUTCEnabled() {
        return Boolean.parseBoolean(this.getOrDefault(LEGACY_ZONE_OFFSET_IN_MINUTES_BEHIND_UTC, FALSE));
    }

    public void setLegacyParquetCompatibility() {
        this.put(LEGACY_DATE_AS_EPOCH_MILLIS, TRUE);
        this.put(LEGACY_TIMESTAMP_AS_GROUP, TRUE);
        this.put(LEGACY_DECIMAL_AS_STRING, TRUE);
    }
}

