/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.JulianFields;
import org.apache.parquet.io.api.Binary;

public class DateTimeUtils {
    public static final LocalDate EPOCH_ZERO_DATE = LocalDate.ofEpochDay(0L);

    private DateTimeUtils() {
    }

    public static Binary toInt96(OffsetTime offsetTime, ZoneOffset normalizeOffset) {
        return DateTimeUtils.toInt96(offsetTime.withOffsetSameInstant(normalizeOffset).toLocalTime());
    }

    public static Binary toInt96(LocalTime time) {
        return DateTimeUtils.toInt96(EPOCH_ZERO_DATE.atTime(time));
    }

    public static Binary toInt96(OffsetDateTime offsetDateTime, ZoneId normalizeZone) {
        return DateTimeUtils.toInt96(offsetDateTime.atZoneSameInstant(normalizeZone).toLocalDateTime());
    }

    public static Binary toInt96(LocalDateTime dateTime) {
        int julianDay = (int)dateTime.getLong(JulianFields.JULIAN_DAY);
        long timeOfDayNanos = dateTime.getLong(ChronoField.NANO_OF_DAY);
        return DateTimeUtils.toInt96(julianDay, timeOfDayNanos);
    }

    private static Binary toInt96(int julianDay, long timeOfDayNanos) {
        ByteBuffer int96Buf = ByteBuffer.allocate(12);
        int96Buf.order(ByteOrder.LITTLE_ENDIAN);
        int96Buf.putLong(timeOfDayNanos);
        int96Buf.putInt(julianDay);
        int96Buf.flip();
        return Binary.fromConstantByteBuffer((ByteBuffer)int96Buf);
    }

    public static LocalDateTime fromInt96(Binary int96Value) {
        if (int96Value.length() != 12) {
            throw new IllegalArgumentException("INT96 value must be 12 bytes in length");
        }
        ByteBuffer int96Buf = int96Value.toByteBuffer();
        int96Buf.order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = int96Buf.getLong();
        int julianDay = int96Buf.getInt();
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.with(JulianFields.JULIAN_DAY, julianDay).with(ChronoField.NANO_OF_DAY, timeOfDayNanos);
    }
}

