/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.datasetutils.utils;

import com.ibm.bi.platform.datasetutils.utils.ValueConversionException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.parquet.io.api.Binary;

public class DecimalUtils {
    public static final int MAX_INT_BYTES = 4;
    public static final int MAX_INT_DIGITS = 9;
    public static final int MAX_INT_VALUE = 999999999;
    public static final int MAX_LONG_BYTES = 8;
    public static final int MAX_LONG_DIGITS = 18;
    public static final long MAX_LONG_VALUE = 999999999999999999L;
    public static final int MAX_PRECISION = 38;
    private static final int[] MIN_BYTES_FOR_PRECISION = new int[38];
    private static final MathContext[] MATH_CONTEXT_FOR_PRECISION = new MathContext[38];

    private DecimalUtils() {
    }

    public static int minBytesForPrecision(int precision) {
        if (precision < 1 || precision > 38) {
            throw new IllegalArgumentException(String.format("Illegal precision (%d); must be >= 0 and <= 38", precision));
        }
        return MIN_BYTES_FOR_PRECISION[precision - 1];
    }

    public static int maxPrecisionForBytes(int numBytes) {
        if (numBytes < 1) {
            throw new IllegalArgumentException(String.format("Illegal number of bytes (%d); must be > 0", numBytes));
        }
        return (int)Math.round(Math.floor(Math.log10(Math.pow(2.0, 8.0 * (double)numBytes - 1.0) - 1.0)));
    }

    public static int decimalToUnscaledInt(BigDecimal decimal, int precision, int scale) {
        if (precision > 9) {
            throw new IllegalArgumentException(String.format("The desired precision (%d) must be <= 9 to store as integer", precision));
        }
        return (int)DecimalUtils.decimalToUnscaledLong(decimal, precision, scale);
    }

    public static long decimalToUnscaledLong(BigDecimal decimal, int precision, int scale) {
        if (precision > 18) {
            throw new IllegalArgumentException(String.format("The desired precision (%d) must be <= 18 to store as long", decimal.precision()));
        }
        BigDecimal adjustedDecimal = DecimalUtils.adjustDecimalForPrecisionAndScale(decimal, precision, scale);
        return adjustedDecimal.unscaledValue().longValueExact();
    }

    public static Binary decimalToUnscaledBytes(BigDecimal decimal, int precision, int scale) {
        int numBytes = DecimalUtils.minBytesForPrecision(precision);
        BigDecimal adjustedDecimal = DecimalUtils.adjustDecimalForPrecisionAndScale(decimal, precision, scale);
        byte[] unscaledBytes = adjustedDecimal.unscaledValue().toByteArray();
        if (unscaledBytes.length == numBytes) {
            return Binary.fromConstantByteArray((byte[])unscaledBytes);
        }
        byte[] paddedBytes = new byte[numBytes];
        byte signByte = unscaledBytes[0] < 0 ? (byte)-1 : 0;
        Arrays.fill(paddedBytes, 0, numBytes - unscaledBytes.length, signByte);
        System.arraycopy(unscaledBytes, 0, paddedBytes, numBytes - unscaledBytes.length, unscaledBytes.length);
        return Binary.fromConstantByteArray((byte[])paddedBytes);
    }

    public static BigDecimal decimalFromUnscaledInt(int unscaled, int precision, int scale) {
        return DecimalUtils.decimalFromUnscaledLong(unscaled, precision, scale);
    }

    public static BigDecimal decimalFromUnscaledLong(long unscaled, int precision, int scale) {
        return new BigDecimal(BigInteger.valueOf(unscaled), scale, DecimalUtils.mathContextForPrecision(precision));
    }

    public static BigDecimal decimalFromBinary(Binary binary, int precision, int scale) {
        if (precision <= 18) {
            long unscaled = DecimalUtils.binaryToLong(binary);
            return DecimalUtils.decimalFromUnscaledLong(unscaled, precision, scale);
        }
        return new BigDecimal(new BigInteger(binary.getBytes()), scale, DecimalUtils.mathContextForPrecision(precision));
    }

    private static int calculateMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    private static MathContext mathContextForPrecision(int precision) {
        return MATH_CONTEXT_FOR_PRECISION[precision - 1];
    }

    private static BigDecimal adjustDecimalForPrecisionAndScale(BigDecimal decimal, int precision, int scale) {
        BigDecimal adjustedDecimal = decimal.scale() == scale ? decimal : decimal.setScale(scale);
        if (adjustedDecimal.precision() > precision) {
            throw new IllegalArgumentException(String.format("The decimal value (%s) cannot be stored with the desired precision (%d) and scale (%d)", decimal.toString(), precision, scale));
        }
        return adjustedDecimal;
    }

    private static long binaryToLong(Binary binary) {
        int end;
        int start;
        byte[] bytes;
        if (binary.length() > 8) {
            throw new IllegalArgumentException(String.format("The length of binary value (%d) must be <= 8 to decode as long", binary.length()));
        }
        ByteBuffer buffer = binary.toByteBuffer();
        if (buffer.hasArray()) {
            bytes = buffer.array();
            start = buffer.arrayOffset() + buffer.position();
            end = buffer.arrayOffset() + buffer.limit();
        } else {
            bytes = binary.getBytes();
            start = 0;
            end = bytes.length;
        }
        long unscaled = 0L;
        for (int i = start; i < end; ++i) {
            unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        unscaled = unscaled << 64 - bits >> 64 - bits;
        return unscaled;
    }

    public static BigDecimal truncateDecimalValue(BigDecimal inputValue, int originalPrecision, int newScale) {
        if (38 < originalPrecision) {
            BigInteger unscaledValue = inputValue.unscaledValue();
            if (inputValue.scale() < 0) {
                for (int i = 0; i < Math.abs(inputValue.scale()) - Math.abs(newScale); ++i) {
                    unscaledValue = unscaledValue.multiply(BigInteger.TEN);
                }
            }
            int numberOfTruncatedDigits = originalPrecision - 38;
            for (int i = 0; i < numberOfTruncatedDigits && !BigInteger.ZERO.equals(unscaledValue = unscaledValue.divide(BigInteger.TEN)); ++i) {
            }
            return new BigDecimal(unscaledValue, newScale);
        }
        return inputValue;
    }

    public static BigDecimal fitDecimalValue(String columnName, long rowId, BigDecimal inputValue) {
        if (inputValue.scale() > 38) {
            throw new ValueConversionException(columnName, rowId, inputValue.unscaledValue().toString(), String.format("Cannot convert decimal value with unscaled part, precision and scale (%s, %s, %s) for column '%s' located at row (%s).", inputValue.unscaledValue(), inputValue.precision(), inputValue.scale(), columnName, rowId));
        }
        int numOfNonFractionalDigitsThatCanFit = 38 - inputValue.scale();
        BigInteger fractionalPartDivisor = BigInteger.TEN.pow(inputValue.scale());
        BigInteger fittingNonFractionalPartDivisor = BigInteger.TEN.pow(numOfNonFractionalDigitsThatCanFit);
        BigInteger[] quotientAndRemainder = inputValue.unscaledValue().divideAndRemainder(fractionalPartDivisor);
        BigInteger quotient = quotientAndRemainder[0];
        BigInteger[] nonFittingQuotientPartAndFittingQuotientPart = quotient.divideAndRemainder(fittingNonFractionalPartDivisor);
        BigInteger nonFittingQuotientPart = nonFittingQuotientPartAndFittingQuotientPart[0];
        if (BigInteger.ZERO.compareTo(nonFittingQuotientPart) != 0) {
            throw new ValueConversionException(columnName, rowId, inputValue.unscaledValue().toString(), String.format("Cannot convert decimal value with unscaled part, precision and scale (%s, %s, %s) for column '%s' located at row (%s).", inputValue.unscaledValue(), inputValue.precision(), inputValue.scale(), columnName, rowId));
        }
        return inputValue;
    }

    static {
        for (int i = 0; i < 38; ++i) {
            DecimalUtils.MIN_BYTES_FOR_PRECISION[i] = DecimalUtils.calculateMinBytesForPrecision(i + 1);
            DecimalUtils.MATH_CONTEXT_FOR_PRECISION[i] = new MathContext(i + 1);
        }
    }
}

